/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.distribution;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;
import org.openintents.distribution.MarketUtils;
import org.openintents.distribution.R;

public class DownloadAppDialog
extends AlertDialog
implements DialogInterface.OnClickListener {
    private static final String TAG = "StartSaveActivity";
    Context mContext;
    String mDownloadAppName;
    String mDownloadPackageName;
    String mDownloadWebsite;
    String mMessageText;
    boolean mMarketAvailable;
    private boolean mHideMarketLink;

    public DownloadAppDialog(Context context) {
        super(context);
        this.mContext = context;
    }

    public DownloadAppDialog(Context context, int message_id, int download_name_id, int download_package_id, int download_website_id) {
        super(context);
        this.mContext = context;
        this.set(message_id, download_name_id, download_package_id, download_website_id);
    }

    public DownloadAppDialog(Context context, String message, String download_name, String download_package, String download_website) {
        super(context);
        this.mContext = context;
        this.set(message, download_name, download_package, download_website);
    }

    protected void set(int message_id, int download_name_id, int download_package_id, int download_website_id) {
        String message = this.mContext.getString(message_id);
        String download_name = this.mContext.getString(download_name_id);
        String download_package = this.mContext.getString(download_package_id);
        String download_website = this.mContext.getString(download_website_id);
        this.set(message, download_name, download_package, download_website);
    }

    protected void set(String message, String download_name, String download_package, String download_website) {
        this.mDownloadAppName = download_name;
        this.mDownloadPackageName = download_package;
        this.mDownloadWebsite = download_website;
        this.mMarketAvailable = MarketUtils.isMarketAvailable(this.mContext, this.mDownloadPackageName);
        this.mHideMarketLink = MarketUtils.hideMarketLink(this.mContext);
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(" ");
        if (this.mMarketAvailable && !this.mHideMarketLink) {
            sb.append(this.mContext.getString(R.string.oi_distribution_download_market_message, new Object[]{this.mDownloadAppName}));
        } else {
            sb.append(this.mContext.getString(R.string.oi_distribution_download_message, new Object[]{this.mDownloadAppName}));
        }
        this.mMessageText = sb.toString();
        this.setMessage(this.mMessageText);
        this.setTitle(this.mContext.getString(R.string.oi_distribution_download_title, new Object[]{this.mDownloadAppName}));
        this.setButton(this.mContext.getText(R.string.oi_distribution_download_market), this);
        this.setButton2(this.mContext.getText(R.string.oi_distribution_download_web), this);
        this.setButton3(this.mContext.getText(0x1040000), this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            Intent intent = MarketUtils.getMarketDownloadIntent(this.mDownloadPackageName);
            this.startSaveActivity(intent);
        } else if (which == -2) {
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri uri = Uri.parse((String)this.mDownloadWebsite);
            intent.setData(uri);
            this.startSaveActivity(intent);
        }
    }

    public static void onPrepareDialog(Context context, Dialog dialog) {
        DownloadAppDialog d = (DownloadAppDialog)dialog;
        boolean has_android_market = MarketUtils.isMarketAvailable(context, d.mDownloadPackageName) && !d.mHideMarketLink;
        dialog.findViewById(16908313).setVisibility(has_android_market ? 0 : 8);
    }

    public void startSaveActivity(Intent intent) {
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this.mContext, (int)R.string.oi_distribution_update_error, (int)0).show();
            Log.e((String)TAG, (String)"Error starting second activity.", (Throwable)e);
        }
    }
}

