/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.distribution;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import org.openintents.distribution.EulaActivity;
import org.openintents.distribution.NewVersionActivity;
import org.openintents.util.VersionUtils;

public class EulaOrNewVersion {
    private static final String TAG = "EulaOrNewVersion";
    private static final boolean debug = false;
    public static final String PREFERENCES_EULA_ACCEPTED = "eula_accepted";
    public static final String PREFERENCES_VERSION_NUMBER = "org.openintents.distribution.version_number_check";
    static final String EXTRA_LAUNCH_ACTIVITY_PACKAGE = "org.openintents.extra.launch_activity_package";
    static final String EXTRA_LAUNCH_ACTIVITY_CLASS = "org.openintents.extra.launch_activity_class";
    static final String EXTRA_LAUNCH_ACTIVITY_INTENT = "org.openintents.extra.launch_activity_intent";

    static boolean showEula(Activity activity) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        boolean accepted = sp.getBoolean(PREFERENCES_EULA_ACCEPTED, false);
        if (accepted) {
            return false;
        }
        EulaOrNewVersion.startForwardActivity(activity, EulaActivity.class);
        return true;
    }

    static void storeEulaAccepted(Context context) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor e = sp.edit();
        e.putBoolean(PREFERENCES_EULA_ACCEPTED, true);
        e.commit();
    }

    static boolean showNewVersion(Activity activity) {
        int thisVersion;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        int lastVersion = sp.getInt(PREFERENCES_VERSION_NUMBER, 0);
        if (lastVersion == (thisVersion = VersionUtils.getVersionCode((Context)activity))) {
            return false;
        }
        EulaOrNewVersion.startForwardActivity(activity, NewVersionActivity.class);
        return true;
    }

    static void storeCurrentVersionCode(Context context) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        int thisVersion = VersionUtils.getVersionCode(context);
        SharedPreferences.Editor e = sp.edit();
        e.putInt(PREFERENCES_VERSION_NUMBER, thisVersion);
        e.commit();
    }

    private static void startForwardActivity(Activity activity, Class launchClass) {
        Intent forwardIntent = activity.getIntent();
        Intent i = new Intent((Context)activity, launchClass);
        ComponentName ci = activity.getComponentName();
        i.putExtra(EXTRA_LAUNCH_ACTIVITY_PACKAGE, ci.getPackageName());
        i.putExtra(EXTRA_LAUNCH_ACTIVITY_CLASS, ci.getClassName());
        if (forwardIntent != null) {
            i.putExtra(EXTRA_LAUNCH_ACTIVITY_INTENT, (Parcelable)forwardIntent);
        }
        i.addFlags(0x2000000);
        activity.startActivity(i);
        activity.finish();
    }
}

