/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.distribution;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import org.openintents.distribution.DownloadAppDialog;
import org.openintents.distribution.R;
import org.openintents.util.VersionUtils;

public class UpdateDialog
extends DownloadAppDialog {
    private static final String TAG = "UpdateMenu";
    private static final boolean DEBUG_NO_MARKET = false;
    public static final String[] UPDATE_CHECKER = new String[]{"org.openintents.updatechecker", "com.android.vending", "com.a0soft.gphone.aTrackDog"};

    public UpdateDialog(Context context) {
        super(context, R.string.oi_distribution_update_box_text, R.string.oi_distribution_update_app, R.string.oi_distribution_update_checker_package, R.string.oi_distribution_update_checker_website);
        this.mContext = context;
        String version = VersionUtils.getVersionNumber(this.mContext);
        String appname = VersionUtils.getApplicationName(this.mContext);
        String appnameversion = this.mContext.getString(R.string.oi_distribution_name_and_version, new Object[]{appname, version});
        StringBuilder sb = new StringBuilder();
        sb.append(appnameversion);
        sb.append("\n\n");
        sb.append(this.mMessageText);
        this.setMessage(sb.toString());
        this.setButton(this.mContext.getText(R.string.oi_distribution_update_check_now), this);
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (which == -1) {
            int resId = R.string.about_website_url;
            intent.setData(Uri.parse((String)this.mContext.getString(resId)));
            this.startSaveActivity(intent);
        } else {
            super.onClick(dialog, which);
        }
    }

    public static boolean isUpdateMenuNecessary(Context context) {
        PackageInfo pi = null;
        int i = 0;
        while (i < UPDATE_CHECKER.length) {
            try {
                pi = context.getPackageManager().getPackageInfo(UPDATE_CHECKER[i], 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (pi != null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

