/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;

public class VersionUtils {
    private static final String TAG = "VersionUtils";

    public static int getVersionCode(Context context) {
        int version = 0;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            version = pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Package name not found", (Throwable)e);
        }
        return version;
    }

    public static String getVersionNumber(Context context) {
        String version = "?";
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            version = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Package name not found", (Throwable)e);
        }
        return version;
    }

    public static String getApplicationName(Context context) {
        String name = "?";
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            name = context.getString(pi.applicationInfo.labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Package name not found", (Throwable)e);
        }
        return name;
    }

    public static int getApplicationIcon(Context context) {
        int icon = 0;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            icon = pi.applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Package name not found", (Throwable)e);
        }
        return icon;
    }

    public static boolean isPackageAvailable(Context context, String packageName, int minVersionCode) {
        boolean result = false;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(packageName, 0);
            if (pi.versionCode >= minVersionCode) {
                result = true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return result;
    }
}

