/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.distribution;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import org.openintents.distribution.AboutDialog;
import org.openintents.distribution.EulaOrNewVersion;
import org.openintents.distribution.R;
import org.openintents.distribution.UpdateDialog;

public class DistributionLibrary {
    public static final int OFFSET_ABOUT = 0;
    public static final int OFFSET_UPDATE = 1;
    public static final int MENU_COUNT = 2;
    public static final int DIALOG_COUNT = 2;
    Activity mActivity;
    int mFirstMenuId = 0;
    int mFirstDialogId = 0;

    public DistributionLibrary(Activity activity, int firstMenuId, int firstDialogId) {
        this.mActivity = activity;
        this.mFirstMenuId = firstMenuId;
        this.mFirstDialogId = firstDialogId;
    }

    public void setFirst(int firstMenuId, int firstDialogId) {
        this.mFirstMenuId = firstMenuId;
        this.mFirstDialogId = firstDialogId;
    }

    public boolean showEulaOrNewVersion() {
        return EulaOrNewVersion.showEula(this.mActivity) || EulaOrNewVersion.showNewVersion(this.mActivity);
    }

    public void onCreateOptionsMenu(Menu menu) {
        menu.removeItem(this.mFirstMenuId + 1);
        menu.removeItem(this.mFirstMenuId + 0);
        if (UpdateDialog.isUpdateMenuNecessary((Context)this.mActivity)) {
            menu.add(0, this.mFirstMenuId + 1, 0, R.string.oi_distribution_menu_update).setIcon(17301569).setShortcut('9', 'u');
        }
        menu.add(0, this.mFirstMenuId + 0, 0, R.string.oi_distribution_about).setIcon(17301569).setShortcut('0', 'a');
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        switch (id - this.mFirstMenuId) {
            case 1: {
                this.mActivity.showDialog(this.mFirstDialogId + 1);
                return true;
            }
            case 0: {
                AboutDialog.showDialogOrStartActivity(this.mActivity, this.mFirstDialogId + 0);
                return true;
            }
        }
        return false;
    }

    public Dialog onCreateDialog(int id) {
        switch (id - this.mFirstDialogId) {
            case 0: {
                return new AboutDialog((Context)this.mActivity);
            }
            case 1: {
                return new UpdateDialog((Context)this.mActivity);
            }
        }
        return null;
    }

    public void onPrepareDialog(int id, Dialog dialog) {
        switch (id - this.mFirstDialogId) {
            case 0: {
                AboutDialog.onPrepareDialog((Context)this.mActivity, dialog);
            }
        }
    }
}

