/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.distribution;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openintents.distribution.EulaOrNewVersion;
import org.openintents.distribution.R;
import org.openintents.util.VersionUtils;

public class EulaActivity
extends Activity {
    Button mAgree;
    Button mDisagree;
    String mLaunchPackage;
    String mLaunchClass;
    Intent mLaunchIntent;
    String mAppName;
    TextView mText1;
    TextView mText2;
    TextView mText;
    ImageView mImage;

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(R.layout.oi_distribution_eula);
        Intent i = this.getIntent();
        Bundle b = i.getExtras();
        this.mLaunchPackage = b.getString("org.openintents.extra.launch_activity_package");
        this.mLaunchClass = b.getString("org.openintents.extra.launch_activity_class");
        this.mLaunchIntent = (Intent)b.getParcelable("org.openintents.extra.launch_activity_intent");
        this.mAgree = (Button)this.findViewById(R.id.button1);
        this.mAgree.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EulaActivity.this.accept();
            }
        });
        this.mDisagree = (Button)this.findViewById(R.id.button2);
        this.mDisagree.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EulaActivity.this.refuse();
            }
        });
        this.mText1 = (TextView)this.findViewById(R.id.text1);
        this.mText2 = (TextView)this.findViewById(R.id.text2);
        this.mText = (TextView)this.findViewById(R.id.text);
        this.mImage = (ImageView)this.findViewById(R.id.imageview);
        this.mAppName = VersionUtils.getApplicationName((Context)this);
        int iconRes = VersionUtils.getApplicationIcon((Context)this);
        this.setTitle(this.mAppName);
        this.mImage.setImageResource(iconRes);
        String title = this.getString(R.string.oi_distribution_eula_title, new Object[]{this.mAppName});
        String message = this.getString(R.string.oi_distribution_eula_message, new Object[]{this.mAppName});
        this.mText1.setText((CharSequence)title);
        this.mText2.setText((CharSequence)message);
        this.mText.setText((CharSequence)this.readTextFromRawResource(R.raw.license_short, false));
    }

    void accept() {
        EulaOrNewVersion.storeEulaAccepted((Context)this);
        this.startOriginalActivity();
    }

    void startOriginalActivity() {
        Intent i;
        if (this.mLaunchIntent != null) {
            i = this.mLaunchIntent;
            i.removeCategory("android.intent.category.LAUNCHER");
        } else {
            i = new Intent();
            i.setClassName(this.mLaunchPackage, this.mLaunchClass);
        }
        i.addFlags(0x2000000);
        this.startActivity(i);
        this.finish();
    }

    void refuse() {
        this.finish();
    }

    String readTextFromRawResource(int resourceid, boolean preserveLineBreaks) {
        String license = "";
        Resources resources = this.getResources();
        BufferedReader in = new BufferedReader(new InputStreamReader(resources.openRawResource(resourceid)));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (TextUtils.isEmpty((CharSequence)line)) {
                    sb.append("\n\n");
                    continue;
                }
                sb.append(line);
                if (preserveLineBreaks) {
                    sb.append("\n");
                    continue;
                }
                sb.append(" ");
            }
            license = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return license;
    }
}

