/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.distribution;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import org.openintents.distribution.DistributionLibraryListActivity;
import org.openintents.distribution.DownloadAppDialog;
import org.openintents.distribution.R;
import org.openintents.util.VersionUtils;

public class InfoActivity
extends DistributionLibraryListActivity
implements AdapterView.OnItemClickListener {
    protected int[] mApplications = new int[0];
    protected String[] mPackageNames = new String[0];
    protected int[] mMinVersionCodes = new int[0];
    protected String[] mMinVersionName = new String[0];
    protected int[] mInfoText = new int[0];
    protected String[] mDeveloperUris = new String[0];
    protected String[] mIntentAction = new String[0];
    protected String[] mIntentData = new String[0];
    private static final int MENU_DISTRIBUTION_START = 101;
    public static final int DIALOG_INFO = 0;
    public static final int DIALOG_GET_FROM_MARKET = 100;
    private static final int DIALOG_DISTRIBUTION_START = 200;
    private String[] mApplicationStrings;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDistribution.setFirst(101, 200);
        if (this.mDistribution.showEulaOrNewVersion()) {
            return;
        }
        this.setContentView(R.layout.oi_distribution_infoactivity);
        this.init();
        this.mApplicationStrings = new String[this.mApplications.length];
        int i = 0;
        while (i < this.mApplications.length) {
            this.mApplicationStrings[i] = this.getString(this.mApplications[i]);
            ++i;
        }
        this.setListAdapter((ListAdapter)new FontArrayAdapter<String>((Context)this, 17367043, this.mApplicationStrings));
        ListView listview = this.getListView();
        listview.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        String appname = VersionUtils.getApplicationName((Context)this);
        String message = this.getString(R.string.oi_distribution_info_activity_text, new Object[]{appname});
        TextView tv = (TextView)this.findViewById(R.id.text);
        tv.setText((CharSequence)message);
    }

    public void init() {
    }

    public void onItemClick(AdapterView<?> parent, View view, int pos, long id2) {
        if (VersionUtils.isPackageAvailable((Context)this, this.mPackageNames[pos], this.mMinVersionCodes[pos])) {
            this.showDialog(0 + pos);
        } else {
            this.showDialog(100 + pos);
        }
    }

    @Override
    protected Dialog onCreateDialog(int id2) {
        Dialog dialog = super.onCreateDialog(id2);
        if (dialog != null) {
            return dialog;
        }
        if (id2 >= 0 && id2 < 100) {
            dialog = this.buildInfoDialog(id2 - 0);
        } else if (id2 >= 100 && id2 < 200) {
            dialog = this.buildGetFromMarketDialog(id2 - 100);
        }
        return dialog;
    }

    @Override
    protected void onPrepareDialog(int id2, Dialog dialog) {
        super.onPrepareDialog(id2, dialog);
        if (id2 >= 0 && id2 < 100) {
            dialog.findViewById(16908313).setVisibility(8);
        } else if (id2 >= 100 && id2 < 200) {
            DownloadAppDialog.onPrepareDialog((Context)this, dialog);
        }
    }

    private AlertDialog buildInfoDialog(final int pos) {
        String infotext = this.getString(this.mInfoText[pos], new Object[]{this.mApplicationStrings[pos]});
        String infolaunch = this.getString(R.string.oi_distribution_info_launch, new Object[]{this.mApplicationStrings[pos]});
        return new AlertDialog.Builder((Context)this).setIcon(17301659).setTitle(R.string.oi_distribution_info_instructions).setMessage((CharSequence)infotext).setPositiveButton((CharSequence)"", null).setNegativeButton((CharSequence)infolaunch, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                InfoActivity.this.launchApplication(pos);
            }
        }).create();
    }

    void launchApplication(int pos) {
        Intent intent = new Intent();
        intent.setAction(this.mIntentAction[pos]);
        if (this.mIntentAction[pos].equals("android.intent.action.MAIN")) {
            if (this.mPackageNames[pos] != null && this.mIntentData[pos] != null) {
                intent.setClassName(this.mPackageNames[pos], this.mIntentData[pos]);
            }
        } else if (this.mIntentData[pos] != null) {
            intent.setData(Uri.parse((String)this.mIntentData[pos]));
        }
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this, (int)R.string.oi_distribution_launch_error, (int)0).show();
        }
    }

    private AlertDialog buildGetFromMarketDialog(int pos) {
        String this_appname = VersionUtils.getApplicationName((Context)this);
        String info_not_available = this.getString(R.string.oi_distribution_info_not_available, new Object[]{this_appname, this.mApplicationStrings[pos], this.mMinVersionName[pos]});
        String download_appname = this.getString(this.mApplications[pos]);
        return new DownloadAppDialog((Context)this, info_not_available, download_appname, this.mPackageNames[pos], this.mDeveloperUris[pos]);
    }

    private class FontArrayAdapter<T>
    extends ArrayAdapter<T> {
        public FontArrayAdapter(Context context, int textViewResourceId, T[] objects) {
            super(context, textViewResourceId, (Object[])objects);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView tv = (TextView)super.getView(position, convertView, parent);
            return tv;
        }
    }
}

