/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.safe.backup;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class MyBackupPro
extends ContentProvider {
    private final String CONTENT_AUTHORITY = "org.openintents.safe.backup.MyBackupPro";
    private String[] filedirpath = new String[]{"/data/data/org.openintents.safe/databases/", "/data/data/org.openintents.safe/shared_prefs/org.openintents.safe_preferences.xml"};
    private int MinSupportedVersion = 8;
    private final String MybackupContentPro = "content://com.rerware.android.MyBackupPro";
    private final String MybackupContentTrial = "content://com.rerware.android.MyBackup";
    private final int MyBackupQuery = 1000;
    private final int MyBackupQueryVersion = 1001;
    private final int MyBackupQueryInflate = 1002;
    private UriMatcher sURIMatcher;
    private String tempFile = "";
    private List<fileInfo> listUris = new ArrayList<fileInfo>();
    private fileInfo fi;

    public MyBackupPro() {
        int i = 0;
        while (i < this.filedirpath.length) {
            this.fi = new fileInfo();
            this.fi.filepath = this.filedirpath[i];
            this.listUris.add(this.fi);
            ++i;
        }
        this.sURIMatcher = new UriMatcher(-1);
        this.tempFile = "/sdcard/MyBackupTemp.zip";
        this.sURIMatcher.addURI("org.openintents.safe.backup.MyBackupPro", "MyBackupQuery", 1000);
        this.sURIMatcher.addURI("org.openintents.safe.backup.MyBackupPro", "MyBackupQueryVersion/#", 1001);
        this.sURIMatcher.addURI("org.openintents.safe.backup.MyBackupPro", "MyBackupQueryInflate/#", 1002);
        int intUnique = -1;
        int i2 = 0;
        while (i2 < this.listUris.size()) {
            this.sURIMatcher.addURI("org.openintents.safe.backup.MyBackupPro", "getfile" + i2 + "/#", ++intUnique);
            this.sURIMatcher.addURI("org.openintents.safe.backup.MyBackupPro", "putfile" + i2 + "/#", ++intUnique);
            ++i2;
        }
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public boolean onCreate() {
        return false;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        int match = this.sURIMatcher.match(uri);
        switch (match) {
            case 1000: {
                String[] Uris = new String[]{"URI_NAME"};
                MatrixCursor mc = new MatrixCursor(Uris);
                int i = 0;
                while (i < this.listUris.size()) {
                    Object[] rowObject = new Object[]{"file" + i};
                    mc.addRow(rowObject);
                    ++i;
                }
                return mc;
            }
            case 1001: {
                int BackupVersionCode = Integer.parseInt((String)uri.getPathSegments().get(1));
                int intOk = BackupVersionCode >= this.MinSupportedVersion ? 1 : 0;
                String[] Uris2 = new String[]{"VERSION_COMPATIBLE"};
                MatrixCursor mc2 = new MatrixCursor(Uris2);
                Object[] rowObject2 = new Object[]{intOk};
                mc2.addRow(rowObject2);
                return mc2;
            }
            case 1002: {
                int inflateFile = Integer.parseInt((String)uri.getPathSegments().get(1));
                this.fi = this.listUris.get(inflateFile);
                if (this.fi.filepath.endsWith("/")) {
                    utilities.deleteEverythingInDir(this.fi.filepath);
                    File dir = new File(this.fi.filepath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    utilities.Unzip(this.tempFile, this.fi.filepath);
                    File temp = new File(this.tempFile);
                    temp.delete();
                }
                return null;
            }
        }
        return null;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor parcel = null;
        int match = this.sURIMatcher.match(uri);
        int authCode = Integer.parseInt((String)uri.getPathSegments().get(1));
        if (this.auth("content://com.rerware.android.MyBackupPro", authCode) == 1 || this.auth("content://com.rerware.android.MyBackup", authCode) == 1) {
            if (match % 2 == 0) {
                String getfile = "";
                this.fi = this.listUris.get((int)Math.floor(match / 2));
                getfile = this.fi.filepath.endsWith("/") ? this.tempFile : this.fi.filepath;
                if (this.fi.filepath.endsWith("/")) {
                    try {
                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.tempFile));
                        utilities.zipDir(this.fi.filepath, this.fi.filepath, zos);
                        zos.close();
                    }
                    catch (Exception ex) {
                        System.out.print(ex.getMessage());
                    }
                }
                File getFile = new File(getfile);
                parcel = ParcelFileDescriptor.open((File)getFile, (int)0x30000000);
                if (this.fi.filepath.endsWith("/")) {
                    File temp = new File(this.tempFile);
                    temp.delete();
                }
            } else {
                String putfile = "";
                this.fi = this.listUris.get((int)Math.floor(match / 2));
                putfile = this.fi.filepath.endsWith("/") ? this.tempFile : this.fi.filepath;
                File putFile = new File(putfile);
                putFile.delete();
                File parentputFile = new File(putFile.getParent());
                if (!parentputFile.exists()) {
                    parentputFile.mkdirs();
                }
                if (!putFile.exists()) {
                    try {
                        putFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                parcel = ParcelFileDescriptor.open((File)putFile, (int)0x30000000);
            }
        }
        return parcel;
    }

    private int auth(String content, int authcode) {
        int intRet = 0;
        try {
            Cursor uriCur = this.getContext().getContentResolver().query(Uri.parse((String)(String.valueOf(content) + "/MyBackupAuth/" + authcode)), null, null, null, null);
            if (uriCur != null) {
                if (uriCur.moveToFirst()) {
                    do {
                        intRet = uriCur.getInt(0);
                    } while (uriCur.moveToNext());
                }
                uriCur.close();
            }
        }
        catch (Exception ex) {
            System.out.print(ex.getMessage());
        }
        return intRet;
    }

    public class fileInfo {
        public String filepath;
    }

    private static class utilities {
        private utilities() {
        }

        private static void zipDir(String dir2zip, String originalDir, ZipOutputStream zos) {
            try {
                File zipDir = new File(dir2zip);
                String[] dirList = zipDir.list();
                byte[] readBuffer = new byte[2156];
                int bytesIn = 0;
                int i = 0;
                while (i < dirList.length) {
                    File f = new File(zipDir, dirList[i]);
                    if (f.isDirectory()) {
                        String filePath = f.getPath();
                        utilities.zipDir(filePath, originalDir, zos);
                    } else {
                        FileInputStream fis = new FileInputStream(f);
                        ZipEntry anEntry = new ZipEntry(f.getPath().substring(originalDir.length()));
                        zos.putNextEntry(anEntry);
                        while ((bytesIn = fis.read(readBuffer)) != -1) {
                            zos.write(readBuffer, 0, bytesIn);
                        }
                        fis.close();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static void Unzip(String zipFile, String targetDir) {
            int BUFFER = 2048;
            try {
                ZipEntry entry;
                BufferedOutputStream dest = null;
                FileInputStream fis = new FileInputStream(zipFile);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                while ((entry = zis.getNextEntry()) != null) {
                    try {
                        int count;
                        System.out.println("Extracting: " + entry);
                        byte[] data = new byte[BUFFER];
                        String strEntry = entry.getName();
                        File entryFile = new File(String.valueOf(targetDir) + strEntry);
                        File entryDir = new File(entryFile.getParent());
                        if (!entryDir.exists()) {
                            entryDir.mkdirs();
                        }
                        FileOutputStream fos = new FileOutputStream(entryFile);
                        dest = new BufferedOutputStream(fos, BUFFER);
                        while ((count = zis.read(data, 0, BUFFER)) != -1) {
                            dest.write(data, 0, count);
                        }
                        dest.flush();
                        dest.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                zis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean deleteEverythingInDir(String strdir) {
            File dir = null;
            try {
                dir = new File(strdir);
                if (!dir.isDirectory()) return dir.delete();
                String[] children = dir.list();
                int i = 0;
                while (true) {
                    if (i >= children.length) {
                        return dir.delete();
                    }
                    boolean success = utilities.deleteEverythingInDir(String.valueOf(dir.getPath()) + "/" + children[i]);
                    if (!success) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dir.delete();
        }
    }
}

