/*
 * Decompiled with CFR 0.152.
 */
package pl.polidea.instrumentation;

import android.os.Bundle;
import android.test.AndroidTestRunner;
import android.test.InstrumentationTestRunner;
import android.util.Log;
import android.util.Xml;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolideaInstrumentationTestRunner
extends InstrumentationTestRunner {
    private static final String TESTSUITES = "testsuites";
    private static final String TESTSUITE = "testsuite";
    private static final String ERRORS = "errors";
    private static final String FAILURES = "failures";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String NAME = "name";
    private static final String PACKAGE = "package";
    private static final String TESTS = "tests";
    private static final String TESTCASE = "testcase";
    private static final String CLASSNAME = "classname";
    private static final String TIME = "time";
    private static final String TIMESTAMP = "timestamp";
    private static final String PROPERTIES = "properties";
    private static final String SYSTEM_OUT = "system-out";
    private static final String SYSTEM_ERR = "system-err";
    private static final String SPLIT_LEVEL_NONE = "none";
    private static final String SPLIT_LEVEL_CLASS = "class";
    private static final String SPLIT_LEVEL_PACKAGE = "package";
    private static final String TAG = PolideaInstrumentationTestRunner.class.getSimpleName();
    private static final String DEFAULT_JUNIT_FILE_POSTFIX = "-TEST.xml";
    private static final String DEFAULT_NO_PACKAGE_PREFIX = "NO_PACKAGE";
    private static final String DEFAULT_SINGLE_FILE_NAME = "ALL-TEST.xml";
    private static final String DEFAULT_SPLIT_LEVEL = "package";
    private String junitOutputDirectory = null;
    private String junitOutputFilePostfix = null;
    private String junitNoPackagePrefix;
    private String junitSplitLevel;
    private String junitSingleFileName;
    private boolean junitOutputEnabled;
    private boolean justCount;
    private XmlSerializer currentXmlSerializer;
    private final LinkedHashMap<Package, TestCaseInfo> caseMap = new LinkedHashMap();
    private boolean outputEnabled;
    private AndroidTestRunner runner;
    private boolean logOnly;
    private PrintWriter currentFileWriter;

    private synchronized TestInfo getTestInfo(TestCase testCase) {
        TestInfo ti;
        Class<?> clazz = testCase.getClass();
        Package thePackage = clazz.getPackage();
        String name = testCase.getName();
        TestCaseInfo caseInfo = this.caseMap.get(thePackage);
        if (caseInfo == null) {
            caseInfo = new TestCaseInfo();
            caseInfo.testCaseClass = testCase.getClass();
            caseInfo.thePackage = thePackage;
            this.caseMap.put(thePackage, caseInfo);
        }
        if ((ti = caseInfo.testMap.get(name)) == null) {
            ti = new TestInfo();
            ti.name = name;
            ti.testCase = testCase.getClass();
            ti.thePackage = thePackage;
            caseInfo.testMap.put(name, ti);
        }
        return ti;
    }

    private void startFile(File outputFile) throws IOException {
        Log.d((String)TAG, (String)("Writing to file " + outputFile));
        this.currentXmlSerializer = Xml.newSerializer();
        this.currentFileWriter = new PrintWriter(outputFile, "UTF-8");
        this.currentXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        this.currentXmlSerializer.setOutput((Writer)this.currentFileWriter);
        this.currentXmlSerializer.startDocument("UTF-8", null);
        this.currentXmlSerializer.startTag(null, TESTSUITES);
    }

    private void endFile() throws IOException {
        Log.d((String)TAG, (String)"closing file");
        this.currentXmlSerializer.endTag(null, TESTSUITES);
        this.currentXmlSerializer.endDocument();
        this.currentFileWriter.flush();
        this.currentFileWriter.close();
    }

    private String getTimestamp() {
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return sdf.format(time);
    }

    private void writeClassToFile(TestCaseInfo tci) throws IllegalArgumentException, IllegalStateException, IOException {
        Package thePackage = tci.thePackage;
        Class<? extends TestCase> clazz = tci.testCaseClass;
        int tests = tci.testMap.size();
        String timestamp = this.getTimestamp();
        int errors = 0;
        int failures = 0;
        int time = 0;
        for (TestInfo testInfo : tci.testMap.values()) {
            if (testInfo.error != null) {
                ++errors;
            }
            if (testInfo.failure != null) {
                ++failures;
            }
            time = (int)((long)time + testInfo.time);
        }
        this.currentXmlSerializer.startTag(null, TESTSUITE);
        this.currentXmlSerializer.attribute(null, ERRORS, Integer.toString(errors));
        this.currentXmlSerializer.attribute(null, FAILURES, Integer.toString(failures));
        this.currentXmlSerializer.attribute(null, NAME, clazz.getName());
        this.currentXmlSerializer.attribute(null, "package", thePackage == null ? "" : thePackage.getName());
        this.currentXmlSerializer.attribute(null, TESTS, Integer.toString(tests));
        this.currentXmlSerializer.attribute(null, TIME, Double.toString((double)time / 1000.0));
        this.currentXmlSerializer.attribute(null, TIMESTAMP, timestamp);
        for (TestInfo testInfo : tci.testMap.values()) {
            this.writeTestInfo(testInfo);
        }
        this.currentXmlSerializer.startTag(null, PROPERTIES);
        this.currentXmlSerializer.endTag(null, PROPERTIES);
        this.currentXmlSerializer.startTag(null, SYSTEM_OUT);
        this.currentXmlSerializer.endTag(null, SYSTEM_OUT);
        this.currentXmlSerializer.startTag(null, SYSTEM_ERR);
        this.currentXmlSerializer.endTag(null, SYSTEM_ERR);
        this.currentXmlSerializer.endTag(null, TESTSUITE);
    }

    private void writeTestInfo(TestInfo testInfo) throws IllegalArgumentException, IllegalStateException, IOException {
        PrintWriter pw;
        StringWriter sw;
        this.currentXmlSerializer.startTag(null, TESTCASE);
        this.currentXmlSerializer.attribute(null, CLASSNAME, testInfo.testCase.getName());
        this.currentXmlSerializer.attribute(null, NAME, testInfo.name);
        this.currentXmlSerializer.attribute(null, TIME, Double.toString((double)testInfo.time / 1000.0));
        if (testInfo.error != null) {
            this.currentXmlSerializer.startTag(null, ERROR);
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            testInfo.error.printStackTrace(pw);
            this.currentXmlSerializer.text(sw.toString());
            this.currentXmlSerializer.endTag(null, ERROR);
        }
        if (testInfo.failure != null) {
            this.currentXmlSerializer.startTag(null, FAILURE);
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            testInfo.failure.printStackTrace(pw);
            this.currentXmlSerializer.text(sw.toString());
            this.currentXmlSerializer.endTag(null, FAILURE);
        }
        this.currentXmlSerializer.endTag(null, TESTCASE);
    }

    private File getJunitOutputFile(Package p) {
        return new File(this.junitOutputDirectory, (p == null ? this.junitNoPackagePrefix : p.getName()) + this.junitOutputFilePostfix);
    }

    private File getJunitOutputFile() {
        return new File(this.junitOutputDirectory, this.junitSingleFileName);
    }

    private File getJunitOutputFile(Class<? extends TestCase> clazz) {
        return new File(this.junitOutputDirectory, clazz.getName() + this.junitOutputFilePostfix);
    }

    private void setDefaultParameters() {
        if (this.junitOutputDirectory == null) {
            this.junitOutputDirectory = this.getTargetContext().getFilesDir().getAbsolutePath();
        }
        if (this.junitOutputFilePostfix == null) {
            this.junitOutputFilePostfix = DEFAULT_JUNIT_FILE_POSTFIX;
        }
        if (this.junitNoPackagePrefix == null) {
            this.junitNoPackagePrefix = DEFAULT_NO_PACKAGE_PREFIX;
        }
        if (this.junitSplitLevel == null) {
            this.junitSplitLevel = "package";
        }
        if (this.junitSingleFileName == null) {
            this.junitSingleFileName = DEFAULT_SINGLE_FILE_NAME;
        }
    }

    private boolean getBooleanArgument(Bundle arguments, String tag, boolean defaultValue) {
        String tagString = arguments.getString(tag);
        if (tagString == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(tagString);
    }

    public void onCreate(Bundle arguments) {
        Log.d((String)TAG, (String)("Creating the Test Runner with arguments: " + arguments.keySet()));
        if (arguments != null) {
            this.junitOutputEnabled = this.getBooleanArgument(arguments, "junitXmlOutput", true);
            this.junitOutputDirectory = arguments.getString("junitOutputDirectory");
            this.junitOutputFilePostfix = arguments.getString("junitOutputFilePostfix");
            this.junitNoPackagePrefix = arguments.getString("junitNoPackagePrefix");
            this.junitSplitLevel = arguments.getString("junitSplitLevel");
            this.junitSingleFileName = arguments.getString("junitSingleFileName");
            this.justCount = this.getBooleanArgument(arguments, "count", false);
            this.logOnly = this.getBooleanArgument(arguments, "log", false);
        }
        this.setDefaultParameters();
        this.logParameters();
        this.createDirectoryIfNotExist();
        this.deleteOldFiles();
        super.onCreate(arguments);
    }

    private void logParameters() {
        Log.d((String)TAG, (String)"Test runner is running with the following parameters:");
        Log.d((String)TAG, (String)("junitOutputDirectory: " + this.junitOutputDirectory));
        Log.d((String)TAG, (String)("junitOutputFilePostfix: " + this.junitOutputFilePostfix));
        Log.d((String)TAG, (String)("junitNoPackagePrefix: " + this.junitNoPackagePrefix));
        Log.d((String)TAG, (String)("junitSplitLevel: " + this.junitSplitLevel));
        Log.d((String)TAG, (String)("junitSingleFileName: " + this.junitSingleFileName));
    }

    private boolean createDirectoryIfNotExist() {
        boolean created = false;
        Log.d((String)TAG, (String)"Creating output directory if it does not exist");
        File directory = new File(this.junitOutputDirectory);
        if (!directory.exists()) {
            created = directory.mkdirs();
        }
        Log.d((String)TAG, (String)("Created directory? " + created));
        return created;
    }

    private void deleteOldFiles() {
        Log.d((String)TAG, (String)"Deleting old files");
        Object[] filesToDelete = new File(this.junitOutputDirectory).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith(PolideaInstrumentationTestRunner.this.junitOutputFilePostfix) || filename.equals(PolideaInstrumentationTestRunner.this.junitSingleFileName);
            }
        });
        if (filesToDelete != null) {
            Log.d((String)TAG, (String)("Deleting: " + Arrays.toString(filesToDelete)));
            for (Object f : filesToDelete) {
                ((File)f).delete();
            }
        }
    }

    public void finish(int resultCode, Bundle results) {
        if (this.outputEnabled) {
            Log.d((String)TAG, (String)"Post processing");
            if ("package".equals(this.junitSplitLevel)) {
                this.processPackageLevelSplit();
            } else if (SPLIT_LEVEL_CLASS.equals(this.junitSplitLevel)) {
                this.processClassLevelSplit();
            } else if (SPLIT_LEVEL_NONE.equals(this.junitSplitLevel)) {
                this.processNoSplit();
            } else {
                Log.d((String)TAG, (String)("Invalid split level " + this.junitSplitLevel + ", falling back to package level split."));
                this.processPackageLevelSplit();
            }
        }
        super.finish(resultCode, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNoSplit() {
        try {
            File f = this.getJunitOutputFile();
            this.startFile(f);
            try {
                for (Package p : this.caseMap.keySet()) {
                    try {
                        TestCaseInfo tc = this.caseMap.get(p);
                        this.writeClassToFile(tc);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)("Error: " + e), (Throwable)e);
                    }
                }
            }
            finally {
                this.endFile();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPackageLevelSplit() {
        Log.d((String)TAG, (String)("Packages: " + this.caseMap.size()));
        for (Package p : this.caseMap.keySet()) {
            Log.d((String)TAG, (String)("Processing package " + p));
            try {
                File f = this.getJunitOutputFile(p);
                this.startFile(f);
                try {
                    TestCaseInfo tc = this.caseMap.get(p);
                    this.writeClassToFile(tc);
                }
                finally {
                    this.endFile();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error: " + e), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassLevelSplit() {
        for (Package p : this.caseMap.keySet()) {
            try {
                TestCaseInfo tc = this.caseMap.get(p);
                File f = this.getJunitOutputFile(tc.testCaseClass);
                this.startFile(f);
                try {
                    this.writeClassToFile(tc);
                }
                finally {
                    this.endFile();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error: " + e), (Throwable)e);
            }
        }
    }

    protected AndroidTestRunner getAndroidTestRunner() {
        Log.d((String)TAG, (String)"Getting android test runner");
        this.runner = super.getAndroidTestRunner();
        if (this.junitOutputEnabled && !this.justCount && !this.logOnly) {
            Log.d((String)TAG, (String)"JUnit test output enabled");
            this.outputEnabled = true;
            this.runner.addTestListener((TestListener)new JunitTestListener());
        } else {
            this.outputEnabled = false;
            Log.d((String)TAG, (String)("JUnit test output disabled: [ junitOutputEnabled : " + this.junitOutputEnabled + ", justCount : " + this.justCount + ", logOnly : " + this.logOnly + " ]"));
        }
        return this.runner;
    }

    private class JunitTestListener
    implements TestListener {
        private static final int MINIMUM_TIME = 100;
        private final ThreadLocal<Long> startTime = new ThreadLocal();

        private JunitTestListener() {
        }

        public void startTest(Test test) {
            Log.d((String)TAG, (String)("Starting test: " + test));
            if (test instanceof TestCase) {
                Thread.currentThread().setContextClassLoader(test.getClass().getClassLoader());
                this.startTime.set(System.currentTimeMillis());
            }
        }

        public void endTest(Test t) {
            if (t instanceof TestCase) {
                long timeTaken;
                TestCase testCase = (TestCase)t;
                this.cleanup(testCase);
                ((PolideaInstrumentationTestRunner)PolideaInstrumentationTestRunner.this).getTestInfo((TestCase)testCase).time = timeTaken = System.currentTimeMillis() - this.startTime.get();
                if (timeTaken < 100L) {
                    try {
                        Thread.sleep(100L - timeTaken);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
            }
            Log.d((String)TAG, (String)("Finished test: " + t));
        }

        public void addError(Test test, Throwable t) {
            if (test instanceof TestCase) {
                ((PolideaInstrumentationTestRunner)PolideaInstrumentationTestRunner.this).getTestInfo((TestCase)((TestCase)test)).error = t;
            }
        }

        public void addFailure(Test test, AssertionFailedError f) {
            if (test instanceof TestCase) {
                ((PolideaInstrumentationTestRunner)PolideaInstrumentationTestRunner.this).getTestInfo((TestCase)((TestCase)test)).failure = f;
            }
        }

        private void cleanup(TestCase test) {
            for (Class<?> clazz = test.getClass(); clazz != TestCase.class; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    Field f = field;
                    if (f.getType().isPrimitive() || Modifier.isStatic(f.getModifiers())) continue;
                    try {
                        f.setAccessible(true);
                        f.set(test, null);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class TestPackageInfo {
        public Package thePackage;
        public Map<Class<? extends TestCase>, TestCaseInfo> testCaseList = new LinkedHashMap<Class<? extends TestCase>, TestCaseInfo>();
    }

    public static class TestCaseInfo {
        public Package thePackage;
        public Class<? extends TestCase> testCaseClass;
        public Map<String, TestInfo> testMap = new LinkedHashMap<String, TestInfo>();
    }

    public static class TestInfo {
        public Package thePackage;
        public Class<? extends TestCase> testCase;
        public String name;
        public Throwable error;
        public AssertionFailedError failure;
        public long time;

        public String toString() {
            return this.name + "[" + this.testCase.getClass() + "] <" + this.thePackage + ">. Time: " + this.time + " ms. E<" + this.error + ">, F <" + this.failure + ">";
        }
    }
}

