/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.Strings;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class GoogleJsonResponseException
extends HttpResponseException {
    static final long serialVersionUID = 1L;
    private final GoogleJsonError details;
    private final JsonFactory jsonFactory;

    private GoogleJsonResponseException(JsonFactory jsonFactory, HttpResponse response, GoogleJsonError details, String message) {
        super(response, message);
        this.jsonFactory = jsonFactory;
        this.details = details;
    }

    public final GoogleJsonError getDetails() {
        return this.details;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleJsonResponseException from(JsonFactory jsonFactory, HttpResponse response) {
        Preconditions.checkNotNull((Object)jsonFactory);
        GoogleJsonError details = null;
        String contentType = response.getContentType();
        if (!response.isSuccessStatusCode() && contentType != null && contentType.startsWith("application/json")) {
            JsonParser parser = null;
            try {
                parser = JsonHttpParser.parserForResponse((JsonFactory)jsonFactory, (HttpResponse)response);
                JsonToken currentToken = parser.getCurrentToken();
                if (currentToken == null) {
                    currentToken = parser.nextToken();
                }
                if (currentToken != null) {
                    parser.skipToKey("error");
                    if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                        details = (GoogleJsonError)((Object)parser.parseAndClose(GoogleJsonError.class, null));
                    }
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (parser == null) {
                        response.getContent().close();
                    } else if (details == null) {
                        parser.close();
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        String message = GoogleJsonResponseException.computeMessage((HttpResponse)response);
        if (details != null) {
            message = message + Strings.LINE_SEPARATOR + details.toPrettyString();
        }
        return new GoogleJsonResponseException(jsonFactory, response, details, message);
    }
}

