/*
 * Copyright (c) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.1.1 (build: 2011-10-25 10:41:51 PDT)
 */

package com.google.api.services.tasks;


import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;

import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import java.io.IOException;


/**
 * Service definition for Tasks (v1).
 *
 * <p>
 * Lets you manage your tasks and task lists.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="http://code.google.com/apis/tasks/v1/using.html" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link JsonHttpRequestInitializer} to initialize global parameters via its
 * {@link Builder}. Sample usage:
 * </p>
 *
 * <pre>
  public class TasksRequestInitializer implements JsonHttpRequestInitializer {
      public void initialize(JsonHttpRequest request) {
        TasksRequest tasksRequest = (TasksRequest)request;
        tasksRequest.setPrettyPrint(true);
        tasksRequest.setKey(ClientCredentials.KEY);
    }
  }
 * </pre>
 *
 * @since 1.3.0
 * @author Google, Inc.
 */
public class Tasks extends GoogleClient {

  /**
   * The default base URL of the service. This is determined when the library is generated and
   * normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/tasks/v1/";

  /**
   * The application name to be sent in the User-Agent header of each request.
   */
  @Deprecated
  private String applicationName;

  /**
   * The URL of the server hosting the API.
   */
  @Deprecated
  private String baseServer = "https://www.googleapis.com";

  /**
   * The base path of the service.
   */
  @Deprecated
  private String basePath = "/tasks/v1/";

  /**
   * Construct a Tasks instance to connect to the Tasks service.
   *
   * @param transport The transport to use for requests
   * @param requestInitializer A initializer to use to build requests for subsequent API calls. May
   *        be null if no initializer is required.
   * @param jsonFactory A factory for creating JSON parsers and serializers
   *
   * @deprecated (scheduled to be removed in 1.4) Use
   *             {@link #Tasks(HttpTransport, JsonFactory)} for only required
   *             params or {@link Builder} if you need to specify any of the optional params.
   */
  @Deprecated
  public Tasks(
      HttpTransport transport,
      HttpRequestInitializer requestInitializer,
      JsonFactory jsonFactory) {
    super(transport, new TasksRequestInitializer(), requestInitializer, jsonFactory,
        DEFAULT_BASE_URL, null);
    ((TasksRequestInitializer)getJsonHttpRequestInitializer()).setTasks(this);
  }

  /**
   * Construct a Tasks instance to connect to the Tasks service.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   */
  public Tasks(HttpTransport transport, JsonFactory jsonFactory) {
    this(transport, null, jsonFactory);
  }

  /**
   * Construct a Tasks instance to connect to the Tasks service.
   *
   * @param appName The application name. This is embedded into the User-Agent string
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   *
   * @deprecated (scheduled to be removed in 1.4) Use
   *             {@link #Tasks(HttpTransport, JsonFactory)} for only required
   *             params or {@link Builder} if you need to specify any of the optional params.
   */
  @Deprecated
  public Tasks(String appName, HttpTransport transport, JsonFactory jsonFactory) {
    this(transport, null, jsonFactory);
    setApplicationName(appName);
  }


  /** Returns response with indentations and line breaks. */
  @Key
  private Boolean prettyPrint;

  /**
   * Returns response with indentations and line breaks.    [default: true]
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Boolean getPrettyPrint() {
    return prettyPrint;
  }

  /**
   * Returns response with indentations and line breaks.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setPrettyPrint(Boolean prettyPrint) {
    this.prettyPrint = prettyPrint;
    return this;
  }

  /** Selector specifying which fields to include in a partial response. */
  @Key
  private String fields;

  /**
   * Selector specifying which fields to include in a partial response.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public String getFields() {
    return fields;
  }

  /**
   * Selector specifying which fields to include in a partial response.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
 * Available to use for quota purposes for server-side applications. Can be any arbitrary string
 * assigned to a user, but should not exceed 40 characters. Overrides userIp if both are provided.
 */
  @Key
  private String quotaUser;

  /**
   * Available to use for quota purposes for server-side applications. Can be any arbitrary string
   * assigned to a user, but should not exceed 40 characters. Overrides userIp if both are provided.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public String getQuotaUser() {
    return quotaUser;
  }

  /**
   * Available to use for quota purposes for server-side applications. Can be any arbitrary string
   * assigned to a user, but should not exceed 40 characters. Overrides userIp if both are provided.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setQuotaUser(String quotaUser) {
    this.quotaUser = quotaUser;
    return this;
  }

  /** OAuth 2.0 token for the current user. */
  @Key
  private String oauthToken;

  /**
   * OAuth 2.0 token for the current user.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public String getOauthToken() {
    return oauthToken;
  }

  /**
   * OAuth 2.0 token for the current user.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setOauthToken(String oauthToken) {
    this.oauthToken = oauthToken;
    return this;
  }

  /**
 * API key. Your API key identifies your project and provides you with API access, quota, and
 * reports. Required unless you provide an OAuth 2.0 token.
 */
  @Key
  private String key;

  /**
   * API key. Your API key identifies your project and provides you with API access, quota, and
   * reports. Required unless you provide an OAuth 2.0 token.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public String getKey() {
    return key;
  }

  /**
   * API key. Your API key identifies your project and provides you with API access, quota, and
   * reports. Required unless you provide an OAuth 2.0 token.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setKey(String key) {
    this.key = key;
    return this;
  }

  /**
 * IP address of the site where the request originates. Use this if you want to enforce per-user
 * limits.
 */
  @Key
  private String userIp;

  /**
   * IP address of the site where the request originates. Use this if you want to enforce per-user
   * limits.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public String getUserIp() {
    return userIp;
  }

  /**
   * IP address of the site where the request originates. Use this if you want to enforce per-user
   * limits.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setUserIp(String userIp) {
    this.userIp = userIp;
    return this;
  }

  /** Data format for the response. */
  @Key
  private String alt;

  /**
   * Data format for the response.    [default: json]
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public String getAlt() {
    return alt;
  }

  /**
   * Data format for the response.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link JsonHttpRequestInitializer}.
   */
  @Deprecated
  public Tasks setAlt(String alt) {
    this.alt = alt;
    return this;
  }

  /**
   * Created to maintain backwards compatibility (scheduled to be removed in 1.4).
   */
  private static class TasksRequestInitializer implements JsonHttpRequestInitializer {
    private Tasks tasks;
    void setTasks(Tasks tasks) {
      this.tasks = tasks;
    }
    public void initialize(JsonHttpRequest jsonHttpRequest) {
      TasksRequest request = (TasksRequest)jsonHttpRequest;
      request.setPrettyPrint(tasks.getPrettyPrint());
      request.setFields(tasks.getFields());
      request.setQuotaUser(tasks.getQuotaUser());
      request.setOauthToken(tasks.getOauthToken());
      request.setKey(tasks.getKey());
      request.setUserIp(tasks.getUserIp());
      request.setAlt(tasks.getAlt());
    }
  }

  /**
   * Construct a Tasks instance to connect to the Tasks service.
   *
   * @param transport The transport to use for requests
   * @param jsonHttpRequestInitializer The initializer to use when creating an JSON HTTP request
   * @param httpRequestInitializer The initializer to use when creating an {@link HttpRequest}
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param baseUrl The base url of the service on the server
   * @param applicationName The application name to be sent in the User-Agent header of requests
   */
  Tasks(
      HttpTransport transport,
      JsonHttpRequestInitializer jsonHttpRequestInitializer,
      HttpRequestInitializer httpRequestInitializer,
      JsonFactory jsonFactory,
      String baseUrl,
      String applicationName) {
      super(transport,
          jsonHttpRequestInitializer,
          httpRequestInitializer,
          jsonFactory,
          baseUrl,
          applicationName);
  }

  /**
   * Sets the application name to be sent in the User-Agent header of requests
   *
   * @param applicationName The application name
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link Builder}.
   */
  @Deprecated
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }

  /**
   * Returns the application name to be sent in the User-Agent header of requests or {@code null}
   * for none.
   *
   * <p>
   * This override will be removed in 1.4
   * </p>
   */
  @Override
  public String getApplicationName() {
    if (applicationName == null) {
      return super.getApplicationName();
    }
    return applicationName;
  }

  /**
   * Returns the base URL of the service, for example {@code "https://www.googleapis.com/tasks/v1/"}.
   *
   * <p>
   * This override will be removed in 1.4
   * </p>
   */
  @Override
  public String getBaseUrl() {
    String baseUrl = getBaseServer() + getBasePath();
    if (DEFAULT_BASE_URL.equals(baseUrl)) {
      return super.getBaseUrl();
    }
    return baseUrl;
  }

  /**
   * Sets the URL of the server hosting the API.
   *
   * @param baseServer The URL of the server hosting the API
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link Builder}.
   */
  @Deprecated
  public void setBaseServer(String baseServer) {
    this.baseServer = baseServer;
  }

  /**
   * Returns the URL of the server hosting the API, for example {@code "https://www.googleapis.com"}.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link #getBaseUrl}.
   */
  @Deprecated
  public String getBaseServer() {
    return baseServer;
  }

  /**
   * Sets the base path of the service.
   *
   * @param basePath The base path of the service
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link Builder}.
   */
  @Deprecated
  public void setBasePath(String basePath) {
    this.basePath = basePath;
  }

  /**
   * Returns the base path of the service, for example {@code "/tasks/v1/"}.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link #getBaseUrl}.
   */
  @Deprecated
  public String getBasePath() {
    return basePath;
  }

  /**
   * Returns an instance of a new builder.
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   */
   public static Builder builder(HttpTransport transport, JsonFactory jsonFactory) {
     return new Builder(transport, jsonFactory);
   }

  /**
   * An accessor for creating requests from the TasksOperations collection.
   *
   * The typical use is:<pre>
   *   {@code Tasks tasks = new Tasks(...);}
   *   {@code Tasks.TasksOperations.List request = tasks.tasks().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public TasksOperations tasks() {
    return new TasksOperations();
  }

  /**
   * An accessor for creating requests from the TasksOperations collection.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link #tasks()}
   */
  @Deprecated
  public final TasksOperations tasks = new TasksOperations();

  /**
   * The "tasks" collection of methods.
   */
  public class TasksOperations {

    /**
     * Creates a new task on the specified task list.
     *
     * Create a request for the method "tasks.insert".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param content the {@link Task}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(String tasklist, com.google.api.services.tasks.model.Task content) throws IOException {
      Insert result = new Insert(tasklist, content);
      initialize(result);
      return result;
    }

    public class Insert extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Insert(String tasklist, com.google.api.services.tasks.model.Task content) {
        super(Tasks.this, HttpMethod.POST, REST_PATH, content);
        this.tasklist = tasklist;
        this.content = content;
      }

      /**
       * Sends the "insert" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.Task} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.Task execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.Task result = response.parseAs(
            com.google.api.services.tasks.model.Task.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Insert setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /**
     * Parent task identifier. If the task is created at the top level, this parameter is omitted.
     * Optional.
     */
      @Key("parent")
      private String parent;

      /**  Parent task identifier. If the task is created at the top level, this parameter is omitted.
      Optional.
       */
      public String getParent() {
        return parent;
      }

      /**
     * Parent task identifier. If the task is created at the top level, this parameter is omitted.
     * Optional.
     */
      public Insert setParent(String parent) {
        this.parent = parent;
        return this;
      }

      /**
     * Previous sibling task identifier. If the task is created at the first position among its
     * siblings, this parameter is omitted. Optional.
     */
      @Key("previous")
      private String previous;

      /**  Previous sibling task identifier. If the task is created at the first position among its siblings,
      this parameter is omitted. Optional.
       */
      public String getPrevious() {
        return previous;
      }

      /**
     * Previous sibling task identifier. If the task is created at the first position among its
     * siblings, this parameter is omitted. Optional.
     */
      public Insert setPrevious(String previous) {
        this.previous = previous;
        return this;
      }


      private com.google.api.services.tasks.model.Task content;

    }
    /**
     * Returns the specified task.
     *
     * Create a request for the method "tasks.get".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String tasklist, String task) throws IOException {
      Get result = new Get(tasklist, task);
      initialize(result);
      return result;
    }

    public class Get extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Get(String tasklist, String task) {
        super(Tasks.this, HttpMethod.GET, REST_PATH, null);
        this.tasklist = tasklist;
        this.task = task;
      }

      /**
       * Sends the "get" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.Task} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.Task execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.Task result = response.parseAs(
            com.google.api.services.tasks.model.Task.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Get setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @Key("task")
      private String task;

      /**  Task identifier.
       */
      public String getTask() {
        return task;
      }

      /** Task identifier. */
      public Get setTask(String task) {
        this.task = task;
        return this;
      }


    }
    /**
     * Clears all completed tasks from the specified task list. The affected tasks will be marked as
     * 'hidden' and no longer be returned by default when retrieving all tasks for a task list.
     *
     * Create a request for the method "tasks.clear".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Clear#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Clear clear(String tasklist) throws IOException {
      Clear result = new Clear(tasklist);
      initialize(result);
      return result;
    }

    public class Clear extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/clear";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Clear(String tasklist) {
        super(Tasks.this, HttpMethod.POST, REST_PATH, null);
        this.tasklist = tasklist;
      }

      /**
       * Sends the "clear" request to the Tasks server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();

        response.ignore();

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Clear setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }


    }
    /**
     * Moves the specified task to another position in the task list. This can include putting it as a
     * child task under a new parent and/or move it to a different position among its sibling tasks.
     *
     * Create a request for the method "tasks.move".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Move#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Move move(String tasklist, String task) throws IOException {
      Move result = new Move(tasklist, task);
      initialize(result);
      return result;
    }

    public class Move extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}/move";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Move(String tasklist, String task) {
        super(Tasks.this, HttpMethod.POST, REST_PATH, null);
        this.tasklist = tasklist;
        this.task = task;
      }

      /**
       * Sends the "move" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.Task} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.Task execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.Task result = response.parseAs(
            com.google.api.services.tasks.model.Task.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Move setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @Key("task")
      private String task;

      /**  Task identifier.
       */
      public String getTask() {
        return task;
      }

      /** Task identifier. */
      public Move setTask(String task) {
        this.task = task;
        return this;
      }

      /**
     * New parent task identifier. If the task is moved to the top level, this parameter is omitted.
     * Optional.
     */
      @Key("parent")
      private String parent;

      /**  New parent task identifier. If the task is moved to the top level, this parameter is omitted.
      Optional.
       */
      public String getParent() {
        return parent;
      }

      /**
     * New parent task identifier. If the task is moved to the top level, this parameter is omitted.
     * Optional.
     */
      public Move setParent(String parent) {
        this.parent = parent;
        return this;
      }

      /**
     * New previous sibling task identifier. If the task is moved to the first position among its
     * siblings, this parameter is omitted. Optional.
     */
      @Key("previous")
      private String previous;

      /**  New previous sibling task identifier. If the task is moved to the first position among its
      siblings, this parameter is omitted. Optional.
       */
      public String getPrevious() {
        return previous;
      }

      /**
     * New previous sibling task identifier. If the task is moved to the first position among its
     * siblings, this parameter is omitted. Optional.
     */
      public Move setPrevious(String previous) {
        this.previous = previous;
        return this;
      }


    }
    /**
     * Returns all tasks in the specified task list.
     *
     * Create a request for the method "tasks.list".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list(String tasklist) throws IOException {
      List result = new List(tasklist);
      initialize(result);
      return result;
    }

    public class List extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private List(String tasklist) {
        super(Tasks.this, HttpMethod.GET, REST_PATH, null);
        this.tasklist = tasklist;
      }

      /**
       * Sends the "list" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.Tasks} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.Tasks execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.Tasks result = response.parseAs(
            com.google.api.services.tasks.model.Tasks.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public List setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /**
     * Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
     * default is not to filter by due date.
     */
      @Key("dueMax")
      private String dueMax;

      /**  Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The default is
      not to filter by due date.
       */
      public String getDueMax() {
        return dueMax;
      }

      /**
     * Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
     * default is not to filter by due date.
     */
      public List setDueMax(String dueMax) {
        this.dueMax = dueMax;
        return this;
      }

      /**
     * Flag indicating whether deleted tasks are returned in the result. Optional. The default is
     * False.
     */
      @Key("showDeleted")
      private Boolean showDeleted;

      /**  Flag indicating whether deleted tasks are returned in the result. Optional. The default is False.
       */
      public Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
     * Flag indicating whether deleted tasks are returned in the result. Optional. The default is
     * False.
     */
      public List setShowDeleted(Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /**
     * Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by.
     * Optional. The default is not to filter by last modification time.
     */
      @Key("updatedMin")
      private String updatedMin;

      /**  Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by. Optional.
      The default is not to filter by last modification time.
       */
      public String getUpdatedMin() {
        return updatedMin;
      }

      /**
     * Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by.
     * Optional. The default is not to filter by last modification time.
     */
      public List setUpdatedMin(String updatedMin) {
        this.updatedMin = updatedMin;
        return this;
      }

      /**
     * Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
     * The default is not to filter by completion date.
     */
      @Key("completedMin")
      private String completedMin;

      /**  Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional. The
      default is not to filter by completion date.
       */
      public String getCompletedMin() {
        return completedMin;
      }

      /**
     * Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
     * The default is not to filter by completion date.
     */
      public List setCompletedMin(String completedMin) {
        this.completedMin = completedMin;
        return this;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      @Key("maxResults")
      private Long maxResults;

      /**  Maximum number of task lists returned on one page. Optional. The default is 100.
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
     * Flag indicating whether completed tasks are returned in the result. Optional. The default is
     * True.
     */
      @Key("showCompleted")
      private Boolean showCompleted;

      /**  Flag indicating whether completed tasks are returned in the result. Optional. The default is True.
       */
      public Boolean getShowCompleted() {
        return showCompleted;
      }

      /**
     * Flag indicating whether completed tasks are returned in the result. Optional. The default is
     * True.
     */
      public List setShowCompleted(Boolean showCompleted) {
        this.showCompleted = showCompleted;
        return this;
      }

      /** Token specifying the result page to return. Optional. */
      @Key("pageToken")
      private String pageToken;

      /**  Token specifying the result page to return. Optional.
       */
      public String getPageToken() {
        return pageToken;
      }

      /** Token specifying the result page to return. Optional. */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
     * Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
     * The default is not to filter by completion date.
     */
      @Key("completedMax")
      private String completedMax;

      /**  Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional. The
      default is not to filter by completion date.
       */
      public String getCompletedMax() {
        return completedMax;
      }

      /**
     * Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
     * The default is not to filter by completion date.
     */
      public List setCompletedMax(String completedMax) {
        this.completedMax = completedMax;
        return this;
      }

      /**
     * Flag indicating whether hidden tasks are returned in the result. Optional. The default is
     * False.
     */
      @Key("showHidden")
      private Boolean showHidden;

      /**  Flag indicating whether hidden tasks are returned in the result. Optional. The default is False.
       */
      public Boolean getShowHidden() {
        return showHidden;
      }

      /**
     * Flag indicating whether hidden tasks are returned in the result. Optional. The default is
     * False.
     */
      public List setShowHidden(Boolean showHidden) {
        this.showHidden = showHidden;
        return this;
      }

      /**
     * Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
     * default is not to filter by due date.
     */
      @Key("dueMin")
      private String dueMin;

      /**  Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The default is
      not to filter by due date.
       */
      public String getDueMin() {
        return dueMin;
      }

      /**
     * Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
     * default is not to filter by due date.
     */
      public List setDueMin(String dueMin) {
        this.dueMin = dueMin;
        return this;
      }


    }
    /**
     * Updates the specified task.
     *
     * Create a request for the method "tasks.update".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @param content the {@link Task}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Update update(String tasklist, String task, com.google.api.services.tasks.model.Task content) throws IOException {
      Update result = new Update(tasklist, task, content);
      initialize(result);
      return result;
    }

    public class Update extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Update(String tasklist, String task, com.google.api.services.tasks.model.Task content) {
        super(Tasks.this, HttpMethod.PUT, REST_PATH, content);
        this.tasklist = tasklist;
        this.task = task;
        this.content = content;
      }

      /**
       * Sends the "update" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.Task} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.Task execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.Task result = response.parseAs(
            com.google.api.services.tasks.model.Task.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Update setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @Key("task")
      private String task;

      /**  Task identifier.
       */
      public String getTask() {
        return task;
      }

      /** Task identifier. */
      public Update setTask(String task) {
        this.task = task;
        return this;
      }


      private com.google.api.services.tasks.model.Task content;

    }
    /**
     * Updates the specified task. This method supports patch semantics.
     *
     * Create a request for the method "tasks.patch".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @param content the {@link Task}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Patch patch(String tasklist, String task, com.google.api.services.tasks.model.Task content) throws IOException {
      Patch result = new Patch(tasklist, task, content);
      initialize(result);
      return result;
    }

    public class Patch extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Patch(String tasklist, String task, com.google.api.services.tasks.model.Task content) {
        super(Tasks.this, HttpMethod.PATCH, REST_PATH, content);
        this.tasklist = tasklist;
        this.task = task;
        this.content = content;
      }

      /**
       * Sends the "patch" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.Task} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.Task execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.Task result = response.parseAs(
            com.google.api.services.tasks.model.Task.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Patch setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @Key("task")
      private String task;

      /**  Task identifier.
       */
      public String getTask() {
        return task;
      }

      /** Task identifier. */
      public Patch setTask(String task) {
        this.task = task;
        return this;
      }


      private com.google.api.services.tasks.model.Task content;

    }
    /**
     * Deletes the specified task from the task list.
     *
     * Create a request for the method "tasks.delete".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String tasklist, String task) throws IOException {
      Delete result = new Delete(tasklist, task);
      initialize(result);
      return result;
    }

    public class Delete extends TasksRequest {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Delete(String tasklist, String task) {
        super(Tasks.this, HttpMethod.DELETE, REST_PATH, null);
        this.tasklist = tasklist;
        this.task = task;
      }

      /**
       * Sends the "delete" request to the Tasks server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();

        response.ignore();

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Delete setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @Key("task")
      private String task;

      /**  Task identifier.
       */
      public String getTask() {
        return task;
      }

      /** Task identifier. */
      public Delete setTask(String task) {
        this.task = task;
        return this;
      }


    }

  }

  /**
   * An accessor for creating requests from the Tasklists collection.
   *
   * The typical use is:<pre>
   *   {@code Tasks tasks = new Tasks(...);}
   *   {@code Tasks.Tasklists.List request = tasks.tasklists().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Tasklists tasklists() {
    return new Tasklists();
  }

  /**
   * An accessor for creating requests from the Tasklists collection.
   *
   * @deprecated (scheduled to be removed in 1.4) Use {@link #tasklists()}
   */
  @Deprecated
  public final Tasklists tasklists = new Tasklists();

  /**
   * The "tasklists" collection of methods.
   */
  public class Tasklists {

    /**
     * Creates a new task list and adds it to the authenticated user's task lists.
     *
     * Create a request for the method "tasklists.insert".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link TaskList}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.tasks.model.TaskList content) throws IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends TasksRequest {

      private static final String REST_PATH = "users/@me/lists";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Insert(com.google.api.services.tasks.model.TaskList content) {
        super(Tasks.this, HttpMethod.POST, REST_PATH, content);
        this.content = content;
      }

      /**
       * Sends the "insert" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.TaskList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.TaskList execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.TaskList result = response.parseAs(
            com.google.api.services.tasks.model.TaskList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }



      private com.google.api.services.tasks.model.TaskList content;

    }
    /**
     * Returns the authenticated user's specified task list.
     *
     * Create a request for the method "tasklists.get".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String tasklist) throws IOException {
      Get result = new Get(tasklist);
      initialize(result);
      return result;
    }

    public class Get extends TasksRequest {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Get(String tasklist) {
        super(Tasks.this, HttpMethod.GET, REST_PATH, null);
        this.tasklist = tasklist;
      }

      /**
       * Sends the "get" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.TaskList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.TaskList execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.TaskList result = response.parseAs(
            com.google.api.services.tasks.model.TaskList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Get setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }


    }
    /**
     * Returns all the authenticated user's task lists.
     *
     * Create a request for the method "tasklists.list".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list() throws IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends TasksRequest {

      private static final String REST_PATH = "users/@me/lists";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private List() {
        super(Tasks.this, HttpMethod.GET, REST_PATH, null);
      }

      /**
       * Sends the "list" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.TaskLists} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.TaskLists execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.TaskLists result = response.parseAs(
            com.google.api.services.tasks.model.TaskLists.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Token specifying the result page to return. Optional. */
      @Key("pageToken")
      private String pageToken;

      /**  Token specifying the result page to return. Optional.
       */
      public String getPageToken() {
        return pageToken;
      }

      /** Token specifying the result page to return. Optional. */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      @Key("maxResults")
      private Long maxResults;

      /**  Maximum number of task lists returned on one page. Optional. The default is 100.
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }


    }
    /**
     * Updates the authenticated user's specified task list.
     *
     * Create a request for the method "tasklists.update".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param content the {@link TaskList}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Update update(String tasklist, com.google.api.services.tasks.model.TaskList content) throws IOException {
      Update result = new Update(tasklist, content);
      initialize(result);
      return result;
    }

    public class Update extends TasksRequest {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Update(String tasklist, com.google.api.services.tasks.model.TaskList content) {
        super(Tasks.this, HttpMethod.PUT, REST_PATH, content);
        this.tasklist = tasklist;
        this.content = content;
      }

      /**
       * Sends the "update" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.TaskList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.TaskList execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.TaskList result = response.parseAs(
            com.google.api.services.tasks.model.TaskList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Update setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }


      private com.google.api.services.tasks.model.TaskList content;

    }
    /**
     * Updates the authenticated user's specified task list. This method supports patch semantics.
     *
     * Create a request for the method "tasklists.patch".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param content the {@link TaskList}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Patch patch(String tasklist, com.google.api.services.tasks.model.TaskList content) throws IOException {
      Patch result = new Patch(tasklist, content);
      initialize(result);
      return result;
    }

    public class Patch extends TasksRequest {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Patch(String tasklist, com.google.api.services.tasks.model.TaskList content) {
        super(Tasks.this, HttpMethod.PATCH, REST_PATH, content);
        this.tasklist = tasklist;
        this.content = content;
      }

      /**
       * Sends the "patch" request to the Tasks server.
       *
       * @return the {@link com.google.api.services.tasks.model.TaskList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.tasks.model.TaskList execute() throws IOException {
        HttpResponse response = executeUnparsed();

        com.google.api.services.tasks.model.TaskList result = response.parseAs(
            com.google.api.services.tasks.model.TaskList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Patch setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }


      private com.google.api.services.tasks.model.TaskList content;

    }
    /**
     * Deletes the authenticated user's specified task list.
     *
     * Create a request for the method "tasklists.delete".
     *
     * This request holds the parameters needed by the the tasks server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String tasklist) throws IOException {
      Delete result = new Delete(tasklist);
      initialize(result);
      return result;
    }

    public class Delete extends TasksRequest {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      private Delete(String tasklist) {
        super(Tasks.this, HttpMethod.DELETE, REST_PATH, null);
        this.tasklist = tasklist;
      }

      /**
       * Sends the "delete" request to the Tasks server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();

        response.ignore();

      }


      /** Task list identifier. */
      @Key("tasklist")
      private String tasklist;

      /**  Task list identifier.
       */
      public String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Delete setTasklist(String tasklist) {
        this.tasklist = tasklist;
        return this;
      }


    }

  }



  /**
   * Builder for {@link Tasks}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends GoogleClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport The transport to use for requests
     * @param jsonFactory A factory for creating JSON parsers and serializers
     */
    Builder(HttpTransport transport, JsonFactory jsonFactory) {
      super(transport, jsonFactory, new GenericUrl(DEFAULT_BASE_URL));
    }

    /** Builds a new instance of {@link Tasks}. */
    @Override
    public Tasks build() {
      return new Tasks(
          getTransport(),
          getJsonHttpRequestInitializer(),
          getHttpRequestInitializer(),
          getJsonFactory(),
          getBaseUrl().build(),
          getApplicationName());
    }

    @Override
    public Builder setJsonHttpRequestInitializer(
        JsonHttpRequestInitializer jsonHttpRequestInitializer) {
      super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
      return this;
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      super.setHttpRequestInitializer(httpRequestInitializer);
      return this;
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      super.setApplicationName(applicationName);
      return this;
    }
  }
}
