/*
 * Copyright (c) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.tasks.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;


/**
 * Model definition for Tasks.Task.
 *
 * This class models an object which will be transmitted to or from the Tasks service. To reduce the
 * data transferred during service requests, you may remove members that contain data elements that
 * your application does not need.
 *
 * For a detailed explanation, see: <a href="http://code.google.com/p/google-api-java-
 * client/wiki/Json"> http://code.google.com/p/google-api-java-client/wiki/Json</a>
 *
 * @author Google, Inc.
 */
public final class Task extends GenericJson {

  /**
   * Status of the task. This is either "needsAction" or "completed".
   */
  @Key("status")
  private String status;

  /** Status of the task. This is either "needsAction" or "completed". */
  public String getStatus() {
    return status;
  }

  /** Status of the task. This is either "needsAction" or "completed". */
  public Task setStatus(String status) {
    this.status = status;
    return this;
  }
  /**
   * Type of the resource. This is always "tasks#task".
   */
  @Key("kind")
  private String kind;

  /** Type of the resource. This is always "tasks#task". */
  public String getKind() {
    return kind;
  }

  /** Type of the resource. This is always "tasks#task". */
  public Task setKind(String kind) {
    this.kind = kind;
    return this;
  }
  /**
   * Last modification time of the task (as a RFC 3339 timestamp).
   */
  @Key("updated")
  private DateTime updated;

  /** Last modification time of the task (as a RFC 3339 timestamp). */
  public DateTime getUpdated() {
    return updated;
  }

  /** Last modification time of the task (as a RFC 3339 timestamp). */
  public Task setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }
  /**
   * Parent task identifier. This field is omitted if it is a top-level task. This field is read-
   * only. Use the "move" method to move the task under a different parent or to the top level.
   */
  @Key("parent")
  private String parent;

  /**
 * Parent task identifier. This field is omitted if it is a top-level task. This field is read-only.
 * Use the "move" method to move the task under a different parent or to the top level.
 */
  public String getParent() {
    return parent;
  }

  /**
 * Parent task identifier. This field is omitted if it is a top-level task. This field is read-only.
 * Use the "move" method to move the task under a different parent or to the top level.
 */
  public Task setParent(String parent) {
    this.parent = parent;
    return this;
  }
  /**
   * Title of the task.
   */
  @Key("title")
  private String title;

  /** Title of the task. */
  public String getTitle() {
    return title;
  }

  /** Title of the task. */
  public Task setTitle(String title) {
    this.title = title;
    return this;
  }
  /**
   * Flag indicating whether the task has been deleted. The default if False.
   */
  @Key("deleted")
  private Boolean deleted;

  /** Flag indicating whether the task has been deleted. The default if False. */
  public Boolean getDeleted() {
    return deleted;
  }

  /** Flag indicating whether the task has been deleted. The default if False. */
  public Task setDeleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }
  /**
   * Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has
   * not been completed.
   */
  @Key("completed")
  private DateTime completed;

  /**
 * Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has not
 * been completed.
 */
  public DateTime getCompleted() {
    return completed;
  }

  /**
 * Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has not
 * been completed.
 */
  public Task setCompleted(DateTime completed) {
    this.completed = completed;
    return this;
  }
  /**
   * Due date of the task (as a RFC 3339 timestamp). Optional.
   */
  @Key("due")
  private DateTime due;

  /** Due date of the task (as a RFC 3339 timestamp). Optional. */
  public DateTime getDue() {
    return due;
  }

  /** Due date of the task (as a RFC 3339 timestamp). Optional. */
  public Task setDue(DateTime due) {
    this.due = due;
    return this;
  }
  /**
   * ETag of the resource.
   */
  @Key("etag")
  private String etag;

  /** ETag of the resource. */
  public String getEtag() {
    return etag;
  }

  /** ETag of the resource. */
  public Task setEtag(String etag) {
    this.etag = etag;
    return this;
  }
  /**
   * Notes describing the task. Optional.
   */
  @Key("notes")
  private String notes;

  /** Notes describing the task. Optional. */
  public String getNotes() {
    return notes;
  }

  /** Notes describing the task. Optional. */
  public Task setNotes(String notes) {
    this.notes = notes;
    return this;
  }
  /**
   * String indicating the position of the task among its sibling tasks under the same parent task
   * or at the top level. If this string is greater than another task's corresponding position
   * string according to lexicographical ordering, the task is positioned after the other task under
   * the same parent task (or at the top level). This field is read-only. Use the "move" method to
   * move the task to another position.
   */
  @Key("position")
  private String position;

  /**
 * String indicating the position of the task among its sibling tasks under the same parent task or
 * at the top level. If this string is greater than another task's corresponding position string
 * according to lexicographical ordering, the task is positioned after the other task under the same
 * parent task (or at the top level). This field is read-only. Use the "move" method to move the
 * task to another position.
 */
  public String getPosition() {
    return position;
  }

  /**
 * String indicating the position of the task among its sibling tasks under the same parent task or
 * at the top level. If this string is greater than another task's corresponding position string
 * according to lexicographical ordering, the task is positioned after the other task under the same
 * parent task (or at the top level). This field is read-only. Use the "move" method to move the
 * task to another position.
 */
  public Task setPosition(String position) {
    this.position = position;
    return this;
  }
  /**
   * Flag indicating whether the task is hidden. This is the case if the task had been marked
   * completed when the task list was last cleared. The default is False. This field is read-only.
   */
  @Key("hidden")
  private Boolean hidden;

  /**
 * Flag indicating whether the task is hidden. This is the case if the task had been marked
 * completed when the task list was last cleared. The default is False. This field is read-only.
 */
  public Boolean getHidden() {
    return hidden;
  }

  /**
 * Flag indicating whether the task is hidden. This is the case if the task had been marked
 * completed when the task list was last cleared. The default is False. This field is read-only.
 */
  public Task setHidden(Boolean hidden) {
    this.hidden = hidden;
    return this;
  }
  /**
   * Task identifier.
   */
  @Key("id")
  private String id;

  /** Task identifier. */
  public String getId() {
    return id;
  }

  /** Task identifier. */
  public Task setId(String id) {
    this.id = id;
    return this;
  }
  /**
   * URL pointing to this task. Used to retrieve, update, or delete this task.
   */
  @Key("selfLink")
  private String selfLink;

  /** URL pointing to this task. Used to retrieve, update, or delete this task. */
  public String getSelfLink() {
    return selfLink;
  }

  /** URL pointing to this task. Used to retrieve, update, or delete this task. */
  public Task setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single Task would include the response headers, while a
   * request which returns an array of Task, would have a non-null response header in the enclosing
   * object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }
}
