/*
 * Copyright (c) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.tasks.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;


/**
 * Model definition for Tasks.TaskList.
 *
 * This class models an object which will be transmitted to or from the Tasks service. To reduce the
 * data transferred during service requests, you may remove members that contain data elements that
 * your application does not need.
 *
 * For a detailed explanation, see: <a href="http://code.google.com/p/google-api-java-
 * client/wiki/Json"> http://code.google.com/p/google-api-java-client/wiki/Json</a>
 *
 * @author Google, Inc.
 */
public final class TaskList extends GenericJson {

  /**
   * Type of the resource. This is always "tasks#taskList".
   */
  @Key("kind")
  private String kind;

  /** Type of the resource. This is always "tasks#taskList". */
  public String getKind() {
    return kind;
  }

  /** Type of the resource. This is always "tasks#taskList". */
  public TaskList setKind(String kind) {
    this.kind = kind;
    return this;
  }
  /**
   * ETag of the resource.
   */
  @Key("etag")
  private String etag;

  /** ETag of the resource. */
  public String getEtag() {
    return etag;
  }

  /** ETag of the resource. */
  public TaskList setEtag(String etag) {
    this.etag = etag;
    return this;
  }
  /**
   * Task list identifier.
   */
  @Key("id")
  private String id;

  /** Task list identifier. */
  public String getId() {
    return id;
  }

  /** Task list identifier. */
  public TaskList setId(String id) {
    this.id = id;
    return this;
  }
  /**
   * URL pointing to this task list. Used to retrieve, update, or delete this task list.
   */
  @Key("selfLink")
  private String selfLink;

  /** URL pointing to this task list. Used to retrieve, update, or delete this task list. */
  public String getSelfLink() {
    return selfLink;
  }

  /** URL pointing to this task list. Used to retrieve, update, or delete this task list. */
  public TaskList setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }
  /**
   * Title of the task list.
   */
  @Key("title")
  private String title;

  /** Title of the task list. */
  public String getTitle() {
    return title;
  }

  /** Title of the task list. */
  public TaskList setTitle(String title) {
    this.title = title;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single TaskList would include the response headers, while a
   * request which returns an array of TaskList, would have a non-null response header in the
   * enclosing object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }
}
