/*
 * Copyright (c) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.tasks.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.Key;


/**
 * Model definition for Tasks.Tasks.
 *
 * This class models an object which will be transmitted to or from the Tasks service. To reduce the
 * data transferred during service requests, you may remove members that contain data elements that
 * your application does not need.
 *
 * For a detailed explanation, see: <a href="http://code.google.com/p/google-api-java-
 * client/wiki/Json"> http://code.google.com/p/google-api-java-client/wiki/Json</a>
 *
 * @author Google, Inc.
 */
public final class Tasks extends GenericJson {

  /**
   * Token used to access the next page of this result.
   */
  @Key("nextPageToken")
  private String nextPageToken;

  /** Token used to access the next page of this result. */
  public String getNextPageToken() {
    return nextPageToken;
  }

  /** Token used to access the next page of this result. */
  public Tasks setNextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }
  /**
   * Collection of tasks.
   */
  @Key("items")
  private java.util.List<Task> items;

  /** Collection of tasks. */
  public java.util.List<Task> getItems() {
    return items;
  }

  /** Collection of tasks. */
  public Tasks setItems(java.util.List<Task> items) {
    this.items = items;
    return this;
  }
  /**
   * Type of the resource. This is always "tasks#tasks".
   */
  @Key("kind")
  private String kind;

  /** Type of the resource. This is always "tasks#tasks". */
  public String getKind() {
    return kind;
  }

  /** Type of the resource. This is always "tasks#tasks". */
  public Tasks setKind(String kind) {
    this.kind = kind;
    return this;
  }
  /**
   * ETag of the resource.
   */
  @Key("etag")
  private String etag;

  /** ETag of the resource. */
  public String getEtag() {
    return etag;
  }

  /** ETag of the resource. */
  public Tasks setEtag(String etag) {
    this.etag = etag;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single Tasks would include the response headers, while a
   * request which returns an array of Tasks, would have a non-null response header in the enclosing
   * object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }
}
