/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.tasks;

import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.services.tasks.TasksRequest;
import com.google.api.services.tasks.model.Task;
import com.google.api.services.tasks.model.TaskList;
import com.google.api.services.tasks.model.TaskLists;
import java.io.IOException;

public class Tasks
extends GoogleClient {
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/tasks/v1/";
    @Deprecated
    private String applicationName;
    @Deprecated
    private String baseServer = "https://www.googleapis.com";
    @Deprecated
    private String basePath = "/tasks/v1/";
    @Key
    private Boolean prettyPrint;
    @Key
    private String fields;
    @Key
    private String quotaUser;
    @Key
    private String oauthToken;
    @Key
    private String key;
    @Key
    private String userIp;
    @Key
    private String alt;
    @Deprecated
    public final TasksOperations tasks = new TasksOperations();
    @Deprecated
    public final Tasklists tasklists = new Tasklists();

    @Deprecated
    public Tasks(HttpTransport transport, HttpRequestInitializer requestInitializer, JsonFactory jsonFactory) {
        super(transport, (JsonHttpRequestInitializer)new TasksRequestInitializer(), requestInitializer, jsonFactory, DEFAULT_BASE_URL, null);
        ((TasksRequestInitializer)this.getJsonHttpRequestInitializer()).setTasks(this);
    }

    public Tasks(HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
    }

    @Deprecated
    public Tasks(String appName, HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
        this.setApplicationName(appName);
    }

    @Deprecated
    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    @Deprecated
    public Tasks setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    @Deprecated
    public String getFields() {
        return this.fields;
    }

    @Deprecated
    public Tasks setFields(String fields) {
        this.fields = fields;
        return this;
    }

    @Deprecated
    public String getQuotaUser() {
        return this.quotaUser;
    }

    @Deprecated
    public Tasks setQuotaUser(String quotaUser) {
        this.quotaUser = quotaUser;
        return this;
    }

    @Deprecated
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Deprecated
    public Tasks setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return this;
    }

    @Deprecated
    public String getKey() {
        return this.key;
    }

    @Deprecated
    public Tasks setKey(String key) {
        this.key = key;
        return this;
    }

    @Deprecated
    public String getUserIp() {
        return this.userIp;
    }

    @Deprecated
    public Tasks setUserIp(String userIp) {
        this.userIp = userIp;
        return this;
    }

    @Deprecated
    public String getAlt() {
        return this.alt;
    }

    @Deprecated
    public Tasks setAlt(String alt) {
        this.alt = alt;
        return this;
    }

    Tasks(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, baseUrl, applicationName);
    }

    @Deprecated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            return super.getApplicationName();
        }
        return this.applicationName;
    }

    public String getBaseUrl() {
        String baseUrl = this.getBaseServer() + this.getBasePath();
        if (DEFAULT_BASE_URL.equals(baseUrl)) {
            return super.getBaseUrl();
        }
        return baseUrl;
    }

    @Deprecated
    public void setBaseServer(String baseServer) {
        this.baseServer = baseServer;
    }

    @Deprecated
    public String getBaseServer() {
        return this.baseServer;
    }

    @Deprecated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Deprecated
    public String getBasePath() {
        return this.basePath;
    }

    public static Builder builder(HttpTransport transport, JsonFactory jsonFactory) {
        return new Builder(transport, jsonFactory);
    }

    public TasksOperations tasks() {
        return new TasksOperations();
    }

    public Tasklists tasklists() {
        return new Tasklists();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        Builder(HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory, new GenericUrl(Tasks.DEFAULT_BASE_URL));
        }

        public Tasks build() {
            return new Tasks(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getBaseUrl().build(), this.getApplicationName());
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String applicationName) {
            super.setApplicationName(applicationName);
            return this;
        }
    }

    public class Tasklists {
        public Insert insert(TaskList content) throws IOException {
            Insert result = new Insert(content);
            Tasks.this.initialize(result);
            return result;
        }

        public Get get(String tasklist) throws IOException {
            Get result = new Get(tasklist);
            Tasks.this.initialize(result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Tasks.this.initialize(result);
            return result;
        }

        public Update update(String tasklist, TaskList content) throws IOException {
            Update result = new Update(tasklist, content);
            Tasks.this.initialize(result);
            return result;
        }

        public Patch patch(String tasklist, TaskList content) throws IOException {
            Patch result = new Patch(tasklist, content);
            Tasks.this.initialize(result);
            return result;
        }

        public Delete delete(String tasklist) throws IOException {
            Delete result = new Delete(tasklist);
            Tasks.this.initialize(result);
            return result;
        }

        public class Delete
        extends TasksRequest {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key(value="tasklist")
            private String tasklist;

            private Delete(String tasklist) {
                super((JsonHttpClient)Tasks.this, HttpMethod.DELETE, REST_PATH, null);
                this.tasklist = tasklist;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Delete setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }
        }

        public class Patch
        extends TasksRequest {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key(value="tasklist")
            private String tasklist;
            private TaskList content;

            private Patch(String tasklist, TaskList content) {
                super((JsonHttpClient)Tasks.this, HttpMethod.PATCH, REST_PATH, (Object)content);
                this.tasklist = tasklist;
                this.content = content;
            }

            public TaskList execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                TaskList result = (TaskList)((Object)response.parseAs(TaskList.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Patch setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }
        }

        public class Update
        extends TasksRequest {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key(value="tasklist")
            private String tasklist;
            private TaskList content;

            private Update(String tasklist, TaskList content) {
                super((JsonHttpClient)Tasks.this, HttpMethod.PUT, REST_PATH, (Object)content);
                this.tasklist = tasklist;
                this.content = content;
            }

            public TaskList execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                TaskList result = (TaskList)((Object)response.parseAs(TaskList.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Update setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }
        }

        public class List
        extends TasksRequest {
            private static final String REST_PATH = "users/@me/lists";
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private List() {
                super((JsonHttpClient)Tasks.this, HttpMethod.GET, REST_PATH, null);
            }

            public TaskLists execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                TaskLists result = (TaskLists)((Object)response.parseAs(TaskLists.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }

        public class Get
        extends TasksRequest {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key(value="tasklist")
            private String tasklist;

            private Get(String tasklist) {
                super((JsonHttpClient)Tasks.this, HttpMethod.GET, REST_PATH, null);
                this.tasklist = tasklist;
            }

            public TaskList execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                TaskList result = (TaskList)((Object)response.parseAs(TaskList.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Get setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }
        }

        public class Insert
        extends TasksRequest {
            private static final String REST_PATH = "users/@me/lists";
            private TaskList content;

            private Insert(TaskList content) {
                super((JsonHttpClient)Tasks.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.content = content;
            }

            public TaskList execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                TaskList result = (TaskList)((Object)response.parseAs(TaskList.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }
        }
    }

    public class TasksOperations {
        public Insert insert(String tasklist, Task content) throws IOException {
            Insert result = new Insert(tasklist, content);
            Tasks.this.initialize(result);
            return result;
        }

        public Get get(String tasklist, String task) throws IOException {
            Get result = new Get(tasklist, task);
            Tasks.this.initialize(result);
            return result;
        }

        public Clear clear(String tasklist) throws IOException {
            Clear result = new Clear(tasklist);
            Tasks.this.initialize(result);
            return result;
        }

        public Move move(String tasklist, String task) throws IOException {
            Move result = new Move(tasklist, task);
            Tasks.this.initialize(result);
            return result;
        }

        public List list(String tasklist) throws IOException {
            List result = new List(tasklist);
            Tasks.this.initialize(result);
            return result;
        }

        public Update update(String tasklist, String task, Task content) throws IOException {
            Update result = new Update(tasklist, task, content);
            Tasks.this.initialize(result);
            return result;
        }

        public Patch patch(String tasklist, String task, Task content) throws IOException {
            Patch result = new Patch(tasklist, task, content);
            Tasks.this.initialize(result);
            return result;
        }

        public Delete delete(String tasklist, String task) throws IOException {
            Delete result = new Delete(tasklist, task);
            Tasks.this.initialize(result);
            return result;
        }

        public class Delete
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="task")
            private String task;

            private Delete(String tasklist, String task) {
                super((JsonHttpClient)Tasks.this, HttpMethod.DELETE, REST_PATH, null);
                this.tasklist = tasklist;
                this.task = task;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Delete setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Delete setTask(String task) {
                this.task = task;
                return this;
            }
        }

        public class Patch
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="task")
            private String task;
            private Task content;

            private Patch(String tasklist, String task, Task content) {
                super((JsonHttpClient)Tasks.this, HttpMethod.PATCH, REST_PATH, (Object)content);
                this.tasklist = tasklist;
                this.task = task;
                this.content = content;
            }

            public Task execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Task result = (Task)((Object)response.parseAs(Task.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Patch setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Patch setTask(String task) {
                this.task = task;
                return this;
            }
        }

        public class Update
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="task")
            private String task;
            private Task content;

            private Update(String tasklist, String task, Task content) {
                super((JsonHttpClient)Tasks.this, HttpMethod.PUT, REST_PATH, (Object)content);
                this.tasklist = tasklist;
                this.task = task;
                this.content = content;
            }

            public Task execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Task result = (Task)((Object)response.parseAs(Task.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Update setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Update setTask(String task) {
                this.task = task;
                return this;
            }
        }

        public class List
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="dueMax")
            private String dueMax;
            @Key(value="showDeleted")
            private Boolean showDeleted;
            @Key(value="updatedMin")
            private String updatedMin;
            @Key(value="completedMin")
            private String completedMin;
            @Key(value="maxResults")
            private Long maxResults;
            @Key(value="showCompleted")
            private Boolean showCompleted;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="completedMax")
            private String completedMax;
            @Key(value="showHidden")
            private Boolean showHidden;
            @Key(value="dueMin")
            private String dueMin;

            private List(String tasklist) {
                super((JsonHttpClient)Tasks.this, HttpMethod.GET, REST_PATH, null);
                this.tasklist = tasklist;
            }

            public com.google.api.services.tasks.model.Tasks execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.tasks.model.Tasks result = (com.google.api.services.tasks.model.Tasks)((Object)response.parseAs(com.google.api.services.tasks.model.Tasks.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public List setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getDueMax() {
                return this.dueMax;
            }

            public List setDueMax(String dueMax) {
                this.dueMax = dueMax;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(String updatedMin) {
                this.updatedMin = updatedMin;
                return this;
            }

            public String getCompletedMin() {
                return this.completedMin;
            }

            public List setCompletedMin(String completedMin) {
                this.completedMin = completedMin;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getShowCompleted() {
                return this.showCompleted;
            }

            public List setShowCompleted(Boolean showCompleted) {
                this.showCompleted = showCompleted;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getCompletedMax() {
                return this.completedMax;
            }

            public List setCompletedMax(String completedMax) {
                this.completedMax = completedMax;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public List setShowHidden(Boolean showHidden) {
                this.showHidden = showHidden;
                return this;
            }

            public String getDueMin() {
                return this.dueMin;
            }

            public List setDueMin(String dueMin) {
                this.dueMin = dueMin;
                return this;
            }
        }

        public class Move
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}/move";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="task")
            private String task;
            @Key(value="parent")
            private String parent;
            @Key(value="previous")
            private String previous;

            private Move(String tasklist, String task) {
                super((JsonHttpClient)Tasks.this, HttpMethod.POST, REST_PATH, null);
                this.tasklist = tasklist;
                this.task = task;
            }

            public Task execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Task result = (Task)((Object)response.parseAs(Task.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Move setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Move setTask(String task) {
                this.task = task;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public Move setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public String getPrevious() {
                return this.previous;
            }

            public Move setPrevious(String previous) {
                this.previous = previous;
                return this;
            }
        }

        public class Clear
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/clear";
            @Key(value="tasklist")
            private String tasklist;

            private Clear(String tasklist) {
                super((JsonHttpClient)Tasks.this, HttpMethod.POST, REST_PATH, null);
                this.tasklist = tasklist;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Clear setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }
        }

        public class Get
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="task")
            private String task;

            private Get(String tasklist, String task) {
                super((JsonHttpClient)Tasks.this, HttpMethod.GET, REST_PATH, null);
                this.tasklist = tasklist;
                this.task = task;
            }

            public Task execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Task result = (Task)((Object)response.parseAs(Task.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Get setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Get setTask(String task) {
                this.task = task;
                return this;
            }
        }

        public class Insert
        extends TasksRequest {
            private static final String REST_PATH = "lists/{tasklist}/tasks";
            @Key(value="tasklist")
            private String tasklist;
            @Key(value="parent")
            private String parent;
            @Key(value="previous")
            private String previous;
            private Task content;

            private Insert(String tasklist, Task content) {
                super((JsonHttpClient)Tasks.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.tasklist = tasklist;
                this.content = content;
            }

            public Task execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Task result = (Task)((Object)response.parseAs(Task.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Insert setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public Insert setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public String getPrevious() {
                return this.previous;
            }

            public Insert setPrevious(String previous) {
                this.previous = previous;
                return this;
            }
        }
    }

    private static class TasksRequestInitializer
    implements JsonHttpRequestInitializer {
        private Tasks tasks;

        private TasksRequestInitializer() {
        }

        void setTasks(Tasks tasks) {
            this.tasks = tasks;
        }

        public void initialize(JsonHttpRequest jsonHttpRequest) {
            TasksRequest request = (TasksRequest)jsonHttpRequest;
            request.setPrettyPrint(this.tasks.getPrettyPrint());
            request.setFields(this.tasks.getFields());
            request.setQuotaUser(this.tasks.getQuotaUser());
            request.setOauthToken(this.tasks.getOauthToken());
            request.setKey(this.tasks.getKey());
            request.setUserIp(this.tasks.getUserIp());
            request.setAlt(this.tasks.getAlt());
        }
    }
}

