/*
 * Decompiled with CFR 0.152.
 */
package com.twofortyfouram;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.twofortyfouram.SharedResources;

public final class MarketActivity
extends Activity {
    private static final String CLASS_NAME = MarketActivity.class.getSimpleName();
    private static final String plugin_title = "plugin_dialog_title";
    private static final String plugin_install = "plugin_dialog_install";
    private static final String plugin_need_locale_message = "plugin_dialog_need_locale_message";
    private static final String plugin_need_locale_informative = "plugin_dialog_need_locale_informative";
    private static final String plugin_market_not_available = "plugin_dialog_market_not_available";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(0x1030010);
        LinearLayout layout = new LinearLayout(this.getApplicationContext());
        this.setContentView((View)layout);
        layout.setVisibility(8);
        this.showDialog(0);
    }

    private CharSequence getTextResource(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException(String.format("%s.getTextResource(): name param was null or empty", CLASS_NAME));
        }
        Resources myResources = this.getResources();
        return myResources.getText(myResources.getIdentifier(name, "string", this.getPackageName()));
    }

    protected Dialog onCreateDialog(int id) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(this.getTextResource(plugin_title));
        TextView alertMessageView = new TextView(this.getApplicationContext());
        alertMessageView.setPadding(10, 10, 10, 10);
        alertMessageView.setTextSize(17.0f);
        alertMessageView.setTypeface(Typeface.defaultFromStyle((int)1));
        alertMessageView.setTextColor(-1);
        TextView informativeMessageView = new TextView(this.getApplicationContext());
        informativeMessageView.setPadding(10, 10, 10, 10);
        informativeMessageView.setTextSize(15.0f);
        informativeMessageView.setTypeface(Typeface.defaultFromStyle((int)0));
        informativeMessageView.setTextColor(-1);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams fill_wrap_params = new LinearLayout.LayoutParams(-1, -2);
        LinearLayout myLayout = new LinearLayout(this.getApplicationContext());
        myLayout.setOrientation(1);
        myLayout.setLayoutParams((ViewGroup.LayoutParams)fill_wrap_params);
        myLayout.addView((View)alertMessageView, (ViewGroup.LayoutParams)params);
        myLayout.addView((View)informativeMessageView, (ViewGroup.LayoutParams)params);
        builder.setView((View)myLayout);
        try {
            final PackageManager manager = this.getPackageManager();
            try {
                manager.getPackageInfo("com.twofortyfouram.locale", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                manager.getPackageInfo("edu.mit.locale", 0);
            }
            Log.i((String)"[Locale]", (String)"Locale is installed");
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    try {
                        Intent i = new Intent("com.twofortyfouram.locale.intent.action.START_LOCALE");
                        i.addFlags(0x10000000);
                        MarketActivity.this.startActivity(i);
                    }
                    catch (ActivityNotFoundException e2) {
                        Log.e((String)"[Locale]", (String)"Locale Activity not found", (Throwable)e2);
                        Toast.makeText((Context)MarketActivity.this.getApplicationContext(), (CharSequence)SharedResources.getTextResource(manager, "activity_unavailable"), (int)1).show();
                    }
                    MarketActivity.this.finish();
                }
            };
            alertMessageView.setText(SharedResources.getTextResource(manager, "plugin_dialog_message"));
            informativeMessageView.setText(SharedResources.getTextResource(manager, "plugin_dialog_informative_setting"));
            builder.setPositiveButton(SharedResources.getTextResource(manager, "plugin_open"), listener);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)"[Locale]", (String)"Locale is not installed");
            alertMessageView.setText(this.getTextResource(plugin_need_locale_message));
            informativeMessageView.setText(this.getTextResource(plugin_need_locale_informative));
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    try {
                        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)(System.currentTimeMillis() > 1263513600000L ? "market://search?q=pname:com.twofortyfouram.locale" : "market://search?q=pname:edu.mit.locale")));
                        i.addFlags(0x10000000);
                        MarketActivity.this.startActivity(i);
                    }
                    catch (ActivityNotFoundException e2) {
                        Log.e((String)"[Locale]", (String)"Android Market Activity not found.");
                        Toast.makeText((Context)MarketActivity.this.getApplicationContext(), (CharSequence)MarketActivity.this.getTextResource(MarketActivity.plugin_market_not_available), (int)1).show();
                    }
                    MarketActivity.this.finish();
                }
            };
            builder.setPositiveButton(this.getTextResource(plugin_install), listener);
        }
        builder.setNegativeButton(0x1040000, null);
        AlertDialog dialog = builder.create();
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface arg0) {
                MarketActivity.this.finish();
            }
        });
        return dialog;
    }
}

