#!/bin/bash

declare -A CONFIG

. /etc/snapsched/config

_sort()
{
	local -n STRS=$1
	local -i I R
	local S="$2"
	local T

	# three quick optimizations
	if [ -z "$S" ] ; then
		return
	fi
	if [ "${#STRS[*]}" -eq 0 ] ; then
		STRS[0]="$S"
		return
	fi
	if [ "$S" \> "${STRS[-1]}" ] ; then
		STRS+=($S)
		return
	fi

	for ((I = 0; ; I++)) ; do
		if [ "$S" \> "${STRS[$I]}" ] ; then
			continue
		fi
		# then S is less-than or equal-to lexigraphically
		for ((N = I; ; N++)) ; do
			T="${STRS[N]}"
			STRS[N]="$S"
			if [ -z "$T" ] ; then
				break
			fi
			S="$T"
		done
		break
	done
}

declare -a SRCS_LIST

for I in  ${!CONFIG[*]} ; do
	if [ "$I" != "${I%\%*}" ] ; then
		continue
	fi
	if [ "$I" != "${I#SSRC_}" ] ; then
		_sort SRCS_LIST "${I#SSRC_}"
		# echo ${I#SSRC_}
	fi
	#if [ "$I" = "SSRC_@" ] ; then
	#echo $I
	#fi
	#if expr match "$I" "SSRC_@%" >/dev/null; then
	#echo $I
	#fi
done

for I in ${!SRCS_LIST[*]} ; do
	echo "SRCS_LIST[$I]='${SRCS_LIST[I]}'"
done
#SRCS_LIST=$SRCS_LIST
#echo "'${SRCS_LIST//\r/ }'"
