/******************************************************************************
 * INTEL CONFIDENTIAL                                                         *
 * Copyright 2014-2016 Intel Corporation All Rights Reserved.                 *
 *                                                                            *
 * The source code contained or described herein and all documents related    *
 * to the source code ("Material") are owned by Intel Corporation or          *
 * its suppliers or licensors. Title to the Material remains                  *
 * with Intel Corporation or its suppliers and licensors.                     *
 * The Material contains trade secrets and proprietary and confidential       *
 * information of Intel or its suppliers and licensors.                       *
 * The Material is protected by worldwide copyright and trade secret laws     *
 * and treaty provisions. No part of the Material may be used, copied,        *
 * reproduced, modified, published, uploaded, posted, transmitted,            *
 * distributed, or disclosed in any way without Intel's                       *
 * prior express written permission.                                          *
 *                                                                            *
 * No license under any patent, copyright, trade secret or other              *
 * intellectual property right is granted to or conferred upon you            *
 * by disclosure or delivery of the Materials, either expressly,              *
 * by implication, inducement, estoppel or otherwise.                         *
 * Any license under such intellectual property rights                        *
 * must be express and approved by Intel in writing.                          *
 ******************************************************************************/
#include <wol.h>

#if defined(WOL_100M)
static WOL_MAC_TYPE const _WOL_PRO100[] = {
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D100_A_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D100_B_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D100_C_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D101_A_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D101_B0_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D101M_A_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D101S_A_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D102_A_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D102_B_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D102_C_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D102_D_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D102_E_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_D102_F_STEP),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_82562_G),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_82562_GZ),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_82562_GX_GT),
  WOL_MAKE_MACTYPE(WOL_100M, NAL_MAC_TYPE_82562),
  0
};
#endif

#if defined(WOL_1G)
static WOL_MAC_TYPE const _WOL_CORDOVA[] = {
#ifndef NO_82543_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82544),
#endif
  0
};

static WOL_MAC_TYPE const _WOL_KENAI[] = {
#ifndef NO_82540_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82540),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82545),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82545_rev_3),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82546),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82546_rev_3),
#endif
#ifndef NO_82541_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82541),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82541_rev_2),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82547),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82547_rev_2),
#endif
#ifndef NO_82571_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82571),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82572),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82573),
#ifndef NO_82574_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82574),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82583),
#endif
#endif
#ifndef NO_80003ES2LAN_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_80003es2lan),
#endif
#ifndef NO_82575_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82575),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82576),
#endif
  0
};

static WOL_MAC_TYPE const _WOL_NAHUM[] = {
#ifndef NO_ICH8LAN_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_ich8lan),
#endif
  0
};

static WOL_MAC_TYPE const _WOL_NAHUM2[] = {
#ifndef NO_ICH8LAN_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_ich9lan),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_ich10lan),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_pchlan),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_pch2lan),
#ifdef NAHUM6_HW
  WOL_MAKE_MACTYPE(WOL_1G, e1000_pch_lpt),
#endif
#endif
  0
};

static WOL_MAC_TYPE const _WOL_BARTONHILLS[] = {
#ifndef NO_82580_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82580),
#endif
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i350),
#ifdef AVOTON_HW
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i354),
#endif
#ifndef NO_I210_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i210),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i211),
#endif
  0
};
#endif

#if defined(WOL_10G)
WOL_MAC_TYPE const _WOL_IXGBE[] = {
#ifndef NO_82598_SUPPORT
  WOL_MAKE_MACTYPE(WOL_10G, ixgbe_mac_82598EB),
#endif
#ifndef NO_82599_SUPPORT
  WOL_MAKE_MACTYPE(WOL_10G, ixgbe_mac_82599EB),
#endif
#ifndef NO_X540_SUPPORT
  WOL_MAKE_MACTYPE(WOL_10G, ixgbe_mac_X540),
#ifdef MAGNOLIA_PARK_HW
  WOL_MAKE_MACTYPE(WOL_10G, ixgbe_mac_X550),
  WOL_MAKE_MACTYPE(WOL_10G, ixgbe_mac_X550EM_x),
#ifdef DENVERTON_HW
  WOL_MAKE_MACTYPE(WOL_10G, ixgbe_mac_X550EM_a),
#endif
#endif
#endif
  0
};
#endif

#if defined(WOL_40G)
WOL_MAC_TYPE const _WOL_40GBE[] = {
  WOL_MAKE_MACTYPE(WOL_40G, I40E_MAC_XL710),
#ifdef X722_SUPPORT
  WOL_MAKE_MACTYPE(WOL_40G, I40E_MAC_X722),
#endif
  0
};
#endif

extern WOL_STATUS _WolGetOffsetBitmask_PRO100(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_CORDOVA(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_KENAI(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_NAHUM(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_NAHUM2(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_BARTONHILLS(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_IXGBE(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);
extern WOL_STATUS _WolGetOffsetBitmask_40GBE(WOL_ADAPTER_HANDLE_TYPE Handle, UINT16 *Offset, UINT16 *Bitmask);

_WOL_FAMILY_INFO_t const WOL_FAMILY_TABLE[] = {
#if defined(WOL_100M)
  { _WOL_PRO100,        _WolGetOffsetBitmask_PRO100         },
#endif /* WOL_100M */
#if defined(WOL_1G)
  { _WOL_CORDOVA,       _WolGetOffsetBitmask_CORDOVA        },
  { _WOL_KENAI,         _WolGetOffsetBitmask_KENAI          },
  { _WOL_NAHUM,         _WolGetOffsetBitmask_NAHUM          },
  { _WOL_NAHUM2,        _WolGetOffsetBitmask_NAHUM2         },
  { _WOL_BARTONHILLS,   _WolGetOffsetBitmask_BARTONHILLS    },
#endif /* WOL_1G */
#if defined(WOL_10G)
  { _WOL_IXGBE,         _WolGetOffsetBitmask_IXGBE          },
#endif /* WOL_10G */
#if defined(WOL_40G)
  { _WOL_40GBE,         _WolGetOffsetBitmask_40GBE          },
#endif /* WOL_40G */
  { 0,                  0                                   }
};

WOL_MAC_TYPE const WOL_APMPME_TABLE[] = {
#if defined(WOL_1G)
  /*
   * Wainwright doesn't seem to be supported
   * neither by QV nor by shared code
   */
#ifndef NO_82543_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82544),
#endif
#ifndef NO_82540_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82540),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82545),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82545_rev_3),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82546),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82546_rev_3),
#endif
#ifndef NO_82541_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82541),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82541_rev_2),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82547),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82547_rev_2),
#endif
#ifndef NO_82571_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82571),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82572),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82573),
#ifndef NO_82574_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82574),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82583),
#endif
#endif
#ifndef NO_80003ES2LAN_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_80003es2lan),
#endif
#ifndef NO_82575_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82575),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82576),
#endif
#ifndef NO_82580_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82580),
#endif
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i350),
#ifdef AVOTON_HW
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i354),
#endif
#ifndef NO_I210_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i210),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_i211),
#endif
#endif /* WOL_1G */
  0
};

WOL_MAC_TYPE const WOL_LASER_TABLE[] = {
#if defined(WOL_1G)
#ifndef NO_82543_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82544),
#endif
#ifndef NO_82540_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82540),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82545),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82545_rev_3),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82546),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82546_rev_3),
#endif
#ifndef NO_82541_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82541),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82541_rev_2),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82547),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82547_rev_2),
#endif
#ifndef NO_82571_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82571),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82572),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82573),
#ifndef NO_82574_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82574),
  WOL_MAKE_MACTYPE(WOL_1G, e1000_82583),
#endif
#endif
#ifndef NO_80003ES2LAN_SUPPORT
  WOL_MAKE_MACTYPE(WOL_1G, e1000_80003es2lan),
#endif
#endif /* WOL_1G */
  0
};

