/**************************************************************************

Copyright (c) 2016, Intel Corporation

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/

#ifndef _xgbe_H_
#define _xgbe_H_

#ifndef EFI_SPECIFICATION_VERSION
#define EFI_SPECIFICATION_VERSION 0x00020000
#endif

#ifndef TIANO_RELEASE_VERSION
#define TIANO_RELEASE_VERSION 0x00080005
#endif

#include <Uefi.h>

#include <Base.h>
#include <Guid/EventGroup.h>
#include <Protocol/PciIo.h>
#include <Protocol/NetworkInterfaceIdentifier.h>
#include <Protocol/DevicePath.h>
#include <Protocol/ComponentName2.h>
#include <Protocol/LoadedImage.h>
#include <Protocol/DriverDiagnostics.h>
#include <Protocol/DriverBinding.h>
#include <Protocol/DriverSupportedEfiVersion.h>
#include <Protocol/PlatformToDriverConfiguration.h>
#include <Protocol/FirmwareManagement.h>
#include <Protocol/DriverHealth.h>

#include <Protocol/HiiConfigRouting.h>
#include <Protocol/FormBrowser2.h>
#include <Protocol/HiiConfigAccess.h>
#include <Protocol/HiiDatabase.h>
#include <Protocol/HiiString.h>

#include <Guid/MdeModuleHii.h>

#include <Library/UefiDriverEntryPoint.h>
#include <Library/UefiRuntimeLib.h>
#include <Library/DebugLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/UefiLib.h>
#include <Library/BaseLib.h>
#include <Library/DevicePathLib.h>
#include <Library\PrintLib.h>

#include <IndustryStandard/Pci.h>

#include "ixgbe_api.h"
#include "ixgbe_type.h"
#include "StartStop.h"
#include "Decode.h"
#include "NVDataStruc.h"
#include "Version.h"
#include "AdapterInformation.h"




#ifndef IXGBE_INTEL_VENDOR_ID
#define IXGBE_INTEL_VENDOR_ID INTEL_VENDOR_ID
#endif

//
// Debug levels for driver DEBUG_PRINT statements
//
#define NONE      0
#define INIT      (1 << 0)
#define DECODE    (1 << 1)
#define XGBE      (1 << 2)
#define SHARED    (1 << 3)
#define DIAG      (1 << 4)
#define CFG       (1 << 5)
#define IO        (1 << 6)
#define IMAGE     (1 << 7)
#define VPDUPD    (1 << 8)
#define RX        (1 << 9)
#define TX        (1 << 10)
#define CRITICAL  (1 << 11)
#define HII       (1 << 12)
#define CLP       (1 << 13)
#define RXFILTER  (1 << 14)
#define WAIT      (1 << 15)
#define FLASH     (1 << 16)
#define VPD_DBG   (1 << 18)
#define SUPPORTED (1 << 19)
#define HEALTH    (1 << 20)
#define ADAPTERINFO (1 << 21)
#define HOSTIF    (1 << 22)
//
// DEBUG Defines are located here
//
#define DBG_LVL (NONE)

//
// Macro to return the offset of a member within a struct.  This
// looks like it dereferences a null pointer, but it doesn't really.
//
#define STRUCT_OFFSET(Structure,Member)     ((UINTN)&(((Structure *)0)->Member))

#define MAX_NIC_INTERFACES  256

//
// Device and Vendor IDs
//
#define INTEL_VENDOR_ID             0x8086
#define HP_SUBVENDOR_ID             0x103C
#define HP_KINGSPORT_SUBSYSTEM      0x12D3
#define HP_KINGSPORT_DEVICE_ID      0x1079

#define TWO_PAIR_DOWNSHIFT_TIMEOUT  30

//
// PCI Base Address Register Bits
//
#define PCI_BAR_IO_MASK   0x00000003
#define PCI_BAR_IO_MODE   0x00000001

#define PCI_BAR_MEM_MASK  0x0000000F
#define PCI_BAR_MEM_MODE  0x00000000
#define PCI_BAR_MEM_64BIT 0x00000004

//
// Bit fields for the PCI command register
//
#define PCI_COMMAND_MWI     0x10
#define PCI_COMMAND_MASTER  0x04
#define PCI_COMMAND_MEM     0x02
#define PCI_COMMAND_IO      0x01
#define PCI_COMMAND         0x04
#define PCI_LATENCY_TIMER   0x0D

//
// Register offsets for IO Mode read/write
//
#define IO_MODE_IOADDR      0x00
#define IO_MODE_IODATA      0x04

#define ETHER_MAC_ADDR_LEN  6

//
// EEPROM Word Defines:
//
#define PCIE_GENERAL_CONFIG 0x06
#define PCIE_CONTROL_5      0x05
#define LAN_FUNCTION_SELECT 0x0400
#define LAN_FUNCTION_SELECT_82599 0x0008
#define PCIE_CTRL_LAN_PCI_DISABLE 0x0002
#define PCIE_CTRL_LAN_DISABLE_SELECT 0x0001


//
// PCI-E control word 7 indicates flash size
// 000: 64KB, 001: 128KB, 010: 256KB, 011: 512KB, 100: 1MB, 101: 2MB, 110: 4MB, 111: 8MB
// The Flash size impacts the requested memory space for the Flash and expansion ROM BARs.
//
#define PCIE_CONTROL_7      0x07
#define FLASH_SIZE_MASK     0x0700
#define FLASH_SIZE_SHIFT    8

//
// "Main Setup Options Word"
//
#define SETUP_OPTIONS_WORD      0x30
#define SETUP_OPTIONS_WORD_LANB SETUP_OPTIONS_WORD + 4
#define FDP_FULL_DUPLEX_BIT     0x1000
#define FSP_100MBS              0x0800
#define FSP_10MBS               0x0400
#define FSP_AUTONEG             0x0000
#define FSP_MASK                0x0C00
#define DISPLAY_SETUP_MESSAGE   0x0100

//
// "Configuration Customization Word"
//
#define CONFIG_CUSTOM_WORD      0x31
#define CONFIG_CUSTOM_WORD_LANB CONFIG_CUSTOM_WORD + 4
#define SIG                     0x4000
#define SIG_MASK                0xC000

//
// UNDI_CALL_TABLE.state can have the following values
//
#define DONT_CHECK                          - 1
#define ANY_STATE                           - 1
#define MUST_BE_STARTED                     1
#define MUST_BE_INITIALIZED                 2

#define EFI_OPTIONAL_PTR                    0x00000001
#define EFI_INTERNAL_PTR                    0x00000004  // Pointer to internal runtime data
#define EVT_SIGNAL_VIRTUAL_ADDRESS_CHANGE   0x60000202

#define XGBE_UNDI_DEV_SIGNATURE             SIGNATURE_32 ('P', 'R', '0', 'x')
#define UNDI_PRIVATE_DATA_FROM_THIS(a) CR (a, UNDI_PRIVATE_DATA, NiiProtocol31, XGBE_UNDI_DEV_SIGNATURE)
#define UNDI_PRIVATE_DATA_FROM_DEVICE_PATH(a) \
        CR(a, UNDI_PRIVATE_DATA, Undi32BaseDevPath, XGBE_UNDI_DEV_SIGNATURE)
#define UNDI_PRIVATE_DATA_FROM_FIRMWARE_MANAGEMENT(a) \
        CR(a, UNDI_PRIVATE_DATA, FirmwareManagement, XGBE_UNDI_DEV_SIGNATURE)
#define UNDI_PRIVATE_DATA_FROM_DRIVER_STOP(a) \
        CR(a, UNDI_PRIVATE_DATA, DriverStop, XGBE_UNDI_DEV_SIGNATURE)
#define UNDI_PRIVATE_DATA_FROM_VLAN(a) \
        CR(a, UNDI_PRIVATE_DATA, VlanConfig, XGBE_UNDI_DEV_SIGNATURE)
#define UNDI_PRIVATE_DATA_FROM_FCOE_UNDI_CONFIGURATION(a) \
        CR(a, UNDI_PRIVATE_DATA, FcoeConfiguration, XGBE_UNDI_DEV_SIGNATURE)
#define UNDI_PRIVATE_DATA_FROM_AIP(a) \
        CR(a, UNDI_PRIVATE_DATA, AdapterInformation, XGBE_UNDI_DEV_SIGNATURE)

#define EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_REVISION_31 0x00010001
#define PXE_ROMID_MINORVER_31 0x10

typedef struct {
  UINT16 cpbsize;
  UINT16 dbsize;
  UINT16 opflags;
  UINT16 state;
  void (*api_ptr)();
} UNDI_CALL_TABLE;

typedef struct {
  EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL *InterfacePointer;
  EFI_DEVICE_PATH_PROTOCOL                  *DevicePathPointer;
} NII_ENTRY;

typedef struct NII_CONFIG_ENTRY {
  UINT32                  NumEntries;
  UINT32                  Reserved;
  struct NII_CONFIG_ENTRY *NextLink;
  NII_ENTRY               NiiEntry[MAX_NIC_INTERFACES];
} NII_TABLE;

extern EFI_GUID                     gEfiNiiPointerGuid;

typedef struct _EFI_NII_POINTER_PROTOCOL {
  EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL *NiiProtocol31;
} EFI_NII_POINTER_PROTOCOL;

typedef VOID (*ptr) (VOID);
typedef VOID (*bsptr_30) (UINTN);
typedef VOID (*virtphys_30) (UINT64, UINT64);
typedef VOID (*block_30) (UINT32);
typedef VOID (*mem_io_30) (UINT8, UINT8, UINT64, UINT64);

typedef VOID (*bsptr) (UINT64, UINTN);
typedef VOID (*virtphys) (UINT64, UINT64, UINT64);
typedef VOID (*block) (UINT64, UINT32);
typedef VOID (*mem_io) (UINT64, UINT8, UINT8, UINT64, UINT64);

typedef VOID (*map_mem) (UINT64, UINT64, UINT32, UINT32, UINT64);
typedef VOID (*unmap_mem) (UINT64, UINT64, UINT32, UINT32, UINT64);
typedef VOID (*sync_mem) (UINT64, UINT64, UINT32, UINT32, UINT64);

//
// Global Variable
//
extern EFI_DRIVER_BINDING_PROTOCOL  gUndiDriverBinding;
extern EFI_DRIVER_BINDING_PROTOCOL  gXgbeUndiDriverBinding;
extern EFI_COMPONENT_NAME_PROTOCOL  gXgbeUndiComponentName;

extern PXE_SW_UNDI *      ixgbe_pxe_31;
extern UNDI_PRIVATE_DATA *XgbeDeviceList[MAX_NIC_INTERFACES];

#pragma pack(1)
typedef struct eth {
  UINT8   dest_addr[PXE_HWADDR_LEN_ETHER];
  UINT8   src_addr[PXE_HWADDR_LEN_ETHER];
  UINT16  type;
} ETHER_HEADER;

#pragma pack(1)
typedef struct PCI_CONFIG_HEADER_s {
  UINT16  VendorID;
  UINT16  DeviceID;
  UINT16  Command;
  UINT16  Status;
  UINT16  RevID;
  UINT16  ClassID;
  UINT8   CacheLineSize;
  UINT8   LatencyTimer;
  UINT8   HeaderType;
  UINT8   BIST;
  UINT32  BaseAddressReg_0;
  UINT32  BaseAddressReg_1;
  UINT32  BaseAddressReg_2;
  UINT32  BaseAddressReg_3;
  UINT32  BaseAddressReg_4;
  UINT32  BaseAddressReg_5;
  UINT32  CardBusCISPtr;
  UINT16  SubVendorID;
  UINT16  SubSystemID;
  UINT32  ExpansionROMBaseAddr;
  UINT8   CapabilitiesPtr;
  UINT8   reserved1;
  UINT16  Reserved2;
  UINT32  Reserved3;
  UINT8   int_line;
  UINT8   int_pin;
  UINT8   Min_gnt;
  UINT8   Max_lat;
} PCI_CONFIG_HEADER;
#pragma pack()

//
// TX Buffer size including crc and padding
//
#define RX_BUFFER_SIZE          2048

#define DEFAULT_RX_DESCRIPTORS  8
#define DEFAULT_TX_DESCRIPTORS  8

//
// Macro to conver byte memory requirement into pages
//
#define UNDI_MEM_PAGES(x) (((x) - 1) / 4096 + 1)

#pragma pack(1)
typedef struct _LocalReceiveBuffer {
  UINT8   RxBuffer[RX_BUFFER_SIZE - (sizeof(UINT64))];
  UINT64  BufferUsed;
} LOCAL_RX_BUFFER, *PLOCAL_RX_BUFFER;


#pragma pack()

typedef struct _DRIVER_DATA_ {
  UINT16 State;         // stopped, started or initialized
  struct ixgbe_hw Hw;
  struct ixgbe_hw_stats stats;

  UINTN Bus;
  UINTN Device;
  UINTN Function;

  UINT8 PciClass;
  UINT8 PciSubClass;

  UINTN LanFunction;    // LAN function to determine port 0 or port 1 when LAN function select is enabled
  UINT8 BroadcastNodeAddress[PXE_MAC_LENGTH];

  UINT32 PciConfig[MAX_PCI_CONFIG_LEN];
  UINT32 NVData[MAX_EEPROM_LEN];

  UINTN HwReset;
  UINTN HwInitialized;
  UINTN DriverBusy;
  UINT16 LinkSpeed;     // requested (forced) link speed
  UINT8 DuplexMode;     // requested duplex
  UINT8 CableDetect;    // 1 to detect and 0 not to detect the cable
  UINT8 LoopBack;

  UINT8  UNDIEnabled;       // When 0 only HII and FMP are avaliable, NII is not installed on ControllerHandle
                            // (e.g. in case iSCSI driver loaded on port)

  BOOLEAN VlanEnable;
  UINT16  VlanTag;

  UINT64 Unique_ID;
  EFI_PCI_IO_PROTOCOL *PciIo;

  VOID (*Delay_30) (UINTN);
  VOID (*Virt2Phys_30) (UINT64 virtual_addr, UINT64 physical_ptr);
  VOID (*Block_30) (UINT32 enable);
  VOID (*Mem_Io_30) (UINT8 read_write, UINT8 len, UINT64 port, UINT64 buf_addr);

  VOID (*Delay) (UINT64, UINTN);
  VOID (*Virt2Phys) (UINT64 unq_id, UINT64 virtual_addr, UINT64 physical_ptr);
  VOID (*Block) (UINT64 unq_id, UINT32 enable);
  VOID (*Mem_Io) (UINT64 unq_id, UINT8 read_write, UINT8 len, UINT64 port, UINT64 buf_addr);
  VOID (*Map_Mem) (UINT64 unq_id, UINT64 virtual_addr, UINT32 size, UINT32 Direction, UINT64 mapped_addr);
  VOID (*UnMap_Mem) (UINT64 unq_id, UINT64 virtual_addr, UINT32 size, UINT32 Direction, UINT64 mapped_addr);
  VOID (*Sync_Mem) (UINT64 unq_id, UINT64 virtual_addr, UINT32 size, UINT32 Direction, UINT64 mapped_addr);

  UINT64 MemoryPtr;
  UINT32 MemoryLength;

  UINT16 RxFilter;
  UINT16 IntMask;
  UINT16 IntStatus;

  struct _McastList {
    UINT16 Length;
    UINT8 McAddr[MAX_MCAST_ADDRESS_CNT][PXE_MAC_LENGTH];
  } McastList;

  UINT16 cur_rx_ind;
  UINT16 cur_tx_ind;
  UINT8 ReceiveStarted;
  struct ixgbe_legacy_rx_desc *rx_ring;
  struct ixgbe_legacy_tx_desc *tx_ring;
  LOCAL_RX_BUFFER *local_rx_buffer;
  UINT16 xmit_done_head;
  UINT64 TxBufferUsed[DEFAULT_TX_DESCRIPTORS];
  BOOLEAN MacAddrOverride;
  UINTN VersionFlag;                                      // Indicates UNDI version 3.0 or 3.1
} XGBE_DRIVER_DATA, *PADAPTER_STRUCT;

typedef struct UNDI_PRIVATE_DATA_S {
  UINTN                                     Signature;
  EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL NiiProtocol31;
  EFI_NII_POINTER_PROTOCOL                  NIIPointerProtocol;
  EFI_HANDLE                                ControllerHandle;
  EFI_HANDLE                                DeviceHandle;
  EFI_DEVICE_PATH_PROTOCOL                  *Undi32BaseDevPath;
  EFI_DEVICE_PATH_PROTOCOL                  *Undi32DevPath;
  XGBE_DRIVER_DATA                          NicInfo;
  CHAR16                                    *Brand;

  EFI_HANDLE                                HiiHandle;
  EFI_UNICODE_STRING_TABLE                  *ControllerNameTable;
  EFI_HII_CONFIG_ACCESS_PROTOCOL            ConfigAccess;

  UNDI_DRIVER_CONFIGURATION                 Configuration;
  //
  // HII Configuration parameters start here
  // depending on these settings some of HII menus are disabled
  //
  BOOLEAN                                   LinkSpeedSettingsSupported;
  UINT8                                     AltMacAddrSupported;


  EFI_HII_DATABASE_PROTOCOL                 *HiiDatabase;
  EFI_HII_STRING_PROTOCOL                   *HiiString;
  EFI_HII_CONFIG_ROUTING_PROTOCOL           *HiiConfigRouting;
  EFI_FORM_BROWSER2_PROTOCOL                *FormBrowser2;
  EFI_GUID                                  HiiFormGuid;
  EFI_DRIVER_STOP_PROTOCOL                  DriverStop;
  EFI_ADAPTER_INFORMATION_PROTOCOL          AdapterInformation;
//  EFI_VLAN_CONFIG_PROTOCOL                  VlanConfig;
  BOOLEAN                                   IsChildInitialized;

  UINT32                                    LastAttemptVersion;
  UINT32                                    LastAttemptStatus;
} UNDI_PRIVATE_DATA;

struct XGBE_UNDI_DMA_RESOURCES {
  struct ixgbe_legacy_rx_desc rx_ring[DEFAULT_RX_DESCRIPTORS];
  struct ixgbe_legacy_tx_desc tx_ring[DEFAULT_TX_DESCRIPTORS];
  LOCAL_RX_BUFFER             rx_buffer[DEFAULT_RX_DESCRIPTORS];
};

#define BYTE_ALIGN_64 0x7F

//
// We need enough space to store TX descriptors, RX descriptors,
// RX buffers, and enough left over to do a 64 byte alignment.
//
#define MEMORY_NEEDED   (sizeof (struct XGBE_UNDI_DMA_RESOURCES) + BYTE_ALIGN_64)

#define FOUR_XGBEABYTE  (UINT64) 0x100000000

VOID
WaitForEnter (
  VOID
  );

BOOLEAN
IsAltMacAddrSupported(
    UNDI_PRIVATE_DATA *UndiPrivateData
);




UINTN
XgbeClearFilter (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT16           NewFilter
  );

PXE_STATCODE
XgbeInitialize (
  XGBE_DRIVER_DATA *XgbeAdapter
  );

EFI_STATUS
XgbeInitHw (
  XGBE_DRIVER_DATA  *XgbeAdapter
  );

EFI_STATUS
XgbeFirstTimeInit (
  UNDI_PRIVATE_DATA *XgbePrivate
  );

EFI_STATUS
XgbePciInit (
  XGBE_DRIVER_DATA *XgbeAdapter
  );

VOID
XgbeReceiveStart (
  IN XGBE_DRIVER_DATA *XgbeAdapter
  );

VOID
XgbeReceiveStop (
  IN XGBE_DRIVER_DATA *XgbeAdapter
  );

UINTN
XgbeReceive (
  XGBE_DRIVER_DATA *XgbeAdapter,
  PXE_CPB_RECEIVE  *CpbReceive,
  PXE_DB_RECEIVE   *DbReceive
  );

UINTN
XgbeReset (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT16           OpFlags
  );

VOID
XgbeSetFilter (
  IN XGBE_DRIVER_DATA *XgbeAdapter,
  IN UINT16           NewFilter
  );

UINTN
XgbeSetInterruptState (
  IN XGBE_DRIVER_DATA *XgbeAdapter
  );


UINTN
XgbeShutdown (
  XGBE_DRIVER_DATA *XgbeAdapter
  );

VOID
XgbeSetMcastList (
  XGBE_DRIVER_DATA *XgbeAdapter
  );

UINTN
XgbeStatistics (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT64           DBaddr,
  UINT16           DBsize
  );

UINTN
XgbeTransmit (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT64           cpb,
  UINT16           opflags
  );



//
// Functions defined in e1000.c
//
UINT32
XgbeInDword (
  IN XGBE_DRIVER_DATA *XgbeAdapter,
  IN UINT32           Port
  );

VOID
XgbeOutDword (
  IN XGBE_DRIVER_DATA *XgbeAdapter,
  IN UINT32           Port,
  IN UINT32           Data
  );

UINT32
XgbeSetRegBits (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT32           Register,
  UINT32           BitMask
  );

UINT32
XgbeClearRegBits (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT32           Register,
  UINT32           BitMask
  );

UINT16
XgbeFreeTxBuffers (
  IN XGBE_DRIVER_DATA *XgbeAdapter,
  IN UINT16           NumEntries,
  OUT UINT64          *TxBuffer
  );

VOID
XgbeMemCopy (
  IN UINT8  *Dest,
  IN UINT8  *Source,
  IN UINT32 Count
  );

BOOLEAN 
IsLinkUp(
  IN XGBE_DRIVER_DATA *XgbeAdapter
);

UINT8
GetLinkSpeed(
  IN XGBE_DRIVER_DATA *XgbeAdapter
);

VOID
BlinkLeds(
  IN XGBE_DRIVER_DATA *XgbeAdapter,
  IN UINT32           Time
);

EFI_STATUS
ReadPbaString(
  IN     XGBE_DRIVER_DATA *XgbeAdapter,
  IN OUT UINT8            *PbaNumber, 
  IN     UINT32           PbaNumberSize
);

BOOLEAN
IsQualifiedSfpModule (
  IN  XGBE_DRIVER_DATA   *AdapterInfo
);

//
// This is the Macro Section
//
#if DBG_LVL
#define DEBUGPRINT(lvl, msg) \
  if ((DBG_LVL & lvl) != 0) { \
    AsciiPrint  msg; \
  }

#define DEBUGWAIT(lvl) \
  if ((DBG_LVL & lvl) != 0) { \
    WaitForEnter (); \
  }
#else

//
// Comment out the debug stuff
//
#define DEBUGPRINT(lvl, msg)
#define DEBUGWAIT(lvl)
#endif

//
// Time translations.
//
VOID
DelayInMicroseconds (
  IN XGBE_DRIVER_DATA *XgbeAdapter,
  IN UINT32           MicroSeconds
  );
#define DelayInMilliseconds(x)  DelayInMicroseconds (XgbeAdapter, x * 1000)

//
// This is a macro to convert the preprocessor defined version number into a hex value
// that can be registered with EFI.
//
//
// The version number ends with additional .1 suffix for open source version of driver
//
#define VERSION_TO_HEX  ((MAJORVERSION << 24) + (MINORVERSION << 16) + (BUILDNUMBER / 10 << 12) + (BUILDNUMBER % 10 << 8) + 1)


#endif // _E1000_H_


