/**************************************************************************

Copyright (c) 2016, Intel Corporation

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/
#ifndef E1000_OSDEP_H_
#define E1000_OSDEP_H_

#include <Uefi.h>
#include <Base.h>
#include <Library\BaseLib.h>
#include <Library\BaseMemoryLib.h>

#pragma warning(disable : 4244)
#pragma warning(disable : 4206)

#ifndef EFI_SPECIFICATION_VERSION
#define EFI_SPECIFICATION_VERSION 0x00020000
#endif /* EFI_SPECIFICATION_VERSION */

#ifndef TIANO_RELEASE_VERSION
#define TIANO_RELEASE_VERSION     0x00080005
#endif /* TIANO_RELEASE_VERSION */

#ifdef EFI32

// Remove truncation warning in type cast when some 64 bit variables are converted to 32-bit pointers
#pragma warning(disable : 4305)
#endif /* EFI32 */

//#define STATIC static

#define CHAR        CHAR8
#define memcmp      CompareMem
#define memcpy      CopyMem
#define strlen      AsciiStrLen

#define int32_t  INT32;
#define uint32_t UINT32;
#define int16_t  INT16;
#define uint16_t UINT16;

#define __le64 UINT64
#define u64 UINT64
#define s64 INT64
#define __le32 UINT32
#define u32 UINT32
#define s32 INT32
#define __le16 UINT16
#define u16 UINT16
#define s16 INT16
#define u8  UINT8
#define s8  INT8
#define bool BOOLEAN

#define true 1
#define false 0

struct e1000_hw;

/** This function calls the MemIo callback to read a dword from the device's
   address space
   
   Since UNDI3.0 uses the TmpMemIo function (instead of the callback routine)
   which also takes the UniqueId parameter (as in UNDI3.1 spec) we don't have
   to make undi3.0 a special case

   @param[in]   Hw     Pointer to hardware instance.
   @param[in]   Port   Which Port to read from.

   @return   Results - The data read from the port.
**/
UINT32
E1000InDword (
  struct e1000_hw *Hw,
  UINT32           Port
  );

/** This function calls the MemIo callback to write a word from the device's
   address space
   
   Since UNDI3.0 uses the TmpMemIo function (instead of the callback routine)
   which also takes the UniqueId parameter (as in UNDI3.1 spec) we don't have
   to make undi3.0 a special case

   @param[in]   Hw   Pointer to hardware instance.
   @param[in]   Port   Which port to write to.
   @param[in]   Data   Data to write to Port.

   @return   Word written
**/
VOID
E1000OutDword (
  IN struct e1000_hw *Hw,
  IN UINT32           Port,
  IN UINT32           Data
  );

/** This function calls the MemIo callback to read a dword from the device's
   address space
   
   Since UNDI3.0 uses the TmpMemIo function (instead of the callback routine)
   which also takes the UniqueId parameter (as in UNDI3.1 spec) we don't have
   to make undi3.0 a special case

   @param[in]   Hw    Pointer to hardware instance.
   @param[in]   Port  Which port to read from.

   @return   Results - The data read from the port.
**/
UINT32
E1000FlashRead (
  IN struct e1000_hw *Hw,
  IN UINT32           Port
  );

/** This function calls the MemIo callback to read a dword from the device's
   address space
   
   Since UNDI3.0 uses the TmpMemIo function (instead of the callback routine)
   which also takes the UniqueId parameter (as in UNDI3.1 spec) we don't have
   to make undi3.0 a special case

   @param[in]   Hw   Pointer to hardware instance.
   @param[in]   Port   Which port to read from.

   @return   Results - The data read from the port.
**/
UINT16
E1000FlashRead16 (
  IN struct e1000_hw *Hw,
  IN UINT32           Port
  );

/** This function calls the MemIo callback to write a word from the device's
   address space
   
   Since UNDI3.0 uses the TmpMemIo function (instead of the callback routine)
   which also takes the UniqueId parameter (as in UNDI3.1 spec) we don't have
   to make undi3.0 a special case

   @param[in]   Hw     Pointer to hardware instance.
   @param[in]   Port   Which port to write to.
   @param[in]   Data   Data to write to Port.

   @return   Word written
**/
VOID
E1000FlashWrite (
  IN struct e1000_hw *Hw,
  IN UINT32           Port,
  IN UINT32           Data
  );

/** This function calls the MemIo callback to write a word from the device's
   address space
   
   Since UNDI3.0 uses the TmpMemIo function (instead of the callback routine)
   which also takes the UniqueId parameter (as in UNDI3.1 spec) we don't have
   to make undi3.0 a special case

   @param[in]   Hw     Pointer to hardware instance.
   @param[in]   Port   Which port to write to.
   @param[in]   Data   Data to write to Port.

   @return   Word written
**/
VOID
E1000FlashWrite16 (
  IN struct e1000_hw *Hw,
  IN UINT32           Port,
  IN UINT16           Data
  );

/** Flushes a PCI write transaction to system memory.

   @param[in]   Hw   Pointer to hardware structure.

   @return  PCI write transaction flushed
**/
VOID
E1000PciFlush (
  struct e1000_hw *Hw
  );

/** Delay a specified number of microseconds.

   @param[in]   Hw   Pointer to hardware instance.
   @param[in]   usecs   Number of microseconds to delay
   
   @return   Execution of code delayed
**/
VOID
USecDelay (
  struct e1000_hw *Hw,
  UINTN            Usecs
  );

/** Writes a value to one of the devices registers using port I/O (as opposed to
   memory mapped I/O). Only 82544 and newer devices support port I/O.

   @param[in]   Hw      Pointer to the shared code hw structure.
   @param[in]   Offset  The register offset to write.
   @param[in]   Value   The value to write to the register.

   @return   Value written to register offset
**/
VOID
E1000WriteRegIo (
  struct e1000_hw *Hw,
  UINT32           Offset,
  UINT32           Value
  );


#define usec_delay(x)     USecDelay (hw, x)
#define msec_delay(x)     USecDelay (hw, x * 1000)
#define usec_delay_irq(x) USecDelay (hw, x)
#define msec_delay_irq(x) USecDelay (hw, x * 1000)
#define memset(Buffer, Value, BufferLength) SetMem (Buffer, BufferLength, Value)

#define CMD_MEM_WRT_INVALIDATE EFI_PCI_COMMAND_MEMORY_WRITE_AND_INVALIDATE

typedef BOOLEAN boolean_t;


#if (0)
#define DEBUGFUNC(F)
#define DEBUGOUT(s) Aprint (s);
#define DEBUGOUT1(s, a) Aprint (s, a);
#define DEBUGOUT2(s, a, b) Aprint (s, a, b);
#define DEBUGOUT3(s, a, b, c) Aprint (s, a, b, c);
#define DEBUGOUT7(s, a, b, c, d, e, f, g) Aprint (s, a, b, c, d, e, f, g);
#else /* NOT (0) */
#define DEBUGFUNC(F)
#define DEBUGOUT(s) \
  do { \
  } while (0)
  
#define DEBUGOUT1(s, a) \
  do { \
    UNREFERENCED_1PARAMETER (a); \
  } while (0)
  
#define DEBUGOUT2(s, a, b) \
  do { \
    UNREFERENCED_2PARAMETER (a, b); \
  } while (0)
  
#define DEBUGOUT3(s, a, b, c) \
  do { \
    UNREFERENCED_3PARAMETER (a, b, c); \
  } while (0)
  
#define DEBUGOUT7(s, a, b, c, d, e, f, g)
#endif /* (0) */

#define E1000_WRITE_REG(a, Reg, Value) \
  E1000OutDword (a, (UINT32) (Reg), Value)

#define E1000_READ_REG(a, Reg)  \
  E1000InDword (a, (UINT32) (Reg)) \

#define E1000_WRITE_REG_ARRAY(a, Reg, Offset, Value) \
  E1000OutDword (a, (UINT32) (Reg + ((Offset) << 2)), Value)

#define E1000_WRITE_REG_ARRAY_BYTE(a, Reg, Offset, Value)  \
  E1000OutDword (a, (UINT32) (Reg + ((Offset) << 2)), Value) \

#define E1000_WRITE_REG_ARRAY_DWORD(a, Reg, Offset, Value)  \
  E1000OutDword (a, (UINT32) (Reg + ((Offset) << 2)), Value)  \

#define E1000_READ_REG_ARRAY(a, Reg, Offset)  \
  E1000InDword (a, (UINT32) (Reg + ((Offset) << 2)))

#define E1000_READ_REG_ARRAY_BYTE(a, Reg, Offset)  \
  E1000InDword (a, (UINT32) (Reg + ((Offset) << 2)))

#define E1000_READ_REG_ARRAY_DWORD(a, Reg, Offset)  \
  E1000InDword (a, (UINT32) (Reg + ((Offset) << 2)))

#define E1000_WRITE_FLUSH(a) E1000PciFlush (a);

#define E1000_WRITE_REG_IO(a, Reg, Value) \
  E1000WriteRegIo (a, (UINT32) (Reg), Value)

#define E1000_READ_FLASH_REG(a, Reg) \
  E1000FlashRead (a, (UINT32) (Reg))

#define E1000_WRITE_FLASH_REG(a, Reg, Data) \
  E1000FlashWrite (a, (UINT32) (Reg), Data)

#define E1000_READ_FLASH_REG16(a, Reg) \
  E1000FlashRead16 (a, (UINT32) (Reg))

#define E1000_WRITE_FLASH_REG16(a, Reg, Data) \
  E1000FlashWrite16 (a, (UINT32) (Reg), Data)

#define E1000_MUTEX                       u8
#define E1000_MUTEX_INIT(Mutex)           UNREFERENCED_1PARAMETER (Mutex)
#define E1000_MUTEX_DESTROY(Mutex)        UNREFERENCED_1PARAMETER (Mutex)
#define E1000_MUTEX_LOCK(Mutex)           UNREFERENCED_1PARAMETER (Mutex)
#define E1000_MUTEX_TRYLOCK(Mutex)        UNREFERENCED_1PARAMETER (Mutex)
#define E1000_MUTEX_UNLOCK(Mutex)         UNREFERENCED_1PARAMETER (Mutex)

#endif /* E1000_OSDEP_H_ */

