<?xml version="1.0" encoding="UTF-8" ?>
<!-- 
#    This template duplicates much of the logic that GanttPV uses to export html

#    Copyright 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 080225 - completed mostly working first draft (only access 'd' and 'i', no timescales)
# 080310 - Brian - brought it much closer to the html expport (added 'list' and most of 'path' access, timescales, and gantt)
-->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:exsl="http://exslt.org/common"
	>
	<xsl:output method="html"/>
	<xsl:param name="reportid" select="4" />
	<xsl:variable name="database" select="/" />

	<xsl:template match="/">
		<xsl:call-template name="report">
			<xsl:with-param name="report" select=".//table[@name='Report']/rows/row[@id=$reportid]"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="report">
		<xsl:param name="report" />
		<xsl:param name="clist" select="//table[@name='ReportColumn']/rows/row[@report=$reportid]" />
		<xsl:param name="rlist" select="//table[@name='ReportRow']/rows/row[@report=$reportid]" />
		<xsl:variable name="projectid" select="$report/ProjectID" />
		<xsl:variable name="project" select="//table[@name='Project']/rows/row[@id=$projectid]" />
		<html>
			<head>
				<title>
					<xsl:value-of select="$project/Name"/>
					<xsl:text>/</xsl:text>
					<xsl:value-of select="$report/Name"/>
				</title>
				<style>
h3, td { font-family: verdana,arial,helvetica,sans-serif; }
h3 { font-size: 14px; color:#000000; background-color: #ffffff; }
td { font-size: 12px;  }
td.head { color:#000000; background-color: #ffffff; text-align:center; }
td.body { color:#000000; background-color: #e6e6e6; }
td.task { background-color: #009966; color:#009966; }
td.custom {  }
td.complete { background-color: #996644; color:#009966; }
td.non { background-color: #e6e6e6; }
td.off { background-color: #cccccc; }
.time { font-family: verdana,arial,helvetica,sans-serif; font-size: 8px; color:#808080; }
A.time { text-decoration:none }
</style>
			</head>
			<body>
				<div align="center">
					<table cellspacing="0" cellpadding="0">
						<tr>
							<td>&#160;</td>
							<td align="center">
								<h3>Gantt Chart (Task)&#160;(New Project)</h3>
								<table border="1" cellspacing="0" cellpadding="1">
									<xsl:variable name="rowspan">
										<xsl:choose>
										<xsl:when test="$clist/TimeScaleDates">
											<xsl:value-of select="'3'"/>
										</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="'2'"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<tr>
										<xsl:apply-templates select="$clist" mode="colhead">
											<xsl:sort select="@seq" data-type="number" />
											<xsl:with-param name="rowspan" select="$rowspan"/>
										</xsl:apply-templates>
									</tr>
									<tr>
										<xsl:apply-templates select="$clist" mode="colhead2">
											<xsl:sort select="@seq" data-type="number" />
										</xsl:apply-templates>
									</tr>
									<tr>
										<xsl:apply-templates select="$clist" mode="colhead3">
											<xsl:sort select="@seq" data-type="number" />
										</xsl:apply-templates>
									</tr>
									<xsl:apply-templates select="$rlist" mode="reportrow">
						<xsl:sort select="@seq" data-type="number"/>
						<xsl:with-param name="clist" select="$clist"/>
					</xsl:apply-templates>
								</table>
							</td>
							<td>&#160;</td>
						</tr>
						<tr>
							<td>&#160;</td>
							<td align="right">
								<div class="time">
									<a class="time" href="http://www.pureviolet.net/ganttpv/">GanttPV</a> 08-02-25 06:41
								</div>
							</td>
							<td>&#160;</td>
						</tr>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="row" mode="colhead">
		<xsl:param name="rowspan" select="'2'" />
		<xsl:variable name="span">
			<xsl:choose>
				<xsl:when test="Periods">
					<xsl:value-of select="Periods"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<td class="head" colspan="{$span}">
			<xsl:attribute name="rowspan">
				<xsl:choose>
					<xsl:when test="Periods">
						<xsl:value-of select="'1'"/>
					</xsl:when>
					<xsl:when test="$rowspan=2">
						<xsl:value-of select="'2'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'3'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<!-- rowspan="1" > -->
			<xsl:call-template name="getlabel">
				<xsl:with-param name="column" select="." />
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template match="row" mode="colhead2">
		<xsl:choose>
			<xsl:when test="Periods">
				<xsl:variable name="Dates" select="TimeScaleDates" />
				<xsl:variable name="result">
					<xsl:call-template name="MonthSpan">
						<xsl:with-param name="DateList" select="$Dates"/>
						<xsl:with-param name="Month" select="substring($Dates,1,7)"/>
						<xsl:with-param name="Count" select="1"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:copy-of select="$result"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="MonthSpan">
		<xsl:param name="DateList"/>
		<xsl:param name="Month" />
		<xsl:param name="Count" select="0"/>
		<xsl:variable name="first" select="substring-before(concat($DateList,','),',')"/>
		<xsl:variable name="rest" select="substring-after($DateList,',')"/>
		<xsl:choose>
			<xsl:when test="substring($rest,1,7) = $Month">
				<xsl:call-template name="MonthSpan">
					<xsl:with-param name="DateList" select="$rest"/>
					<xsl:with-param name="Month" select="$Month"/>
					<xsl:with-param name="Count" select="$Count+1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="head" colspan="{$Count}">
					<xsl:choose>
						<xsl:when test="$Count>2">
							<xsl:value-of select="$Month"/>
						</xsl:when>
						<!-- doesn't fit without going onto the next row - bcc 080310
						<xsl:when test="$Count>1">
							<xsl:value-of select="substring($Month,3)"/>
						</xsl:when>
						-->
						<xsl:otherwise>
							<xsl:value-of select="substring($Month,6)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<xsl:if test="$rest">
					<xsl:call-template name="MonthSpan">
						<xsl:with-param name="DateList" select="$rest"/>
						<xsl:with-param name="Month" select="substring($rest,1,7)"/>
						<xsl:with-param name="Count" select="1"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="row" mode="colhead3">
		<xsl:choose>
			<xsl:when test="Periods">
				<xsl:variable name="Dates" select="TimeScaleDates" />
				<xsl:variable name="result">
					<xsl:call-template name="PeriodDate">
						<xsl:with-param name="DateList" select="$Dates"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:copy-of select="$result"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="PeriodDate">
		<xsl:param name="DateList"/>
		<xsl:variable name="first" select="substring-before(concat($DateList,','),',')"/>
		<xsl:variable name="rest" select="substring-after($DateList,',')"/>
				<td class="head" >
					<xsl:value-of select="substring($first,9,2)"/>
				</td>
				<xsl:if test="$rest">
					<xsl:call-template name="PeriodDate">
						<xsl:with-param name="DateList" select="$rest"/>
					</xsl:call-template>
				</xsl:if>
	</xsl:template>

	<xsl:template match="row" mode="reportrow">
		<xsl:param name="clist"/>
		<tr>
			<xsl:apply-templates select="$clist" mode="colcell">
				<xsl:sort select="@seq" data-type="number"/>
				<xsl:with-param name="thisrow" select="." />
			</xsl:apply-templates>
		</tr>
	</xsl:template>

	<!-- current is a column -->
	<xsl:template match="row" mode="colcell">
		<xsl:param name="thisrow" />
		<xsl:variable name="cellcontents">
			<xsl:call-template name="getcell">
				<xsl:with-param name="row" select="$thisrow" />
				<xsl:with-param name="column" select="." />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="width">
			<xsl:if test="$thisrow/@seq=1">
			<xsl:call-template name="getwidth">
				<xsl:with-param name="column" select="." />
			</xsl:call-template>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="cellcontentsN" select="exsl:node-set($cellcontents)" />
		<xsl:choose>
			<xsl:when test="count($cellcontentsN//time)=0">
			<td class="body"  nowrap=""  >
				<xsl:if test="string($width)">
					<xsl:attribute name="width">
						<xsl:value-of select="$width"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="$cellcontentsN[1]" />
			</td>
			</xsl:when>
			<xsl:when test="$cellcontentsN//task">
				<xsl:for-each select="$cellcontentsN/*">
					<xsl:variable name="temp" select="."/>
					<xsl:variable name="class">
						<xsl:choose>
							<xsl:when test=".//task">
								<xsl:text>task</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>non</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="x">
						<xsl:choose>
							<xsl:when test="$class='task'">
								<xsl:text>X</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#160;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<td class="{$class}" >
						<xsl:if test="$thisrow/@seq=1">
							<xsl:attribute name="width">
								<xsl:value-of select="'24'"/>
							</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="$x" />
					</td>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="$cellcontentsN/*">
					<td class="body"  >
						<xsl:if test="string($width)">
							<xsl:attribute name="width">
								<xsl:value-of select="$width"/>
							</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="." />
					</td>
				</xsl:for-each>					
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- column width defaults to column type width -->
	<xsl:template name="getwidth">
		<xsl:param name="column" />
		<xsl:variable name="localwidth" select="$column/Width" />
		<xsl:choose>
			<xsl:when test="$localwidth">
				<xsl:value-of select="$localwidth" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="columntypeid" select="$column/ColumnTypeID" />
				<xsl:variable name="columntype" select="//table[@name='ColumnType']/rows/row[@id=$columntypeid]" />
				<xsl:value-of select="$columntype/Width"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- column label defaults to column type label -->
	<xsl:template name="getlabel">
		<xsl:param name="column" />
		<xsl:variable name="locallabel" select="$column/Label" />
		<xsl:choose>
			<xsl:when test="$locallabel">
				<xsl:value-of select="$locallabel" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="columntypeid" select="$column/ColumnTypeID" />
				<xsl:variable name="columntype" select="//table[@name='ColumnType']/rows/row[@id=$columntypeid]" />
				<xsl:choose>
					<xsl:when test="$columntype/Label">
				<xsl:value-of select="$columntype/Label"/>
				</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$columntype/Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- get the contents of a report cell 
	Correct lookup of a cell's contents is a bit complicated.
	Fortunately, it is all handled for you here (or will be :-). 
	Just pass this template the report row and column records. 
	It will find the right data.
	(If you would like to see the GanttPV version of this logic 
	look in Data.GetCellValue.)
	IMPORTANT - Only access types 'd' (direct) and 'i' (simple indirect)
	are implemented. Timescales and gantt charts are not implemented.
	-->
	<xsl:template name="getcell">
		<xsl:param name="row" />
		<xsl:param name="column" />
		<!-- <xsl:param name="offset" select="-1"/> -->
		<!-- the column type defines:  (+ marks data used here)
			Name - the official name of the column type (names unique within report type)
			Label - the name displayed in menus for this column type
			+AccessType - indicates method used to find data displayed by this column type
			DataType - i=integer, t=text, d=date
			Edit - whether this field should be user editable
			+Path - shows the navigation path to data
			+ReportTypeID - id of parent ReportType
			+T - does this column refer to data from the ReportType's 'TableA' or 'TableB'?
			Width - default width for displaying this column
		-->
		<xsl:variable name="columntypeid" select="$column/ColumnTypeID" />
		<xsl:variable name="columntype" select="//table[@name='ColumnType']/rows/row[@id=$columntypeid]" />
		<!-- the report type defines: (+ marks data used here)
			Name - the official name of the report type
			AllOrEach - should this report be created for 'all projects', individual projects, or both
			Also - if this is the second part of a two table report, where to find the first part (for menus only)
			SuggestedColumns - by default the report is created with these columns
			+TableA - report is primarily based on this table 
			+TableB - (optional) report may also include data from this table
		-->
		<xsl:variable name="reporttypeid" select="$columntype/ReportTypeID" />
		<xsl:variable name="reporttype"  select="//table[@name='ReportType']/rows/row[@id=$reporttypeid]" />

		<xsl:variable name="rowcolname" select="$columntype/Name" />
		<xsl:variable name="accesstype" select="$columntype/AccessType" />
		<xsl:variable name="tableselector" select="concat('Table', $columntype/T)" />
		<xsl:variable name="columntable" select="$reporttype/*[local-name(.)=$tableselector]" />
		
		<!-- access type - identifies where to find the information to display for this column -->
		<xsl:choose>
			<!-- this column doesn't apply to the current cell, return nothing -->
			<!-- the first project/report is an exception for historical reasons -->
			<xsl:when test="($row/ReportID != '1') and ($row/TableName != $columntable)" />
			<!-- direct - the information is stored in this row
			look in this run using the column type name  -->
			<xsl:when test="$accesstype='d'">
				<xsl:variable name="target" select="//table[@name=$row/TableName]/rows/row[@id=$row/TableID]" />
				<xsl:variable name="result" select="$target/*[local-name(.)=$rowcolname]"/>
				<xsl:choose>
					<xsl:when test="$result">
						<xsl:value-of select="$result"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#160;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- indirect - the information is one step away via foreign key
			look in the table/column using the foreign key rowid specified in this row
			if the table name is an alias be sure to translate it first -->
			<xsl:when test="$accesstype='i'">
				<!-- foreign table name -->
				<xsl:variable name="tname">
					<xsl:call-template name="ConvertAlias">
						<xsl:with-param name="name" select="substring-before($rowcolname, '/')" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="tcol" select="substring-after($rowcolname, '/')" />
				<xsl:variable name="localcol" select="concat($tname, 'ID')" />
				<xsl:variable name="target" select="//table[@name=$row/TableName]/rows/row[@id=$row/TableID]" />
				<xsl:variable name="tid" select="$target/*[local-name(.)=$localcol]" />
				<xsl:variable name="ftarget" select="//table[@name=$tname]/rows/row[@id=$tid]" />
					<xsl:variable name="result" select="$ftarget/*[local-name(.)=$tcol]"/>
				<xsl:choose>
					<xsl:when test="$result">
						<xsl:value-of select="$result"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#160;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- these access types are not yet implemented - bcc 080216 -->
			<!-- time scale -->
			<xsl:when test="$accesstype='s'">
				<xsl:variable name="timeunit" select="substring-before($rowcolname, '/')" />
				<xsl:variable name="targetcolumn" select="substring-after($rowcolname, '/')" />
				<xsl:choose>
					<xsl:when test="$targetcolumn = 'Gantt'">
						<xsl:variable name="target" select="//table[@name=$row/TableName]/rows/row[@id=$row/TableID]" />
						<!-- <xsl:variable name="target" select="$database//table[@name=$row/TableName]/rows/row[@rowid=$row/TableID]" /> -->
						<xsl:call-template name="GetGanttList">
							<xsl:with-param name="row" select="$row" />
							<xsl:with-param name="target" select="$target" />
							<xsl:with-param name="timeunit" select="$timeunit" />
							<xsl:with-param name="dates" select="TimeScaleDates" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="GetTimeList">
							<xsl:with-param name="tablename" select="$row/TableName" />
							<xsl:with-param name="tableid" select="$row/TableID" />
							<xsl:with-param name="timeunit" select="$timeunit" />
							<xsl:with-param name="targetcolumn" select="$targetcolumn" />
							<xsl:with-param name="dates" select="TimeScaleDates" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- create list using list path -->
			<xsl:when test="$accesstype='list'">
				<xsl:variable name="path">
					<xsl:call-template name="ConvertListToPath">
						<xsl:with-param name="path" select="$columntype/Path"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="result">
					<xsl:call-template name="FollowPath">
						<xsl:with-param name="rowset" select="/Database/tables/table[@name=$row/TableName]/rows/row[@id=$row/TableID]" />
						<xsl:with-param name="path" select="$path"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$result"/>
				<xsl:text>&#160;</xsl:text>
			</xsl:when>
			<!-- create list using new path format -->
			<xsl:when test="$accesstype='path'">
				<xsl:variable name="result">
					<xsl:call-template name="FollowPath">
						<xsl:with-param name="rowset" select="/Database/tables/table[@name=$row/TableName]/rows/row[@id=$row/TableID]" />
						<xsl:with-param name="path" select="$columntype/Path"/>
					</xsl:call-template>
					</xsl:variable>
				<xsl:text>&#160;</xsl:text>
			</xsl:when>
			<!-- create list using role format -->
			<xsl:when test="$accesstype='role'">
				<xsl:text>&#160;</xsl:text>
			</xsl:when>
			<!-- unknown access type-->
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetGanttList">
		<!-- 
		Parameter values:
		row = report row
		target = pointed to by row
		timeunit is taken from the ColumnType
		dates are taken from the ReportColumn
		How they are used:
		different values are returnd from the row and target
		-->
		<xsl:param name="row" />
		<xsl:param name="target" />
		<xsl:param name="timeunit" />
		<xsl:param name="dates" />
		<xsl:variable name="thisdate" select="substring-before(concat($dates,','),',')" />
		<xsl:variable name="remainingdates" select="substring-after($dates,',')" />
		<xsl:element name="time">
			<xsl:copy-of select="$row/GanttBarColor" />
			<xsl:variable name="start" select="string($target/CalculatedStartDate/text())" />
			<xsl:variable name="end" select="string($target/CalculatedEndDate/text())" />
			<xsl:variable name="thisdatenum" select="concat(substring($thisdate,1,4),substring($thisdate,6,2),substring($thisdate,9,2))" />
			<xsl:variable name="startnum" select="concat(substring($start,1,4),substring($start,6,2),substring($start,9,2))" />
			<xsl:variable name="endnum" select="concat(substring($end,1,4),substring($end,6,2),substring($end,9,2))" />
			<xsl:choose>
				<xsl:when test="$startnum &lt;= $thisdatenum and $endnum &gt; $thisdatenum">
					<xsl:copy-of select="$row/PlanBarColor" />
					<xsl:element name="task">yes</xsl:element>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
		<xsl:if test="$remainingdates">
			<xsl:call-template name="GetGanttList">
				<xsl:with-param name="row" select="$row" />
				<xsl:with-param name="target" select="$target" />
				<xsl:with-param name="timeunit" select="$timeunit" />
				<xsl:with-param name="dates" select="$remainingdates" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="GetTimeList">
		<!-- 
		Parameter values:
		tablename, tableid are take from the ReportRow
		timeunit, targetcolumn are taken from the ColumnType
		dates are taken from the ReportColumn
		How they are used:
		tablename + timeunit = target table name
		(tablename+'ID')(tableid) & 'Period'(date) = select correct row
		targetcolumn = contains data returned
		-->
		<xsl:param name="tablename" />
		<xsl:param name="tableid" />
		<xsl:param name="timeunit" />
		<xsl:param name="targetcolumn" />
		<xsl:param name="dates" />
		<xsl:variable name="targettable" select="concat($tablename, $timeunit)" />
		<xsl:variable name="thisdate" select="substring-before(concat($dates,','),',')" />
		<xsl:variable name="remainingdates" select="substring-after($dates,',')" />
		<xsl:variable name="selectcolumn" select="concat($tablename, 'ID')" />
		<xsl:variable name="target" select="$database//table[@name=$targettable]/rows/row[(*[local-name(.)=$selectcolumn])=$tableid and Period=$thisdate]" />
		<xsl:variable name="result" select="$target/*[local-name(.)=$targetcolumn]" />
		<xsl:element name="time">
			<xsl:choose>
				<xsl:when test="$result">
					<xsl:copy-of select="$result" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>&#160;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
		<xsl:if test="$remainingdates">
		<xsl:call-template name="GetTimeList">
			<xsl:with-param name="tablename" select="$tablename" />
			<xsl:with-param name="tableid" select="$tableid" />
			<xsl:with-param name="timeunit" select="$timeunit" />
			<xsl:with-param name="targetcolumn" select="$targetcolumn" />
			<xsl:with-param name="dates" select="$remainingdates" />
		</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="ConvertListToPath">
		<xsl:param name="path" select="''"/>
		<xsl:variable name="listcol" select="substring-before(concat($path,'/'),'/')"/>
		<xsl:variable name="rest1" select="substring-after($path,'/')"/>
		<xsl:variable name="listtable" select="substring-before(concat($rest1,'/'),'/')"/>
		<xsl:variable name="rest2" select="substring-after($rest1,'/')"/>
		<xsl:variable name="listselect" select="substring-before(concat($rest2,'/'),'/')"/>
		<xsl:variable name="rest3" select="substring-after($rest2,'/')"/>
		<xsl:variable name="listtarget" select="substring-before(concat($rest3,'/'),'/')"/>
		<xsl:variable name="rest4" select="substring-after($rest3,'/')"/>
		<xsl:variable name="listtable2" select="substring-before(concat($rest4,'/'),'/')"/>
		<xsl:variable name="listcol2" select="substring-after($rest4,'/')"/>
		<xsl:choose>
			<xsl:when test="not($listtable2)">
				<xsl:choose>
					<xsl:when test="$listtarget='ID'">
						<xsl:value-of select="concat($listtable,'-',$listselect,'/ID')"/>
					</xsl:when>
					<xsl:otherwise>
				<xsl:value-of select="concat($listtable,'-',$listselect,'/',substring($listtarget,1,string-length($listtarget)-2),'/ID')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($listtable,'-',$listselect,'/',$listtable2,'/',$listcol2)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="FollowPath">
		<xsl:param name="rowset"/>
		<xsl:param name="path"/>
		<xsl:variable name="link" select="substring-before(concat($path,'/'), '/')" />
		<xsl:variable name="rest" select="substring-after($path, '/')" />

		<xsl:choose>
			<!-- follow this link -->
			<xsl:when test="count(exsl:node-set($rowset)/*) and $rest">
				<xsl:variable name="a" select="substring-before(concat($link,'-'), '-')" />
				<xsl:variable name="rest1" select="substring-after($link, '-')" />
				<xsl:variable name="b" select="substring-before(concat($rest1,'-'),'-')" />
				<xsl:variable name="c" select="substring-after($rest1,'-')" />
				<xsl:variable name="newrowset">
				<xsl:choose>
					<xsl:when test="not($b)">
						<xsl:call-template name="ForwardLookup">
							<xsl:with-param name="rowset" select="$rowset"/>
							<xsl:with-param name="table" select="$a" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="not($c)">
						<xsl:call-template name="ReverseLookup">
							<xsl:with-param name="rowset" select="$rowset"/>
							<xsl:with-param name="table" select="$a" />
							<xsl:with-param name="search" select="$b" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ComplexLookup">
							<xsl:with-param name="rowset" select="$rowset"/>
							<xsl:with-param name="target" select="$a" />
							<xsl:with-param name="table" select="$b" />
							<xsl:with-param name="search" select="$c" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="FollowPath">
						<xsl:with-param name="rowset" select="exsl:node-set($newrowset)/*"/>
						<xsl:with-param name="path" select="$rest"/>
					</xsl:call-template>
			</xsl:when>
			<!-- return data based on rowset -->
			<xsl:otherwise>
				<xsl:for-each select="$rowset">
					<xsl:if test="position()!=1">
						<xsl:text>, </xsl:text>
					</xsl:if>
					<xsl:value-of select="./*[local-name(.)=$link]"/>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>			
	</xsl:template>

	<!-- get column $table+'ID', return row in $table with that id -->
		<xsl:template name="ForwardLookup">
			<xsl:param name="rowset"/>
			<xsl:param name="table" select="''" />
			<xsl:variable name="column" select="concat($table, 'ID')" />
			<xsl:variable name="realtable">
					<xsl:call-template name="ConvertAlias">
						<xsl:with-param name="name" select="$table" />
					</xsl:call-template>
			</xsl:variable>
			<xsl:for-each select="$rowset">
				<xsl:variable name="rowid" select="*[local-name(.)=$column]" />
				<xsl:copy-of select="$database//table[@name=$realtable]/rows/row[@id=$rowid]"/>
				<!-- for some reason this version doesn't work - bcc 080310
				<xsl:copy-of select="$database/tables/table[@name=$realtable]/rows/row[@id=$rowid]"/> -->
			</xsl:for-each>
		</xsl:template>

	<!-- go to named table, find rows that point back to this table, return rows-->
	<xsl:template name="ReverseLookup">
		<xsl:param name="rowset"/>
		<xsl:param name="table" select="''" />
		<xsl:param name="search" select="''" />
		<xsl:for-each select="$rowset">
			<xsl:variable name="rowid" select="@id" />
			<xsl:copy-of select="$database//table[@name=$table]/rows/row[(*[local-name(.)=$search])=$rowid]"/>
		</xsl:for-each>
	</xsl:template>

	<!-- not implemented yet - bcc 080309 -->
	<xsl:template name="ComplexLookup">
		<xsl:param name="rowset"/>
		<xsl:param name="target" select="''" />
			<xsl:param name="table" select="''" />
			<xsl:param name="search" select="''" />
		<xsl:copy-of select="$rowset"/>
	</xsl:template>

	<xsl:template name="ConvertAlias">
		<xsl:param name="name" select="''" />
		<xsl:variable name="alttname" select="/Database/tablealiases/alias[@name=$name]" />
		<xsl:choose>
				<xsl:when test="$alttname">
					<xsl:value-of select="$alttname" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$name" />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>

	</xsl:stylesheet>
