<?xml version="1.0" encoding="UTF-8" ?>
<!-- 
#    Export a project's tasks in task id order

#    Copyright 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 080225 - first draft

-->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:c="http://column.names"
	>
	<xsl:output method="text"/>
	<!-- REQUIRED - specify the project's id number -->
	<xsl:param name="projectid" select="'2'" />
	
	<!-- this script can also extract information from other tables by changing the table name -->
	<xsl:param name="table" select="'Task'" />

	<!-- these are the columns that will be exported
	Name = the column name in the database
	Label = the column name that will be included with the data
	-->
	<c:columns>
		<c:column>
			<c:Name>ID</c:Name>
			<c:Label>ID</c:Label>
		</c:column>
		<c:column>
			<c:Name>Name</c:Name>
			<c:Label>Name</c:Label>
		</c:column>
		<c:column>
			<c:Name>EffortHours</c:Name>
			<c:Label>Effort</c:Label>
		</c:column>
		<c:column>
			<c:Name>DurationHours</c:Name>
			<c:Label>Duration</c:Label>
		</c:column>
		<c:column>
			<c:Name>CalculatedStartDate</c:Name>
			<c:Label>Start Date</c:Label>
		</c:column>
		<!-- example of looking up information in another table
		it means: look in the dependency table for any rows with a matching TaskID
		then return a list of PrerequisiteID's under the heading "Prerequisite"
		-->
		<c:column type="lookup">
			<c:Table>Dependency</c:Table>
			<c:Match>TaskID</c:Match>
			<c:Return>PrerequisiteID</c:Return>
			<c:Label>Prerequisites</c:Label>
		</c:column>
	</c:columns>

	<xsl:template match="/">
		<xsl:variable name="project" select="//table[@name='Project']/rows/row[ProjectID=$projectid]" />
		<xsl:call-template name="export">
			<xsl:with-param name="project" select="$project"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="export">
		<xsl:param name="project" />
		<xsl:variable name="clist" select="document('')/*/c:columns"/>
		<xsl:variable name="rlist" select="//table[@name=$table]/rows/row[ProjectID=$projectid]" />
		<xsl:call-template name="colhead">
			<xsl:with-param name="clist" select="$clist" />
		</xsl:call-template>
		<xsl:apply-templates select="$rlist" mode="exportrow">
			<xsl:sort select="@id" data-type="number"/>
			<xsl:with-param name="clist" select="$clist"/>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template name="colhead">
		<xsl:param name="clist" />
		<xsl:for-each select="$clist/c:column">
			<xsl:if test="position()!=1">
				<xsl:text>&#9;</xsl:text>
			</xsl:if>
				<xsl:value-of select="c:Label"/>
			</xsl:for-each>
		<xsl:text>
</xsl:text>
	</xsl:template>

	<xsl:template match="row" mode="exportrow">
		<xsl:param name="clist"/>
		<xsl:variable name="row" select="." />
		<xsl:variable name="database" select="/" />
		<xsl:for-each select="$clist/c:column">
			<xsl:if test="position()!=1">
				<xsl:text>&#9;</xsl:text>
			</xsl:if>
			<!--  two special cases
			- looking up data in other tables (such as dependency information)
			- using a default value for task durations
			-->
			<xsl:choose>
				<xsl:when test="@type='lookup'" >
					<xsl:call-template name="getvalues">
						<xsl:with-param name="database" select="$database" />
						<xsl:with-param name="row" select="$row" />
						<xsl:with-param name="column" select="." />
					</xsl:call-template>
				</xsl:when>
				<!-- if task duration hours were not specified, default to 8 -->
				<xsl:when test="c:Name='DurationHours' and $table='Task'" >
					<xsl:variable name="result" select="$row/DurationHours"/>
					<xsl:choose>
						<xsl:when test="$result">
							<xsl:value-of select="$result"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'8'"/>
						</xsl:otherwise>
					</xsl:choose> 
				</xsl:when>
				<!-- this is the normal case (selecting data by the column name) -->
				<xsl:otherwise>
					<xsl:variable name="colname" select="c:Name" />
					<xsl:value-of select="$row/*[local-name(.)=$colname]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:text>
</xsl:text>
	</xsl:template>

	<!-- look up data in a different table
	for example, when requesting task prerequisitese this routine will
	(1) find all of the dependency records that refer to this task as 'TaskID'
	(2) return all of the prerequisite ids from those dependency records
	-->
	<xsl:template name="getvalues">
		<xsl:param name="database" />
		<xsl:param name="row" />
		<xsl:param name="column" />
		<xsl:variable name="matchtable" select="$column/c:Table" />
		<xsl:variable name="match" select="$column/c:Match" />
		<xsl:variable name="return" select="$column/c:Return" />
		<xsl:variable name="matches" select="$database//table[@name=$matchtable]/rows/row[(*[local-name(.)=$match])=$row/@id]" />
		<xsl:for-each select="$matches">
			<xsl:if test="position()!=1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="./*[local-name(.)=$return]"/>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>