# Measurement - Expenses
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041104 - first version, based on Earned Value
# 041121 - several corrections
# 041122 - don't do future totals for actuals
# 041202 - adjust cut off date for "future"

# known problems
#	doesn't clear out prior totals, this could be done during creation of the index

# This routine is given:
#	- a list of project ids
#	- a list of weeks
#	- a list of project/measurment records to update

# It uses the following fields:
#	Calculates the following: 
#	- ProjectWeek
#		PlannedExpense (sums all of the planned expenses for each period)
#		ActualExpense (sums all of the actual expenses for each period)
#		OutlookExpense (sums all of the actual expenses and planned w/o actual expenses for each period)
#		PlannedExpenseToDate
#		ActualExpenseToDate
#		OutlookExpenseToDate
#	- ProjectMeasurement
#		LastWeekly

# It uses the following:
#	- Project
#		(nothing)
#	- ProjectWeek
#		(nothing)
#	- ProjectResourceWeek
#		(nothing)
#	- ProjectResourceDay
#		(nothing)
#	- Task (nothing)
#		ActualEndDate
#		BaseEndDate  (looks here first)
#		CalculatedEndDate  (looks here second)

def CalculateMeasurements(projects, periods, records):
    # make sure period are all valid dates (here or before this is called?)
    # weeks must be in ascending order

    today = Data.GetToday()
    di = Data.DateConv[today]
    cutoff = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to week (date index) minus (day 

    # make sure all required tables exist
    if not (Data.Database.has_key('ProjectWeek') 
        and Data.Database.has_key('ProjectMeasurement')
        and Data.Database.has_key('Expense')
        ):
        if debug: print "missing necessary table"
        pass   # give error message

    pwk = Data.Database['ProjectWeek']
    pm = Data.Database['ProjectMeasurement']
    exp = Data.Database['Expense']

    # create index for project/week
    minweek = min(periods)
    priorweek = Data.DateIndex[Data.DateConv[minweek] - 7]
    weekindex = {}
    for k, v in pwk.iteritems():
        p = v.get('ProjectID')  # these should always be there, but just in case we'll default to None
        w = v.get('Period')
        if (p in projects) and ((w in periods) or (w == priorweek)):
            weekindex[(p, w)] = k

    # create summary of Expense (project/expense)
    pdpExpense = {} # plan
    pdaExpense = {} # actual
    pdoExpense = {} # outlook
    for k, v in exp.iteritems():
        if v.get('zzStatus') == 'deleted': continue
        p = v.get('ProjectID')
        if not p: continue

        pd = v.get('PlannedDate')
        if pd:
            pdi = Data.DateConv[pd]
            pw = Data.DateIndex[pdi - Data.DateInfo[pdi][2]]  # convert to beginning of week (date index) minus (day of week)
        else:
            pw = None

        ad = v.get('ActualDate')
        if ad:
            adi = Data.DateConv[ad]
            aw = Data.DateIndex[adi - Data.DateInfo[adi][2]]  # convert to beginning of week (date index) minus (day of week)
        else:
            aw = None

        if (p in projects):
            pcost = v.get('PlannedAmount')
            acost = v.get('ActualAmount')
            if acost != None:
                ocost = acost; ow = aw
            elif pcost != None:
                ocost = pcost; ow = pw
            else:
                ocost = 0; ow = None
                
            if (pw in periods):
                if pcost:
                    if pdpExpense.has_key((p,pw)):
                        pdpExpense [(p,pw)] += pcost
                    else:
                        pdpExpense [(p,pw)] = pcost

            if (aw in periods):
                if acost:
                    if pdaExpense.has_key((p,aw)):
                        pdaExpense [(p,aw)] += acost
                    else:
                        pdaExpense [(p,aw)] = acost

            if (ow in periods):
                if ocost:
                    if pdoExpense.has_key((p,ow)):
                        pdoExpense [(p,ow)] += ocost
                    else:
                        pdoExpense [(p,ow)] = ocost

    for p in projects:
        for w in periods:
            change = { 'Table': 'ProjectWeek', 'ProjectID': p, 'Period': w }

            pwid = weekindex.get((p, w))
            if pwid:
                change['ID'] = pwid

            pe = pdpExpense.get((p,w))
            if not pe: pe = 0
            change['PlannedExpense'] = pe

            ae = pdaExpense.get((p,w))
            if not ae : ae = 0 
            change['ActualExpense'] = ae 

            oe = pdoExpense.get((p,w))
            if not oe : oe = 0 
            change['OutlookExpense'] = oe 

           # get prior week cumulative totals
            priorweek = Data.DateIndex[Data.DateConv[w] - 7] # find prior week
            pwidprior = weekindex.get((p, priorweek))

            if pwidprior:
                priorweekPEToDate = pwk[pwidprior].get('PlannedExpenseToDate')
                priorweekAEToDate = pwk[pwidprior].get('ActualExpenseToDate')
                priorweekOEToDate = pwk[pwidprior].get('OutlookExpenseToDate')

                if not priorweekPEToDate : priorweekPEToDate = 0
                if not priorweekAEToDate : priorweekAEToDate = 0
                if not priorweekOEToDate : priorweekOEToDate = 0
            else:
                priorweekPEToDate , priorweekAEToDate , priorweekOEToDate = 0, 0, 0

            change['PlannedExpenseToDate'] = priorweekPEToDate + pe
            change['ActualExpenseToDate'] = priorweekAEToDate + ae
            change['OutlookExpenseToDate'] = priorweekOEToDate + oe

            if w >= cutoff:
                change['ActualExpense'] = None
                change['ActualExpenseToDate'] = None

            # ?add project/week to index? Yes, needed to get prior week totals.

            undo = Data.Update(change)
            if not pwid:
                weekindex[(p, w)] = undo['ID']

    rundate = Data.GetToday()
    change = { 'Table': 'ProjectMeasurement' }
    for rec in records:
        change['ID'] = rec
        change['LastUpdate'] = rundate
        Data.Update(change)

    if debug: print "weekindex", weekindex
    if debug: print "pdpExpense", pdpExpense
    if debug: print "pdaExpense", pdaExpense
    if debug: print "pdoExpense", pdoExpense

    # Data.SetUndo  -- set undo is done by the calling program

CalculateMeasurements(projects, periods, records)
