#!/usr/bin/env python
# gantt report definition

# Copyright 2004, 2005, 2006, 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040412 - first version of this program
# 040414 - added menu/toolbar processing; added links to web pages
# 040417 - moved menu processing to Menu.py so it can be more easily shared
# 040419 - changes for new ReportRow column names; added RefreshReport to display updated data
# 040420 - change to show 'About' under the application menu instead of the 'Help' menu; double click on report name to open or show report; close will close this report; will open reports where they were before
# 040421 - fixed New Report button; added Duplicate button logic; added Delete button logic
# 040422 - added reactivate logic to Delete button; added ShowHidden logic; add logic to change  colors for different row types
# 040424 - added menu event handling for scripts
# 040427 - some changes to ReportColumn fields names
# 040503 - changes to use new ReportType and ColumnType tables
# 040505 - support new UI changes; temporarily make all new reports of type "Task"
# 040506 - updated NewReport button to allow selection of report
# 040508 - prevent deletion of project 1 or reports 1 or 2
# 040510 - fixed doClose and doExit
# 040512 - use Alex's report icon instead of smiley face; new reports for specific projects can be any task report
# 040518 - added doHome
# 040520 - renamed this script from Main.py to GanttPV.py
# 040528 - don't allow duplication of project id #1
# 040616 - change Target End Date column width to 120 (doesn't show heading as two lines for some reason)
# 040715 - Pierre_Rouleau@impathnetworks.com: removed all tabs, now use 4-space indentation level to comply with Official Python Guideline.
# 040716 - minor fix to tab changes
# 040914 - ReportTypes can be flagged as all/each/both for all projects or individual project use
# 050202 - remove line feed from insert report menu text
# 050409 - Alexander - added command-line support for opening .ganttpv files and .py scripts.
# 050503 - Alexander - moved script-running logic to Data.py
# 050504 - Alexander - implemented Window menu; moved some menu event-handling logic to Menu.py
# 050515 - Alexander - added MacOpenFile
# 060131 - Alexander - when the selection is invalid (index >= number of rows), treat it as empty
# 060315 - Brian - don't store invalid window position for main window.
# 060704 - Brian - update menus for 0.7
# 060705 - Brian - language support
# 060705 - Alex - implement "move row" buttons
# 060813 - Brian - add alternate logic that can prevent language translation (for ascii builds)
# 060909 - Brian - adjust columns widths so column headers aren't truncated
# 070323 - Brian - prevent main window from shifting down when reopened

import wx, wx.grid
from wx.lib.dialogs import MultipleChoiceDialog as wxMultipleChoiceDialog
# import webbrowser
import os, os.path, sys
import gettext
import re
# import images
import Data, ReportAids, UI, ID, Menu, GanttReport
import StartupData, ORMReport, ORM, QuickStart

debug = Data.debug

if debug: print "load GanttPV.py"

#----------------------------------------------------------------------

class ProjectReportList(wx.ListCtrl):
    def __init__(self, parent):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT|wx.LC_VIRTUAL|wx.LC_HRULES|wx.LC_VRULES|wx.LC_SINGLE_SEL)

        self.currentItem = None

        self.images = wx.ImageList(16, 16)
        path = os.path.join(Data.Path, "icons", "Report.bmp")
        self.idx1 = self.images.Add(wx.Bitmap(path, wx.BITMAP_TYPE_BMP))
        self.SetImageList(self.images, wx.IMAGE_LIST_SMALL)

        # create local pointers to data and report definitions
        self.UpdateDataPointers()
        self.UpdateColumnPointers()
        self.UpdateRowPointers()

        self.InsertColumn(0, _("Name"))
        self.InsertColumn(1, _("Start Date"))
        self.InsertColumn(2, _("Target End Date"))
        self.SetColumnWidth(0, 200)
        self.SetColumnWidth(1, 85)
        self.SetColumnWidth(2, 125)

        other = Data.Option
        self.attrhidden = wx.ListItemAttr()
        self.attrhidden.SetBackgroundColour(other.get('HiddenColor', 'light grey'))

        self.attrdeleted = wx.ListItemAttr()
        self.attrdeleted.SetBackgroundColour(other.get('DeletedColor', "pink"))

        self.attrproject = wx.ListItemAttr()
        self.attrproject.SetBackgroundColour(other.get('ParentColor', "pale green"))

        self.attrreport = wx.ListItemAttr()
        self.attrreport.SetBackgroundColour(other.get('ChildColor', "khaki"))

        wx.EVT_LIST_ITEM_ACTIVATED(self, self.GetId(), self.OnItemActivated)
        wx.EVT_LIST_ITEM_DESELECTED(self, self.GetId(), self.OnItemDeselected)
        wx.EVT_LIST_ITEM_SELECTED(self, self.GetId(), self.OnItemSelected)

    def OnItemSelected(self, event):
        self.currentItem = event.GetIndex()
        Menu.AdjustMenus(Data.OpenReports[1])

    def OnItemActivated(self, event):  # double clicked or "ENTER" while selected
        item = event.GetIndex()
        self.currentItem = item

        rr = self.reportrow[self.rows[item]]
        rowtable = rr['TableName']
        rowid = rr['TableID']

        if debug: print 'rowid:', rowid
        if rowtable == 'Project':
                # if project open project edit window
            Menu.doEditName(rowtable, rowid)  # so that it does something
        elif rowtable == 'Report':
            Data.OpenReport(rowid)  # row id == report id

    def getColumnText(self, index, col):
        item = self.GetItem(index, col)
        return item.GetText()

    def OnItemDeselected(self, evt):
        self.currentItem = None
        Menu.AdjustMenus(Data.OpenReports[1])

#----------- provide data to list display

    def OnGetItemText(self, item, col):
        rr = self.reportrow[self.rows[item]]
        rowtable = rr['TableName']
        rowid = rr['TableID']
        # rc = self.reportcolumn[self.columns[col]]
        rc = self.columntype[self.ctypes[col]]
        # print 'rc', rc
        column = rc['Name']
        # print table, column  # it prints each column twice???
        value = self.data[rowtable][rowid].get(column, '---')
        if value == None: value = ''
        return value

    def OnGetItemImage(self, item):
        rr = self.reportrow[self.rows[item]]
        rowtable = rr['TableName']
        # rowid = rr['TableID']
        if rowtable == 'Report':
            return self.idx1
        else:
            return -1

    def OnGetItemAttr(self, item):
        rr = self.reportrow[self.rows[item]]
        rowtable = rr['TableName']
        rowid = rr['TableID']
        deleted = Data.Database[rowtable][rowid].get('zzStatus') == 'deleted'
        hidden = rr.get('Hidden', False)
        if deleted:
            return self.attrdeleted
        elif hidden:
            return self.attrhidden
        elif rowtable == 'Project':
            return self.attrproject
        elif rowtable  == 'Report':
            return self.attrreport
        else:
            return None

# These are not part of the standard interface - my routines to make display easier

    def UpdateDataPointers(self):
        Data.UpdateDataPointers(self, 1)

    def UpdateColumnPointers(self):
        pointers = Data.GetColumnPointers(1)
        self.columns, self.ctypes, self.coloffset = pointers

    def UpdateRowPointers(self):
        Data.UpdateRowPointers(self)
        count = len(self.rows)
        if self.currentItem >= count:
            self.currentItem = None
        self.SetItemCount(count)  # number of items in virtual list

#----------------------------------------------------------------------

class ProjectReportFrame(UI.MainFrame):
    def __init__(self, reportid, *args, **kwds):
        if debug: print 'ProjectReportFrame __init__'
        if debug: print 'reportid', reportid
        UI.MainFrame.__init__(self, *args, **kwds)

        # these three commands were moved out of UI.MainFrame's init
        self.main_list = ProjectReportList(self.Main_Panel)
        self.Report = self.main_list
        self.ReportID = reportid

        Data.OpenReports[reportid] = self  # used to refresh report
        Data.Report[reportid]['Open'] = True  # needed by close routine

        Menu.GetScriptNames()
        Menu.doAddScripts(self)
        Menu.FillWindowMenu(self)
        Menu.AdjustMenus(self)

        self.set_properties()
        self.do_layout()

        # file menu events
        wx.EVT_MENU(self, wx.ID_NEW,    Menu.doNew)
        wx.EVT_MENU(self, wx.ID_OPEN,   Menu.doOpen)
        wx.EVT_MENU(self, ID.M_OPEN_REPORT, self.OnOpenReport)
        wx.EVT_MENU(self, wx.ID_CLOSE,  self.doClose)
        # wx.EVT_MENU(self, wx.ID_CLOSE,  Menu.doExit)
        wx.EVT_MENU(self, wx.ID_CLOSE_ALL, Menu.doCloseReports)
        wx.EVT_MENU(self, wx.ID_SAVE,   Menu.doSave)
        wx.EVT_MENU(self, wx.ID_SAVEAS, Menu.doSaveAs)
        wx.EVT_MENU(self, ID.M_AUTO_SAVE, Menu.doAutoSaveOnQuit)
        wx.EVT_MENU(self, wx.ID_REVERT, Menu.doRevert)
        wx.EVT_MENU(self, ID.M_REVERT_OPEN, Menu.doRevertOpen)
        wx.EVT_MENU(self, wx.ID_EXIT, Menu.doExit)

        # edit menu events
        wx.EVT_MENU(self, wx.ID_UNDO,          Menu.doUndo)
        wx.EVT_MENU(self, wx.ID_REDO,          Menu.doRedo)

        wx.EVT_MENU(self, ID.M_INSERT_PROJECT,  self.OnNewProject)
        wx.EVT_MENU(self, ID.M_INSERT_REPORT,   self.OnNewReport)
        wx.EVT_MENU(self, ID.M_DELETE_ROW,      self.OnDelete)
        wx.EVT_MENU(self, ID.M_MOVE_ROW_UP, self.OnMoveRow)
        wx.EVT_MENU(self, ID.M_MOVE_ROW_DOWN, self.OnMoveRow)

        wx.EVT_MENU(self, ID.M_EDIT_PROJECT_NAME,   self.OnEditProjectName)
        wx.EVT_MENU(self, ID.M_EDIT_REPORT_NAME,   self.OnEditReportName)

        # script menu events
        wx.EVT_MENU(self, ID.FIND_SCRIPTS, Menu.doFindScripts)
        wx.EVT_MENU(self, ID.REFRESH_SCRIPTS, Menu.doRefreshScripts)
        wx.EVT_MENU(self, ID.REPEAT_SCRIPT, Menu.doRepeatScript)
        wx.EVT_MENU_RANGE(self, ID.FIRST_SCRIPT, ID.LAST_SCRIPT, Menu.doScript)

        # window menu events
        wx.EVT_MENU_RANGE(self, ID.FIRST_WINDOW, ID.LAST_WINDOW, self.doBringWindow)

        # help menu events
        wx.EVT_MENU(self, wx.ID_ABOUT, Menu.doShowAbout)
        wx.EVT_MENU(self, ID.QUICK_START, self.doQuick)
        wx.EVT_MENU(self, ID.ORM_QUICK_START, self.doORMQuick)
        wx.EVT_MENU(self, ID.SHORT_CUTS, self.doShort)
        wx.EVT_MENU(self, ID.HOME_PAGE, Menu.doHome)
        wx.EVT_MENU(self, ID.HELP_PAGE, Menu.doHelp)
        wx.EVT_MENU(self, ID.HELP_BOOK, Menu.doBook)
        wx.EVT_MENU(self, ID.FORUM, Menu.doForum)

        # frame events
        wx.EVT_ACTIVATE(self, self.OnActivate)
        wx.EVT_CLOSE(self, self.doClose)
        wx.EVT_SIZE(self, self.OnSize)
        wx.EVT_MOVE(self, self.OnMove)

        # tool bar events
        wx.EVT_TOOL(self, ID.NEW_PROJECT, self.OnNewProject)
        wx.EVT_TOOL(self, ID.NEW_REPORT, self.OnNewReport)
        wx.EVT_TOOL(self, ID.EDIT, self.OnEdit)
        wx.EVT_TOOL(self, ID.DUPLICATE, self.OnDuplicate)
        wx.EVT_TOOL(self, ID.DELETE, self.OnDelete)
        wx.EVT_TOOL(self, ID.SHOW_HIDDEN_REPORT, self.OnShowHidden)
        wx.EVT_TOOL(self, ID.MOVE_UP, self.OnMoveRow)
        wx.EVT_TOOL(self, ID.MOVE_DOWN, self.OnMoveRow)

# ------ Tool Bar Commands ---------

    def OnNewProject(self, event):
        change = {'Table': 'Project', 'Name': 'New Project'}
        id = Data.Update(change)['ID']

        change = {'Table': 'Project', 'ID': id, 'Name': _('Project') + " " + str(id)}
        undo = Data.Update(change)

        change = {'Table': 'ReportRow', 'ReportID': 1, 'TableName': 'Project', 'TableID': id}
        undo = Data.Update(change)  # created here to control where inserted
        newrowid = undo['ID']

        rlist = Data.GetRowList(self.ReportID)
        item = self.Report.currentItem
        if item is None:
            pos = len(rlist)  # nothing selected
        else:
            rowid = self.Report.rows[item]
            pos = rlist.index(rowid) + 1
        rlist.insert(pos, newrowid)
        Data.ReorderReportRows(self.ReportID, rlist)
        Data.SetUndo('New Project')

    def OnNewReport(self, event):
        if debug: print "Start OnNewReport"
        # add report to which project?
        item = self.Report.currentItem
        if item == None:
            if debug: print "no item selected"
            return
        rowid = self.Report.rows[item]
        rr = Data.ReportRow[rowid]

        rowtable = rr['TableName']
        rowid = rr['TableID']
        if debug: print "rowtable", rowtable, "rowid", rowid
        if rowtable == 'Project':
            pid = rowid
        elif rowtable == 'Report':
            pid = Data.Database['Report'][rowid].get('ProjectID')
        if not pid:
            if debug: print "couldn't find project id"
            return  # shouldn't happen

        menuid = []  # list of types to be displayed for selection
        rlist = Data.GetRowList(2)  # report 2 defines the sequence of the report type selection list
        for k in rlist:
            rr = Data.ReportRow[k]
            hidden = rr.get('Hidden', False)
            table = rr.get('TableName')  # should always be 'ReportType' or 'ColumnType'
            id = rr.get('TableID')
            if (not hidden) and table == 'ReportType' and id:
                active = Data.ReportType[id].get('zzStatus') != 'deleted'
                if pid == 1:
                    allproj = Data.ReportType[id].get('AllOrEach') in ['all', 'both', None]
                    if active and allproj :
                        menuid.append(id)
                else:
                    eachproj = Data.ReportType[id].get('AllOrEach') in ['each', 'both']
                    if active and (eachproj or Data.ReportType[id].get('TableA') == "Task"):
                        menuid.append(id)

        types = [Data.ReportType[x] for x in menuid]
        names = [(rt.get('Label') or rt.get('Name') or '') for rt in types]
        menutext = [s.replace('\n', ' ') for s in names]

        # sort menu
        # menus = zip(menutext, menuid)
        # menus.sort()
        # menutext, menuid = zip(*menus)
        if debug: print menuid, menutext

        # dlg = GanttReport.SearchSelection(self, -1, "New Report", size=(240, 320))
        # dlg.Instructions.SetLabel("Select reports to add:")
        # dlg.SelectionListBox.Set(menutext)
        dlg = wxMultipleChoiceDialog(self, "Select reports to add:", "New Report", menutext, style=wx.DEFAULT_FRAME_STYLE, size=(240, 320))
        dlg.Centre()
        if (dlg.ShowModal() != wx.ID_OK): return
        newlist = dlg.GetValue()

        for selection in newlist:
            rtid = menuid[selection]
            columns = Data.GetSuggestedColumns(rtid)
            report = {'Table': 'Report', 'ReportTypeID': rtid}
            Data.AddReport(pid, report, columns)
        Data.SetUndo('New Report')
        if debug: print "End OnNewReport"

# use this logic when I open a new report???
#        global _docList
#        newFrame = DrawingFrame(None, -1, "Untitled")
#        newFrame.Show(True)
#        _docList.append(newFrame)

# not implemented yet
    def OnEdit(self, event):
        if debug: print 'Start OnEdit'
        item = self.Report.currentItem
        if item == None:
            if debug: print "no item selected"
            return
        rowid = self.Report.rows[item]
        rr = Data.ReportRow[rowid]

        rowtable = rr['TableName']
        rowid = rr['TableID']
        if debug: print 'rowtable:', rowtable
        if debug: print 'rowid:', rowid
        if rowtable == 'Project':
            # if project open project edit window
            dlg = wx.TextEntryDialog(frame, 'New project name', 'Edit Project Name', 'asdf')
            dlg.SetValue("xxxxxxx")
            if dlg.ShowModal() == wxID_OK:
                pass
            dlg.Destroy()

        # change = { 'Table': 'Report', 'Name': 'New Report', 'FirstColumn': id }
        # Data.Update(change)
        # Data.SetUndo('Edit')

        elif rowtable == 'Report':
            # if project open project edit window
            dlg = wx.TextEntryDialog(frame, 'New report name', 'Edit Report Name', 'asdf')
            dlg.SetValue("xxxxx")
            if dlg.ShowModal() == wxID_OK:
                pass
            dlg.Destroy()

        if debug: print 'End OnEdit'

    def OnDuplicate(self, event):
        if debug: print "Start OnDuplicate"
        item = self.Report.currentItem
        if item == None:
            if debug: print "no item selected"
            return
        rowid = self.Report.rows[item]
        rr = Data.ReportRow[rowid]

        rowtable = rr['TableName']
        rowid = rr['TableID']
        if debug: print "rowtable", rowtable, "rowid", rowid
        if rowtable == 'Project' and rowid:  # duplicate project
            if rowid == 1: return
            # copy project
            new = Data.Project[rowid].copy()
            del new['ID']
            new['Table'] = 'Project'
            undo = Data.Update(new)
            pid = undo['ID']
            # copy tasks
            for k, v in Data.Task.items():
                v = Data.Task[k]
                if v['ProjectID'] != rowid: continue
                new = v.copy()
                del new['ID']
                new['Table'] = 'Task'
                new['ProjectID'] = pid
                Data.Update(new)
            Data.SetUndo('Duplicate Project')

        elif rowtable == 'Report' and rowid:  # duplicate report
            # copy report
            rep = Data.Report[rowid].copy()
            del rep['ID']
            rep['Table'] = 'Report'
            undo = Data.Update(rep)
            rid = undo['ID']

            # copy report columns
            clist = Data.GetColumnList(rowid)
            cols = []
            for c in clist:
                new = Data.ReportColumn[c].copy()
                del new['ID']
                new['Table'] = 'ReportColumn'
                new['ReportID'] = rid
                cols.append(new)
            cols.reverse()

            c = None
            for new in cols:
                new['NextColumn'] = c
                undo = Data.Update(new)
                c = undo['ID']
            rep['FirstColumn'] = c

            # copy order of report rows
            rlist = Data.GetRowList(rowid)
            rows = []
            for r in rlist:
                new = Data.ReportRow[r].copy()
                del new['ID']
                new['Table'] = 'ReportRow'
                new['ReportID'] = rid
                rows.append(new)
            rows.reverse()

            r = None
            for new in rows:
                new['NextRow'] = r
                undo = Data.Update(new)
                r = undo['ID']
            rep['FirstRow'] = r

# turn these into a routine?
# def dupchain(parent, parentname, child, childname, first, next)  
#       parent is a record, child is a table, names are table names, first & next are columns names

            rep['ID'] = rid
            Data.Update(rep)
            Data.SetUndo('Duplicate Report')
        if debug: print "End OnDuplicate"
        
    def OnDelete(self, event):
        if debug: print "Start OnDelete"
        item = self.Report.currentItem
        if item == None:
            if debug: print "no item selected"
            return
        rowid = self.Report.rows[item]
        rr = Data.ReportRow[rowid]

        rowtable = rr['TableName']
        rowid = rr['TableID']
        if debug: print "rowtable", rowtable, "rowid", rowid
        if rowtable == 'Project' and rowid:  # delete project
            if rowid == 1: return  # don't allow deletion of project 1
            # check to see if already deleted
            if Data.Database['Project'][rowid].get('zzStatus') == 'deleted':  # only reactivate project, not tasks
                change = {'Table':'Project', 'ID': rowid, 'zzStatus': None}
                Data.Update(change)
                Data.SetUndo('Reactivate Project')
            else:
                # delete project
                change = {'Table':'Project', 'ID': rowid, 'zzStatus': 'deleted'}
                Data.Update(change)
                # delete tasks
                change = {'Table':'Task', 'ID': None, 'zzStatus': 'deleted'}
                for k, v in Data.Task.iteritems():
                    if v.get('ProjectID') == rowid:
                        change['ID'] = k
                        Data.Update(change)
                Data.SetUndo('Delete Project')

        elif rowtable == 'Report' and rowid:  # duplicate report
            if rowid == 1 or rowid == 2: return  # don't allow deletion of report 1 or 2
            # check to see if already deleted
            if Data.Database['Report'][rowid].get('zzStatus') == 'deleted':
                newstatus = None
                message = 'Reactivate Report'
            else:
                newstatus = 'deleted'
                message = 'Delete Report'
            # delete report
            change = {'Table':'Report', 'ID': rowid, 'zzStatus': newstatus}
            Data.Update(change)
            # delete report columns
            change = {'Table':'ReportColumn', 'ID': None, 'zzStatus': newstatus}
            for k, v in Data.ReportColumn.iteritems():
                if v['ReportID'] != rowid: continue
                change['ID'] = k
                Data.Update(change)
            # delete report rows
            change = {'Table':'ReportRow', 'ID': None, 'zzStatus': newstatus}
            for k, v in Data.ReportRow.iteritems():
                if v['ReportID'] != rowid: continue
                change['ID'] = k
                Data.Update(change)
            Data.SetUndo(message)
        if debug: print "End OnDelete"

    def OnHide(self, event):
        item = self.Report.currentItem
        if item == None:
            if debug: print "no item selected"
            return
        Menu.onHide(self.Report, event, [item])

    def OnShowHidden(self, event):
        Menu.onShowHidden(self, event)

    def OnMoveRow(self, event):
        """ Move selected rows up or down by one position """
        rows = self.Report.rows
        rowlevels = self.Report.rowlevels

        item = self.Report.currentItem
        if item == None:
            if debug: print "no item selected"
            return
        rowid = rows[item]
        level = rowlevels[item]

        if event.GetId() in (ID.MOVE_UP, ID.M_MOVE_ROW_UP):
            step = -1
        else: # ID.MOVE_DOWN
            step = 1

        # find the next visible, same-parent row
        next_row_id = None
        x = item + step
        while 0 <= x < len(rows):
            lev = rowlevels[x]
            if lev == level:
                next_row_id = rows[x]
                break
            elif lev < level:
                break
            x += step
        if next_row_id is None:
            return

        # check for invisible rows
        if not self.Report.report.get('ShowHidden'):
            # report may include rows that are not displayed
            rows, rowlevels = Data.GetRowLevels(self.ReportID)
            dest = rows.index(rowid)  # convert row position
        else:
            # don't modify the row list directly
            rows = rows[:]
            dest = item

        # move next row to the other side of selection
        rows.remove(next_row_id)
        rows.insert(dest, next_row_id)

        # apply the new row order
        Data.ReorderReportRows(self.ReportID, rows)
        Data.SetUndo('Move Row')

    # ---- menu commands -----

    def doClose(self, event):
        # if Data.platform == "mac":
        #     self.Hide()
        # else:
        Menu.doExit(event)

    def doBringWindow(self, event):
        Menu.doBringWindow(self, event)
        
    def doQuick(self, event):
        Menu.doQuick(self, event)

    def doORMQuick(self, event):
        Menu.doORMQuick(self, event)

    def doShort(self, event):
        Menu.doShort(self, event)
        
    def OnEditProjectName(self, event):
        reportrowid = self.Report.rows[self.Report.currentItem]  # item -> report row id
        rr = self.Report.reportrow[reportrowid]  # report row id -> report row record
        rowtable = rr['TableName']
        rowid = rr['TableID']

        if rowtable == 'Report':  # report row
            projectid = Data.Report[rowid].get('ProjectID')
            Menu.doEditName('Project', projectid)
        else:  # project row
            Menu.doEditName(rowtable, rowid)

    def OnEditReportName(self, event):
        reportrowid = self.Report.rows[self.Report.currentItem]  # item -> report row id
        rr = self.Report.reportrow[reportrowid]  # report row id -> report row record
        rowtable = rr['TableName']
        rowid = rr['TableID']
        Menu.doEditName(rowtable, rowid)

    def OnOpenReport(self, event):
        """ Open selected report """
        reportrowid = self.Report.rows[self.Report.currentItem]  # item -> report row id
        rr = self.Report.reportrow[reportrowid]  # report row id -> report row record
        rowtable = rr['TableName']
        rowid = rr['TableID']

        if debug: print 'rowid:', rowid
        if rowtable == 'Project': pass
            # if project open project edit window
        elif rowtable == 'Report':
            Data.OpenReport(rowid)  # row id == report id

 # ---------------- activate

    def OnActivate(self, event):
        if event.GetActive():
            Data.SetActiveReport(self.ReportID)
        event.Skip()

# ----------------- window size/position 

    def OnSize(self, event):
        size = event.GetSize()
        # if debug: print size
        r = Data.Database['Report'][self.ReportID]
        r['FrameSizeW'] = size.width
        r['FrameSizeH'] = size.height

        event.Skip()  # to call default handler; needed?

    def OnMove(self, event):
        pos = event.GetPosition()
        # if debug: print pos
        if pos.x > 0 and pos.y > 0:
            r = Data.Database['Report'][self.ReportID]
            if Data.platform == "win":  # else windows don't open in the right place
                r['FramePositionX'] = pos.x - 4
                r['FramePositionY'] = pos.y - 50
            else:
                r['FramePositionX'] = pos.x
                r['FramePositionY'] = pos.y

        event.Skip()  # needed?

    def UpdatePointers(self, all=0):  # 1 = new database; 0 = changed report rows or columns
        item = self.Report.currentItem
        if item is not None:
           rowid = self.Report.rows[item]

        if all:
            self.Report.UpdateDataPointers()
        self.Report.UpdateColumnPointers()
        self.Report.UpdateRowPointers()

        if item is not None:
            try:
                item = self.Report.rows.index(rowid)
                self.main_list.Select(item)
            except ValueError:
                pass

# -------------

class GanttPVApp(wx.App):
    def OnInit(self):
        wx.InitAllImageHandlers()

        Main = ProjectReportFrame(1, None)
          # first parameter is the report id
          # second parameter is parent for wx.Frame
        self.SetTopWindow(Main)

        self.ParseOptions()
        Main.Show(True)

        return 1

    def ParseOptions(self):
        """ Process any command line options """
        options = sys.argv
        usageStr = 'usage: ' + options[0] + ' [file...]'
        i = 1
        while i < len(options):
            Data.OpenFile(options[i])
            i += 1

    def MacOpenFile(self, path):
        """ Open a file for Mac OS. """
        Data.OpenFile(path)

# end of class GanttPVApp

if __name__ == "__main__":
    path = os.path.abspath(sys.argv[0])
    Data.Path = os.path.dirname(path)
    if debug: print "data path:", Data.Path

    ## eventually put the options file where it belongs
    ## (this code crashes the Windows Python IDE at present
    ##   that makes it tough to test)
    # paths = wx.StandardPaths.Get()
    # user_data_dir = paths.GetUserDataDir()
    # print user_data_dir

    home = os.path.expanduser('~')
    print "home path expanded", home

    Data.LoadOption()

    if 1: # language translation
        # set language from options file
        language = Data.Option.get('Language') or 'en'
        locale_dir = os.path.join(Data.Path, 'locale')
        domain = 'pureviolet'
        try:
            selected_language = gettext.translation(domain, locale_dir, languages=[language])
            selected_language.install()
        except IOError:
            pass  # if file not available, just ignore error
    else:
        def _(message): return message
        import __builtin__
        __builtin__.__dict__['_'] = _

    # protect "_" from pyshell
    Data._=_; ReportAids._=_; UI._=_; ID._=_; Menu._=_; GanttReport._=_
    StartupData._=_; ORMReport._=_; ORM._=_; QuickStart._=_

    # set default data
    Data.SetEmptyData()
    Data.PrepDatabase()

    if debug: print "Start main loop ------------------------ "
    Data.App = GanttPVApp(0)
    ReportAids.CreateReports()
    Data.App.MainLoop()
    if debug: print "End main loop -------------------------- "

if debug: print "end GanttPV.py"

