#!/usr/bin/env python
# ID's for menus

# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040414 - first version of this file
# 040416 - changes to match revised menus/tool bars in Main & Gantt Report
# 040423 - added Scripts menu
# 040505 - renamed some ID's from 'Task' to 'Row'
# 040715 - Pierre_Rouleau@impathnetworks.com: removed all tabs, now use 4-space indentation level to comply with Official Python Guideline.
# 050503 - Alexander - added Window menu support; re-numbered IDs; used standard wx constants for some menu items
# 070404 - Brian - added ID's for new menu items for 0.7

# -------- wx menu item IDs --------

# wx.ID_NEW  # File menu
# wx.ID_OPEN
M_OPEN_REPORT = 600
# wx.ID_CLOSE
# wx.ID_CLOSE_ALL
# wx.ID_SAVE
# wx.ID_SAVEAS
M_AUTO_SAVE = 601
M_REVERT_TO_SAVE = 602
M_REVERT_OPEN = 603
# wx.ID_EXIT

# wx.ID_UNDO  # Edit menu
# wx.ID_REDO

# main only
M_INSERT_PROJECT = 701
M_INSERT_REPORT = 702
# grid only
M_INSERT_ROW = 703
M_INSERT_ROW_ABOVE = 704
M_INSERT_CHILD = 705
M_INSERT_RELATED = 706
# common
M_DELETE_ROW = 707
M_MOVE_ROW_UP = 708
M_MOVE_ROW_DOWN = 709
M_SHIFT_LEFT = 710
M_SHIFT_RIGHT = 711
M_EDIT_PROJECT_NAME = 712
M_EDIT_REPORT_NAME = 713

M_ASSIGN_PREREQUISITE = 801
M_LINK_TASKS = 802
M_ASSIGN_RESOURCE = 803
M_RESOURCE_TO_GROUP = 804
M_DEFINE_RESOURCE_GROUP = 805
M_ASSIGN_TASK = 806

M_INSERT_COLUMN = 811
M_DELETE_COLUMN = 812
M_MOVE_COLUMN_LEFT = 813
M_MOVE_COLUMN_RIGHT = 814
M_SCROLL_LEFT_FAST = 815
M_SCROLL_LEFT = 816
M_SCROLL_RIGHT = 817
M_SCROLL_RIGHT_FAST = 818
M_SCROLL_TO_TASK = 819

# wx.ID_MAXIMIZE_FRAME  # Window menu
# wx.ID_ICONIZE_FRAME

# wx.ID_ABOUT  # Help menu
# wx.ID_HELP


# -------- our menu item IDs --------

FIND_SCRIPTS   = 301  # Scripts menu
REFRESH_SCRIPTS = 302
REPEAT_SCRIPT = 303

QUICK_START = 501
SHORT_CUTS  = 502
HOME_PAGE   = 503  # Help menu
HELP_PAGE   = 504
HELP_BOOK   = 505
FORUM       = 506
ORM_QUICK_START = 507

FIRST_SCRIPT      = 11000  # ranges for generated items
LAST_SCRIPT       = 11999
FIRST_WINDOW      = 12000
LAST_WINDOW       = 12999


# -------- our tool IDs --------

NEW_PROJECT  = 2101  # Main
NEW_REPORT   = 2102
EDIT         = 2103
DUPLICATE    = 2104
DELETE       = 2105
SHOW_HIDDEN_REPORT = 2106

INSERT_ROW      = 2201  # Report
DUPLICATE_ROW   = 2202
DELETE_ROW      = 2203
MOVE_UP          = 2204
MOVE_DOWN        = 2205
PREREQUISITE     = 2206
ASSIGN_RESOURCE  = 2207
HIDE_ROW        = 2208
SHOW_HIDDEN      = 2209

INSERT_COLUMN   = 2301
# SELECT_CONTENTS = 2302
DELETE_COLUMN   = 2303
MOVE_LEFT       = 2304
MOVE_RIGHT      = 2305

COLUMN_OPTIONS    = 2401

SCROLL_LEFT_FAR  = 2502
SCROLL_LEFT      = 2503
SCROLL_RIGHT     = 2504
SCROLL_RIGHT_FAR = 2505
SCROLL_TO_TASK   = 2506
# NEW_RESOURCE     = 2601  # Resource
# EDIT_RESOURCE    = 2602
# ASSIGN_TASK      = 2603
# DELETE_RESOURCE  = 2604
# HIDE_RESOURCE    = 2605
# SHOW_HIDDEN_RESOURCE = 2606

NORMAL = 3101
DRAW = 3102

# ---------- ORM window ids ----------

FIRST_DELETE_SEQUENCE = 13000
LAST_DELETE_SEQUENCE = 13999
FIRST_RING_CONSTRAINT = 14000
LAST_RING_CONSTRAINT = 14999
