# Copyright 2007, 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 090102 - Brian - separate canvas logic into separate file

# higher priority
# - get undo working
# - add a refresh diagram button or menu item
# 1) add a menu bar to the window - change content depending on which pane is active?
# 3) put a status bar at the bottom
# 6) put all of the notebook windows into a dynamic sash window??
#   but there may be problems with the scroll bars??
#   also, I can't see how to save and restore the subwindow layout
# - when lots of lines cross the diagram to the same object
#       select object; it suggests how may times to repeat graphic;
#       repeats graphic and moves each instance to a good location
# - drag to select all objects totally within the rectangle
# - move all selected items when moving
# - automatic positioning algorithm for imported data
# when typing into an object -- added on 071111

# cntrl-double click selects an object and its nearest neighbors???
# cntrl-triple click selects an object and its nearest neighbors once removed???
#   these inclusions travel accross connectors (added on 071115) 

# if editing text in object:
#   if shift key:
#       select text
#   else:
#       arrow keys move the cursor in the field
# else:
#   if shift key:
#       select the different fields inside of the object
#   else:
#       move the object a pixel in that direction

# lower priority
# 1) Put the OGL windows into dynamicsashwindows so they can be split
# 2) Use Style Text Control for editing formated text
#    it will allow you to select text with the mouse and drag it within
#        the document, maybe also can drag into other objects?

#COMPLETED
# 2))put a toolbar at the top of each page in the notebooks
#  steal it from the demo -- Drafted
# 4) put popupmenus on the orm drawing canvas - to select different types of objects
#       -- partly DONE working for pseudo dc canvas
# 5) add a pseudo dc window -- DONE
# - get subtypes working -- DONE 071112

from ORM import *  # because ORM used to be in the same file
import Event

#---------------------------------------------------------------------------
# Below here it is pseudo dc
#---------------------------------------------------------------------------

W = 2000
H = 2000
SW = 150
SH = 150
SHAPE_COUNT = 2500
hitradius = 2

# -------------
# might use these two classes to store data only needed by drawing canvas
# not used yet - I'm still not sure if I need these

class CanvasObject:
    _moxref = {}  # (object_type, object_id) -> GraphicObject_object
    _canxref = {}  # ReportRowID -> CanvasNode
    def __init__(self, node):
        self.node = node  # this is the GraphicObject
        _canxref[node.ID] = self

        mo = node.Target
        _moxref[mo.Table, mo.ID] = node

    def _MoGet(mo):
        return _canxref[_moxref[mo.Table, mo.ID].ID]
    MoLookup = _MoGet

    def _MoGetRo(mo):
        return _moxref[mo.Table, mo.ID]
    MoLookupRo = _MoGetRo

    def _RoGet(ro):
        return _canxref[ro.ID]
    RoLookup = _RoGet


class CanvasNode(CanvasObject):
    def __init__(self, node):

        self.connectors = []
        

class CanvasConnector(CanvasObject):
    def __init__(self, connector):

        self.nodes = []

# -------------
class MyCanvas(wx.ScrolledWindow):
    AddedToSelection = Event.Event(msg='Added to selection in an ORM Canvas')
    DroppedFromSelection = Event.Event(msg='Dropped from selection in an ORM Canvas')
    def __init__(self, parent, id, log, size = wx.DefaultSize, report=None):
        wx.ScrolledWindow.__init__(self, parent, id, (0, 0), size=size, style=wx.WANTS_CHARS | wx.SUNKEN_BORDER)
        self.AddedToSelection = Event.Event(msg='Added to selection in this ORM Canvas')
        self.DroppedFromSelection = Event.Event(msg='Dropped from selection in this ORM Canvas')

        self.leftClickType = 'ORMObjectTypeShape'  # where to specify behaviors?

        self.Report = report  # report object
        self.ReportID = report.ID  # redundant - may remove

        self.lines = []
        self.maxWidth  = W
        self.maxHeight = H
        self.x = self.y = 0
        self.curLine = []
        self.drawing = False
        self.selection = {}  # keys = selected ids
        self.rolelist = []   # list of selected roles
        self.focus_cell = None
        self.keyboard_nav_dcid = False
        self.selection_rectangle = False  # fix a run time error

        font = self.GetFont() 
        if Data.platform == "mac":
            font.SetPointSize(11)
            font.SetFaceName('Geneva')
        else:
            font.SetPointSize(7)
            font.SetFaceName('Tahoma')
        # font.SetFamily(wx.wxSWISS) 
        self.SetFont(font) 

        self.SetBackgroundColour("WHITE")
        # bmp = images.getTest2Bitmap()
        bmp = Menu.Bitmap("icons/New Project.bmp", wx.BITMAP_TYPE_ANY)
        mask = wx.Mask(bmp, wx.BLUE)
        bmp.SetMask(mask)
        self.bmp = bmp

        self.SetVirtualSize((self.maxWidth, self.maxHeight))
        self.SetScrollRate(20,20)
        
        self.keyboard_target_dcid = None
        self.current_sample_cell = None

        # create a PseudoDC to record our drawing
        self.pdc = wx.PseudoDC()
        self.pen_cache = {}
        self.brush_cache = {}
        self.DoDrawing(self.pdc)
#        log.write('Created PseudoDC draw list with %d operations!'%self.pdc.GetLen())
        self.log = log
        self.log.write('Created PseudoDC draw list with %d operations!'%self.pdc.GetLen())

        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_ERASE_BACKGROUND, lambda x:None)
        self.Bind(wx.EVT_MOUSE_EVENTS, self.OnMouse)
        self.Bind(wx.EVT_CHAR, self.OnChar)  # edit orm object text
        self.Bind(wx.EVT_SET_FOCUS, self.OnSetFocus)

        # vars for handling mouse clicks
        self.dragid = -1
        self.lastpos = (0,0)

        self.pointer_cursor = wx.StockCursor(wx.CURSOR_ARROW) # wx.Cursor(Menu.IconPath("icons/pointer.bmp"), wx.BITMAP_TYPE_BMP, 5, 0) 
        self.pencil_cursor = wx.Cursor(Menu.IconPath("icons/Pencil.bmp"), wx.BITMAP_TYPE_BMP, 4, 15)

# -- code for popup menus -- This isn't working
        self.Bind(wx.EVT_CONTEXT_MENU, self.OnContextMenuCanvas)
        self.Bind(wx.EVT_CONTEXT_MENU, self.OnContextMenuShape)

# -- code for popup menu on canvas
    def OnContextMenuCanvas(self, event):
        self.popupx, self.popupy = self.ConvertEventCoords(event)

        if not hasattr(self, "popupID1"):
            # bind numbered menu functions (obsolete)
            for i in range(1, 10):
                id = wx.NewId()
                setattr(self, "popupID%d" % i, id)
                try:
                    wx.EVT_MENU(self, id, getattr(self, "OnPopup%d" % i))
                except AttributeError:
                    pass

            # bind named menu functions
            id_names = [
                'CreateRingConstraint',
                ]
            for name in id_names:
                id = wx.NewId()
                setattr(ID, name, id)
                wx.EVT_MENU(self, id, getattr(self, "On" + name))

        # make a menu
        menu = wx.Menu()
        # Show how to put an icon in the menu
##        item = wx.MenuItem(menu, self.popupID1,"Note")
###        bmp = images.getSmilesBitmap()
##        bmp = Menu.Bitmap("icons/New Project.bmp", wx.BITMAP_TYPE_ANY)
##        item.SetBitmap(bmp)
##        menu.AppendItem(item)
        # add some other items
        menu.Append(self.popupID1, "Object Type")
        menu.Append(self.popupID2, "Fact Type")
        menu.Append(self.popupID3, "Note")
        menu.Append(self.popupID4, "Role Constraint")
        menu.Append(ID.CreateRingConstraint, "Ring Constraint")
        menu.Append(self.popupID5, "Subtype Constraint")
        menu.Append(self.popupID6, "Select All")
#        menu.Append(self.popupID5, "Undo - not implemented")
#        menu.Append(self.popupID6, "Redo - not implemented")
        # make a submenu
#        sm = wx.Menu()
#        sm.Append(self.popupID8, "sub item 1")
#        sm.Append(self.popupID9, "sub item 1")
#        menu.AppendMenu(self.popupID7, "Test Submenu", sm)


        # Popup the menu.  If an item is selected then its handler
        # will be called before PopupMenu returns.
        self.PopupMenu(menu)
        menu.Destroy()

    def OnPopup1(self, event):
        new_shape = self.AddNode('ORMObjectTypeShape', self.popupx, self.popupy)
        self.ClearSelection()
        self.SelectObject(new_shape.dcid)
        Data.SetUndo('Add Object Type')
        # id = self.shapeid_to_dcid_xref[new_shape.ID]
        self.RedisplayID(new_shape.dcid)

    def OnPopup2(self, event):
        new_fact = self.AddNode('ORMFactTypeShape', self.popupx, self.popupy)
        new_reading = self.AddFollower('ORMFactReadingShape', new_fact)
        self.ClearSelection()
        self.SelectObject(new_fact.dcid)
        Data.SetUndo('Add Fact')
        # id = self.shapeid_to_dcid_xref[new_shape.ID]
        self.RedisplayID(new_fact.dcid)
        self.RedisplayID(new_reading.dcid)

    def OnPopup3(self, event):
        new_shape = self.AddNode('ORMNoteShape', self.popupx, self.popupy)
        self.ClearSelection()
        self.SelectObject(new_shape.dcid)
        Data.SetUndo('Add Note')
        # id = self.shapeid_to_dcid_xref[new_shape.ID]
        self.RedisplayID(new_shape.dcid)

    def OnPopup4(self, event):
        new_shape = self.AddNode('ORMConstraintShape', self.popupx, self.popupy)
        Data.SetUndo('Add Constraint')
        if len(self.rolelist) >= 2:
            self.AddRoleSequence(new_shape)
        self.ClearSelection()
        self.SelectObject(new_shape.dcid)
#        id = self.shapeid_to_dcid_xref[new_shape.ID]
        self.RedisplayID(new_shape.dcid)

    def OnCreateRingConstraint(self, event):
        new_shape = self.AddNode('ORMConstraintShape', self.popupx, self.popupy)
        new_shape.Target.Operator = 'Irreflexive'
        Data.SetUndo('Add Ring Constraint')
        if len(self.rolelist) >= 2:
            self.AddRoleSequence(new_shape)
        self.ClearSelection()
        self.SelectObject(new_shape.dcid)
        self.RedisplayID(new_shape.dcid)

    def OnPopup5(self, event):
        new_shape = self.AddNode('ORMSubtypeConstraintShape', self.popupx, self.popupy)
        self.ClearSelection()
        self.SelectObject(new_shape.dcid)
        Data.SetUndo('Add Subtype Constraint')
#        id = self.shapeid_to_dcid_xref[new_shape.ID]
        self.RedisplayID(new_shape.dcid)

    def OnPopup6(self, event):
        self.SelectAll()

    def OnPopup7(self, event):
        self.log.WriteText("Popup seven\n")

    def OnPopup8(self, event):
        self.log.WriteText("Popup eight\n")

    def OnPopup9(self, event):
        self.log.WriteText("Popup nine\n")
# -- end code for popup menu on canvas??? --

# -- code for popup menu on shape
    def RoleMenu(self, role, menu):
        if role.ORMFactType.Nary <= 2 or role.Unique == 'a':
            menu.AppendCheckItem(self.popsID15, "Set Role as Unique")
            menu.Check(self.popsID15, (role.Unique == 'a'))
        if role.ORMFactType.Nary > 2:
            menu.AppendCheckItem(self.popsID16, "Set Other Roles as Unique")
            menu.Check(self.popsID16, (role.UniqueOther == 'ax'))
        menu.AppendCheckItem(self.popsID12, "Set Role as Mandatory")
        menu.Check(self.popsID12, (role.Mandatory == 'a'))
        menu.AppendSeparator()
        menu.AppendCheckItem(self.popsID17, "Set Role as Unique (Deontic)")
        menu.Check(self.popsID17, (role.Unique == 'd'))
        if role.ORMFactType.Nary > 2:
            menu.AppendCheckItem(self.popsID18, "Set Other Roles as Unique (Deontic)")
            menu.Check(self.popsID18, (role.UniqueOther == 'dx'))
        menu.AppendCheckItem(self.popsID13, "Set Role as Mandatory (Deontic)")
        menu.Check(self.popsID13, (role.Mandatory == 'd'))
        menu.AppendSeparator()
        menu.AppendCheckItem(self.popsID19, "Show Role Name")
        menu.Check(self.popsID19, bool(self.FindRoleNameShape(role)))

    def RoleConstraintMenu(self, constraint, menu):
        menu.AppendCheckItem(self.popsID21, "Set as Unique")
        menu.Check(self.popsID21, (constraint.Operator == 'Unique'))
        menu.AppendCheckItem(self.popsID22, "Set as Preferred")
        menu.Check(self.popsID22, (constraint.Operator == 'Preferred'))
        menu.AppendCheckItem(self.popsID23, "Set as InclusiveOr")
        menu.Check(self.popsID23, (constraint.Operator == 'InclusiveOr'))
        menu.AppendCheckItem(self.popsID24, "Set as Subset")
        menu.Check(self.popsID24, (constraint.Operator == 'Subset'))
        menu.AppendCheckItem(self.popsID25, "Set as Equality")
        menu.Check(self.popsID25, (constraint.Operator == 'Equality'))
        menu.AppendCheckItem(self.popsID26, "Set as Exclusion")
        menu.Check(self.popsID26, (constraint.Operator == 'Exclusion'))
        menu.AppendCheckItem(self.popsID27, "Set as ExclusiveOr")
        menu.Check(self.popsID27, (constraint.Operator == 'ExclusiveOr'))
        # menu.AppendCheckItem(self.popsID28, "Set as Value (not implemented)")
        # menu.Check(self.popsID28, (constraint.Operator == 'Value'))

    def RingConstraintMenu(self, constraint, menu):
        for i, s in enumerate(RingConstraints):
             menu.AppendCheckItem(ID.FIRST_RING_CONSTRAINT + i, 'Set as %s' % s)
             menu.Check(ID.FIRST_RING_CONSTRAINT + i, (constraint.Operator == s))

    def ConstraintMenu(self, constraint, menu):
        if self.rolelist:
            menu.Append(self.popsID20, "Add Role Sequence")
            menu.AppendSeparator()

        if constraint.Operator in RingConstraints:
            self.RingConstraintMenu(constraint, menu)
        else:
            self.RoleConstraintMenu(constraint, menu)

        menu.AppendSeparator()
        menu.AppendCheckItem(ID.SetAsDeontic, "Set as Deontic")
        menu.Check(ID.SetAsDeontic, bool(constraint.Deontic))
        count = len(constraint.GetList('ORMRoleSequence'))
        if count > 0:
            menu.AppendSeparator()
            for x in range(1, count + 1):
                menu.Append(ID.FIRST_DELETE_SEQUENCE + x,
                            "Delete Role List %d" % x)

    def SubtypeConstraintMenu(self, constraint, menu):
        menu.AppendRadioItem(self.popsID51, "Set as Exclusive")
        menu.Check(self.popsID51, (constraint.Operator == 'Exclusive'))
        menu.AppendRadioItem(self.popsID52, "Set as Total")
        menu.Check(self.popsID52, (constraint.Operator == 'Total'))
        menu.AppendRadioItem(self.popsID53, "Set as Partition")
        menu.Check(self.popsID53, (constraint.Operator == 'Partition'))
        menu.AppendSeparator()
        menu.AppendCheckItem(ID.SetAsDeontic, "Set as Deontic")
        menu.Check(ID.SetAsDeontic, bool(constraint.Deontic))

    def OnContextMenuShape(self, event):
        self.popupx, self.popupy = self.ConvertEventCoords(event)

        if not hasattr(self, "popsID01"):
            # bind numbered menu functions (obsolete)
            for i in range(1, 54):
                id = wx.NewId()
                setattr(self, "popsID%02d" % i, id)
                try:
                    wx.EVT_MENU(self, id, getattr(self, "OnPops%02d" % i))
                except AttributeError:
                    pass

            # bind named menu functions
            id_names = [
                'SetAsDeontic',
                ]
            for name in id_names:
                id = wx.NewId()
                setattr(ID, name, id)
                wx.EVT_MENU(self, id, getattr(self, "On" + name))

            wx.EVT_MENU_RANGE(self, ID.FIRST_DELETE_SEQUENCE, ID.LAST_DELETE_SEQUENCE, self.OnDeleteRoleSequence)
            wx.EVT_MENU_RANGE(self, ID.FIRST_RING_CONSTRAINT, ID.LAST_RING_CONSTRAINT, self.OnRingConstraint)

        # make a menu
        menu = wx.Menu()
        # Show how to put an icon in the menu
#        item = wx.MenuItem(menu, self.popupID1,"Note")
#        bmp = images.getSmilesBitmap()
#        bmp = Menu.Bitmap("icons/New Project.bmp", wx.BITMAP_TYPE_ANY)
#        item.SetBitmap(bmp)
#        menu.AppendItem(item)
        # add some other items
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])

            if shape.Subtype == 'ORMObjectTypeShape':
                menu.Append(self.popsID06, "Dependent Layout Right")
                # make a submenu
                sm = wx.Menu()
                sm.Append(self.popsID08, "Dependent Layout Left")
        #        sm.Append(self.popsID9, "sub item 1")
                menu.AppendMenu(self.popsID07, "Dependent Layout", sm)
                menu.AppendSeparator()
                target = shape.Get('Target')
                if target.Type == 'Entity':
                    change = 'Value'
                else:
                    change = 'Entity'
                menu.Append(self.popsID01, "Change to %s Type" % change)

            elif shape.Subtype == 'ORMFactTypeShape':
                target = shape.Get('Target')
                menu.AppendCheckItem(self.popsID02, "Set as Spanning Unique")
                menu.Check(self.popsID02, bool(target.Unique))
                role = shape.GetRole(self.popupx, self.popupy)
                if role:
                    menu.AppendSeparator()
                    self.RoleMenu(role, menu)
                if 'ORMSampleRow' in Data.Database:  # not in v0.10 install script
                    menu.AppendSeparator()
                    menu.AppendCheckItem(self.popsID04, "Show Sample Data")
                    menu.Check(self.popsID04, bool(self.FindSampleTableShape(target)))
                menu.AppendSeparator()
                if target.Nary == 2:
                    menu.Append(self.popsID03, "Reverse Role Order")
                menu.AppendCheckItem(self.popsID05, "Objectify Fact Type")
                menu.Check(self.popsID05, bool(target.GetList('ORMObjectType')))

            elif shape.Subtype == 'ORMRoleConnectorShape':
                target = shape.Get('Target')
                self.RoleMenu(target, menu)

            elif shape.Subtype == 'ORMConstraintShape':
                target = shape.Get('Target')
                self.ConstraintMenu(target, menu)

            elif shape.Subtype == 'ORMSubtypeConstraintShape':
                target = shape.Get('Target')
                self.SubtypeConstraintMenu(target, menu)

#        menu.Append(self.popsID3, "Constraint")
#        menu.Append(self.popsID4, "Four")
#        menu.Append(self.popsID5, "Undo - not implemented")

        # Popup the menu.  If an item is selected then its handler
        # will be called before PopupMenu returns.
            if menu.GetMenuItemCount():  # prevent right-click move bug
                self.PopupMenu(menu)
        menu.Destroy()

    def OnPops01(self, event):
        '''Toggle Object Type between Entity and Value'''
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            target = shape.Get('Target')
            if target.Type == 'Entity':
                target.Type = 'Value'
            else:
                target.Type = 'Entity'
            Data.SetUndo('Set %s Type' % target.Type)
            self.RedrawID(shape.dcid)

    def OnPops02(self, event):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            target = shape.Get('Target')
            if target.Unique:
                target.Unique = None
                text = "Set Not Unique"
            else:
                target.Unique = 'a'
                text = "Set Unique"
                for role in target.GetList('ORMRole'):
                    if role.Unique in ('a', 'p'):  # these were more restrictive
                        role.Unique = None
            Data.SetUndo(text)
            self.RedrawID(shape.dcid)

    def OnPops03(self, event):
        '''Reverse role order in current reading'''
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])  # fact type shape
            # reverse readings
            target = shape.Get('Target')
            if target.Nary != 2: return
            reading = target.Get('ORMFactReading')
            if not reading.Reading:
                pass
            elif '/' in reading.Reading:
                a, x, b = reading.Reading.partition('/')
                if '/' in b:
                    return
                elif a:
                    reading.Reading = b + '/' + a
                else:
                    reading.Reading = b
            else:
                reading.Reading = '/' + reading.Reading

            # reverse the order of role connectors
            roles = reading.ORMRoleSequence.GetList('ORMRolePosition')
##            roles.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
##            roles = target.GetList('ORMRole')
            sorted_roles = sorted(roles, cmp=lambda x,y: cmp(x.Seq, y.Seq), reverse=True)
            for i, x in enumerate(sorted_roles):
                x.Seq = i+1
            self.RedrawID(shape.dcid)
            for x in shape.GetFollowers():
                self.RedrawID(x.dcid)
            Data.SetUndo('Reverse role order')

    def ObjectifyFact(self, event):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            fact_shape = self.dcid_to_shape_xref.get(l[0])
            fact_mo = fact_shape.Target
            if fact_mo.GetList('ORMObjectType'):
                if debug: print "trying to objectify an objectified fact type"
                return  # already objectified
#            object_shape = self.AddNode('ORMObjectTypeShape', self.popupx, self.popupy)
            object_shape = self.AddFollower('ORMObjectTypeShape', fact_shape)
            x, y = fact_shape.GetCenter()  # posx and posy should be the center, but aren't
            object_shape.SetTempPos(x, y)
            object_shape.CommitPos()
##            object_mo = object_shape.Target
##            object_shape.NodeAID = fact_shape.ID
##            object_mo.FactTypeID = fact_mo.ID
            fact_shape.OnTop()  # move object type behind fact type
            Data.SetUndo('Objectify Fact Type')
            self.RedrawID(fact_shape.dcid)
            self.RedrawID(object_shape.dcid)

    def UnObjectifyFact(self, event):
        pass

    def OnPops04(self, event):
        if event.IsChecked():
            self.SampleTableShowHide(event, 'show', 'Show Sample Data') 
        else:
            self.SampleTableShowHide(event, 'hide', 'Hide Sample Data') 

    def OnPops05(self, event):  # objectify fact type
        if event.IsChecked():
            self.ObjectifyFact(event) 
        else:
            self.UnObjectifyFact(event)

    def OnPops06(self, event):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            self.MoveDependents(l[0], 'Name', 'Right')
        Data.SetUndo('Dependent Layout Right')

    def OnPops07(self, event):
        self.log.WriteText("Popup seven\n")

    def OnPops08(self, event):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            self.MoveDependents(l[0], 'Name', 'Left')
        Data.SetUndo('Dependent Layout Left')

    def OnPops09(self, event):
        self.log.WriteText("Popup nine\n")

    def RoleMandatory(self, event, new_mandatory_value, undo_msg):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            if shape.Subtype == 'ORMFactTypeShape':
                target = shape.GetRole(self.popupx, self.popupy)
            else:  # role connector
                target = shape.Get('Target')
            target.Mandatory = new_mandatory_value
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)
            if shape.Subtype == 'ORMFactTypeShape':
                for x in shape.GetFollowers():
                    self.RedrawID(x.dcid)

    def OnPops11(self, event):
        self.RoleMandatory(event, None, 'Set Not Mandatory') 

    def OnPops12(self, event):
        if  event.IsChecked():
            self.RoleMandatory(event, 'a', 'Set Mandatory') 
        else:
            self.OnPops11(event)

    def OnPops13(self, event):
        if event.IsChecked():
            self.RoleMandatory(event, 'd', 'Set Mandatory (Deontic)') 
        else:
            self.OnPops11(event)

    def RoleUnique(self, event, new_unique_value, undo_msg):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            if shape.Subtype == 'ORMFactTypeShape':
                role = shape.GetRole(self.popupx, self.popupy)
            else:  # role connector
                role = shape.Get('Target')
            role.Unique = new_unique_value
            if new_unique_value in ('a', 'p'):
                role.ORMFactType.Unique = None
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)
            if shape.Subtype == 'ORMFactTypeShape':
                for x in shape.GetFollowers():
                    self.RedrawID(x.dcid)
            else:  # role
                self.RedrawID(shape.Get('NodeA').dcid)

    def RoleUniqueOther(self, event, new_unique_value, undo_msg):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            if shape.Subtype == 'ORMFactTypeShape':
                role = shape.GetRole(self.popupx, self.popupy)
            else:  # role connector
                role = shape.Get('Target')
            role.UniqueOther = new_unique_value
            if new_unique_value in ('a', 'p'):
                role.ORMFactType.Unique = None
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)
            if shape.Subtype == 'ORMFactTypeShape':
                for x in shape.GetFollowers():
                    self.RedrawID(x.dcid)
            else:  # role
                self.RedrawID(shape.Get('NodeA').dcid)

    def FindRoleNameShape(self, role):
        return [ x for x in self.Report.GetGraphicList('ORMRoleNameShape')
                 if x.Target is role ]

    def FindSampleTableShape(self, fact):
        return [ x for x in self.Report.GetGraphicList('ORMSampleTableShape')
                 if x.Target is fact ]

    def FindRoleConnectorShape(self, role):
        return [ x for x in self.Report.GetGraphicList('ORMRoleConnectorShape')
                 if x.Target is role ] 

    def RoleNameShowHide(self, event, show, undo_msg):
        # show is not currently used; this will toggle the current state
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            # find role
            if shape.Subtype == 'ORMFactTypeShape':
                role = shape.GetRole(self.popupx, self.popupy)
            else:  # role connector
                role = shape.Get('Target')
             # find shape pointing to the role
            name_shapes = self.FindRoleNameShape(role)  # should be 0 or 1 object
            if name_shapes:
                name_shapes[0].Delete()
            else:
                connector_shapes = self.FindRoleConnectorShape(role)  # should be 0 or 1 object
                if connector_shapes:  # should always be true
                    new_rolelabel = self.AddFollower('ORMRoleNameShape', connector_shapes[0])
                    self.SelectObject(new_rolelabel.dcid)
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)
##            if shape.Subtype == 'ORMFactTypeShape':
##                for x in shape.GetFollowers():
##                    self.RedrawID(x.dcid)
##            else:  # role
##                self.RedrawID(shape.Get('NodeA').dcid)

    def SampleTableShowHide(self, event, show, undo_msg):
        # show is not currently used; this will toggle the current state
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            # find following shape
            table_shapes = self.FindSampleTableShape(shape.Target)  # should be 0 or 1 object
            if table_shapes:
                table_shapes[0].Delete()  # should delete multiples, if found (server issue)?
            else:
                new_table_shape = self.AddFollower('ORMSampleTableShape', shape)
                self.SelectObject(new_table_shape.dcid)
                x, y = new_table_shape.GetPos()  # where to show?
                # make sure at least on sample row exists
                rows = shape.Target.GetList('ORMSampleRow')
                if not rows:
                    AddSampleRow(shape.Target)
                    y += 15   # leave room for normal reading position
                else:
                    y += 10 * len(rows) + 5  # good enought? maybe I should hide, not delete?
                new_table_shape.SetTempPos(x, y)
                new_table_shape.CommitPos()

                self.RedrawID(new_table_shape.dcid)
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)

    def OnPops14(self, event):
        self.RoleUnique(event, None, 'Set Not Unique') 

    def OnPops15(self, event):
        if event.IsChecked():
            self.RoleUnique(event, 'a', 'Set Unique') 
        else:
            self.OnPops14(event)

    def OnPops16(self, event):
        if event.IsChecked():
            self.RoleUniqueOther(event, 'ax', 'Set Other Roles as Unique') 
        else:
            self.RoleUniqueOther(event, None, 'Set Other Roles as Not Unique') 

    def OnPops17(self, event):
        if event.IsChecked():
            self.RoleUnique(event, 'd', 'Set Unique (Deontic)') 
        else:
            self.OnPops14(event)

    def OnPops18(self, event):
        if event.IsChecked():
            self.RoleUniqueOther(event, 'dx', 'Set Other Roles as Unique (Deontic)') 
        else:
            self.RoleUniqueOther(event, None, 'Set Other Roles as Not Unique') 

    def OnPops19(self, event):
        if event.IsChecked():
            self.RoleNameShowHide(event, 'show', 'Show Role Name') 
        else:
            self.RoleNameShowHide(event, 'hide', 'Hide Role Name') 

    def AddRoleSequence(self, shape):
        target = shape.Get('Target')
        # create new constraint list
        priorlists = target.GetList('ORMRoleSequence')
        clist = shape.db.GetObject('ORMRoleSequence')  # new constraint object
        clist.ORMConstraintID = target.ID
        clist.Seq = len(priorlists)+1  # next number
        projectid = self.Report.ProjectID
        clist.ProjectID = projectid
        today = Data.TodayString()
        clist.DateAdded = today
        fact_type_ids = {}
        for i, role in enumerate(self.rolelist):
            crole = shape.db.GetObject('ORMRolePosition')
            crole.ORMRoleSequenceID = clist.ID
            crole.ORMRoleID = role.ID
            crole.Seq = i + 1
            crole.ProjectID = projectid
            crole.DateAdded = today
            fact_type_ids[role.ORMFactTypeID] = None

        print 'fact type ids', fact_type_ids
        self.rolelist = []
        facts = [ x for x in self.Report.GetList('GraphicObject') if x.Subtype == 'ORMFactTypeShape' ]
        for factshape in facts:
            if factshape.Target.ID in fact_type_ids:
                new_shape = self.AddConnector('ORMConstraintConnectorShape', factshape, shape)
                new_shape.Target = clist
                self.RedrawID(factshape.dcid)
                self.RedrawID(new_shape.dcid)
        Data.SetUndo("Add Role Sequence to Constraint")

    def OnPops20(self, event):
        if not self.rolelist: return  # ignore command if no roles have been selected
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            self.AddRoleSequence(shape)

    def SetRoleConstraint(self, event, new_value, undo_msg):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            target = shape.Get('Target')
            target.Operator = new_value
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)

    def OnPops21(self, event):
        s = 'Unique'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops22(self, event):
        s = 'Preferred'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops23(self, event):
        s = 'InclusiveOr'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops24(self, event):
        s = 'Subset'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops25(self, event):
        s = 'Equality'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops26(self, event):
        s = 'Exclusion'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops27(self, event):
        s = 'ExclusiveOr'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops28(self, event):
        s = 'Value'
        self.SetRoleConstraint(event, s, 'Undo ' + s)
    def OnPops29(self, event):
        s = 'Ring'
        self.SetRoleConstraint(event, s, 'Undo ' + s)

    def OnRingConstraint(self, event):
        s = RingConstraints[event.GetId() - ID.FIRST_RING_CONSTRAINT]
        self.SetRoleConstraint(event, s, 'Undo ' + s)

    def DeleteRoleSequence(self, event, delete_seq):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])

            # get all the connectors that target the specified role sequence
            connectors = [x for x in shape.GetGraphicList('ORMConstraintConnectorShape', 'NodeB')
                          if x.Target and x.Target.Seq == delete_seq]
            if connectors:  # any of them will do
                if debug: print 'connector found', connectors
                role_seq = connectors[0].Target  # ORMRoleSequence
                if debug: print 'role_seq', role_seq
                if debug: print 'role_pos', role_seq.GetList('ORMRolePosition')
                for role_pos in role_seq.GetList('ORMRolePosition'):
                    role_pos.Delete()
                role_seq.Delete()  # delete role sequence 1
            for c_shape in connectors:
                c_shape.Delete()

            # renumber remaining sequences
            role_seqs = shape.Target.GetList('ORMRoleSequence')
            sorted_seqs = sorted(role_seqs, cmp=lambda x,y: cmp(x.Seq, y.Seq))
            for i, x in enumerate(sorted_seqs):
                x.Seq = i+1

            Data.SetUndo('Delete Role Sequence %s' % delete_seq)
##            self.RedrawID(shape.dcid)

    def OnPops41(self, event):  # delete role sequence 1
        if debug: print 'starting delete 1'
        self.DeleteRoleSequence(event, 1)
    def OnPops42(self, event):
        self.DeleteRoleSequence(event, 2)
    def OnPops43(self, event):
        self.DeleteRoleSequence(event, 3)
    def OnPops44(self, event):
        self.DeleteRoleSequence(event, 4)
    def OnDeleteRoleSequence(self, event):
        self.DeleteRoleSequence(event, event.GetId() - ID.FIRST_DELETE_SEQUENCE)

    def SubtypeConstraintOperator(self, event, new_value, undo_msg):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            target = shape.Get('Target')
            target.Operator = new_value
            Data.SetUndo(undo_msg)
            self.RedrawID(shape.dcid)

    def OnPops51(self, event):
        self.SubtypeConstraintOperator(event, 'Exclusive', 'Set Exclusive') 

    def OnPops52(self, event):
        self.SubtypeConstraintOperator(event, 'Total', 'Set Total') 

    def OnPops53(self, event):
        self.SubtypeConstraintOperator(event, 'Partition', 'Set Partition') 

    def OnSetAsDeontic(self, event):
        l = self.pdc.FindObjects(self.popupx, self.popupy, hitradius)
        if l:
            shape = self.dcid_to_shape_xref.get(l[0])
            target = shape.Get('Target')
            if event.IsChecked():
                target.Deontic = True
                Data.SetUndo("Set as Deontic")
            else:
                target.Deontic = False
                Data.SetUndo("Set as Alethic")
            self.RedrawID(shape.dcid)
            for follow in shape.GetFollowers():  # when typing into fact
                self.RedrawID(follow.dcid)

# -- end code for popup menu on shape --

    def ConvertEventCoords(self, event):
        xView, yView = self.GetViewStart()
        xDelta, yDelta = self.GetScrollPixelsPerUnit()
        return (event.GetX() + (xView * xDelta),
            event.GetY() + (yView * yDelta))

    def OffsetRect(self, r):
        xView, yView = self.GetViewStart()
        xDelta, yDelta = self.GetScrollPixelsPerUnit()
        r.OffsetXY(-(xView*xDelta),-(yView*yDelta))

#    Data.SetUndo('Add Entity')
    def AddNode(self, node_type, x, y):  # create model and graphic objects
        shape = AddNodeToDiagram(self.Report, node_type, x, y)
        dc = self.pdc
        dc.BeginDrawing()
        self.CreateNode(dc, shape)  # maybe pass panel instead of dc??
        dc.EndDrawing()
        return shape

    def AddConnector(self, node_type, source, target):  # create model and graphic objects
        shape = AddConnectorToDiagram(self.Report, node_type, source, target)
        dc = self.pdc
        dc.BeginDrawing()
        self.CreateNode(dc, shape)
        source.Draw(dc)
        target.Draw(dc)
        dc.EndDrawing()
        return shape

    def AddFollower(self, node_type, source):  # create model and graphic objects
        shape = AddFollowerToDiagram(self.Report, node_type, source)
        x, y = source.GetPos()  # use temporary position (more likely to be there)
        shape.PosX = x + 10
        shape.PosY = y + 20

        dc = self.pdc
        dc.BeginDrawing()
        self.CreateNode(dc, shape)  # sets follower behavior
        source.Draw(dc)
        dc.EndDrawing()
        return shape

    def SetGraphic(self, dc, shape, newid=False):
        if self != shape.canvas or not shape.dcid or newid:
            # remove old dcid before adding a new one
            if shape.dcid and self==shape.canvas:
                if shape.dcid in self.objids:
                    self.objids.remove(shape.dcid)
            id = wx.NewId()
            # need to remember which dc id belongs to which shape
            # can't store in object, must be in the graphics window -- WRONG!
    #        self.shapeid_to_dcid_xref[shape.ID] = id  # convert to 'shape.dcid' instead
            shape._SetInShell('dcid', id)
            shape._SetInShell('canvas', self)
            self.dcid_to_shape_xref[id] = shape
            shape.Draw(dc)
            self.objids.append(id)

    def CreateNode(self, dc, shape):  # create graphics node for existing model object
        '''
        The DC is a pseudo dc that will later be useed to draw the shape on the canvas
        A shape is a "GraphicObject" object that represents a shape on the diagram
        '''
        if debug: print '--> creating node for ', shape

        orm_object = shape.Get('Target')
        if debug: print 'node points to object', orm_object
        x = shape.PosX  # treat this as the center of the shape
        y = shape.PosY
        if debug: print 'posx posy = ', x, y

##        if debug: print shape, x, y
##        if x is None or y is None:  # this is a poor choice of edit -- RETHINK!
##            print "invalid x or y for this object, skipping it"
##            print Data.Database[shape.Table][shape.ID]
##            return

        shape.SetTempPos(x,y)  # used to avoid lots of updates while moving
        shape.Follow()
        self.SetGraphic(dc, shape)

    def RedisplayID(self, id):  # object has moved but not changed
        r = self.pdc.GetIdBounds(id)
        r.Inflate(4,4)
        self.OffsetRect(r)
        self.RefreshRect(r, False)

    def RedrawID(self, id):  # object has changed
        r = self.pdc.GetIdBounds(id)
        shape = self.dcid_to_shape_xref.get(id)
        shape.Draw(self.pdc)
        r2 = self.pdc.GetIdBounds(id)
        r = r.Union(r2)
        r.Inflate(4,4)
        self.OffsetRect(r)  # is this needed? what does it do?
        self.RefreshRect(r, False)

    def RedrawAll(self):  # this should be called after undo and redo -- IMPORTANT
        dcids = {}
        for dcid in self.objids:  # to delete objects if add is undone
            dcids[dcid] = None
            
        for shape in self.Report.GetList('GraphicObject', getDeleted=True):
            if debug: print '-- shape', shape
            if shape.Valid():
                if shape.dcid in dcids: del dcids[shape.dcid]
                if debug: print '--- keep', shape
##                dcid = shape.dcid
                shape.Follow()  # some will be there already, some won't
                x, y = shape.PosX, shape.PosY    # undo of moves (temp pos doesn't undo)
                if x != None and y != None:
                    shape.SetTempPos(x, y)

                if shape.canvas != self or shape.dcid == None:  # undo of deletes, the need to be recreated
                    self.CreateNode(self.pdc, shape)
                shape.OnBottom()  # put objectification behind facttype

                self.RedrawID(shape.dcid)
                shape.OnBottom()  # put objectification behind facttype
            else:
                if debug: print "---- don't keep", shape
                if shape.dcid:  # deleted object graphic is still displayed
                    if shape.dcid in dcids: del dcids[shape.dcid]
                    self.DeleteDCID(shape.dcid)
                    shape._SetInShell('dcid', None)  # get new if redrawn to keep number seq == level seq

        for dcid in dcids:  # to delete objects if add is undone
            if debug: print "deleting dcid that isn't in an object", dcid
            if dcid in self.dcid_to_shape_xref:
                shape = self.dcid_to_shape_xref[dcid]
                shape._SetInShell('dcid', None)
            self.DeleteDCID(dcid)

    def DeleteDCID(self, dcid):  # used by RedrawAll() and shape.Delete()
        if dcid:
            if debug: print 'removing dcid', dcid
            if dcid == self.keyboard_target_dcid:
                self.keyboard_target_dcid = None
            self.DropFromSelection(dcid)
            self.pdc.RemoveId(dcid)
            if dcid in self.objids:
                self.objids.remove(dcid)

    def _ConnectEm(self, source, target):
        if source.ID == target.ID:
            return False
        elif (source.TableName == 'ORMNote'
            and target.TableName in ('ORMObjectType', 'ORMFactType', 'ORMConstraint',
                                     'ORMSubtypeConstraint')):
            new_shape = self.AddConnector('ORMNoteConnectorShape', source, target)
        elif source.TableName == 'ORMFactType' and target.TableName == 'ORMObjectType':
            new_shape = self.AddConnector('ORMRoleConnectorShape', source, target)
##            new_rolelabel = self.AddFollower('ORMRoleNameShape', new_shape)
        elif source.TableName == 'ORMSubtypeConstraint' and target.TableName == 'ORMSubtypeConnector':
            new_shape = self.AddConnector('ORMSubtypeConstraintConnectorShape', source, target)
        elif source.TableName == 'ORMObjectType' and target.TableName == 'ORMObjectType':
            new_shape = self.AddConnector('ORMSubtypeConnectorShape', source, target)
        else:
            return False
        self.RedisplayID(new_shape.dcid)
        return new_shape.__class__

    def ConnectEm(self, source, target):
        if debug: print 'connecting', source.TableName, target.TableName
        return (self._ConnectEm(source, target) or
                self._ConnectEm(target, source))

# ---- selection ----
    def DrawSelectionRectangle(self, flag):
        pass
##        selection_rectangle_origin_x    # selection tracking
##        self.pdc.Draw
        
    def AddToSelection(self, id):
        old_key_target = self.keyboard_target_dcid
        self.keyboard_target_dcid = id  # for char input
        if old_key_target and self.dcid_to_shape_xref.get(old_key_target):
            self.dcid_to_shape_xref.get(old_key_target).ClearFocus()  # old keyboard target
            self.RedrawID(old_key_target)
        shape = self.dcid_to_shape_xref.get(id)
        if not shape:
            print "invalid dcid %s, can't add to selection" % id
            return
        self.selection[id] = shape  # tell canvas
        shape.SetSelected()  # tell object
        shape.SetFocus()  # new keyboard target
        self.RedrawID(id)
        self.AddedToSelection(self, id)
        MyCanvas.AddedToSelection(self, id)
        
    def DropFromSelection(self, id):
        if id in self.selection:
            del(self.selection[id])
            if id == self.keyboard_target_dcid:
                self.ClearKeyboardTarget()  # before redraw
                self.ClearNavMode()
            shape = self.dcid_to_shape_xref.get(id)
            shape.ClearSelected()
            if shape.Valid():  # if shape dropped from selection by being deleted
                shape.Draw(self.pdc)
                self.RedisplayID(id)
            self.DroppedFromSelection(self, id)
            MyCanvas.DroppedFromSelection(self, id)

    def SelectAll(self):
##        report_object = self.Report
##        db = report_object.db
##        shapes = [ db.GetObject('GraphicObject', x) for x in Data.SearchByColumn(db.Database['GraphicObject'], {'ReportID': self.ReportID}) ]
##        for shape in shapes:
        for shape in self.Report.GetList('GraphicObject'):
            self.AddToSelection(shape.dcid)

    def ClearSelection(self):    # keys = id, values = objects??
        self.rolelist = []
        self.ClearKeyboardTarget()  # redundant, also done in DropFromSelection
        for id in self.GetSelection():
            self.DropFromSelection(id)
        self.ClearNavMode()

    def ClearKeyboardTarget(self):  # do this before redraw
        if (self.keyboard_target_dcid
            and self.dcid_to_shape_xref.get(self.keyboard_target_dcid)):
            self.dcid_to_shape_xref.get(self.keyboard_target_dcid).ClearFocus()
        self.keyboard_target_dcid = None
        self.current_sample_cell = None        

    def ClearNavMode(self):
        if self.keyboard_nav_dcid:
            temp = self.keyboard_nav_dcid
            self.keyboard_nav_dcid = None
            self.RedrawID(temp)  # should clarify names of Redraw vs. Redisplay - source of bugs

    def GetSelection(self):
        return self.selection.keys()

    def InSelection(self, id):
        return id in self.selection

    def SelectObject(self, id):
        if not self.InSelection(id):
            self.ClearSelection()
        self.AddToSelection(id)  # role may not be selected even if fact is

    def ToggleObjectSelect(self, id):
        if self.InSelection(id):
            shape = self.dcid_to_shape_xref.get(id)
            if shape.Subtype == 'ORMFactTypeShape':
                if not shape.ToggleRole():
##                    shape.Draw(self.pdc)
##                    self.RedisplayID(id)
##                else:
                    self.DropFromSelection(id)  # last role turned off
                facts = [ x for x in self.Report.GetList('GraphicObject') if x.Subtype == 'ORMFactTypeShape' ]
                    # a bit blunt (redraws all the facts) but it works
                for f in facts:
                    f.Draw(self.pdc)
                    self.RedisplayID(f.dcid)
            else:
                self.DropFromSelection(id)
        else:
            self.AddToSelection(id)

    def AddDependentsToSelection(self, id):
        '''
If entity type:
  Add all children with no other parents
If fact type:
  Add all participating entities
  '''
        if debug: print 'AddDependentsToSelection'
        shape = self.dcid_to_shape_xref.get(id)
        if shape.Subtype == 'ORMRoleConnectorShape':  # relation
            self.AddToSelection(shape.dcid)
            self.AddToSelection(shape.Get('NodeA').dcid)
            self.AddToSelection(shape.Get('NodeB').dcid)
        elif shape.Subtype == 'ORMFactTypeShape':
            # fact -> roles -> objects (all of them?)
            if debug: print 'fact followers', shape.GetFollowers()
            for role in shape.GetFollowers('ORMRole'):
                leaf = role.Get('NodeB')
                self.AddToSelection(role.dcid)
                self.AddToSelection(leaf.dcid)
        elif shape.Subtype == 'ORMObjectTypeShape':
            # object type -> role -> fact -> out_role -> leaf_object
            for role in shape.GetFollowers('ORMRole'):
                fact = role.Get('NodeA')  # find the other end
                out_roles = fact.GetFollowers('ORMRole')
                if len(out_roles) == 1:  # nary = 1
                    if debug: print 'nary = 1'
                    self.AddToSelection(role.dcid)
                    self.AddToSelection(fact.dcid)
                elif len(out_roles) == 2:  # 
                    out_role = out_roles[0]  # find the other object type
                    if out_role.ID == role.ID:
                        out_role = out_roles[1]
                    leaf = out_role.Get('NodeB')
                    if len(leaf.GetFollowers('ORMRole')) == 1:  # should filter out notes -- TODO!
                        self.AddToSelection(role.dcid)
                        self.AddToSelection(fact.dcid)
                        self.AddToSelection(out_role.dcid)
                        self.AddToSelection(leaf.dcid)
##                    elif len(shape.GetFollowers('ORMRole')) == 1:
##                        self.AddToSelection(role.dcid)
##                        self.AddToSelection(fact.dcid)

        self.AddToSelection(id)  # last to make sure it is target of keyboard
                
    def MoveDependents(self, id, reformat='', direction=''):
        '''reformat = name of field to sort on'''
        if debug: print 'AddDependentsToSelection'
        shape = self.dcid_to_shape_xref.get(id)
        grid = []
        if shape.Subtype == 'ORMRelation':  # relation?? doeesn't exit
            pass
##            self.AddToSelection(shape.dcid)
##            self.AddToSelection(shape.Get('NodeA').dcid)
##            self.AddToSelection(shape.Get('NodeB').dcid)
        elif shape.Subtype == 'ORMFactTypeShape':  # fact type
            pass
##            # fact -> roles -> objects (all of them?)
##            for role in shape.GetFollowers('ORMRole'):
##                leaf = role.Get('NodeB')
##                self.AddToSelection(role.dcid)
##                self.AddToSelection(leaf.dcid)
        elif shape.Subtype == 'ORMObjectTypeShape':
            # object type -> role -> fact -> out_role -> leaf_object
            for role in shape.GetFollowers('ORMRole'):
                fact = role.Get('NodeA')  # find the other end
                out_roles = fact.GetFollowers('ORMRole')
                if len(out_roles) == 1:  # nary = 1
                    if debug: print 'nary = 1'
                    self.AddToSelection(role.dcid)
                    self.AddToSelection(fact.dcid)
                    grid.append([role, fact])
                elif len(out_roles) == 2:  # should filter out notes -- TODO!
                    out_role = out_roles[0]  # should be the fact
                    if out_role.ID == role.ID:
                        out_role = out_roles[1]
                    leaf = out_role.Get('NodeB')  # should be the fact
                    if len(leaf.GetFollowers('ORMRole')) == 1:  # should filter out notes -- TODO!
                        self.AddToSelection(role.dcid)
                        self.AddToSelection(fact.dcid)
                        self.AddToSelection(out_role.dcid)
                        self.AddToSelection(leaf.dcid)
                        grid.append([role, fact, out_role, leaf])
##                    elif len(shape.GetFollowers()) == 1:
##                        self.AddToSelection(role.dcid)
##                        self.AddToSelection(fact.dcid)
##                        grid.append([role, fact])

        self.AddToSelection(id)  # last to make sure it is target of keyboard

        if reformat in ('Name', 'ID') and grid and direction in ('Right', 'Left'):
            sorter = []
            if reformat == 'Name':
                for i, branch in enumerate(grid):
                    if len(branch) == 2:
                        sort_name = ('A', (branch[0].Get('Target').Name
                                           or branch[1].Get('Target').Name or ''))
                    else:  # == 4
                        sort_name = ('B', (branch[2].Get('Target').Name
                                           or branch[3].Get('Target').Name or ''))
                    sorter.append((sort_name, i))
            else:  # 'ID'
                for i, branch in enumerate(grid):
                    if len(branch) == 2:
                        sort_name = ('A', str(branch[1].ID))
                    else:  # == 4
                        sort_name = ('B', str(branch[3].ID))
                    sorter.append((sort_name, i))
            y = shape.PosY
            offsetY = 50
            offsetX = 80
            if direction == 'Right':
                direction = +1
            else:
                direction = -1
##            if len(grid) % 2:  # odd number
##                y -= (len(grid) - 1) / 2 * offsetY
##            else:
##                y -= (len(grid) / 2) * offsetY - offsetY / 2
            sorter.sort()
            for x, i in sorter:
                branch = grid[i]
                x = shape.PosX

                node = branch[1]
                x += offsetX * direction
                self.MoveID(node.dcid, x-node.PosX, y-node.PosY-5)  # -4 = half height
                self.CommitPositionID(node.dcid)
                if len(branch) == 4:
                    node = branch[3]
                    x += offsetX * direction
                    self.MoveID(node.dcid, x-node.PosX, y-node.PosY)
                    self.CommitPositionID(node.dcid)
                y += offsetY
                
##    def AddNeighborsToSelection(self, id):
##        if debug: print 'AddNeighborsToSelection'
##        shape = self.dcid_to_shape_xref.get(id)
##        if shape.NodeAID:  # relation
##            self.AddToSelection(shape.dcid)
##            self.AddToSelection(shape.Get('NodeA').dcid)
##            self.AddToSelection(shape.Get('NodeB').dcid)
##        else:  # not relations
##            print shape.GetFollowers()
##            for follower in shape.GetFollowers():
##                if follower.NodeAID:  # relation
##                    self.AddToSelection(follower.dcid)
##                    self.AddToSelection(follower.Get('NodeA').dcid)  # one of these is redundant
##                    self.AddToSelection(follower.Get('NodeB').dcid)
##                else:  # -- are they always relations?
##                    pass
##        self.AddToSelection(id)  # last to make sure it is target of keyboard

    def InferTarget(self, source, x, y):
        target = None
        if isinstance(source, ORMObjectTypeShape):
            target = self.AddNode('ORMFactTypeShape', x-6, y-6)  # center on cursor
            reading = self.AddFollower('ORMFactReadingShape', target)
        elif isinstance(source, ORMFactTypeShape):
            target = self.AddNode('ORMObjectTypeShape', x, y)
        if target is not None:
            Data.SetUndo('Add %s' % target.__class__)
            self.RedisplayID(target.dcid)
            connected = self.ConnectEm(source, target)
            if connected:
                self.RedrawID(source.dcid)  # better way to do?
                self.RedrawID(target.dcid)
                self.ClearSelection()
                self.SelectObject(target.dcid)
                Data.SetUndo('Add %s' % 'Connector')

    def AddRole(self, role):
        if role in self.rolelist:
            self.rolelist.remove(role)
        self.rolelist.append(role)

    def RemoveRole(self, role):
        if role in self.rolelist:
            self.rolelist.remove(role)

    # mouse handling
    # left - select and move; shift - change model; cntl - change selection
    # right - menu
    # ------------------------------------------------
    # action              | target        | result
    # ------------------------------------------------
    # left click          | canvas        | clear selection
    #                     | object        | select object
    # left double         | object        | open object -- NOT YET
    # left drag           | canvas        | new selection rectangle -- PARTIAL
    #                     | object        | move object
    # shift left click    | canvas        | create entity type
    #                     | object        | select object
    # shift left double   | --            | none
    # shift left drag     | canvas/canvas | create entity type, fact, and role
    #                     | canvas/object | create entity type, connect to object
    #                     | object/canvas | create target type, connect
    #                     | object/object | connect objects
    # cntl left click     | object        | toggle selection of object
    # cntl left double    | object        | add object & neighbors to selection
    # cntl left drag      | canvas        | add to selection rectangle -- PARTIAL
    # right click         | canvas        | open canvas menu
    #                     | object        | open object menu

    def OnMouse(self, event):
        global hitradius
        self.clickx = self.clicky = 0  # to identify role clicks
        if event.LeftDown():
            x,y = self.ConvertEventCoords(event)
            self.clickx, self.clicky = x, y
            l = self.pdc.FindObjects(x, y, hitradius)
            source = None
            self.selection_rectangle = False
            if l:  # select object (future manage multiple selected objects)
                for id in l:
                    if not self.pdc.GetIdGreyedOut(id):
                        self.dragid = id
                        self.lastpos = (event.GetX(),event.GetY())
                        source = self.dcid_to_shape_xref.get(self.dragid)
                        break
                if source:
                    if (self.demo.draw_mode or event.ShiftDown()) and not self.Report.Lock:  # "demo" is a poor name, this is where the window global data is
                        if source.Subtype == 'ORMConstraintShape':
                            self.AddRoleSequence(source)
                        self.SelectObject(self.dragid)
                    elif event.CmdDown():
                        self.ToggleObjectSelect(self.dragid)
                    else:
                        self.SelectObject(self.dragid)
            else: # didn't click on any object
                if (self.demo.draw_mode or event.ShiftDown()) and not self.Report.Lock:  # "demo" is a poor name, this is where the window global data is
                    # add new object
                    new_shape = self.AddNode(self.leftClickType, x, y)
                    Data.SetUndo('Add %s' % self.leftClickType)
                    # redisplay object??
                    # id = self.shapeid_to_dcid_xref[new_shape.ID]
                    self.RedisplayID(new_shape.dcid)
                    # make object current selection
                    self.dragid = new_shape.dcid  # remember start of drag
                    self.lastpos = (event.GetX(),event.GetY())  # needed?
                    l = [new_shape.dcid]
                    self.SelectObject(self.dragid)
                else:  # control down and normal
                    if not event.CmdDown():
                        self.ClearSelection()
                    self.selection_rectangle_origin_x = x
                    self.selection_rectangle_origin_y = y
                    self.selection_rectangle_current_x = x
                    self.selection_rectangle_current_y = y
                    self.DrawSelectionRectangle(True)
                    self.prior_in_list = {}
                    self.selection_rectangle = True

            # keyboard input
            self.SetFocus()
        elif event.LeftDClick():
            if debug: print "double click event"
            x,y = self.ConvertEventCoords(event)
            l = self.pdc.FindObjects(x, y, hitradius)
            source = None
            if l:  # select object (future manage multiple selected objects)
                for id in l:
                    if not self.pdc.GetIdGreyedOut(id):
                        self.dragid = id
                        self.lastpos = (event.GetX(),event.GetY())
                        source = self.dcid_to_shape_xref.get(self.dragid)
                        break
                if source:  # above here it is identical to single click
                    if debug: print 'double clicked on an object'
                    if self.demo.draw_mode or event.ShiftDown():
                        pass  # open object
                    elif event.CmdDown():
                        if debug: print "control double click on object"
                        self.AddDependentsToSelection(self.dragid)
                    else:
                        pass  # open object
        elif event.RightDown():
            if self.Report.Lock: return
            x,y = self.ConvertEventCoords(event)
            #l = self.pdc.FindObjectsByBBox(x, y)
            l = self.pdc.FindObjects(x, y, hitradius)
            if l:
                self.OnContextMenuShape(event)
##                self.pdc.SetIdGreyedOut(l[0], not self.pdc.GetIdGreyedOut(l[0]))
##                r = self.pdc.GetIdBounds(l[0])
##                r.Inflate(4,4)
##                self.OffsetRect(r)
##                self.RefreshRect(r, False)
# -- code for popup menu on canvas??? --
            else: # didn't click on any object
                self.OnContextMenuCanvas(event)
# -- end code for popup menu on canvas??? --
        elif event.Dragging() or event.LeftUp():
            if self.demo.draw_mode or event.ShiftDown():  # "demo" is a poor name, this is where the window global data is
                pass
            elif event.CmdDown() or self.dragid == -1:  # control down and (normal not drag)
                if self.selection_rectangle:
                    x,y = self.ConvertEventCoords(event)
                    if x != self.selection_rectangle_current_x and y != self.selection_rectangle_current_y:
                        self.DrawSelectionRectangle(False)
                        minx = min(self.selection_rectangle_origin_x, x)
                        maxx = max(self.selection_rectangle_origin_x, x)
                        miny = min(self.selection_rectangle_origin_y, y)
                        maxy = max(self.selection_rectangle_origin_y, y)
                        rect = wx.Rect(minx, miny, maxx - minx, maxy - miny)
                        in_list = [ id for id in self.objids
                          if (minx <= self.pdc.GetIdBounds(id).GetX() and
                              self.pdc.GetIdBounds(id).GetX() + self.pdc.GetIdBounds(id).GetWidth()<= maxx and
                              miny <= self.pdc.GetIdBounds(id).GetY() and
                              self.pdc.GetIdBounds(id).GetY() + self.pdc.GetIdBounds(id).GetHeight() <= maxy)
                                    ]
                        for id in in_list:
                            if id in self.prior_in_list:
                                del self.prior_in_list[id]
                            else:
                                self.AddToSelection(id)
                        for id in self.prior_in_list.keys():
                            self.DropFromSelection(id)
                        self.prior_in_list = dict([ (x, None) for x in in_list])
                        self.selection_rectangle_current_x = x
                        self.selection_rectangle_current_y = y
                        self.DrawSelectionRectangle(False)
            else:  # no modifiers
                if self.dragid != -1:
                    x,y = self.lastpos
                    dx = event.GetX() - x
                    dy = event.GetY() - y
                    # self.MoveID(self.dragid, dx, dy)
                    self.MoveSelection(dx, dy)
                    self.lastpos = (event.GetX(),event.GetY())
                    # adjust all arrows pointing to dragged object
                else:  # continue selection rectangle
                    pass
            if event.LeftUp():
                if (self.demo.draw_mode or event.ShiftDown()) and not self.Report.Lock:  # "demo" is a poor name, this is where the window global data is
                    # self.dragid = -1
                    # what did we release on?
                    x,y = self.ConvertEventCoords(event)
                    l = self.pdc.FindObjects(x, y, hitradius)
                    if l:  # connect to this object and maybe connection (if legal)
                        target = self.dcid_to_shape_xref.get(l[0])
                        source = self.dcid_to_shape_xref.get(self.dragid)
                        if source.ID != target.ID:
                            connected = self.ConnectEm(source, target)  # return value if connected?
                            if connected:
                                self.ClearSelection()
                                self.SelectObject(target.dcid)
                                Data.SetUndo('Add %s' % 'Connector')
                    else:  # create target object and connection (if legal)
                        source = self.dcid_to_shape_xref.get(self.dragid)
                        if debug: print "source class:", source.__class__
                        self.InferTarget(source, x, y)
                elif event.CmdDown():
                    if self.selection_rectangle:
                        x,y = self.ConvertEventCoords(event)
                        self.DrawSelectionRectangle(False)
                        self.selection_rectangle_current_x = x
                        self.selection_rectangle_current_y = y
                        self.selection_rectangle = False
                else:
                    if self.dragid != -1:
                        # self.CommitPositionID(self.dragid)
                        shape = self.dcid_to_shape_xref.get(self.dragid)
                        if abs(shape.TempX - shape.PosX) + abs(shape.TempY - shape.PosY) > 2: # if move is more than X pixels then commit it???
                            self.CommitPositionSelection()
                            Data.SetUndo('Move')
                        self.dragid = -1


    def MoveSelection(self, dx, dy):
        for dcid in self.GetSelection():

            # special handling of objectified fact types
            # because moving object type should move the fact type, too
            shape = self.dcid_to_shape_xref.get(dcid)
            if shape.Subtype == 'ORMObjectTypeShape' and shape.NodeA:
                if self.InSelection(shape.NodeA.dcid):
                    pass  # move because follow is surpressed when both are selected
                else:  # move fact type
                    self.MoveID(shape.NodeA.dcid, dx, dy)
                    continue

            self.MoveID(dcid, dx, dy)

    def MoveID(self, dcid, dx, dy, follow=0):
        shape = self.dcid_to_shape_xref.get(dcid)
        r = self.pdc.GetIdBounds(dcid)
        if shape.NodeA and shape.NodeB:  # recalculate ends
            shape.Draw(self.pdc)
        elif shape.NodeA:  # follow
            nodea = shape.Get('NodeA')
            if nodea.GetSelected() and shape.GetSelected() and follow:
                return  # we're both selected; prevent double move
            if nodea.NodeA and nodea.NodeB and not follow:
                if nodea.NodeA.GetSelected() or nodea.NodeB.GetSelected():
                    return  # we're attached to a moving line; prevent double move              
            self.pdc.TranslateId(dcid, dx, dy)
            x,y = shape.GetPos()
            shape.SetTempPos(x+dx, y+dy)
            if nodea.NodeA and nodea.NodeB and not follow:
                SetLineFollowerMetrics(nodea, shape)
        else:
            self.pdc.TranslateId(dcid, dx, dy)
            x,y = shape.GetPos()
            shape.SetTempPos(x+dx, y+dy)
        r2 = self.pdc.GetIdBounds(dcid)
        r = r.Union(r2)
        r.Inflate(4,4)
        self.OffsetRect(r)
        self.RefreshRect(r, False)

#        shape.PosX += dx  # would += work? aparently yes
#        shape.PosY += dy

##        if shape.NodeAID and shape.NodeBID:
        if shape.NodeA and shape.NodeB:
            self.MoveLineFollowers(shape)
        else:
            for follower in shape.GetFollowers():
                self.MoveID(follower.dcid, dx, dy, 1)

    def MoveLineFollowers(self, line):
        pointA, pointB = line.GetEnds()
        length = dist(pointA, pointB) or 1
        x0, y0 = pointA
        x1, y1 = pointB
        width, height = x1 - x0, y1 - y0
        for f in line.GetFollowers():
            x2 = x0 + width * f.parallel + height * f.orthagonal / length
            y2 = y0 + height * f.parallel - width * f.orthagonal / length

            # # draw the lines used to position the follower
            # junctionX = x0 + width * f.parallel
            # junctionY = y0 + height * f.parallel
            # self.pdc.SetPen(self.CachedPen('Blue', 1, wx.DOT))
            # self.pdc.DrawLine(x0, y0, junctionX, junctionY)
            # self.pdc.DrawLine(junctionX, junctionY, x2, y2)

            # x, y = f.GetPos()
            # dx, dy = x2 - x, y2 - y
            # self.MoveID(f.dcid, dx, dy, 1)  # drifting for some reason
            f.SetTempPos(x2, y2)
            self.RedrawID(f.dcid)

    def CommitPositionSelection(self):
        for id in self.GetSelection():
            self.CommitPositionID(id)

    def CommitPositionID(self, dcid):
        shape = self.dcid_to_shape_xref.get(dcid)
        shape.CommitPos()
        for follower_shape in shape.GetFollowers():
            self.CommitPositionID(follower_shape.dcid)

    def OnSetFocus(self, evt):
        if debug: print "set focus event received"

    def OnChar(self, evt):
        uk = evt.GetUnicodeKey()
        uni = unichr(uk)
        keycode = evt.GetKeyCode()
        if debug: print "char -", uni, "-"
        if self.Report.Lock: return
        if self.keyboard_target_dcid:
            shape = self.dcid_to_shape_xref.get(self.keyboard_target_dcid)
            if not shape.Valid():
                if debug: print 'OnChar: atempt to send char to invalid shape'
                self.keyboard_target_dcid = None
                return
            if keycode in (wx.WXK_LEFT, wx.WXK_RIGHT, wx.WXK_UP, wx.WXK_DOWN):
                shape.MoveCursor(keycode)
                self.RedrawID(shape.dcid)
                return
            if (uk == 18 or uni == 'r') and evt.CmdDown():  # ctrl-r
                x, y = shape.GetPos()
                yvals = []
                if shape.Subtype == 'ORMFactTypeShape':
                    yvals = [xx.Get('NodeB').PosY for xx in shape.GetFollowers()
                             if xx.TableName == 'ORMRole' and xx.Get('NodeA').PosX > x]
                    x += 40
                    y += 5
                elif shape.Subtype == 'ORMObjectTypeShape':
                    yvals = [xx.Get('NodeA').PosY for xx in shape.GetFollowers()
                             if xx.TableName == 'ORMRole' and xx.Get('NodeA').PosX > x]
                    y += 1
                elif shape.Subtype == 'ORMSampleTableShape':
                    if self.focus_cell and self.focus_cell.ORMRolePosition:
                        mo = shape.Target
                        seq = self.focus_cell.ORMRolePosition.Seq
                        if evt.ShiftDown():
                            seq -= .5
                        else:
                            seq += .5
                        AddSampleRow(mo, seq=seq)
                        # AdjustSampleRows(mo)  # already done by AddSampleRow
                        x, y = shape.GetPos()
                        print 'cliph', shape.ClipH, 'cols', shape.ClipColumns, 'count', shape.ClipColumns.count(',')
                        # shift table graphic down 1/2 row so it will remain in the same position
                        y += shape.ClipH // ((shape.ClipColumns.count(',') or 1) * 2)
                        shape.SetTempPos(x, y)
                        shape.CommitPos()
                        self.RedrawID(shape.dcid)
                        Data.SetUndo('Add Sample Data Row')
                    return
                if yvals:
                    maxy = max(yvals)
                    y = maxy + 35
                self.InferTarget(shape, x + 70, y)
                return
            if uni in ('<', '>'):
                ''' calculate a list of neighbors in order around the clock'''
                if debug: print 'processing a', uni
                x0, y0 = shape.GetPos()
                ends = []
                if shape.Subtype == 'ORMFactTypeShape':
                    ends = [xx.Get('NodeB') for xx in shape.GetFollowers() if xx.TableName == 'ORMRole']
                    ends.sort(cmp=lambda x,y: cmp(math.atan2(x.PosY, x.PosX), math.atan2(y.PosY, y.PosX)))
                elif shape.Subtype == 'ORMObjectTypeShape':
                    ends = [xx.Get('NodeA') for xx in shape.GetFollowers() if xx.TableName == 'ORMRole']
                    ends.sort(cmp=lambda x,y: cmp(math.atan2(x.PosY-y0, x.PosX-x0), math.atan2(y.PosY-y0, y.PosX-x0)))

                if self.keyboard_nav_dcid:
                    if debug: print 'in nav mode'
                    nav_shape = self.dcid_to_shape_xref.get(self.keyboard_nav_dcid)
                    # i = ends.index(nav_shape)  # should always work
                    i = 0
                    while ends[i] is not nav_shape:
                        i += 1
                    if uni == '<':
                        i -= 1
                        if i < 0: i = len(ends) - 1
                    elif uni == '>':
                        i += 1
                        if i >= len(ends): i = 0
                    self.keyboard_nav_dcid = ends[i].dcid
                    self.RedrawID(nav_shape.dcid)
                    self.RedrawID(self.keyboard_nav_dcid)
                elif ends: # at least one
                    if debug: print 'entering nav mode'
                    angles = [abs(math.atan2(x.PosY-y0, x.PosX-x0)) for x in ends]
                    if uni == '>':
                        start = min(angles)
                    else:
                        start = max(angles)
                    i = 0
                    while angles[i] is not start:
                        i += 1
                    self.keyboard_nav_dcid = ends[i].dcid
                    self.RedrawID(self.keyboard_nav_dcid)
                else:  # this should never happen
                    if debug: print 'leaving nav mode'
                    temp = self.keyboard_nav_dcid
                    self.keyboard_nav_dcid = False
                    self.RedrawID(temp)
                return

            if self.keyboard_nav_dcid:
                if debug: print 'looking for accept key'
                temp = self.keyboard_nav_dcid
                self.ClearNavMode()
                if uk == 13 or uni == ',' or uni == '.':  # choose current option
                    if debug: print 'found accept key'
                    self.ClearSelection()
                    self.SelectObject(temp)
##                self.keyboard_nav_dcid = False
##                self.RedrawID(temp)
                if debug: print 'leaving nav mode' 
                return

            if evt.CmdDown():  # don't turn menu commands into characters
                evt.Skip()
                return

            try:
                if Data.UndoStack[-1] == 'Typing' and Data.UndoStack[-2].get('ID') == shape.TableID:
                     Data.UndoStack.pop()
            except (IndexError, AttributeError):
                pass
            shape.Char(uni)  # send character to shape for processing
            Data.SetUndo('Typing')
##            shape.Draw(self.pdc)
##            self.RedisplayID(shape.dcid)
            self.RedrawID(shape.dcid)
            if shape.Subtype in ('ORMObjectTypeShape', 'ORMFactTypeShape', 'ORMRoleConnectorShape'):  # why not for everything??
                for follow in shape.GetFollowers():  # when typing into fact
                    self.RedrawID(follow.dcid)
        # evt.Skip()  # don't know if I should skip them or not

    def CachedPen(self, c, t, s):
        if not self.pen_cache.has_key( (c, t, s) ):
            self.pen_cache[(c, t, s)] = wx.Pen(c, t, s)
        return self.pen_cache[(c, t, s)]

    def CachedBrush(self, c):
        if not self.brush_cache.has_key(c):
            self.brush_cache[c] = wx.Brush(c)
        return self.brush_cache[c]

    def OnPaint(self, event):
        # Create a buffered paint DC.  It will create the real
        # wx.PaintDC and then blit the bitmap to it when dc is
        # deleted.  
        dc = wx.BufferedPaintDC(self)
        # use PrepateDC to set position correctly
        self.PrepareDC(dc)
        # we need to clear the dc BEFORE calling PrepareDC
        bg = wx.Brush(self.GetBackgroundColour())
        dc.SetBackground(bg)
        dc.Clear()
        # create a clipping rect from our position and size
        # and the Update Region
        xv, yv = self.GetViewStart()
        dx, dy = self.GetScrollPixelsPerUnit()
        x, y   = (xv * dx, yv * dy)
        rgn = self.GetUpdateRegion()
        rgn.Offset(x,y)
        r = rgn.GetBox()
        # draw to the dc using the calculated clipping rect
        self.pdc.DrawToDCClipped(dc,r)

    def DoDrawing(self, dc):
        '''
        Used when report is first openned
        Loads in all current objects
        '''
        random.seed()
        self.objids = []
#        self.shapeid_to_dcid_xref = {}  # NOT NEEDED - xrefs between shapes and dc_ids
        self.dcid_to_shape_xref = {}     # inverse of shapeid_to_dcid_xref
#        self.followers = {}  # followers[leader_shape.ID] => list of follower shapes
        self.boundsdict = {}
        dc.BeginDrawing()

        # report_object = db.GetObject('Report', self.ReportID)
        # report_object = self.Report
##        db = self.Report.db
##        shapes = [ db.GetObject('GraphicObject', x) for x in Data.SearchByColumn(db.Database['GraphicObject'], {'ReportID': self.ReportID}) ]
        #shapes = [ report_object.db.GetObject('ReportRow', x) for x in Data.GetRowList(self.ReportID) ]
        shapes = self.Report.GetList('GraphicObject')
        if debug:
            print "-- these are all of the shapes -- len=%s" % len(shapes)
            print shapes
            print "-----"
        for shape in shapes:
            # if the nodes isn't already created then do it now
            if debug: print 'before create of:', shape.__class__
            if shape.canvas != self:  # if not processed by CreateNode before    #isinstance(shape, ORMShape):
                self.CreateNode(dc, shape)
            self.SetGraphic(dc, shape)  # draw shape on this canvas
            shape.OnBottom()  # put objectification behind facttype
        dc.EndDrawing()

class ControlPanel(wx.Panel):
    def __init__(self, parent, id, pos=wx.DefaultPosition,
            size=wx.DefaultSize, style = wx.TAB_TRAVERSAL):
        wx.Panel.__init__(self,parent,id,pos,size,style)

        # add new tool bar here
        self.report_toolbar = wx.ToolBar(self, -1)
        self.report_toolbar.SetToolBitmapSize((16, 16))  # change
        # self.SetToolBar(self.report_toolbar)
        self.report_toolbar.AddRadioLabelTool(ID.NORMAL, _("Normal Mode"), Menu.Bitmap("icons/Pointer.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, _("Normal Mode"), _("Dragging will select and move objects"))
        self.report_toolbar.AddRadioLabelTool(ID.DRAW, _("Drawing Mode"), Menu.Bitmap("icons/Pencil.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, _("Drawing Mode"), _("Dragging will create and connect objects"))
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddLabelTool(ID.DELETE, _("Delete"), Menu.Bitmap("icons/Delete.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Delete"), _("Delete selected objects"))
        self.report_toolbar.Realize()
 
        # lbl = wx.StaticText(self, wx.ID_ANY, "Hit Test Radius: ")
        lbl2 = wx.StaticText(self, wx.ID_ANY, "Hold shift key to switch to drawing mode.")
        # global hitradius
        # sc = wx.SpinCtrl(self, wx.ID_ANY, "%d" % hitradius)
        # sc.SetRange(0,100)
        # sc.SetValue(hitradius)
        # self.sc = sc
        sz = wx.BoxSizer(wx.HORIZONTAL)
        sz.Add(self.report_toolbar,0, wx.ALIGN_CENTRE) # toolbar
        # sz.Add((15, 15))
        # sz.Add(lbl,0, wx.ALIGN_CENTRE)
        # sz.Add(sc,0)
        sz.Add((15, 15))
        sz.Add(lbl2,0, wx.ALIGN_CENTRE)
        self.SetSizerAndFit(sz)
        # sc.Bind(wx.EVT_SPINCTRL,self.OnChange)
        # sc.Bind(wx.EVT_TEXT,self.OnChange)
        
        wx.EVT_TOOL(self, ID.NORMAL, self.OnNormal)
        wx.EVT_TOOL(self, ID.DRAW, self.OnDraw)
        wx.EVT_TOOL(self, ID.DELETE, self.OnDelete)

    def OnChange(self, event):
        global hitradius
        hitradius = self.sc.GetValue()
    
    def OnNormal(self, event):
        self.demo.draw_mode = False
        self.report_toolbar.ToggleTool(ID.NORMAL, True)
        self.win.SetCursor(self.win.pointer_cursor)

    def OnDraw(self, event):
        self.demo.draw_mode = True
        self.report_toolbar.ToggleTool(ID.DRAW, True)
        self.win.SetCursor(self.win.pencil_cursor)

    def OnKeyUp(self, event):
        if event.GetKeyCode() == wx.WXK_SHIFT and not self.demo.draw_mode:
            self.report_toolbar.ToggleTool(ID.NORMAL, True)
            self.win.SetCursor(self.win.pointer_cursor)
        event.Skip()

    def OnKeyDown(self, event):
        if event.GetKeyCode() == wx.WXK_SHIFT:
            self.report_toolbar.ToggleTool(ID.DRAW, True)
            self.win.SetCursor(self.win.pencil_cursor)
        event.Skip()

    def OnDelete(self, event):
        shapes = [ self.win.dcid_to_shape_xref.get(x) for x in self.win.GetSelection() ]
        for shape in shapes:
            if shape.IsUIDeletable():
                shape.Delete()
        Data.SetUndo('Deletion')
        self.win.RedrawAll()
