#!/usr/bin/env python
# Quick start help information

# Copyright 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 060709 - first version of this file
# 060710 - Brian - Clarified some points, added more short cuts
# 060722 - Brian - reworded some of the comments, added more on short cuts
# 061207 - Brian - rewrote most of the text
# 061230 - Brian - more revisions to text
# 070328 - Brian - improved Resources text to respond to Blake's beta test comment
# 080615 - Brian - drafted ORM help
# 080616 - Alex - adjust the information by platform
# 080723 - Brian - Expand ORM help

import Data

if Data.platform == "mac":
    platform_dict = {
        "right-click": "control-click",
        "Right-click": "Control-click",
        "command": "command",
        "Command": "Command",
    }
else:
    platform_dict = {
        "right-click": "right-click",
        "Right-click": "Right-click",
        "command": "control",
        "Command": "Control",
    }

overview = """
<html><body>
<p>GanttPV helps people schedule projects so they can be completed more effectively. Use GanttPV
to:</p>
<ul>
<li>Define projects</li>
<li>Define the tasks that must be completed to finish each project</li>
<li>Identify the people who will be working on the projects</li>
<li>Create a schedule that will show when each task will be completed
and who is assigned to each task</li>
</ul>
<p></p>
<hd2>The Main Window</hd2>
<ul>
<li>Shows all of the projects defined in the GanttPV database file.</li>
<li>Below each project are listed its reports.</li>
<li>To open a report:<br />(1) double click on the report name<br /> or (2) click on the
report name and press "Enter".</li>
</ul>
<p></p>
<p>To define a new project:</p>
<ul>
<li>The first project is already defined</li>
<li>To add another project click the <i>New Project</i> toolbar button</li>
</ul>
<p>To add a new report</p>
<ul>
<li>Select a project or report (by clicking anywhere on its row)</li>
<li>Click the <i>New Report</i> toolbar button.</li>
<li>Select a report type from the list and click okay.</li>
<li>To add a new gantt chart, specify a "Task" report.</li>
</ul>
<p>Reports under "All Projects" contain information that
is shared by all of the other projects. For example, Resources and Holidays.</p>
</body></html>
"""

report_window = """
<html><body>
<hd2>Report Windows</hd2>
<p>Each grid report includes one main type of row and may include a second type.
For example, in a "Task" report, there is one row per task. To add a new task,
insert a new row.</p>
<p></p>
<p>Some report types:</p>
<ul>
<li>Task Reports are used to define the tasks that make up a project. For each task
you can define: (1) a start date, (2) preprequsite tasks, (3) assigned resources.
Gantt chart reports are Task reports that include a bar chart column.</li>
<li>Resource Reports list all of the resources that can be assigned to
project tasks. Resources include people, but can also include trucks, movie cameras,
or anything else that needs to be scheduled.</li>
<li>Followup Reports will show the "To Do" list for the project. Followup
items are either too small to be tasks or don't have to be completed at a specific
time. (Run the "Install Followup Tracking" script to enable.)</li>
</ul>
<p></p>
</body></html>
""" % platform_dict

define_tasks = """
<html><body>
<hd2>How to define tasks?</hd2>
<ol>
<li>Open a task report</l>
<li>Add a new row for each task</li>
<li>Give each task a name</li>
<li>Estimate effort - how many hours of work will take to complete the task</li>
<li>Estimate duration - how much time from when the task is started until it is finished</li>
<li>Either set the start date of the task or identify which task it should start after
<ul>
<li>Enter the start date in this format: 2006-11-25 (see the short cuts for quick ways to enter dates)</li>
<li>Define "start after" tasks. These are called prerequisites. GanttPV will
calclate a start date for the task based on the completion dates for the prerequite tasks.</li>
</ul>
</ol>
<p></p>
<hd2>Define dependencies between tasks</hd2>
<ol>
<li>Open a task report</l>
<li>Select a task by clicking on the row number</li>
<li>Open the Action menu and select Define Prerequisite for Task</li>
<li>Click on the tasks that should be prerequisite tasks and click OK</li>
</ol>
<p></p>
</body></html>
""" % platform_dict

define_resources = """
<html><body>
<hd2>How to define resources?</hd2>
<ol>
<li>Open a resource report</l>
<li>Add a new row for each resource</li>
<li>Give each resource a name</li>
</ol>
<p></p>
<hd2>How to assign resources to tasks?</hd2>
<ol>
<li>Open a task report</l>
<li>Select a task by clicking on the row number</li>
<li>Open the Action menu and select Assign Resource to Task</li>
<li>Click on the resource to assign to the task and click OK</li>
</ol>
<p></p>
<hd2>How to create resources groups?</hd2>
<ol>
<li>Run <i>Install Resource Groups</i></l>
<li>Insert the <i>Group Type</i> column in a resource report</li>
<li>A resource becomes a resource group if it has a group type value</li>
<li>Enter either "Work" or "Skill"</li>
<li>If a work group is assigned to a task, it is automatically replaced
with all of the group members</li>
<li>A skill group can be assigned to a task; a member of the group can be substituted later</li>
</ol>
<p></p>
<hd2>How to identify the members of a resource group?</hd2>
<ol>
<li>Select the report row of the resource group you would like to define.</l>
<li>Select "Define Members of Resource Group..." in the Action menu.</li>
<li>Select or deselect members, then click OK.</li>
</ol>
<p>Currently only the "Work" group is supported.
GanttPV doesn't do anything will "Skill" groups, but will eventually (probably via a script).</p>
</body></html>
""" % platform_dict

work_time = """
<html><body>
<p>Three parts to defining work time</p>
<ul>
<li>Define the standard work week</li>
<li>Define exceptions to the standard work week (such as holidays)</li>
<li>Duration vs. Effort</li>
</ul>
<p></p>
<hd3>Defining the normal work week</hd3>
<ul>
<li>Run the script <i>Edit Work Week</i>
<li>Enter the normal number of work hours per day of the week</li>
</ul>
<p></p>
<hd3>Defining holidays</hd3>
<ul>
<li>The holiday report is used to define any exceptions to the normal work week.
It is called a holiday report, because usually on holidays the workday has no or reduced hours.</li>
<li>Create a Holiday report under "All Projects"</li>
<li>Insert a new row for each holiday</li>
<li>Enter the date (like 2006-25-11) for each holiday</li>
<li>Enter the number of work hours for that day (normally 0)</li>
</ul>
<p></p>
<p>How is duration different than effort?</p>
<ul>
<li>Duration is the number of work hours between the task start and task end</li>
<li>Effort is the number of hours people work on a task</li>
<li>Examples
<ul>
<li>If a task has a duration of 4 hours and three people will work
on the task full time during those hours, then the effort hours for the task would
be 12 hours.</li>
<li>If a task has a duration of 16 hours and one person will work on
the task half time, then the effort hours for the task would be 8 hours.</li>
</ul>
</li>
</ul>
<p></p>
</body></html>
""" % platform_dict

### --- deleted from text ---
##<p>Edit Project Name</p>
##<ul>
##<li>Select the project's name in the Main window</li>
##<li>Run script to edit the project name</li>
##</ul>
##<p>Edit Report Name</p>
##<ul>
##<li>Select the report's name in the Main window</li>
##<li>Run script to edit the report name</li>
##</ul>

scripts = """
<html><body>
<hd3>What are scripts?</hd3>
<p>Listed here are the scripts that every GanttPV user should know how to use.
All other scripts are optional and may be ignored.</p>
<p>Scripts enable technically oriented users to add new features to GanttPV.
If you are curious about a script, read the documentation
on the GanttPV web site.
It is almost impossible to guess how to use scripts without reading the
documentation.
If you have questions not answered in the
documentation, please email us.
</p>
<p>To find the documentation for a script</p>
<ol>
<li>Open the GanttPV home page by selecting "GanttPV Home" from GanttPV's "Help" menu</li>
<li>Click on the Scripts "List" link</li>
<li>Click on the script name (scripts are listed alphabetically)</li>
</ol>
<p><i>Print Report</i> Script</p>
<ul>
<li>Open the report to print</li>
<li>From the Script menu, select <i>Print - Export</i> -> <i>Print Report</i></li>
<li>The number of timescale columns that print is the same as the number that
are displayed on the screen. To increase the number of time periods displayed,
select the column and then run the <i>Edit Column Options</i> script.
</ul>
<p><i>Calculate Assignment Hours</i> Script</p>
<ul>
<li>Use to update the hours per day for resources, tasks, and assignments</li>
<li>Run the script to update hours after changing: task duration or effort or
changing the resources assigned to a task</li>
</ul>
<p><i>Sort By Selected Column</i> Script</p>
<ul>
<li>Click on a column heading</li>
<li>Run script</li>
</ul>
<p><i>Sort Like Related Report</i> Script</p>
<ul>
<li>Use this script to bring two reports into the same order</li>
<li>Open report to be sorted</li>
<li>Run script</li>
</ul>
</body></html>
""" % platform_dict

finding_help = """
<html><body>
<p>Where to get help?</p>
<p>Take the Tour of GanttPV</p>
<ul>
<li>From the Help Menu select the Help Page</li>
<li>It will open your browser to the GanttPV Help page</li>
<li>Look for the link to the Tour.</li>
</ul>
<p>Visit the GanttPV web site</p>
<ul>
<li>Use the Help Menu to find the GanttPV home page</li>
<li>The GanttPV web site contains many useful pages</li>
</ul>
<p>Ask questions or search for answers in the Forum</p>
<ul>
<li>Use the Help Menu to visit the forum</li>
<li>Use the search feature to find an answer to your question</li>
<li>To ask a new question, click on the Using GanttPV Forum, scroll to the bottom of the page,
and add a new topic.</li>
</ul>
</body></html>
""" % platform_dict

#
orm_overview = """
<html><body>
<hd3>Managing Facts</hd3>
<p>The simplest tool for managing facts
is a list or table. Most GanttPV reports are based on lists.
When facts become more complicated than a list or table can handle,
a popular solution is to create a database.</p>
<p>Ideally, the team would be able to get professional help in designing
necessary databases. Because that isn't always possible, project managers should
learn the basics of database design.</p>
<p />
<hd3>What is Object Role Modeling?</hd3>
<p>Object Role Modeling (ORM) is the most powerful and easiest to learn
approach to information modeling and database design. Everyone who
must manage facts or work with databases will find it useful.</p>
<p>ORM consists of diagrams and a methodology. Of the two, the
methodology is most important. ORM gives specific instructions on how
to identify and document important types of facts. ORM tools like this one
can transform fact type descriptions into a database design.</p>
<p>These quick start pages provide a brief introduction to the methodology
and diagram notation. More detailed information is available at <u>www.orm.net</u>
and <u>www.ORMFoundation.org</u>.</p>
</body></html>
""" % platform_dict

orm_steps = """
<html><body>
<hd3>Seven Step Procedure for Information Modeling</hd3>
<p>The first three steps explain how to identify important fact types.
The remaining steps capture constraints that will make sure
the facts collected are correct and usable.</p>
<ol>
<li>Transform familiar examples into elementary facts.</li>
<li>Draw the fact types, and apply a population check.</li>
<li>Check for entity types to be combined, and note arithmetic derivations
and constraints.</li>
<li>Add uniqueness constraints, and check arity of fact types.</li>
<li>Add manditory role constraints, and check for logical derivations.</li>
<li>Add value, set-comparison, and subtyping constraints.</li>
<li>Add other constraints and perform final checks.</li>
</ol>
<p>See the references for an explanation of each of these steps.</p>
</body></html>
""" % platform_dict

orm_facts = """
<html><body>
<hd3>Step 1 - From Examples to Fact Types</hd3>
<p>The most important step of the procedure is the first one.</p>
<ul>
<li>Find an example of data that is being used (or that will be used).</li>
<li>Ask someone who is familiar with the data to read it out to you.</li>
<li>Rephrase their words as an elementary fact.</li>
</ul>
<p>The following table illustrates the value of this procedure:</p>
<table><tr><th>Name</th><th>Measurement</th></tr>
<tr><td>Abby</td><td>70</td></tr>
<tr><td>Woods</td><td>85</td></tr>
<tr><td>Smith</td><td>65</td></tr></table>
<p>With just this table, we don't know what "Abby" is. It could be the
name of an animal, a person, a location, or anything else. "Measurement" is
just as much of a puzzle. It could refer to age, quantities, or
anything else.
</p><p>
When we ask an expert who is familiar with the information to read the facts
for us, the meaning
becomes mores clear: <i>When we took these measurements, the
building named "Abby" had an internal temperature of 70 degrees.</i>
</p><p>
Here is the fact after we restate it formally: <i>Building(.name) "Abby" had
internal Temperature(degreesFahrenheit:) 70.</i></p><p>
Building and Temperature are considered objects that play roles in this
fact type. "... has internal ..." is
called the fact type reading. Each fact of this type can be stated by filling
in the blanks with the appropriate values.
</p>
<ul>
<li>Capitalize each word of the object type name. Omit spaces and
special characters.</li>
<li>Specify in parentheses the prefered method of refering to each object type.
In this example, the dot indicates that ".name" is a abbreviation.
It means we refer to "Buildings" by
their "BuildingName". The colon in "degreesFahrenheit:" means that this is a unit of measure
and is an abbreviation for "DegreesFahrenheitValue".
<li>Three dots "..." should be included in the fact type reading to show
where the roles are inserted. If there are only two roles and the roles
appear at the beginning and the end, the dots can be omitted.</li>
</ul>
<p>See the references for more information.</p>
</body></html>
""" % platform_dict

orm_scripts = """
<html><body>
<hd3>ORM Scripts:</hd3>
<ul>
<li><i>Install ORM Diagram</i> - run this first to add the ORM reports to the menu:
<ul>
<li><i>ORM Diagram</i> - draw ORM diagrams to capture information requirements
(see ORM in shortcuts help) </li>
<li><i>ORM Object Type</i> - edit object type names, specify data types</li>
<li><i>ORM Fact Type</i> - edit fact type readings, specify fact type names</li>
<li><i>Relational Table</i> - override generated table names</li>
<li><i>Relational Table / Relational Column</i> - override generated
column names and data types</li>
</ul>
<li><i>Rmap</i> - generate relational tables and columns based on model</li>
<li><i>Rmap Baseline</i> - remember current tables for comparison with future changes</li>
<li><i>Generate SQL</i> - generate draft table 'create' statments based
the current Rmap relational table results</li>
<li><i>Generate SQL Deltas</i> - generate draft of SQL statements to help
convert old baseline tables to the current design</li>
</ul>
</body></html>
""" % platform_dict

orm_diagram = """
<html><body>
<hd3>ORM Diagram Shortcuts</hd3>
<p>Add an Object Type</p>
<ul>
<li>Hold the shift key and click on the canvas</li>
<li>Or type ctrl-r while a Fact Type is selected</li>
</ul>
<p>Add a Fact Type</p>
<ul>
<li>Hold the shift key and drag from an Object Type to
the canvas</li>
<li>Or type ctrl-r while a Object Type is selected</li>
</ul>
<p>Add another Role to a Fact Type</p>
<ul>
<li>Hold the shift key and drag from an Object Type to
a Fact Type or vice versa</li>
</ul>
<p>Add a Constraint</p>
<ol>
<li>%(Right-click)s on a role box</li>
<li>Select constraint type</li>
</ol>
<p>Add an External Constraint</p>
<ol>
<li>%(Right-click)s on the canvas</li>
<li>Select "Role Constraint" from popup menu</li>
<li>%(Right-click)s on Constraint circle</li>
<li>Select constraint type</li>
<li>Click on a Role box</li>
<li>%(Command)s-click to add more Roles to the sequence<br>
(Note the numbers appearing in the role boxes)</li>
<li>Shift-click on the Constraint circle</li>
<li>Repeat as necessary</li>
</ol>
<p>Add another Sample Data Row</p>
<ol>
<li>Click on a Sample Data Cell</li>
<li>Type ctrl-r (or ctrl-shift-r)</li>
</ol>
</body></html>
""" % platform_dict

#
shortcuts_a = """
<html><body>
<!-- <hd3>Shortcuts</hd3> -->
<p>Date shortcuts:</p>
<ul>
<li>"=" - Enters current date</li>
<li>Enter the day, defaults to current year and month</li>
<li>Enter the month and day, defaults to current year</li>
<li>"*1" - Enters next Monday's date</li>
<li>"*2" - Enters next Tuesday's date, etc.</li>
</ul>
<p>Show main window</p>
<ul>
<li>%(Command)s-1</li>
</ul>
<p>Insert new row into report</p>
<ul>
<li>%(Command)s-R</li>
</ul>
<p>Move rows up or down</p>
<ul>
<li>%(Command)s-9 (up) or %(Command)s-0 (down)</li>
</ul>
<p>Copy selected cells to clipboard</p>
<ul>
<li>%(Command)s-C</li>
</ul>
<p>Paste selected cells from clipboard</p>
<ul>
<li>%(Command)s-V</li>
</ul>
<p>Print Report</p>
<ul>
<li>%(Command)s-P</li>
</ul>
<p>Save Backup Copy of Database</p>
<ul>
<li>%(Command)s-B</li>
</ul>
<p>Select ID (for editable columns ending with 'ID')</p>
<ul>
<li>%(Command)s-2</li>
</ul>
<p>Add Checklist Item to Task (for Task/Checklist report)</p>
<ul>
<li>%(Command)s-3</li>
</ul>
<p>Sort by Priority (for Followup lists)</p>
<ul>
<li>%(Command)s-4</li>
</ul>
<p>Sort on Selected Column</p>
<ul>
<li>%(Command)s-5</li>
</ul>
</body></html>
""" % platform_dict

shortcuts_b = """
<html><body>
<p>Moving rows:</p>
<ul>
<li>To move rows from the bottom of report to the top (or the opposite)
<ol>
<li>Select the rows to move</li>
<li>Add to the selection a row near the top of the report</li>
<li>Click the "Move Row Up" toolbar button (or use the keyboard shortcut)</li>
</ol>
</li>
<li>The selected rows are brought together at the top of the report</li>
<li>This short cut can be used to bring any selected rows together</li>
</ul>
<p></p>
<p>Use Copy and Paste to import Task (or Resource) names</p>
<ul>
<li>Select and Copy a list of names from a table or spreadsheet</li>
<li>Insert a new Task at the end of the report</li>
<li>Select the last Task's name cell</li>
<li>When you paste the list of names, a new Task will be added for each</li>
</ul>

</body></html>
""" % platform_dict
### --- deleted from text ---
##<p>Copy Selection to Clipboard</p>
##<ul>
##<li>%(Command)s-C</li>
##</ul>

### it appears that wxHTMLWindow doesn't support unicode - this is a problem for i18n
## before the html content
##  print "Content-Type: text/html; charset=utf-8\n\n"
## or in the document
##  <head><meta http-equiv="content-type" content="text-html; charset=utf-8"></head>

shortcuts_c = """
<html><body>
<p>To assign new shortcuts to the scripts:</p>
<ol>
<li>Open the script file "Set Script Shortcuts" with a text editor.
<li>Edit the list of shortcuts.
<li>Run the edited version from the Script menu.
</ol>
</hd3>
</body></html>
""" % platform_dict
