#!/usr/bin/env python
# Report Aids - used by report modules

# Copyright 2004, 2005, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 060317 - Brian - moved these routines out of Data.py
# 060325 - Alex - moved logic for main window title into RefreshReports
# 060606 - Alex - added hint method; preserved window order
# 080517 - Alex - added RegisterSizePos
# 080112 - Brian - added open/close report events

# import datetime, calendar
import cPickle
import wx
import os, sys
import Data
import Menu, GanttReport, ORMReport
import UMLReport, StateReport
# import Menu, GanttReport
# import random
# import StartupData

debug = Data.debug
if debug: print "load ReportAids.py"

WindowOrder = 0  # counter to track which windows are closer to the front

# this routine needs a home, just not in Data.py
def GetModuleNames():
    """ Return the GanttPV modules as a namespace dictionary.

    This dictionary should be passed to any scripts run with execfile.
    """
    import Data, GanttPV, GanttReport, ORMReport, ID, Menu, ReportAids, UI, wx
    # import Data, GanttPV, GanttReport, ID, Menu, ReportAids, UI, wx
    return locals()

Data.GetModuleNames = GetModuleNames

def RefreshReports():
    if debug: print "Start RefreshReports"
    for k, v in Data.OpenReports.items():  # deleted reports are closed during this loop
        if debug: print 'reportid', k
        if not v: continue
        if Data.Report[k].get('zzStatus') == 'deleted':
            CloseReport(k)
        if k == 1:
            if Data.FileName:
                title = os.path.basename(Data.FileName) + " (Main Window)"
            else:
                title = "Main"
            v.SetTitle(title)
        else:
            v.SetReportTitle()  # only grid reports
        Menu.AdjustMenus(v)
        v.Refresh()
        v.Report.Refresh()  # update displayed data (needed for Main on Windows, not needed on Mac)
    if debug: print "End RefreshReports"

Data.RefreshReports = RefreshReports

# -----------------
def UpdateDataPointers(self, reportid):
    # self is either a list or a table behind a grid
    # create local pointers to database
    self.data = Data.Database
    # pointers to one record
    self.report = self.data["Report"][reportid]
    reporttypeid = self.report['ReportTypeID']
    #if debug: print 'reporttypeid', reporttypeid
    self.reporttype = self.data["ReportType"][reporttypeid]
    # pointers to tables
    self.reportcolumn = self.data["ReportColumn"]
    self.columntype = self.data["ColumnType"]
    self.reportrow = self.data["ReportRow"]

Data.UpdateDataPointers = UpdateDataPointers

def UpdateRowPointers(self):
    # self is either a list or a table behind a grid
    reportid = self.report.get('ID')
    showHidden = self.report.get('ShowHidden')
    self.rows, self.rowlevels = Data.GetRowLevels(reportid, showHidden)

Data.UpdateRowPointers = UpdateRowPointers

# --------- Routines to load and save data ---------

bar_colors = {
    'ActualBar': (238, 238, 102),
    'ActualBarSelected': (238, 238, 102),
    'BaseBar': (0, 0, 187),
    'BaseBarSelected': (0, 0, 187),
    'CompletionBar': (0, 0, 0),
    'CompletionBarSelected': (0, 0, 0),
}

def LoadOption(directory=None):
    """ Load the option file. """
    # global OptionFile, Option
    if not directory:
        directory = Data.Path

    Data.OptionFile = os.path.join(directory, "Options.ganttpvo")
    if debug: print "load option file:", Data.OptionFile
    try:
        f = open(Data.OptionFile, "rb")
    except IOError:
        if debug: print "option file not found"
    else:
        header = f.readline()  # header will identify need for conversion of earlier versions or use of different file formats
        Data.Option = cPickle.load(f)
        if not Data.Option.get("CompletionBar"):
            Data.Option.update(bar_colors)  # ad hoc fix to old, ugly bar colors
        f.close()
        Menu.GetScriptNames()

Data.LoadOption = LoadOption

# --------- Project files

def OpenReport(id):
    """ Open a report and bring it to the front.  """
    global WindowOrder

    r = Data.Report.get(id)
    if not r or r.get('zzStatus') == 'deleted':
        return
    r['Open'] = True
    WindowOrder += 1
    r['WindowOrder'] = WindowOrder
    if not Data.OpenReports.get(id):
        pos = (r.get('FramePositionX') or -1, r.get('FramePositionY') or -1)
        rtid = r.get('ReportTypeID')
        panel_type = Data.ReportType[rtid].get('PanelType')
        print "panel type", panel_type
        if panel_type == 'ORMDiagram':
            size = (r.get('FrameSizeW') or 650, r.get('FrameSizeH') or 500)
            Data.OpenReports[id] = ORMReport.ORMReportFrame(id, None, -1, "", pos, size)
        elif panel_type == 'StateDiagram':
            size = (r.get('FrameSizeW') or 650, r.get('FrameSizeH') or 500)
            Data.OpenReports[id] = StateReport.StateReportFrame(id, None, -1, "", pos, size)
        elif panel_type == 'UMLClassDiagram':
            size = (r.get('FrameSizeW') or 650, r.get('FrameSizeH') or 500)
            Data.OpenReports[id] = UMLReport.UMLReportFrame(id, None, -1, "", pos, size)
        else:
            size = (r.get('FrameSizeW') or 768, r.get('FrameSizeH') or 311)
            Data.OpenReports[id] = GanttReport.GanttReportFrame(id, None, -1, "", pos, size)
        Menu.UpdateWindowMenuItem(id)
    Data.OpenReports[id].Show(True)
    Data.OpenReports[id].Raise()
    Data.OpenReportEvent(id)

Data.OpenReport = OpenReport

def CloseReport(id):
    """ Close a report. """
    if Data.OpenReports.has_key(id):
        if Data.Report.get(id) and Data.Report[id].has_key('Open'):
            del Data.Report[id]['Open']
        Data.OpenReports[id].Destroy()
        del Data.OpenReports[id]
        Menu.UpdateWindowMenuItem(id)
    Data.CloseReportEvent(id)

Data.CloseReport = CloseReport

def CloseReports():
    """ Close all reports except #1. """
    for id, frame in Data.OpenReports.items():
        if id == 1: continue
        if Data.Report.get(id) and Data.Report[id].has_key('Open'):
            del Data.Report[id]['Open']
        frame.Destroy()
        del Data.OpenReports[id]
    Menu.ResetWindowMenus()

Data.CloseReports = CloseReports

def SetActiveReport(id):
    global WindowOrder
    Data.ActiveReport = id
    WindowOrder += 1
    Data.Report[id]['WindowOrder'] = WindowOrder

Data.SetActiveReport = SetActiveReport

def MakeReady():
    Data.PrepDatabase()
    CreateReports()

Data.MakeReady = MakeReady

def CreateReports():
    global WindowOrder

    # adjust main report
    if 1 in Data.OpenReports:
        v = Data.Report[1]
        v['Open'] = True
        pos = (v.get('FramePositionX') or -1, v.get('FramePositionY') or -1)
        size = (v.get('FrameSizeW') or 422, v.get('FrameSizeH') or 313)
        frame = Data.OpenReports[1]
        frame.Show(False)
        frame.SetPosition(pos)
        frame.SetSize(size)
        frame.UpdatePointers(1) # new database

    # open reports
    WindowOrder = 0
    reports = []
    for k, v in Data.Report.iteritems():
        if v.get('Open'):
            reports.append((v.get('WindowOrder'), k))
    reports.sort()
    for order, k in reports:
        OpenReport(k)

    Data.UndoStack = []
    Data.RedoStack = []
    Data.ChangedData = False  # true if database needs to be saved
    Data.ChangedCalendar = Data.ChangedSchedule = Data.ChangedReport = Data.ChangedRow = False

    RefreshReports()

Data.CreateReports = CreateReports

# this doesn't belong in ReportAids.py - needs new home
def AskIfUserWantsToSave(action):
    """ Give the user the opportunity to save the current document.

    'action' is a string describing the action about to be taken.  If
    the user wants to save the document, it is saved immediately.  If
    the user cancels, we return False.
    """
    # global FileName
    if not Data.ChangedData: return True # Nothing to do.

    response = wx.MessageBox("Save changes before " + action + "?",
                                "Confirm", wx.YES_NO | wx.CANCEL)

    if response == wx.YES:
        if Data.FileName and Data.SaveContents():
            return True
        else:
            tempFileName = wx.FileSelector("Save File As", "Saving",
                default_filename='Untitled.ganttpv',
                default_extension="ganttpv",
                wildcard="*.ganttpv",
                flags = wx.SAVE | wx.OVERWRITE_PROMPT)
            if tempFileName and Data.SaveContents(tempFileName):
                Data.FileName = tempFileName
                Data.RefreshReports()
                return True
    elif response == wx.NO:
        return True # User doesn't want changes saved.

    return False # User cancelled or file failed to save.

Data.AskIfUserWantsToSave = AskIfUserWantsToSave

def Hint(message):
    if debug: print message
    frame = Data.OpenReports.get(Data.ActiveReport)
    frame.SetStatusText(message)

Data.Hint = Hint

def RegisterSize(frame, name):
    sizeName = "FrameSize_" + name
    if sizeName in Data.Option:
       size = Data.Option[sizeName]
       frame.SetSize(size)

    def OnSize(event):
        Data.Option[sizeName] = event.GetSize()
        event.Skip()

    wx.EVT_SIZE(frame, OnSize)

def RegisterPos(frame, name):
    posName = "FramePos_" + name
    if posName in Data.Option:
       pos = Data.Option[posName]
       frame.SetPosition(pos)

    def OnMove(event):
        pos = event.GetPosition()
        if pos.x > 0 and pos.y > 0:
            if Data.platform == "win":
                Data.Option[posName] = (pos.x - 4, pos.y - 50)
            else:
                Data.Option[posName] = pos
        event.Skip()

    wx.EVT_MOVE(frame, OnMove)

def RegisterSizePos(frame, name):
    RegisterSize(frame, name)
    RegisterPos(frame, name)

def ClearRegistry():
    for key in Data.Option.keys():
        for prefix in ["FrameSize_", "FramePos_"]:
            if key.startswith(prefix):
                del Data.Option[key]

if debug: print "end ReportAids.py"
