#!/usr/bin/env python
# StartupData - initial data for new files
# generated by "Save as Script.py" on 2006-03-16

# Copyright 2004, 2005, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 060316 - Brian - moved initial data out of Data.py
# 060606 - Alex - added AllOrEach field to ReportType table
# 060704 - Brian - hide Project/Report as default
# 060715 - Brian - add AutoSaveOnQuit flag to options
# 060722 - Brian - added definitions from "Install Assignment Hours" script

debug = 1
if debug: print "load StartupData.py"

def GanttPVOptions():
    if debug: print "Running GanttPVOptions"
# these options are user preferences
    return {
        'AutoSaveOnQuit': True, # auto save on quit, don't prompt
        'AutoGantt' : True,  # Delay calculation of calendar and schedule changes
        'ConfirmScripts': True,  # scripts should display a confirm dialog
        'ScriptDirectory': None,  # where script directory is located
#           'HelpfulWarnings': True,  # display warning popups  -- do I want to do this?
# ProjecReport Colors
        'ParentColor': ( 153, 153, 255 ),
        'ChildColor': ( 238, 238, 238 ),
        'HiddenColor': ( 204, 204, 204 ),
        'DeletedColor': ( 255, 102, 204 ),
# Gantt Chart Colors
# background
        'WorkDay': (230, 230, 230),
        'WorkDaySelected': (153, 204, 255),
        'NotWorkDay': (204, 204, 204),
        'NotWorkDaySelected': (136, 187, 238),
# bars
        'PlanBar': (0, 153, 102),
        'PlanBarSelected': (0, 153, 102),
        'ActualBar': (238, 238, 102),
        'ActualBarSelected': (238, 238, 102),
        'BaseBar': (0, 0, 187),
        'BaseBarSelected': (0, 0, 187),
        'CompletionBar': (0, 0, 0),
        'CompletionBarSelected': (0, 0, 0),

#           'ResourceProblem': None,
#           'ResourceProblemSelected': None,

        }

## -- Generated from script -- start

#!/usr/bin/env python

# generated by "Save as Script - Startup Format.py" on 2006-07-22

def GanttPVData():
    if debug: print "Running GanttPVData"

# def ResetDatabase():  # from script
#     if not Data.AskIfUserWantsToSave("resetting database"):
#         return

    Database = {}

    def FillTable(name, columns, data):
        table = {}
        for row in data:
            record = {}
            for i, value in enumerate(row):
                if value or value == 0:
                    col = columns[i]
                    record[col] = value
                id = record['ID']
                table[id] = record
        Database[name] = table

    def _(message): return message  # used to defer translation


    Database[_('Assignment')] = {} 

    Database[_('AssignmentDay')] = {} 

    Database[_('AssignmentWeek')] = {} 

    name = _( 'ColumnType' )
    columns = ['ID', 'Name', 'Label', 'AccessType', 'DataType', 'Edit', 'Path', 'ReportTypeID', 'T', 'Width']
    data = [
        [1, 'ID', _('ID'), 'd', 'i', None, None, 1, 'A', None],
        [2, 'Name', _('Name'), 'd', 't', True, None, 1, 'A', 140],
        [3, 'StartDate', _('Start Date'), 'd', 'd', True, None, 1, 'A', 80],
        [4, 'TargetEndDate', _('Target\nEnd Date'), 'd', 'd', True, None, 1, 'A', 80],
        [5, 'ID', _('ID'), 'd', 'i', None, None, 2, 'B', None],
        [6, 'Name', _('Name'), 'd', 't', True, None, 2, 'B', 140],
        [7, 'ID', _('ID'), 'd', 'i', None, None, 3, 'A', None],
        [8, 'ProjectID', _('Project\nID'), 'd', 'i', True, None, 3, 'A', 80],
        [9, 'Name', _('Name'), 'd', 't', True, None, 3, 'A', 140],
        [10, 'StartDate', _('Start Date'), 'd', 'd', True, None, 3, 'A', 80],
        [11, 'DurationHours', _('Duration'), 'd', 'i', True, None, 3, 'A', 60],
        [12, 'CalculatedStartDate', _('Start Date\n(Calculated)'), 'd', 'd', None, None, 3, 'A', 80],
        [13, 'CalculatedEndDate', _('End Date\n(Calculated)'), 'd', 'd', None, None, 3, 'A', 80],
        [14, 'Day/Gantt', _('Day/Gantt'), 's', 'g', None, None, 3, 'X', None],
        [15, 'Day/Hours', _(None), 's', 'i', None, None, 3, 'X', None],
        [16, 'ID', _('ID'), 'd', 'i', None, None, 4, 'B', None],
        [17, 'Resource/Name', _('Resource/Name'), 'i', 't', True, None, 4, 'B', 140],
        [18, 'ID', _('ID'), 'd', 'i', None, None, 5, 'B', None],
        [19, 'Prerequisite/Name', _('Prerequisite/Name'), 'i', 't', True, None, 5, 'B', 140],
        [20, 'ID', _('ID'), 'd', 'i', None, None, 6, 'A', None],
        [21, 'Name', _('Name'), 'd', 't', True, None, 6, 'A', 140],
        [22, 'SelectColumn', _('Select\nColumn'), 'd', 't', None, None, 6, 'A', 80],
        [23, 'SelectValue', _('Select\nValue'), 'd', 'i', None, None, 6, 'A', 80],
        [24, 'ProjectID', _('Project\nID'), 'd', 'i', None, None, 6, 'A', None],
        [25, 'ID', _('ID'), 'd', 'i', None, None, 7, 'B', None],
        [26, 'Width', _('Width'), 'd', 'i', True, None, 7, 'B', 40],
        [27, 'Label', _('Label'), 'd', 't', True, None, 7, 'B', 140],
        [28, 'Periods', _('Periods'), 'd', 'i', True, None, 7, 'B', 40],
        [29, 'FirstDate', _('First\nDate'), 'd', 'd', True, None, 7, 'B', 80],
        [30, 'ID', _('ID'), 'd', 'i', None, None, 8, 'A', None],
        [31, 'ShortName', _('Short\nName'), 'd', 't', True, None, 8, 'A', 80],
        [32, 'Name', _('Name'), 'd', 't', True, None, 8, 'A', 140],
        [33, 'ID', _('ID'), 'd', 'i', None, None, 9, 'B', None],
        [34, 'Task/Name', _('Task/Name'), 'i', 't', True, None, 9, 'B', 140],
        [35, 'Day/Hours', _(None), 's', 'i', None, None, 9, 'X', None],
        [36, 'ID', _('ID'), 'd', 'i', None, None, 10, 'A', None],
        [37, 'Name', _('Name'), 'd', 't', True, None, 10, 'A', 140],
        [38, 'Date', _('Date'), 'd', 'd', True, None, 10, 'A', 80],
        [39, 'Hours', _('Hours'), 'd', 'i', True, None, 10, 'A', 60],
        [40, 'ID', _('ID'), 'd', 'i', None, None, 11, 'A', None],
        [41, 'Also', _('Also'), 'd', 'i', None, None, 11, 'A', 40],
        [42, 'Name', _('Name'), 'd', 't', None, None, 11, 'A', 140],
        [43, 'TableA', _('Table\nA'), 'd', 't', None, None, 11, 'A', 100],
        [44, 'TableB', _('Table\nB'), 'd', 't', None, None, 11, 'A', 100],
        [45, 'Label', _('Label'), 'd', 't', True, None, 11, 'A', 120],
        [46, 'ID', _('ID'), 'd', 'i', None, None, 12, 'B', None],
        [47, 'DataType', _('Data Type'), 'd', 't', None, None, 12, 'B', None],
        [48, 'AccessType', _('Access Type'), 'd', 't', None, None, 12, 'B', None],
        [49, 'Edit', _('Edit'), 'd', 'b', None, None, 12, 'B', None],
        [50, 'Name', _('Name'), 'd', 't', None, None, 12, 'B', 140],
        [51, 'Label', _('Label'), 'd', 't', True, None, 12, 'B', 140],
        [52, 'ActualEndDate', _('Actual\nEnd Date'), 'd', 'd', True, None, 1, 'A', 80],
        [53, 'Week/EffortHours', _('Week/Effort'), 's', 'i', True, None, 1, 'X', 40],
        [54, 'Project/Name', _('Project\nName'), 'i', 't', False, None, 3, 'A', 140],
        [55, 'EffortHours', _('Effort'), 'd', 'i', True, None, 3, 'A', 60],
        [56, 'ResourceNames', _('Resource\nNames'), 'list', 't', False, 'ID/Assignment/TaskID/ResourceID/Resource/Name', 3, 'A', 80],
        [57, 'ResourcesShortNames', _('Resource\nShort Names'), 'list', 't', False, 'ID/Assignment/TaskID/ResourceID/Resource/ShortName', 3, 'A', 80],
        [58, 'ActualEndDate', _('Actual\nEnd Date'), 'd', 'd', True, None, 3, 'A', 80],
        [59, 'Week/EffortHours', _('Week/Effort'), 's', 'i', True, None, 3, 'X', 40],
        [60, 'Day/EffortHours', _('Day/Effort'), 's', 'i', True, None, 3, 'X', 40],
        [61, 'Role', _('Role'), 'd', 't', True, None, 4, 'B', 80],
        [62, 'EffortHours', _('Assignment\nEffort'), 'd', 'i', True, None, 4, 'B', 80],
        [63, 'Week/EffortHours', _('Week/Effort'), 's', 'i', True, None, 8, 'X', 40],
        [64, 'Day/EffortHours', _('Day/Effort'), 's', 'i', True, None, 8, 'X', 40],
        [65, 'Task/ProjectID', _('Project\nID'), 'i', 'i', False, None, 9, 'B', 60],
        [66, 'EffortHours', _('Assignment\nEffort'), 'd', 'i', True, None, 9, 'B', 80],
        ]
    FillTable(name, columns, data)

    Database[_('Dependency')] = {} 

    Database[_('Holiday')] = {} 

    Database[_('NextID')] = {'ResourceWeek': 1, 'ResourceDay': 1, 'Task': 2, 'Resource': 2, 'AssignmentDay': 1, 'TaskWeek': 1, 'TaskDay': 1, 'Assignment': 1, 'AssignmentWeek': 1, 'ReportRow': 87, 'Project': 3, 'Dependency': 1, 'ReportType': 13, 'ProjectWeek': 1, 'Report': 5, 'ColumnType': 67, 'ReportColumn': 15, 'Holiday': 1, 'Other': 2} 

    name = _( 'Other' )
    columns = ['ID', 'WeekHours']
    data = [
        [1, (8, 8, 8, 8, 8, 0, 0)],
        ]
    FillTable(name, columns, data)

    Database[_('OtherData')] = Database['Other']

    name = _( 'Prerequisite' )
    columns = ['ID', 'Name', 'CalculatedStartDate', 'ProjectID', 'TotalFloatHours']
    data = [
        [1, 'First Task', '2006-07-24', 2, 0],
        ]
    FillTable(name, columns, data)

    name = _( 'Project' )
    columns = ['ID', 'Name']
    data = [
        [1, 'All Projects'],
        [2, 'New Project'],
        ]
    FillTable(name, columns, data)

    Database[_('ProjectWeek')] = {} 

    name = _( 'Report' )
    columns = ['ID', 'Name', 'FirstColumn', 'FirstRow', 'FrameSizeH', 'FrameSizeW', 'Open', 'ProjectID', 'ReportTypeID', 'SelectColumn', 'SelectValue', 'ShowHidden']
    data = [
        [1, 'Project/Report List (Main Window)', 1, 1, 313, 422, True, 1, 2, None, None, False],
        [2, 'Report Options', 4, 8, 678, 446, None, 1, 12, None, None, None],
        [3, 'Resource List', 5, 71, None, None, None, 1, 8, None, None, None],
        [4, 'Gantt Chart (Task)', 6, 4, 311, 768, None, 2, 3, 'ProjectID', 2, None],
        ]
    FillTable(name, columns, data)

    name = _( 'ReportColumn' )
    columns = ['ID', 'Label', 'A', 'B', 'ColumnTypeID', 'NextColumn', 'Periods', 'ReportID', 'Time', 'TypeA', 'TypeB', 'Width']
    data = [
        [1, 'Name', 'Name', 'Name', 2, 2, None, 1, None, 'CHAR', 'CHAR', 140],
        [2, 'Start Date', 'StartDate', None, 3, 3, None, 1, None, 'DATE', None, 80],
        [3, 'Target Date', 'TargetEndDate', None, 4, None, None, 1, None, 'DATE', None, 80],
        [4, 'Name', 'Name', None, 42, 12, None, 2, None, 'CHAR', None, 140],
        [5, 'Name', 'Name', None, 32, None, None, 3, None, 'CHAR', None, 140],
        [6, 'Name', 'Name', None, 9, 7, None, 4, None, 'CHAR', None, 140],
        [7, 'Start Date', 'StartDate', None, 10, 8, None, 4, None, 'DATE', None, 80],
        [8, 'Duration', 'DurationHours', None, 11, 13, None, 4, None, 'INT', None, 60],
        [9, 'Start Date\n(Calculated)', 'CalculatedStartDate', None, 12, 14, None, 4, None, 'DATE', None, 80],
        [10, 'End Date\n(Calculated)', 'CalculatedEndDate', None, 13, 11, None, 4, None, 'DATE', None, 80],
        [11, None, None, None, 14, None, 21, 4, 'Day', 'CHART', None, None],
        [12, None, None, None, 50, None, None, 2, None, None, None, 140],
        [13, None, None, None, 55, 9, None, 4, None, None, None, 60],
        [14, None, None, None, 56, 11, None, 4, None, None, None, 80],
        ]
    FillTable(name, columns, data)

    name = _( 'ReportRow' )
    columns = ['ID', 'Hidden', 'NextRow', 'ParentRow', 'ReportID', 'TableID', 'TableName']
    data = [
        [1, None, 5, None, 1, 1, 'Project'],
        [2, None, 3, None, 1, 2, 'Project'],
        [3, None, None, 2, 1, 4, 'Report'],
        [4, None, None, None, 4, 1, 'Task'],
        [5, True, 6, 1, 1, 1, 'Report'],
        [6, True, 7, 1, 1, 2, 'Report'],
        [7, None, 2, 1, 1, 3, 'Report'],
        [8, None, 20, None, 2, 1, 'ReportType'],
        [9, None, 24, None, 2, 2, 'ReportType'],
        [10, None, 26, None, 2, 3, 'ReportType'],
        [11, None, 35, None, 2, 4, 'ReportType'],
        [12, None, 37, None, 2, 5, 'ReportType'],
        [13, True, 39, None, 2, 6, 'ReportType'],
        [14, True, 44, None, 2, 7, 'ReportType'],
        [15, None, 49, None, 2, 8, 'ReportType'],
        [16, None, 52, None, 2, 9, 'ReportType'],
        [17, None, 55, None, 2, 10, 'ReportType'],
        [18, True, 59, None, 2, 11, 'ReportType'],
        [19, True, 65, None, 2, 12, 'ReportType'],
        [20, None, 21, 8, 2, 1, 'ColumnType'],
        [21, None, 22, 8, 2, 2, 'ColumnType'],
        [22, None, 23, 8, 2, 3, 'ColumnType'],
        [23, None, 72, 8, 2, 4, 'ColumnType'],
        [24, None, 25, 9, 2, 5, 'ColumnType'],
        [25, None, 10, 9, 2, 6, 'ColumnType'],
        [26, None, 27, 10, 2, 7, 'ColumnType'],
        [27, None, 34, 10, 2, 8, 'ColumnType'],
        [28, None, 29, 10, 2, 9, 'ColumnType'],
        [29, None, 30, 10, 2, 10, 'ColumnType'],
        [30, None, 75, 10, 2, 11, 'ColumnType'],
        [31, None, 32, 10, 2, 12, 'ColumnType'],
        [32, None, 78, 10, 2, 13, 'ColumnType'],
        [33, None, 80, 10, 2, 14, 'ColumnType'],
        [34, True, 74, 10, 2, 15, 'ColumnType'],
        [35, None, 36, 11, 2, 16, 'ColumnType'],
        [36, None, 81, 11, 2, 17, 'ColumnType'],
        [37, None, 38, 12, 2, 18, 'ColumnType'],
        [38, None, 13, 12, 2, 19, 'ColumnType'],
        [39, None, 40, 13, 2, 20, 'ColumnType'],
        [40, None, 41, 13, 2, 21, 'ColumnType'],
        [41, True, 42, 13, 2, 22, 'ColumnType'],
        [42, True, 43, 13, 2, 23, 'ColumnType'],
        [43, None, 14, 13, 2, 24, 'ColumnType'],
        [44, None, 45, 14, 2, 25, 'ColumnType'],
        [45, True, 46, 14, 2, 26, 'ColumnType'],
        [46, None, 47, 14, 2, 27, 'ColumnType'],
        [47, None, 48, 14, 2, 28, 'ColumnType'],
        [48, None, 15, 14, 2, 29, 'ColumnType'],
        [49, None, 51, 15, 2, 30, 'ColumnType'],
        [50, None, 84, 15, 2, 31, 'ColumnType'],
        [51, None, 50, 15, 2, 32, 'ColumnType'],
        [52, None, 53, 16, 2, 33, 'ColumnType'],
        [53, None, 54, 16, 2, 34, 'ColumnType'],
        [54, True, 85, 16, 2, 35, 'ColumnType'],
        [55, None, 56, 17, 2, 36, 'ColumnType'],
        [56, None, 57, 17, 2, 37, 'ColumnType'],
        [57, None, 58, 17, 2, 38, 'ColumnType'],
        [58, None, 18, 17, 2, 39, 'ColumnType'],
        [59, None, 60, 18, 2, 40, 'ColumnType'],
        [60, True, 61, 18, 2, 41, 'ColumnType'],
        [61, None, 62, 18, 2, 42, 'ColumnType'],
        [62, True, 63, 18, 2, 43, 'ColumnType'],
        [63, True, 64, 18, 2, 44, 'ColumnType'],
        [64, None, 19, 18, 2, 45, 'ColumnType'],
        [65, None, 66, 19, 2, 46, 'ColumnType'],
        [66, True, 67, 19, 2, 47, 'ColumnType'],
        [67, True, 68, 19, 2, 48, 'ColumnType'],
        [68, True, 69, 19, 2, 49, 'ColumnType'],
        [69, None, 70, 19, 2, 50, 'ColumnType'],
        [70, None, None, 19, 2, 51, 'ColumnType'],
        [71, None, None, None, 3, 1, 'Resource'],
        [72, None, 73, 8, 2, 52, 'ColumnType'],
        [73, None, 9, 8, 2, 53, 'ColumnType'],
        [74, None, 28, 10, 2, 54, 'ColumnType'],
        [75, None, 31, 10, 2, 55, 'ColumnType'],
        [76, None, 77, 10, 2, 56, 'ColumnType'],
        [77, None, 33, 10, 2, 57, 'ColumnType'],
        [78, None, 76, 10, 2, 58, 'ColumnType'],
        [79, None, 11, 10, 2, 59, 'ColumnType'],
        [80, None, 79, 10, 2, 60, 'ColumnType'],
        [81, None, 82, 11, 2, 61, 'ColumnType'],
        [82, None, 12, 11, 2, 62, 'ColumnType'],
        [83, None, 16, 15, 2, 63, 'ColumnType'],
        [84, None, 83, 15, 2, 64, 'ColumnType'],
        [85, None, 86, 16, 2, 65, 'ColumnType'],
        [86, None, 17, 16, 2, 66, 'ColumnType'],
        ]
    FillTable(name, columns, data)

    name = _( 'ReportType' )
    columns = ['ID', 'Name', 'AllOrEach', 'Also', 'SuggestedColumns', 'TableA', 'TableB']
    data = [
        [1, 'Project', 'all', None, ',Name;,StartDate;,TargetEndDate;,Week/EffortHours,,13', 'Project', None],
        [2, 'Project/Report', 'all', 1, 'Project,Name;,Name', 'Project', 'Report'],
        [3, 'Task', 'both', None, ',Name;,StartDate;,DurationHours;,EffortHours;,CalculatedStartDate;,ResourceNames;,Day/Gantt,,21', 'Task', None],
        [4, 'Task/Assignment', 'each', 3, 'Task,Name;Task,DurationHours;Task,EffortHours;,Resource/Name;,Role;,EffortHours;Task,Day/EffortHours,,21', 'Task', 'Assignment'],
        [5, 'Task/Dependency', 'both', 3, 'Task,Name;,Prerequisite/Name', 'Task', 'Dependency'],
        [6, 'Report', 'all', None, None, 'Report', None],
        [7, 'Report/ReportColumn', 'all', 6, None, 'Report', 'ReportColumn'],
        [8, 'Resource', 'all', None, ',Name;,Day/EffortHours,,21', 'Resource', None],
        [9, 'Resource/Assignment', 'all', 8, 'Resource,Name;,Task/Name;,Role;,EffortHours;Resource,Day/EffortHours,,21', 'Resource', 'Assignment'],
        [10, 'Holiday', 'all', None, ',Name;,Date;,Hours', 'Holiday', None],
        [11, 'ReportType', 'all', None, None, 'ReportType', None],
        [12, 'ReportType/ColumnType', 'all', 11, None, 'ReportType', 'ColumnType'],
        ]
    FillTable(name, columns, data)

    name = _( 'Resource' )
    columns = ['ID', 'Name']
    data = [
        [1, 'First Resource'],
        ]
    FillTable(name, columns, data)

    Database[_('ResourceDay')] = {} 

    Database[_('ResourceWeek')] = {} 

    Database[_('Task')] = Database['Prerequisite']

    Database[_('TaskDay')] = {} 

    Database[_('TaskWeek')] = {} 

    del _  # used to defer translation

    return Database

#    Data.CloseReports()
#    Data.Database = Database
#    Data.MakeReady()

#ResetDatabase()

## -- Generated from script -- end

if debug: print "end StartupData.py"

