#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4.1 on Tue Jul 04 12:02:33 2006

# Copyright 2004, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050409 - Alexander - revised MultipleSelection, added resize border.
# 050426 - Alexander - assigned a keyboard shortcut to Redo item.
# 050504 - Alexander - added Window menu; added "Close Reports" to File menu; assigned keyboard shortcuts to "Save As" and "Close Reports"
# 050515 - Alexander - changed some filenames to use my latest icons
# 050518 - Alexander - fixed a serious scrollbar bug by commenting out SetSizeHints calls
# 050518 - Alexander - changed ReportFrame to use the size given in its __init__ arguments
# 060203 - Alexander - added Revert to FileMenu; call them database files instead of project files
# 060325 - Alex - de-capitalize modifier keys in menu shortcuts
# 060704 - Brian - revised menus and language support for 0.7
# 060811 - Brian - prevent automatic add of second Window menu
# 061229 - Brian - added edit project and report names to menu
# 070228 - Brian - add code to use smaller 'About' font on windows.
# 080519 - Brian - make diagram frame from report frame

import wx, ID, Menu, Data

class MainFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MainFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.Main_Panel = wx.Panel(self, -1)
        
        # Menu Bar
        self.main_menubar = wx.MenuBar()
        try:
            self.main_menubar.SetAutoWindowMenu(0)
        except AttributeError:
            pass
        self.SetMenuBar(self.main_menubar)
        self.FileMenu = wx.Menu()
        self.New = wx.MenuItem(self.FileMenu, wx.ID_NEW, _("New\tCtrl-N"), _("Create a new database file; close open database (if any)"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.New)
        self.Open = wx.MenuItem(self.FileMenu, wx.ID_OPEN, _("Open...\tCtrl-O"), _("Open existing database file"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Open)
        openselectedreport = wx.MenuItem(self.FileMenu, ID.M_OPEN_REPORT, _("Open Selected Report"), _("Open selected report in a new window"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(openselectedreport)
        self.FileMenu.AppendSeparator()
        self.CloseReport = wx.MenuItem(self.FileMenu, wx.ID_CLOSE, _("Close Report\tCtrl-W"), _("Close report window"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.CloseReport)
        self.CloseAllReports = wx.MenuItem(self.FileMenu, wx.ID_CLOSE_ALL, _("Close All Reports\tCtrl-Alt-W"), _("Close all reports except main"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.CloseAllReports)
        self.Save = wx.MenuItem(self.FileMenu, wx.ID_SAVE, _("Save\tCtrl-S"), _("Save project file"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Save)
        self.SaveAs = wx.MenuItem(self.FileMenu, wx.ID_SAVEAS, _("Save As...\tCtrl-Shift-S"), _("Save database file with new name"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.SaveAs)
        self.AutoSave = wx.MenuItem(self.FileMenu, ID.M_AUTO_SAVE, _("Automatically Save On Quit"), _("Automatically save database when it is closed"), wx.ITEM_CHECK)
        self.FileMenu.AppendItem(self.AutoSave)
        self.FileMenu.AppendSeparator()
        self.RevertToSaved = wx.MenuItem(self.FileMenu, wx.ID_REVERT, _("Revert to Last Saved"), _("Revert the database to the last manually saved version"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.RevertToSaved)
        self.RevertToOpened = wx.MenuItem(self.FileMenu, ID.M_REVERT_OPEN, _("Revert to Last Opened"), _("Revert the database to the way it was when first opened"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.RevertToOpened)
        self.FileMenu.AppendSeparator()
        self.Quit = wx.MenuItem(self.FileMenu, wx.ID_EXIT, _("Quit\tCtrl-Q"), _("Quit program"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Quit)
        self.main_menubar.Append(self.FileMenu, _("File"))
        self.Edit = wx.Menu()
        self.Undo = wx.MenuItem(self.Edit, wx.ID_UNDO, _("Undo\tCtrl-Z"), _("Undo last change"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.Undo)
        self.Redo = wx.MenuItem(self.Edit, wx.ID_REDO, _("Redo\tCtrl-Shift-Z"), _("Redo change"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.Redo)
        self.Edit.AppendSeparator()
        self.InsertProject = wx.MenuItem(self.Edit, ID.M_INSERT_PROJECT, _("Insert New Project"), _("Insert new project after the selected row"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.InsertProject)
        self.InsertReport = wx.MenuItem(self.Edit, ID.M_INSERT_REPORT, _("Insert New Report..."), _("Insert a new report"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.InsertReport)
        self.Edit.AppendSeparator()
        self.DeleteRow = wx.MenuItem(self.Edit, ID.M_DELETE_ROW, _("Delete Selected Row"), _("Delete the selected row"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.DeleteRow)
        self.Edit.AppendSeparator()
        self.MoveRowUp = wx.MenuItem(self.Edit, ID.M_MOVE_ROW_UP, _("Move Selected Row Up\tCtrl-9"), _("Move the selected row up one posiion (if possible)"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.MoveRowUp)
        self.MoveRowDown = wx.MenuItem(self.Edit, ID.M_MOVE_ROW_DOWN, _("Move Selected Row Down\tCtrl-0"), _("Move the selected row down (if possible)"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.MoveRowDown)
        self.Edit.AppendSeparator()
        editprojectname = wx.MenuItem(self.Edit, ID.M_EDIT_PROJECT_NAME, _("Edit Project Name..."), _("Edit the name of the selected project"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(editprojectname)
        editreportname = wx.MenuItem(self.Edit, ID.M_EDIT_REPORT_NAME, _("Edit Report Name..."), _("Edit the name of the selected report"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(editreportname)
        self.main_menubar.Append(self.Edit, _("Edit"))
        self.Script = wx.Menu()
        self.FindScripts = wx.MenuItem(self.Script, ID.FIND_SCRIPTS, _("Choose Scripts Folder..."), _("Specify location of scripts folder"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.FindScripts)
        self.RefreshScripts = wx.MenuItem(self.Script, ID.REFRESH_SCRIPTS, _("Refresh Script Menu"), _("Update the script menu to include changes to the script folder"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.RefreshScripts)
        self.RepeatScript = wx.MenuItem(self.Script, ID.REPEAT_SCRIPT, _("Repeat Previous Script\tCtrl-8"), _("Re-run the previous script"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.RepeatScript)
        self.main_menubar.Append(self.Script, _("Script"))
        wxglade_tmp_menu = wx.Menu()
        self.WindowMenu = wxglade_tmp_menu
        self.FirstWindow = wx.MenuItem(wxglade_tmp_menu, ID.FIRST_WINDOW, _("Main Window\tCtrl-1"), _("Bring the main window to front"), wx.ITEM_CHECK)
        wxglade_tmp_menu.AppendItem(self.FirstWindow)
        self.WindowMenu.Check(ID.FIRST_WINDOW, True)
        self.main_menubar.Append(wxglade_tmp_menu, _("Window"))
        self.Help = wx.Menu()
        self.About = wx.MenuItem(self.Help, wx.ID_ABOUT, _("About GanttPV..."), "", wx.ITEM_NORMAL)
        self.Help.AppendItem(self.About)
        self.QuickStart = wx.MenuItem(self.Help, ID.QUICK_START, _("Quick Start..."), _("Provide hints on how to use report"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.QuickStart)
        self.ORMQuickStart = wx.MenuItem(self.Help, ID.ORM_QUICK_START, _("ORM Quick Start..."), _("Provide hints on how to use ORM"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.ORMQuickStart)
        self.ShortCuts = wx.MenuItem(self.Help, ID.SHORT_CUTS, _("Shortcuts..."), _("Displays most the most useful shortcuts"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.ShortCuts)
        self.HomePage = wx.MenuItem(self.Help, ID.HOME_PAGE, _("GanttPV Home"), _("Open GanttPV home page in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HomePage)
        self.HelpPage = wx.MenuItem(self.Help, ID.HELP_PAGE, _("Help Page and Tour"), _("Open GanttPV help page in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HelpPage)
        self.HelpBook = wx.MenuItem(self.Help, ID.HELP_BOOK, _("GanttPV Book"), _("Open GanttPV Book web page in browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HelpBook)
        self.Forum = wx.MenuItem(self.Help, ID.FORUM, _("Forum"), _("Open GanttPV user forum in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.Forum)
        self.main_menubar.Append(self.Help, _("&Help"))
        # Menu Bar end
        self.main_statusbar = self.CreateStatusBar(1, 0)
        
        # Tool Bar
        self.main_toolbar = wx.ToolBar(self, -1)
        self.main_toolbar.SetToolBitmapSize((16, 16))  # change
        self.SetToolBar(self.main_toolbar)
        self.main_toolbar.AddLabelTool(ID.NEW_PROJECT, _("New Project"), Menu.Bitmap("icons/New Project.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("New Project"), _("Create a new project record"))
        self.main_toolbar.AddLabelTool(ID.NEW_REPORT, _("New Report"), Menu.Bitmap("icons/Insert Report.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("New Report"), _("Create a new report for selected project"))
        self.main_toolbar.AddLabelTool(ID.DUPLICATE, _("Duplicate"), Menu.Bitmap("icons/Duplicate.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Duplicate"), _("Duplicate selected project or report"))
        self.main_toolbar.AddSeparator()
        self.main_toolbar.AddLabelTool(ID.DELETE, _("Delete"), Menu.Bitmap("icons/Delete.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Delete"), _("Delete selected project or report"))
        self.main_toolbar.AddLabelTool(ID.SHOW_HIDDEN_REPORT, _("Show Hidden"), Menu.Bitmap("icons/Show Hidden.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_CHECK, _("Show Hidden"), _("Hide/show hidden and deleted records"))
        self.main_toolbar.AddSeparator()
        self.main_toolbar.AddLabelTool(ID.MOVE_UP, _("Move Up"), Menu.Bitmap("icons/Move Up.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Row Up"), _("Move selected rows up"))
        self.main_toolbar.AddLabelTool(ID.MOVE_DOWN, _("Move Down"), Menu.Bitmap("icons/Move Down.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Row Down"), _("Move selected rows down"))
        # Tool Bar end
#        self.main_list = wx.ListCtrl(self.Main_Panel, -1, style=wx.LC_REPORT|wx.LC_SINGLE_SEL|wx.SUNKEN_BORDER)

#        self.__set_properties()
#        self.__do_layout()
        # end wxGlade

    def set_properties(self):
        # begin wxGlade: MainFrame.__set_properties
        self.SetTitle(_("Main"))
        self.SetSize((422, 313))
        self.main_statusbar.SetStatusWidths([-1])
        # statusbar fields
#        main_statusbar_fields = [_("frame_1_statusbar")]
#        for i in range(len(main_statusbar_fields)):
#            self.main_statusbar.SetStatusText(main_statusbar_fields[i], i)
        self.main_toolbar.Realize()
        # end wxGlade

    def do_layout(self):
        # begin wxGlade: MainFrame.__do_layout
        sizer_28 = wx.BoxSizer(wx.VERTICAL)
        sizer_29 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_30 = wx.BoxSizer(wx.VERTICAL)
        sizer_29.Add((10, 10), 0, 0, 0)
        sizer_30.Add((10, 10), 0, 0, 0)
        sizer_30.Add(self.main_list, 1, wx.EXPAND, 0)
        sizer_30.Add((10, 10), 0, 0, 0)
        sizer_29.Add(sizer_30, 1, wx.EXPAND, 0)
        sizer_29.Add((10, 10), 0, 0, 0)
        self.Main_Panel.SetAutoLayout(True)
        self.Main_Panel.SetSizer(sizer_29)
        sizer_29.Fit(self.Main_Panel)
        # sizer_29.SetSizeHints(self.Main_Panel)  # change
        sizer_28.Add(self.Main_Panel, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_28)
        self.Layout()
        self.Centre()
        # end wxGlade

# end of class MainFrame


class ReportFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: ReportFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.Report_Panel = wx.Panel(self, -1)
        
        # Menu Bar
        self.report_menubar = wx.MenuBar()
        self.SetMenuBar(self.report_menubar)
        self.FileMenu = wx.Menu()
        self.New = wx.MenuItem(self.FileMenu, wx.ID_NEW, _("New\tCtrl-N"), _("Create a new database file; close open database (if any)"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.New)
        self.Open = wx.MenuItem(self.FileMenu, wx.ID_OPEN, _("Open...\tCtrl-O"), _("Open existing database file"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Open)
        self.FileMenu.AppendSeparator()
        self.CloseReport = wx.MenuItem(self.FileMenu, wx.ID_CLOSE, _("Close Report\tCtrl-W"), _("Close report window"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.CloseReport)
        self.CloseAllReports = wx.MenuItem(self.FileMenu, wx.ID_CLOSE_ALL, _("Close All Reports\tCtrl-Alt-W"), _("Close all reports except main"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.CloseAllReports)
        self.Save = wx.MenuItem(self.FileMenu, wx.ID_SAVE, _("Save\tCtrl-S"), _("Save project file"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Save)
        self.SaveAs = wx.MenuItem(self.FileMenu, wx.ID_SAVEAS, _("Save As...\tCtrl-Shift-S"), _("Save database file with new name"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.SaveAs)
        self.AutoSave = wx.MenuItem(self.FileMenu, ID.M_AUTO_SAVE, _("Automatically Save On Quit"), _("Automatically save database when it is closed"), wx.ITEM_CHECK)
        self.FileMenu.AppendItem(self.AutoSave)
        self.FileMenu.AppendSeparator()
        self.RevertToSaved = wx.MenuItem(self.FileMenu, wx.ID_REVERT, _("Revert to Last Saved"), _("Revert the database to the last manually saved version"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.RevertToSaved)
        self.RevertToOpened = wx.MenuItem(self.FileMenu, ID.M_REVERT_OPEN, _("Revert to Last Opened"), _("Revert the database to the way it was when first opened"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.RevertToOpened)
        self.FileMenu.AppendSeparator()
        self.Quit = wx.MenuItem(self.FileMenu, wx.ID_EXIT, _("Quit\tCtrl-Q"), _("Quit program"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Quit)
        self.report_menubar.Append(self.FileMenu, _("File"))
        self.Edit = wx.Menu()
        self.Undo = wx.MenuItem(self.Edit, wx.ID_UNDO, _("Undo\tCtrl-Z"), _("Undo last change"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.Undo)
        self.Redo = wx.MenuItem(self.Edit, wx.ID_REDO, _("Redo\tCtrl-Shift-Z"), _("Redo change"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.Redo)
        self.Edit.AppendSeparator()
        copy = wx.MenuItem(self.Edit, wx.ID_COPY, _("Copy\tCtrl-C"), _("Copy cells in current selection to clipboard"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(copy)
        paste = wx.MenuItem(self.Edit, wx.ID_PASTE, _("Paste\tCtrl-V"), _("Paste cells from clipboard"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(paste)
        self.Edit.AppendSeparator()
        self.InsertRow = wx.MenuItem(self.Edit, ID.M_INSERT_ROW, _("Insert New %s\tCtrl-R"), _("Insert new %s below the selected row"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.InsertRow)
        self.InsertRowAbove = wx.MenuItem(self.Edit, ID.M_INSERT_ROW_ABOVE, _("Insert New %s Above Selection\tCtrl-Shift-R"), _("Insert a new %s above the selected row"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.InsertRowAbove)
##        self.InsertChild = wx.MenuItem(self.Edit, ID.M_INSERT_CHILD, _("Insert Child %s"), _("Insert a child %s"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.InsertChild)
        self.InsertRelated = wx.MenuItem(self.Edit, ID.M_INSERT_RELATED, _("Insert Related %s"), _("Insert a new %s"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.InsertRelated)
        self.Edit.AppendSeparator()
        self.DeleteRow = wx.MenuItem(self.Edit, ID.M_DELETE_ROW, _("Delete Selected Row"), _("Delete the selected row"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.DeleteRow)
        self.Edit.AppendSeparator()
        self.MoveRowUp = wx.MenuItem(self.Edit, ID.M_SHIFT_LEFT, _("Shift Left\tCtrl-Shift-9"), _("Shift left (to next higher level)"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.MoveRowUp)
        self.MoveRowDown = wx.MenuItem(self.Edit, ID.M_SHIFT_RIGHT, _("Shift Right\tCtrl-Shift-0"), _("Shift right (to next lower level)"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.MoveRowDown)
        self.Edit.AppendSeparator()
        self.MoveRowUp = wx.MenuItem(self.Edit, ID.M_MOVE_ROW_UP, _("Move Selected Row Up\tCtrl-9"), _("Move the selected row up one posiion (if possible)"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.MoveRowUp)
        self.MoveRowDown = wx.MenuItem(self.Edit, ID.M_MOVE_ROW_DOWN, _("Move Selected Row Down\tCtrl-0"), _("Move the selected row down (if possible)"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.MoveRowDown)
        self.Edit.AppendSeparator()
        editprojectname = wx.MenuItem(self.Edit, ID.M_EDIT_PROJECT_NAME, _("Edit Project Name..."), _("Edit the name of the project that owns this report"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(editprojectname)
        editreportname = wx.MenuItem(self.Edit, ID.M_EDIT_REPORT_NAME, _("Edit Report Name..."), _("Edit the name of this report"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(editreportname)
        self.report_menubar.Append(self.Edit, _("Edit"))
        wxglade_tmp_menu = wx.Menu()
        self.Action = wxglade_tmp_menu
        self.AssignPrerequisite = wx.MenuItem(wxglade_tmp_menu, ID.M_ASSIGN_PREREQUISITE, _("Define Prerequisite for Task..."), _("Assign prerequisite for selected task"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.AssignPrerequisite)
        self.LinkTasks = wx.MenuItem(wxglade_tmp_menu, ID.M_LINK_TASKS, _("Link Selected Tasks as Dependent"), _("Link tasks as dependent in the order they appear in the report"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.LinkTasks)
        self.AssignResource = wx.MenuItem(wxglade_tmp_menu, ID.M_ASSIGN_RESOURCE, _("Assign Resource to Task..."), _("Assign resources to the selected task"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.AssignResource)
        wxglade_tmp_menu.AppendSeparator()
        self.AssignResourceToGroup = wx.MenuItem(wxglade_tmp_menu, ID.M_RESOURCE_TO_GROUP, _("Assign Resource to Resource Group..."), _("Identify the groups to which the selected resource belongs"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.AssignResourceToGroup)
        self.DefineGroupMembers = wx.MenuItem(wxglade_tmp_menu, ID.M_DEFINE_RESOURCE_GROUP, _("Define Members of Resource Group..."), _("Define which resources are members of the specified resource group"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.DefineGroupMembers)
        self.AssignTask = wx.MenuItem(wxglade_tmp_menu, ID.M_ASSIGN_TASK, _("Assign Task to Resource..."), _("Specify all tasks assignments for a resource"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.AssignTask)
        self.report_menubar.Append(wxglade_tmp_menu, _("Action"))
        wxglade_tmp_menu = wx.Menu()
        self.View = wxglade_tmp_menu
        self.InsertColumn = wx.MenuItem(wxglade_tmp_menu, ID.M_INSERT_COLUMN, _("Insert Column..."), _("Insert a new column before selection"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.InsertColumn)
        wxglade_tmp_menu.AppendSeparator()
        self.DeleteColumn = wx.MenuItem(wxglade_tmp_menu, ID.M_DELETE_COLUMN, _("Delete Selected Column"), _("Delete the selected column from the report"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.DeleteColumn)
        wxglade_tmp_menu.AppendSeparator()
        self.MoveColumnLeft = wx.MenuItem(wxglade_tmp_menu, ID.M_MOVE_COLUMN_LEFT, _("Move Selected Column Left"), _("Move the selected column to the left"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.MoveColumnLeft)
        self.MoveColumnRight = wx.MenuItem(wxglade_tmp_menu, ID.M_MOVE_COLUMN_RIGHT, _("Move Selected Column Right"), _("Move the selected column to the right"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.MoveColumnRight)
        wxglade_tmp_menu.AppendSeparator()
        self.ScrollLeftFast = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_LEFT_FAST, _("Scroll Timescale Left Fast"), _("Shift the selected time scale several periods to the left"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.ScrollLeftFast)
        self.ScrollLeft = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_LEFT, _("Scroll Timescale Left"), _("Shift the selected time scale one period to the left"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.ScrollLeft)
        self.ScrollRight = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_RIGHT, _("Scroll Timescale Right"), _("Shift the selected time scale one period to the right"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.ScrollRight)
        self.ScrollRightFast = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_RIGHT_FAST, _("Scroll Timescale Right Fast"), _("Shift the selected time scale several periods to the right"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.ScrollRightFast)
        self.ScrollToTask = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_TO_TASK, _("Scroll Timescale to Task Start Date"), _("Scroll timescales to the selected task's start date"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendItem(self.ScrollToTask)
        self.report_menubar.Append(wxglade_tmp_menu, _("View"))
        self.Script = wx.Menu()
        self.FindScripts = wx.MenuItem(self.Script, ID.FIND_SCRIPTS, _("Choose Scripts Folder..."), _("Specify location of scripts folder"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.FindScripts)
        self.RefreshScripts = wx.MenuItem(self.Script, ID.REFRESH_SCRIPTS, _("Refresh Script Menu"), _("Update the script menu to include changes to the script folder"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.RefreshScripts)
        self.RepeatScript = wx.MenuItem(self.Script, ID.REPEAT_SCRIPT, _("Repeat Previous Script\tCtrl-8"), _("Re-run the previous script"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.RepeatScript)
        self.report_menubar.Append(self.Script, _("Script"))
        wxglade_tmp_menu = wx.Menu()
        self.WindowMenu = wxglade_tmp_menu
        self.FirstWindow = wx.MenuItem(wxglade_tmp_menu, ID.FIRST_WINDOW, _("Main Window\tCtrl-1"), _("Bring the main window to front"), wx.ITEM_CHECK)
        wxglade_tmp_menu.AppendItem(self.FirstWindow)
        # self.WindowMenu.Check(ID.FIRST_WINDOW, True)
        self.report_menubar.Append(wxglade_tmp_menu, _("Window"))
        self.Help = wx.Menu()
        self.About = wx.MenuItem(self.Help, wx.ID_ABOUT, _("About GanttPV..."), "", wx.ITEM_NORMAL)
        self.Help.AppendItem(self.About)
        self.QuickStart = wx.MenuItem(self.Help, ID.QUICK_START, _("Quick Start..."), _("Provide hints on how to use report"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.QuickStart)
        self.ORMQuickStart = wx.MenuItem(self.Help, ID.ORM_QUICK_START, _("ORM Quick Start..."), _("Provide hints on how to use ORM"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.ORMQuickStart)
        self.ShortCuts = wx.MenuItem(self.Help, ID.SHORT_CUTS, _("Shortcuts..."), _("Displays most the most useful shortcuts"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.ShortCuts)
        self.HomePage = wx.MenuItem(self.Help, ID.HOME_PAGE, _("GanttPV Home"), _("Open GanttPV home page in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HomePage)
        self.HelpPage = wx.MenuItem(self.Help, ID.HELP_PAGE, _("Help Page and Tour"), _("Open GanttPV help page in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HelpPage)
        self.HelpBook = wx.MenuItem(self.Help, ID.HELP_BOOK, _("GanttPV Book"), _("Open GanttPV Book web page in browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HelpBook)
        self.Forum = wx.MenuItem(self.Help, ID.FORUM, _("Forum"), _("Open GanttPV user forum in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.Forum)
        self.report_menubar.Append(self.Help, _("&Help"))
        # Menu Bar end
        self.report_statusbar = self.CreateStatusBar(1, 0)
        
        # Tool Bar
        self.report_toolbar = wx.ToolBar(self, -1)
        self.report_toolbar.SetToolBitmapSize((16, 16))  # change
        self.SetToolBar(self.report_toolbar)
        self.report_toolbar.AddLabelTool(ID.INSERT_ROW, _("Insert %s"), Menu.Bitmap("icons/Insert Row.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Insert new %s"), _("Insert new %s below selection"))
        self.report_toolbar.AddLabelTool(ID.DUPLICATE_ROW, _("Duplicate %s"), Menu.Bitmap("icons/Duplicate.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Duplicate %s"), _("Duplicate selected %s"))
        self.report_toolbar.AddLabelTool(ID.DELETE_ROW, _("Delete Row"), Menu.Bitmap("icons/Delete Row.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Delete Row"), _("Delete selected rows"))
        self.report_toolbar.AddLabelTool(ID.MOVE_UP, _("Move Up"), Menu.Bitmap("icons/Move Up.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Row Up"), _("Move selected rows up"))
        self.report_toolbar.AddLabelTool(ID.MOVE_DOWN, _("Move Down"), Menu.Bitmap("icons/Move Down.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Row Down"), _("Move selected rows down"))
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddLabelTool(ID.PREREQUISITE, _("Assign Prerequisite"), Menu.Bitmap("icons/Assign Prerequisites.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Assign Prerequisite"), _("Identify prerequisites for selected task"))
        self.report_toolbar.AddLabelTool(ID.ASSIGN_RESOURCE, _("Assign Resource"), Menu.Bitmap("icons/Assign Resources.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Assign Resource"), _("Assign resources to selected task"))
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddLabelTool(ID.HIDE_ROW, _("Hide Row"), Menu.Bitmap("icons/Hide Report.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Hide Row"), _("Hide/show selected rows"))
        self.report_toolbar.AddLabelTool(ID.SHOW_HIDDEN, _("Show Hidden"), Menu.Bitmap("icons/Show Hidden.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_CHECK, _("Show Hidden"), _("Show or reveal hidden and deleted rows"))
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddLabelTool(ID.INSERT_COLUMN, _("Insert Column"), Menu.Bitmap("icons/Insert Column.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Insert Column"), _("Insert column types from popup list"))
        self.report_toolbar.AddLabelTool(ID.DELETE_COLUMN, _("Delete Column"), Menu.Bitmap("icons/Delete Column.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Delete Column"), _("Delete selected columns"))
        self.report_toolbar.AddLabelTool(ID.MOVE_LEFT, _("Move Left"), Menu.Bitmap("icons/Move Left.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Column Left"), _("Move selected columns to the left"))
        self.report_toolbar.AddLabelTool(ID.MOVE_RIGHT, _("Move Right"), Menu.Bitmap("icons/Move Right.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Column Right"), _("Move selected columns to the right"))
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddLabelTool(ID.COLUMN_OPTIONS, _("Column Options"), Menu.Bitmap("icons/Column Options.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Column Options"), _("Set options on selected column"))
        self.report_toolbar.AddSeparator()
        self.report_toolbar.AddLabelTool(ID.SCROLL_LEFT_FAR, _("Scroll Left Far"), Menu.Bitmap("icons/Scroll Left Fast.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Left"), _("Scroll left several time periods"))
        self.report_toolbar.AddLabelTool(ID.SCROLL_LEFT, _("Scroll Left"), Menu.Bitmap("icons/Scroll Left Slow.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Left"), _("Scroll left one time period"))
        self.report_toolbar.AddLabelTool(ID.SCROLL_RIGHT, _("Scroll Right"), Menu.Bitmap("icons/Scroll Right Slow.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Right"), _("Scroll right one time period"))
        self.report_toolbar.AddLabelTool(ID.SCROLL_RIGHT_FAR, _("Scroll Right Far"), Menu.Bitmap("icons/Scroll Right Fast.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Right"), _("Scroll right several time periods"))
        self.report_toolbar.AddLabelTool(ID.SCROLL_TO_TASK, _("Scroll To Task"), Menu.Bitmap("icons/Scroll to Task.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll To Task"), _("Scroll to display bar for selected task"))
        # Tool Bar end
#        self.report_window = GanttReport.GanttChartGrid(self.Report_Panel, -1, 537,  262, reportid)

#        self.__set_properties()
#        self.__do_layout()
        # end wxGlade

    def set_properties(self):
        # begin wxGlade: ReportFrame.__set_properties
#        self.SetTitle(_("Report"))
#        self.SetSize((526, 253))
        self.report_statusbar.SetStatusWidths([-1])
        # statusbar fields
#        report_statusbar_fields = [_("frame_2_statusbar")]
#        for i in range(len(report_statusbar_fields)):
#            self.report_statusbar.SetStatusText(report_statusbar_fields[i], i)
        self.report_toolbar.Realize()
#        self.report_window.SetMinSize((537, 262))
        # end wxGlade

    def do_layout(self):
        # begin wxGlade: ReportFrame.__do_layout
        sizer_128 = wx.BoxSizer(wx.VERTICAL)
        sizer_129 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_130 = wx.BoxSizer(wx.VERTICAL)
        sizer_129.Add((10, 10), 0, 0, 0)
        sizer_130.Add((10, 10), 0, 0, 0)
        sizer_130.Add(self.report_window, 1, wx.EXPAND, 0)
        sizer_130.Add((10, 10), 0, 0, 0)
        sizer_129.Add(sizer_130, 1, wx.EXPAND, 0)
        sizer_129.Add((10, 10), 0, 0, 0)
        self.Report_Panel.SetAutoLayout(True)
        self.Report_Panel.SetSizer(sizer_129)
        sizer_129.Fit(self.Report_Panel)
        # sizer_129.SetSizeHints(self.Report_Panel)
        sizer_128.Add(self.Report_Panel, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_128)
        self.Layout()
        # end wxGlade

# end of class ReportFrame


class DiagramFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: ReportFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.Report_Panel = wx.Panel(self, -1)
        
        # Menu Bar
        self.report_menubar = wx.MenuBar()
        self.SetMenuBar(self.report_menubar)
        self.FileMenu = wx.Menu()
        self.New = wx.MenuItem(self.FileMenu, wx.ID_NEW, _("New\tCtrl-N"), _("Create a new database file; close open database (if any)"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.New)
        self.Open = wx.MenuItem(self.FileMenu, wx.ID_OPEN, _("Open...\tCtrl-O"), _("Open existing database file"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Open)
        self.FileMenu.AppendSeparator()
        self.CloseReport = wx.MenuItem(self.FileMenu, wx.ID_CLOSE, _("Close Report\tCtrl-W"), _("Close report window"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.CloseReport)
        self.CloseAllReports = wx.MenuItem(self.FileMenu, wx.ID_CLOSE_ALL, _("Close All Reports\tCtrl-Alt-W"), _("Close all reports except main"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.CloseAllReports)
        self.Save = wx.MenuItem(self.FileMenu, wx.ID_SAVE, _("Save\tCtrl-S"), _("Save project file"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Save)
        self.SaveAs = wx.MenuItem(self.FileMenu, wx.ID_SAVEAS, _("Save As...\tCtrl-Shift-S"), _("Save database file with new name"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.SaveAs)
        self.AutoSave = wx.MenuItem(self.FileMenu, ID.M_AUTO_SAVE, _("Automatically Save On Quit"), _("Automatically save database when it is closed"), wx.ITEM_CHECK)
        self.FileMenu.AppendItem(self.AutoSave)
        self.FileMenu.AppendSeparator()
        self.RevertToSaved = wx.MenuItem(self.FileMenu, wx.ID_REVERT, _("Revert to Last Saved"), _("Revert the database to the last manually saved version"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.RevertToSaved)
        self.RevertToOpened = wx.MenuItem(self.FileMenu, ID.M_REVERT_OPEN, _("Revert to Last Opened"), _("Revert the database to the way it was when first opened"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.RevertToOpened)
        self.FileMenu.AppendSeparator()
        self.Quit = wx.MenuItem(self.FileMenu, wx.ID_EXIT, _("Quit\tCtrl-Q"), _("Quit program"), wx.ITEM_NORMAL)
        self.FileMenu.AppendItem(self.Quit)
        self.report_menubar.Append(self.FileMenu, _("File"))
        self.Edit = wx.Menu()
        self.Undo = wx.MenuItem(self.Edit, wx.ID_UNDO, _("Undo\tCtrl-Z"), _("Undo last change"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.Undo)
        self.Redo = wx.MenuItem(self.Edit, wx.ID_REDO, _("Redo\tCtrl-Shift-Z"), _("Redo change"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(self.Redo)
        self.Edit.AppendSeparator()
        copy = wx.MenuItem(self.Edit, wx.ID_COPY, _("Copy\tCtrl-C"), _("Copy cells in current selection to clipboard"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(copy)
        paste = wx.MenuItem(self.Edit, wx.ID_PASTE, _("Paste\tCtrl-V"), _("Paste cells from clipboard"), wx.ITEM_NORMAL)
        self.Edit.AppendItem(paste)

##        self.Edit.AppendSeparator()
##        self.InsertRow = wx.MenuItem(self.Edit, ID.M_INSERT_ROW, _("Insert New %s\tCtrl-R"), _("Insert new %s below the selected row"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.InsertRow)
##        self.InsertRowAbove = wx.MenuItem(self.Edit, ID.M_INSERT_ROW_ABOVE, _("Insert New %s Above Selection\tCtrl-Shift-R"), _("Insert a new %s above the selected row"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.InsertRowAbove)
####        self.InsertChild = wx.MenuItem(self.Edit, ID.M_INSERT_CHILD, _("Insert Child %s"), _("Insert a child %s"), wx.ITEM_NORMAL)
####        self.Edit.AppendItem(self.InsertChild)
##        self.InsertRelated = wx.MenuItem(self.Edit, ID.M_INSERT_RELATED, _("Insert Related %s"), _("Insert a new %s"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.InsertRelated)
##        self.Edit.AppendSeparator()
##        self.DeleteRow = wx.MenuItem(self.Edit, ID.M_DELETE_ROW, _("Delete Selected Row"), _("Delete the selected row"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.DeleteRow)
##        self.Edit.AppendSeparator()
##        self.MoveRowUp = wx.MenuItem(self.Edit, ID.M_SHIFT_LEFT, _("Shift Left\tCtrl-Shift-9"), _("Shift left (to next higher level)"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.MoveRowUp)
##        self.MoveRowDown = wx.MenuItem(self.Edit, ID.M_SHIFT_RIGHT, _("Shift Right\tCtrl-Shift-0"), _("Shift right (to next lower level)"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.MoveRowDown)
##        self.Edit.AppendSeparator()
##        self.MoveRowUp = wx.MenuItem(self.Edit, ID.M_MOVE_ROW_UP, _("Move Selected Row Up\tCtrl-9"), _("Move the selected row up one posiion (if possible)"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.MoveRowUp)
##        self.MoveRowDown = wx.MenuItem(self.Edit, ID.M_MOVE_ROW_DOWN, _("Move Selected Row Down\tCtrl-0"), _("Move the selected row down (if possible)"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(self.MoveRowDown)
##        self.Edit.AppendSeparator()
##        editprojectname = wx.MenuItem(self.Edit, ID.M_EDIT_PROJECT_NAME, _("Edit Project Name..."), _("Edit the name of the project that owns this report"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(editprojectname)
##        editreportname = wx.MenuItem(self.Edit, ID.M_EDIT_REPORT_NAME, _("Edit Report Name..."), _("Edit the name of this report"), wx.ITEM_NORMAL)
##        self.Edit.AppendItem(editreportname)

        self.report_menubar.Append(self.Edit, _("Edit"))
        wxglade_tmp_menu = wx.Menu()

##        self.Action = wxglade_tmp_menu
##        self.AssignPrerequisite = wx.MenuItem(wxglade_tmp_menu, ID.M_ASSIGN_PREREQUISITE, _("Define Prerequisite for Task..."), _("Assign prerequisite for selected task"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.AssignPrerequisite)
##        self.LinkTasks = wx.MenuItem(wxglade_tmp_menu, ID.M_LINK_TASKS, _("Link Selected Tasks as Dependent"), _("Link tasks as dependent in the order they appear in the report"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.LinkTasks)
##        self.AssignResource = wx.MenuItem(wxglade_tmp_menu, ID.M_ASSIGN_RESOURCE, _("Assign Resource to Task..."), _("Assign resources to the selected task"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.AssignResource)
##        wxglade_tmp_menu.AppendSeparator()
##        self.AssignResourceToGroup = wx.MenuItem(wxglade_tmp_menu, ID.M_RESOURCE_TO_GROUP, _("Assign Resource to Resource Group..."), _("Identify the groups to which the selected resource belongs"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.AssignResourceToGroup)
##        self.DefineGroupMembers = wx.MenuItem(wxglade_tmp_menu, ID.M_DEFINE_RESOURCE_GROUP, _("Define Members of Resource Group..."), _("Define which resources are members of the specified resource group"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.DefineGroupMembers)
##        self.AssignTask = wx.MenuItem(wxglade_tmp_menu, ID.M_ASSIGN_TASK, _("Assign Task to Resource..."), _("Specify all tasks assignments for a resource"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.AssignTask)
##        self.report_menubar.Append(wxglade_tmp_menu, _("Action"))

##        wxglade_tmp_menu = wx.Menu()
##        self.View = wxglade_tmp_menu
##        self.InsertColumn = wx.MenuItem(wxglade_tmp_menu, ID.M_INSERT_COLUMN, _("Insert Column..."), _("Insert a new column before selection"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.InsertColumn)
##        wxglade_tmp_menu.AppendSeparator()
##        self.DeleteColumn = wx.MenuItem(wxglade_tmp_menu, ID.M_DELETE_COLUMN, _("Delete Selected Column"), _("Delete the selected column from the report"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.DeleteColumn)
##        wxglade_tmp_menu.AppendSeparator()
##        self.MoveColumnLeft = wx.MenuItem(wxglade_tmp_menu, ID.M_MOVE_COLUMN_LEFT, _("Move Selected Column Left"), _("Move the selected column to the left"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.MoveColumnLeft)
##        self.MoveColumnRight = wx.MenuItem(wxglade_tmp_menu, ID.M_MOVE_COLUMN_RIGHT, _("Move Selected Column Right"), _("Move the selected column to the right"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.MoveColumnRight)
##        wxglade_tmp_menu.AppendSeparator()
##        self.ScrollLeftFast = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_LEFT_FAST, _("Scroll Timescale Left Fast"), _("Shift the selected time scale several periods to the left"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.ScrollLeftFast)
##        self.ScrollLeft = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_LEFT, _("Scroll Timescale Left"), _("Shift the selected time scale one period to the left"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.ScrollLeft)
##        self.ScrollRight = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_RIGHT, _("Scroll Timescale Right"), _("Shift the selected time scale one period to the right"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.ScrollRight)
##        self.ScrollRightFast = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_RIGHT_FAST, _("Scroll Timescale Right Fast"), _("Shift the selected time scale several periods to the right"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.ScrollRightFast)
##        self.ScrollToTask = wx.MenuItem(wxglade_tmp_menu, ID.M_SCROLL_TO_TASK, _("Scroll Timescale to Task Start Date"), _("Scroll timescales to the selected task's start date"), wx.ITEM_NORMAL)
##        wxglade_tmp_menu.AppendItem(self.ScrollToTask)
##        self.report_menubar.Append(wxglade_tmp_menu, _("View"))

        self.Script = wx.Menu()
        self.FindScripts = wx.MenuItem(self.Script, ID.FIND_SCRIPTS, _("Choose Scripts Folder..."), _("Specify location of scripts folder"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.FindScripts)
        self.RefreshScripts = wx.MenuItem(self.Script, ID.REFRESH_SCRIPTS, _("Refresh Script Menu"), _("Update the script menu to include changes to the script folder"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.RefreshScripts)
        self.RepeatScript = wx.MenuItem(self.Script, ID.REPEAT_SCRIPT, _("Repeat Previous Script\tCtrl-8"), _("Re-run the previous script"), wx.ITEM_NORMAL)
        self.Script.AppendItem(self.RepeatScript)
        self.report_menubar.Append(self.Script, _("Script"))
        wxglade_tmp_menu = wx.Menu()
        self.WindowMenu = wxglade_tmp_menu
        self.FirstWindow = wx.MenuItem(wxglade_tmp_menu, ID.FIRST_WINDOW, _("Main Window\tCtrl-1"), _("Bring the main window to front"), wx.ITEM_CHECK)
        wxglade_tmp_menu.AppendItem(self.FirstWindow)
        # self.WindowMenu.Check(ID.FIRST_WINDOW, True)
        self.report_menubar.Append(wxglade_tmp_menu, _("Window"))
        self.Help = wx.Menu()
        self.About = wx.MenuItem(self.Help, wx.ID_ABOUT, _("About GanttPV..."), "", wx.ITEM_NORMAL)
        self.Help.AppendItem(self.About)
        self.QuickStart = wx.MenuItem(self.Help, ID.QUICK_START, _("Quick Start..."), _("Provide hints on how to use report"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.QuickStart)
        self.ORMQuickStart = wx.MenuItem(self.Help, ID.ORM_QUICK_START, _("ORM Quick Start..."), _("Provide hints on how to use ORM"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.ORMQuickStart)
        self.ShortCuts = wx.MenuItem(self.Help, ID.SHORT_CUTS, _("Shortcuts..."), _("Displays most the most useful shortcuts"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.ShortCuts)
        self.HomePage = wx.MenuItem(self.Help, ID.HOME_PAGE, _("GanttPV Home"), _("Open GanttPV home page in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HomePage)
        self.HelpPage = wx.MenuItem(self.Help, ID.HELP_PAGE, _("Help Page and Tour"), _("Open GanttPV help page in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HelpPage)
        self.HelpBook = wx.MenuItem(self.Help, ID.HELP_BOOK, _("GanttPV Book"), _("Open GanttPV Book web page in browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.HelpBook)
        self.Forum = wx.MenuItem(self.Help, ID.FORUM, _("Forum"), _("Open GanttPV user forum in web browser"), wx.ITEM_NORMAL)
        self.Help.AppendItem(self.Forum)
        self.report_menubar.Append(self.Help, _("&Help"))
        # Menu Bar end
        self.report_statusbar = self.CreateStatusBar(1, 0)
        
##        # Tool Bar
##        self.report_toolbar = wx.ToolBar(self, -1)
##        self.report_toolbar.SetToolBitmapSize((16, 16))  # change
##        self.SetToolBar(self.report_toolbar)
##        self.report_toolbar.AddLabelTool(ID.INSERT_ROW, _("Insert %s"), Menu.Bitmap("icons/Insert Row.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Insert new %s"), _("Insert new %s below selection"))
##        self.report_toolbar.AddLabelTool(ID.DUPLICATE_ROW, _("Duplicate %s"), Menu.Bitmap("icons/Duplicate.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Duplicate %s"), _("Duplicate selected %s"))
##        self.report_toolbar.AddLabelTool(ID.DELETE_ROW, _("Delete Row"), Menu.Bitmap("icons/Delete Row.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Delete Row"), _("Delete selected rows"))
##        self.report_toolbar.AddLabelTool(ID.MOVE_UP, _("Move Up"), Menu.Bitmap("icons/Move Up.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Row Up"), _("Move selected rows up"))
##        self.report_toolbar.AddLabelTool(ID.MOVE_DOWN, _("Move Down"), Menu.Bitmap("icons/Move Down.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Row Down"), _("Move selected rows down"))
##        self.report_toolbar.AddSeparator()
##        self.report_toolbar.AddLabelTool(ID.PREREQUISITE, _("Assign Prerequisite"), Menu.Bitmap("icons/Assign Prerequisites.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Assign Prerequisite"), _("Identify prerequisites for selected task"))
##        self.report_toolbar.AddLabelTool(ID.ASSIGN_RESOURCE, _("Assign Resource"), Menu.Bitmap("icons/Assign Resources.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Assign Resource"), _("Assign resources to selected task"))
##        self.report_toolbar.AddSeparator()
##        self.report_toolbar.AddLabelTool(ID.HIDE_ROW, _("Hide Row"), Menu.Bitmap("icons/Hide Report.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Hide Row"), _("Hide/show selected rows"))
##        self.report_toolbar.AddLabelTool(ID.SHOW_HIDDEN, _("Show Hidden"), Menu.Bitmap("icons/Show Hidden.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_CHECK, _("Show Hidden"), _("Show or reveal hidden and deleted rows"))
##        self.report_toolbar.AddSeparator()
##        self.report_toolbar.AddLabelTool(ID.INSERT_COLUMN, _("Insert Column"), Menu.Bitmap("icons/Insert Column.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Insert Column"), _("Insert column types from popup list"))
##        self.report_toolbar.AddLabelTool(ID.DELETE_COLUMN, _("Delete Column"), Menu.Bitmap("icons/Delete Column.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Delete Column"), _("Delete selected columns"))
##        self.report_toolbar.AddLabelTool(ID.MOVE_LEFT, _("Move Left"), Menu.Bitmap("icons/Move Left.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Column Left"), _("Move selected columns to the left"))
##        self.report_toolbar.AddLabelTool(ID.MOVE_RIGHT, _("Move Right"), Menu.Bitmap("icons/Move Right.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Move Column Right"), _("Move selected columns to the right"))
##        self.report_toolbar.AddSeparator()
##        self.report_toolbar.AddLabelTool(ID.COLUMN_OPTIONS, _("Column Options"), Menu.Bitmap("icons/Column Options.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Column Options"), _("Set options on selected column"))
##        self.report_toolbar.AddSeparator()
##        self.report_toolbar.AddLabelTool(ID.SCROLL_LEFT_FAR, _("Scroll Left Far"), Menu.Bitmap("icons/Scroll Left Fast.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Left"), _("Scroll left several time periods"))
##        self.report_toolbar.AddLabelTool(ID.SCROLL_LEFT, _("Scroll Left"), Menu.Bitmap("icons/Scroll Left Slow.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Left"), _("Scroll left one time period"))
##        self.report_toolbar.AddLabelTool(ID.SCROLL_RIGHT, _("Scroll Right"), Menu.Bitmap("icons/Scroll Right Slow.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Right"), _("Scroll right one time period"))
##        self.report_toolbar.AddLabelTool(ID.SCROLL_RIGHT_FAR, _("Scroll Right Far"), Menu.Bitmap("icons/Scroll Right Fast.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll Right"), _("Scroll right several time periods"))
##        self.report_toolbar.AddLabelTool(ID.SCROLL_TO_TASK, _("Scroll To Task"), Menu.Bitmap("icons/Scroll to Task.bmp", wx.BITMAP_TYPE_ANY), wx.NullBitmap, wx.ITEM_NORMAL, _("Scroll To Task"), _("Scroll to display bar for selected task"))
##        # Tool Bar end
#        self.report_window = GanttReport.GanttChartGrid(self.Report_Panel, -1, 537,  262, reportid)

#        self.__set_properties()
#        self.__do_layout()
        # end wxGlade

    def set_properties(self):
        # begin wxGlade: ReportFrame.__set_properties
#        self.SetTitle(_("Report"))
#        self.SetSize((526, 253))
        self.report_statusbar.SetStatusWidths([-1])
        # statusbar fields
#        report_statusbar_fields = [_("frame_2_statusbar")]
#        for i in range(len(report_statusbar_fields)):
#            self.report_statusbar.SetStatusText(report_statusbar_fields[i], i)
##        self.report_toolbar.Realize()
#        self.report_window.SetMinSize((537, 262))
        # end wxGlade

    def do_layout(self):
        # begin wxGlade: ReportFrame.__do_layout
        sizer_128 = wx.BoxSizer(wx.VERTICAL)
        sizer_129 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_130 = wx.BoxSizer(wx.VERTICAL)
        sizer_129.Add((10, 10), 0, 0, 0)
        sizer_130.Add((10, 10), 0, 0, 0)
        sizer_130.Add(self.report_window, 1, wx.EXPAND, 0)
        sizer_130.Add((10, 10), 0, 0, 0)
        sizer_129.Add(sizer_130, 1, wx.EXPAND, 0)
        sizer_129.Add((10, 10), 0, 0, 0)
        self.Report_Panel.SetAutoLayout(True)
        self.Report_Panel.SetSizer(sizer_129)
        sizer_129.Fit(self.Report_Panel)
        # sizer_129.SetSizeHints(self.Report_Panel)
        sizer_128.Add(self.Report_Panel, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_128)
        self.Layout()
        # end wxGlade

# end of class DiagramFrame


class AboutDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: AboutDialog.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.Logo_Text = wx.StaticText(self, -1, _("GanttPV 0.11b"))
        self.About_Text = wx.StaticText(self, -1, _("Copyright 2004-2008 by Brian C. Christensen (brian@pureviolet.net)\n\nGanttPV is an open source project management tool. \n\n- Originally designed and coded by Brian C. Christensen\n- Icons by Alexander V. Christensen\n\nThanks to Alexander Christensen and Roy Heath for assistance with the hard parts.\n\nGanttPV is distributed under the GNU GPL. See the file 'License.txt' accompanying this software for details. GanttPV comes with ABSOLUTELY NO WARRANTY.\n\nIcons copyright 2005 by Alexander V. Christensen (used by permission)"))
        self.OK_Button = wx.Button(self, wx.ID_OK, _("OK"))

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: AboutDialog.__set_properties
        self.SetTitle(_("About GanttPV"))
        if Data.platform == "win":
            self.SetSize((562, 280))
        else:
            self.SetSize((542, 300))
        self.Logo_Text.SetFont(wx.Font(22, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, ""))
        if Data.platform == "win":
            self.About_Text.SetFont(wx.Font(8, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, ""))
        else:
            self.About_Text.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, ""))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: AboutDialog.__do_layout
        sizer_33 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_34 = wx.BoxSizer(wx.VERTICAL)
        sizer_35 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_33.Add((10, 10), 0, 0, 0)
        sizer_34.Add((10, 10), 0, 0, 0)
        sizer_34.Add(self.Logo_Text, 0, 0, 0)
        sizer_34.Add((10, 10), 0, 0, 0)
        sizer_34.Add(self.About_Text, 0, wx.EXPAND, 0)
        sizer_34.Add((10, 0), 0, 0, 0)
        sizer_35.Add((10, 10), 0, 0, 0)
        sizer_35.Add(self.OK_Button, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_35.Add((10, 10), 0, 0, 0)
        sizer_34.Add(sizer_35, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_34.Add((10, 10), 0, 0, 0)
        sizer_33.Add(sizer_34, 1, wx.EXPAND, 0)
        sizer_33.Add((10, 10), 0, 0, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_33)
        self.Layout()
        # end wxGlade

# end of class AboutDialog


class PreferencesFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: PreferencesFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.notebook_1 = wx.Notebook(self, -1, style=0)
        self.notebook_1_pane_1 = wx.Panel(self.notebook_1, -1)
        self.rc_options_sizer_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, _("Report Copy Options"))
        self.tc_options_sizer_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, _("Task Copy Options"))
        self.resc_options_sizer_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, _("Resource Copy Options"))
        self.pc_options_sizer_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, _("Program Copy Options"))
        self.pc_include_label = wx.StaticText(self.notebook_1_pane_1, -1, _("Include:"))
        self.pc_Tasks = wx.CheckBox(self.notebook_1_pane_1, -1, _("Tasks"))
        self.pc_Estimates = wx.CheckBox(self.notebook_1_pane_1, -1, _("Estimates"))
        self.pc_Resource_Assignments = wx.CheckBox(self.notebook_1_pane_1, -1, _("Resource Assignments"))
        self.rc_include_label = wx.StaticText(self.notebook_1_pane_1, -1, _("Include:"))
        self.rc_Columns = wx.CheckBox(self.notebook_1_pane_1, -1, _("Column Definitions"))
        self.rc_Rows = wx.CheckBox(self.notebook_1_pane_1, -1, _("Row Definitions"))
        self.checkbox_6 = wx.CheckBox(self.notebook_1_pane_1, -1, _("checkbox_6"))
        self.tc_include_label = wx.StaticText(self.notebook_1_pane_1, -1, _("Include:"))
        self.tc_Estimates = wx.CheckBox(self.notebook_1_pane_1, -1, _("Estimates"))
        self.tc_Resource_Assignmets = wx.CheckBox(self.notebook_1_pane_1, -1, _("Resource Assignments"))
        self.checkbox_9 = wx.CheckBox(self.notebook_1_pane_1, -1, _("checkbox_9"))
        self.resc_options_label = wx.StaticText(self.notebook_1_pane_1, -1, _("Include:"))
        self.resc_Skills = wx.CheckBox(self.notebook_1_pane_1, -1, _("Skills"))
        self.checkbox_11 = wx.CheckBox(self.notebook_1_pane_1, -1, _("checkbox_11"))
        self.checkbox_12 = wx.CheckBox(self.notebook_1_pane_1, -1, _("checkbox_12"))
        self.notebook_1_pane_2 = wx.Panel(self.notebook_1, -1)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: PreferencesFrame.__set_properties
        self.SetTitle(_("Preferences"))
        self.SetSize((412, 356))
        self.pc_Tasks.SetValue(1)
        self.pc_Estimates.SetValue(1)
        self.rc_Columns.SetValue(1)
        self.checkbox_6.Hide()
        self.tc_Estimates.SetValue(1)
        self.checkbox_9.Hide()
        self.resc_Skills.SetValue(1)
        self.checkbox_11.Hide()
        self.checkbox_12.Hide()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: PreferencesFrame.__do_layout
        sizer_14 = wx.BoxSizer(wx.VERTICAL)
        grid_sizer_5 = wx.GridSizer(2, 2, 0, 0)
        resc_options_sizer = wx.StaticBoxSizer(self.resc_options_sizer_staticbox, wx.VERTICAL)
        tc_options_sizer = wx.StaticBoxSizer(self.tc_options_sizer_staticbox, wx.VERTICAL)
        rc_options_sizer = wx.StaticBoxSizer(self.rc_options_sizer_staticbox, wx.VERTICAL)
        pc_options_sizer = wx.StaticBoxSizer(self.pc_options_sizer_staticbox, wx.VERTICAL)
        pc_options_sizer.Add(self.pc_include_label, 0, 0, 0)
        pc_options_sizer.Add(self.pc_Tasks, 0, 0, 0)
        pc_options_sizer.Add(self.pc_Estimates, 0, 0, 0)
        pc_options_sizer.Add(self.pc_Resource_Assignments, 0, 0, 0)
        grid_sizer_5.Add(pc_options_sizer, 1, wx.EXPAND, 0)
        rc_options_sizer.Add(self.rc_include_label, 0, 0, 0)
        rc_options_sizer.Add(self.rc_Columns, 0, 0, 0)
        rc_options_sizer.Add(self.rc_Rows, 0, 0, 0)
        rc_options_sizer.Add(self.checkbox_6, 0, 0, 0)
        grid_sizer_5.Add(rc_options_sizer, 1, wx.EXPAND, 0)
        tc_options_sizer.Add(self.tc_include_label, 0, 0, 0)
        tc_options_sizer.Add(self.tc_Estimates, 0, 0, 0)
        tc_options_sizer.Add(self.tc_Resource_Assignmets, 0, 0, 0)
        tc_options_sizer.Add(self.checkbox_9, 0, 0, 0)
        grid_sizer_5.Add(tc_options_sizer, 1, wx.EXPAND, 0)
        resc_options_sizer.Add(self.resc_options_label, 0, 0, 0)
        resc_options_sizer.Add(self.resc_Skills, 0, 0, 0)
        resc_options_sizer.Add(self.checkbox_11, 0, 0, 0)
        resc_options_sizer.Add(self.checkbox_12, 0, 0, 0)
        grid_sizer_5.Add(resc_options_sizer, 1, wx.EXPAND, 0)
        self.notebook_1_pane_1.SetAutoLayout(True)
        self.notebook_1_pane_1.SetSizer(grid_sizer_5)
        grid_sizer_5.Fit(self.notebook_1_pane_1)
        grid_sizer_5.SetSizeHints(self.notebook_1_pane_1)
        self.notebook_1.AddPage(self.notebook_1_pane_1, _("Copy Options"))
        self.notebook_1.AddPage(self.notebook_1_pane_2, _("Save Options"))
        sizer_14.Add(self.notebook_1, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_14)
        self.Layout()
        # end wxGlade

# end of class PreferencesFrame


class MultipleSelection(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MultipleSelection.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.Instructions = wx.StaticText(self, -1, _("Make selection:"))
        self.SelectionListBox = wx.ListBox(self, -1, choices=[], style=wx.LB_MULTIPLE)
        self.SearchLabel = wx.StaticText(self, -1, _("Search:\n"))
        self.Search = wx.TextCtrl(self, -1)
        self.OK = wx.Button(self, wx.ID_OK, _("OK"))
        self.Cancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: MultipleSelection.__set_properties
        # self.SetTitle(_("Selection"))
        # self.SelectionListBox.SetMinSize((295, 200))
        # self.SelectionListBox.SetSelection(0)
        self.OK.SetDefault()
        self.Search.SetFocus()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MultipleSelection.__do_layout
        sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_whoKnows = wx.BoxSizer(wx.HORIZONTAL)
        sizer_26 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4.Add((10, 10), 0, 0, 0)
        sizer_9.Add((10, 10), 0, 0, 0)
        sizer_whoKnows.Add(self.SearchLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_whoKnows.Add((10, 10), 0, 0, 0)
        sizer_whoKnows.Add(self.Search, 1, wx.GROW, 0)
        sizer_9.Add(sizer_whoKnows, 0, wx.EXPAND, 0)
        sizer_9.Add((10, 10), 0, 0, 0)
        sizer_9.Add(self.Instructions, 0, wx.EXPAND, 0)
        sizer_9.Add((10, 10), 0, 0, 0)
        sizer_9.Add(self.SelectionListBox, 1, wx.GROW, 0)
        sizer_9.Add((10, 10), 0, 0, 0)
        sizer_26.Add((10, 10), 0, 0, 0)
        sizer_26.Add(self.OK, 0, 0, 0)
        sizer_26.Add((10, 10), 0, 0, 0)
        sizer_26.Add(self.Cancel, 0, 0, 0)
        sizer_26.Add((10, 10), 0, 0, 0)
        sizer_9.Add(sizer_26, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_9.Add((10, 10), 0, 0, 0)
        sizer_4.Add(sizer_9, 1, wx.EXPAND, 0)
        sizer_4.Add((10, 10), 0, 0, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_4)
        # sizer_4.Fit(self)
        # sizer_4.SetSizeHints(self)
        self.Layout()
        # end wxGlade

# end of class MultipleSelection


class MyDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MyDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.Name_Label = wx.StaticText(self, -1, _("Project Name"))
        self.Name = wx.TextCtrl(self, -1, "")
        self.Start_Date_Label = wx.StaticText(self, -1, _("Start Date  (YYYY-MM-DD)"))
        self.Start_Date = wx.TextCtrl(self, -1, "")
        self.Target_End_Date_Label = wx.StaticText(self, -1, _("Target End Date"))
        self.Target_End_Date = wx.TextCtrl(self, -1, "")
        self.Description_Label = wx.StaticText(self, -1, _("Description"))
        self.Description = wx.TextCtrl(self, -1, "", style=wx.TE_PROCESS_ENTER|wx.TE_MULTILINE)
        self.Project_OK = wx.Button(self, -1, _("OK"))
        self.Project_Cancel = wx.Button(self, -1, _("Cancel"))

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: MyDialog.__set_properties
        self.SetTitle(_("Edit Project Information"))
        self.Name.SetMinSize((200, -1))
        self.Start_Date.SetMinSize((100, -1))
        self.Target_End_Date.SetMinSize((100, -1))
        self.Description.SetMinSize((400, 100))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MyDialog.__do_layout
        sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_32 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_31 = wx.BoxSizer(wx.VERTICAL)
        grid_sizer_6 = wx.FlexGridSizer(3, 3, 2, 2)
        sizer_1.Add((10, 10), 0, 0, 0)
        sizer_2.Add((10, 10), 0, 0, 0)
        grid_sizer_6.Add(self.Name_Label, 0, 0, 0)
        grid_sizer_6.Add(self.Name, 0, 0, 0)
        grid_sizer_6.Add((10, 10), 0, 0, 0)
        grid_sizer_6.Add(self.Start_Date_Label, 0, 0, 0)
        grid_sizer_6.Add(self.Start_Date, 0, 0, 0)
        grid_sizer_6.Add((10, 10), 0, 0, 0)
        grid_sizer_6.Add(self.Target_End_Date_Label, 0, 0, 0)
        grid_sizer_6.Add(self.Target_End_Date, 0, 0, 0)
        grid_sizer_6.Add((10, 10), 0, 0, 0)
        sizer_2.Add(grid_sizer_6, 1, wx.EXPAND, 0)
        sizer_2.Add((10, 10), 0, 0, 0)
        sizer_31.Add(self.Description_Label, 0, 0, 0)
        sizer_31.Add(self.Description, 0, wx.EXPAND, 0)
        sizer_2.Add(sizer_31, 1, wx.EXPAND, 0)
        sizer_2.Add((10, 10), 0, 0, 0)
        sizer_32.Add((10, 10), 0, 0, 0)
        sizer_32.Add(self.Project_OK, 0, 0, 0)
        sizer_32.Add((10, 10), 0, 0, 0)
        sizer_32.Add(self.Project_Cancel, 0, 0, 0)
        sizer_32.Add((10, 10), 0, 0, 0)
        sizer_2.Add(sizer_32, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_2.Add((10, 10), 0, 0, 0)
        sizer_1.Add(sizer_2, 1, wx.EXPAND, 0)
        sizer_1.Add((10, 10), 0, 0, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        sizer_1.SetSizeHints(self)
        self.Layout()
        # end wxGlade

# end of class MyDialog


class GanttPVApp(wx.App):
    def OnInit(self):
        wx.InitAllImageHandlers()
        Main = MainFrame(None, -1, "")
        self.SetTopWindow(Main)
        Main.Show()
        return 1

# end of class GanttPVApp

if __name__ == "__main__":
    import gettext
    gettext.install("GanttPV") # replace with the appropriate catalog name

    GanttPV = GanttPVApp(0)
    GanttPV.MainLoop()
