#!/usr/bin/env python
# Create Mac Application
# 040531 modified example from web page
# 040601 - added Alex's new GanttPV icon
# 040926 - use new CVS work area directories
# 050415 - use 4.5.5.1 libraries
# 050510 - use 4.6.0 libraries
# 060729 - update for 0.7

import bundlebuilder, os 
# I set this to make adding subfolders into the package easier 
#packageroot ="/Users/bcc/version/ganttpv/" 
packageroot ="." 

# Create the AppBuilder 
myapp = bundlebuilder.AppBuilder (verbosity=1)

# Tell it where to find the main script - the one that loads on startup 
myapp.mainprogram=os.path.join(packageroot ,"GanttPV.py")
# myapp.argv_emulation=1  # ?for double click of .ganttpv files? <-- need to investigate
myapp.standalone=1
myapp.name="GanttPV"
#myapp.iconfile="/Users/bcc/version/icons/GanttPV Icon.icns"
myapp.iconfile="icons/GanttPV Icon.icns"

# includePackages forces certain packages to be added to the app bundle 
myapp.includePackages.append("ID")
myapp.includePackages.append("Data")
myapp.includePackages.append("GanttReport")
myapp.includePackages.append("UI")
myapp.includePackages.append("Menu")
myapp.includePackages.append("StartupData")
myapp.includePackages.append("Zeroconf")
# myapp.includePackages.append("argvemulator") # ?for double click of .ganttpv files? <-- need to investigate

# Here you add supporting files and/or folders to your bundle 
myapp.resources.append(os.path.join(packageroot,"icons" ))
myapp.resources.append(os.path.join(packageroot,"locale" ))

# bundlebuilder does not yet have the capability to detect what shared libraries 
# are needed by your app - so in this case I am adding the wxPython libs manually 
# myapp.libs.append("/usr/local/lib/libwx_mac-2.4.0.dylib")
# myapp.libs.append("/usr/local/lib/libwx_mac-2.4.0.rsrc")
# myapp.libs.append("/usr/local/lib/libwx_mac_gl-2.4.0.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_base_carbond-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_base_carbond_net-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_base_carbond_xml-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_adv-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_core-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_gizmos-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_gl-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_html-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_ogl-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_stc-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd_xrc-2.5.1.dylib")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd-2.5.1.r")
# myapp.libs.append("/usr/lib/wxPython-2.5.1.5/lib/libwx_macd-2.5.1.rsrc")

# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd-2.5.5.0.0.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd-2.5.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd-2.5.5.r")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd-2.5.5.rsrc")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd-2.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_animate-2.5.5.0.0.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_animate-2.5.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_animate-2.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_gizmos-2.5.5.0.0.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_gizmos-2.5.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_gizmos-2.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_gl-2.5.5.0.0.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_gl-2.5.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_gl-2.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_stc-2.5.5.0.0.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_stc-2.5.5.dylib")
# myapp.libs.append("/usr/local/lib/wxPython-ansi-2.5.5.1/lib/libwx_macd_stc-2.5.dylib")

myapp.libs.append("/usr/local/lib/wxPython-ansi-2.6.0.0/lib/libwx_macd-2.6.0.dylib")
myapp.libs.append("/usr/local/lib/wxPython-ansi-2.6.0.0/lib/libwx_macd_animate-2.6.0.dylib")
myapp.libs.append("/usr/local/lib/wxPython-ansi-2.6.0.0/lib/libwx_macd_gizmos-2.6.0.dylib")
myapp.libs.append("/usr/local/lib/wxPython-ansi-2.6.0.0/lib/libwx_macd_gizmos_xrc-2.6.0.dylib")
myapp.libs.append("/usr/local/lib/wxPython-ansi-2.6.0.0/lib/libwx_macd_gl-2.6.0.dylib")
myapp.libs.append("/usr/local/lib/wxPython-ansi-2.6.0.0/lib/libwx_macd_stc-2.6.0.dylib")

# Here we build the app! 
myapp.setup()
myapp.build()
