#!/usr/bin/env python
# setup.py -- for windows
# 040517 - draft
# 040519 - added Assign Resources and Dependencies icons
# 040520 - merged my script w/ InnoSetup example
# 040601 - include "Icon Copyright.txt" file w/ icons
# 040715 - PRouleau: removed all tabs, now use 4-space indentation level to comply with Official Python Guideline.
# 041026 - include new scripts
# 041204 - include new scripts
# 050106 - include new scripts
# 050519 - new script names and direcctories
# 050527 - allow Alex to move executable up a level
# 051125 - release 0.6 scripts
# 060204 - use 0.6 beta 2 script organization
# 060729 - update for 0.7
# 060802 - more 0.7 changes (scripts)
# 060928 - include new scripts
# 070227 - include new scripts for v0.8
# 080314 - include new scripts for v0.9
# 080802 - include new scripts for v0.10
# 081126 - include new scripts for v0.11

# A setup script showing how to extend py2exe.
#
# In this case, the py2exe command is subclassed to create an installation
# script for InnoSetup, which can be compiled with the InnoSetup compiler
# to a single file windows installer.
#
# By default, the installer will be created as dist\Output\setup.exe.

from distutils.core import setup
import py2exe
import sys

#the following is taken from: http://trac.nvda-project.org/changeset/548/trunk/source/setup.py
# "Copyright (C) 2006-2007 Michael Curran <mick@kulgan.net>
# This file is covered by the GNU General Public License.
# py2exe insists on excluding certain dlls that don't seem to exist on many systems, so hackishly force them to be included."
from py2exe import build_exe
origIsSystemDLL = build_exe.isSystemDLL 
def isSystemDLL(pathname): 
        if os.path.basename(pathname).lower() in ("msvcp71.dll", "gdiplus.dll"): 
                return 0 
        return origIsSystemDLL(pathname) 
build_exe.isSystemDLL = isSystemDLL 
# end of fix

################################################################
# A program using wxPython

# The manifest will be inserted as resource into GanttPV.exe.  This
# gives the controls the Windows XP appearance (if run on XP ;-)
#
# Another option would be to store if in a file named
# GanttPV.exe.manifest, and probably copy it with the data_files
# option.
#
manifest_template = '''
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
<assemblyIdentity
    version="5.0.0.0"
    processorArchitecture="x86"
    name="%(prog)s"
    type="win32"
/>
<description>%(prog)s Program</description>
<dependency>
    <dependentAssembly>
        <assemblyIdentity
            type="win32"
            name="Microsoft.Windows.Common-Controls"
            version="6.0.0.0"
            processorArchitecture="X86"
            publicKeyToken="6595b64144ccf1df"
            language="*"
        />
    </dependentAssembly>
</dependency>
</assembly>
'''

RT_MANIFEST = 24

################################################################
# arguments for the setup() call

GanttPV = dict(
    script = "GanttPV.py",
    other_resources = [(RT_MANIFEST, 1, manifest_template % dict(prog="GanttPV"))],
    dest_base = r"GanttPV")

zipfile = r"lib\shardlib"

options = {"py2exe": {"compressed": 1,
                      "optimize": 2,
                      }}


################################################################
import os

class InnoScript:
    def __init__(self,
                 name,
                 lib_dir,
                 dist_dir,
                 windows_exe_files = [],
                 lib_files = [],
                 version = "0.11b"):   # --- change this! ---
        self.lib_dir = lib_dir
        self.dist_dir = dist_dir
        if not self.dist_dir[-1] in "\\/":
            self.dist_dir += "\\"
        self.name = name
        self.version = version
        self.windows_exe_files = [self.chop(p) for p in windows_exe_files]
        self.lib_files = [self.chop(p) for p in lib_files]

    def chop(self, pathname):
        assert pathname.startswith(self.dist_dir)
        return pathname[len(self.dist_dir):]
    
    def create(self, pathname="dist\\GanttPV.iss"):
        self.pathname = pathname
        ofi = self.file = open(pathname, "w")
        print >> ofi, "; WARNING: This script has been created by py2exe. Changes to this script"
        print >> ofi, "; will be overwritten the next time py2exe is run!"
        print >> ofi, r"[Setup]"
        print >> ofi, r"AppName=%s" % self.name
        print >> ofi, r"AppVerName=%s %s" % (self.name, self.version)
        print >> ofi, r"DefaultDirName={pf}\%s" % self.name
        print >> ofi, r"DefaultGroupName=%s" % self.name
        print >> ofi

        print >> ofi, r"[Files]"
        for path in self.windows_exe_files + self.lib_files:
            print >> ofi, r'Source: "%s"; DestDir: "{app}\%s"; Flags: ignoreversion' % (path, os.path.dirname(path))
        print >> ofi

        print >> ofi, r"[Icons]"
        for path in self.windows_exe_files:
            print >> ofi, r'Name: "{group}\%s"; Filename: "{app}\%s"' % \
                  (self.name, path)
        print >> ofi, 'Name: "{group}\Uninstall %s"; Filename: "{uninstallexe}"' % self.name

    def compile(self):
        try:
            import ctypes
        except ImportError:
            try:
                import win32api
            except ImportError:
                import os
                os.startfile(self.pathname)
            else:
                print "Ok, using win32api."
                win32api.ShellExecute(0, "compile",
                                                self.pathname,
                                                None,
                                                None,
                                                0)
        else:
            print "Cool, you have ctypes installed."
            res = ctypes.windll.shell32.ShellExecuteA(0, "compile",
                                                      self.pathname,
                                                      None,
                                                      None,
                                                      0)
            if res < 32:
                raise RuntimeError, "ShellExecute failed, error %d" % res


################################################################

from py2exe.build_exe import py2exe

class build_installer(py2exe):
    # This class first builds the exe file(s), then creates a Windows installer.
    # You need InnoSetup for it.
    def run(self):
        # First, let py2exe do it's work.
        py2exe.run(self)

        lib_dir = self.lib_dir
        dist_dir = self.dist_dir
        
        # create the Installer, using the files py2exe has created.
        script = InnoScript("GanttPV",
                            lib_dir,
                            dist_dir,
                            self.windows_exe_files,
                            self.lib_files)
        print "*** creating the inno setup script***"
        script.create()
        print "*** compiling the inno setup script***"
        script.compile()
        # Note: By default the final setup.exe will be in an Output subdirectory.

################################################################

setup(
        options = options,
        # The lib directory contains everything except the executables and the python dll.
        zipfile = zipfile,
        windows = [{
            "script": "GanttPV.py",
            "icon_resources": [(1, "icons/GanttPV Icon.ico")]
        }],
#       console = [GanttPV],
        # use out build_installer class as extended py2exe build command
        cmdclass = {"py2exe": build_installer},
        name="GanttPV",
        version="0.11b",  # --- change this! ---
        description="GanttPV - open source project management tool",
        author="Brian C. Christensen",
        author_email="brian@PureViolet.net",
        url="http://www.PureViolet.net/GanttPV/",
        scripts = ['GanttPV.py',],
        py_modules=['GanttReport', 'ID', 'Data', 'UI', 'Menu', 'QuickStart', 'ReportAids', 'StartupData', 'Zeroconf'],
#      packages=['', ''],
        data_files=[
        ('icons', [
                'icons/Assign Prerequisites.bmp',
                'icons/Assign Resources.bmp',
                'icons/Column Options.bmp',
                'icons/Delete Column.bmp',
                'icons/Delete Row.bmp',
                'icons/Delete.bmp',
                'icons/Duplicate.bmp',
                'icons/Hide Report.bmp',
                'icons/Icon Copyright.txt',
                'icons/Insert Column.bmp',
                'icons/Insert Report.bmp',
                'icons/Insert Row.bmp',
                'icons/Move Down.bmp',
                'icons/Move Left.bmp',
                'icons/Move Right.bmp',
                'icons/Move Up.bmp',
                'icons/New Project.bmp',
                'icons/Pencil.bmp',
                'icons/Pointer.bmp',
                'icons/Report.bmp',
                'icons/Scroll Left Fast.bmp',
                'icons/Scroll Left Slow.bmp',
                'icons/Scroll Right Fast.bmp',
                'icons/Scroll Right Slow.bmp',
                'icons/Scroll to Task.bmp',
                'icons/Show Hidden.bmp',
                # 'icons/Project.bmp',
                # 'icons/Report stack.bmp',
                # 'icons/Deleted Report.bmp',
                # 'icons/Lighted Report.bmp',
                # 'icons/Edit.bmp',
                # 'icons/GanttPV.bmp',
                # 'icons/Hide Hidden.bmp',
                ]),
        ('Scripts', [
        'Scripts/Copy Selection to Clipboard.py',
        'Scripts/Custom Colors and Sizes.py',
        'Scripts/Duplicate Project.py',
        'Scripts/Edit Column Options.py',
##        'Scripts/Edit Project Name.py',
        'Scripts/Edit Record.py',
##        'Scripts/Edit Report Name.py',
        'Scripts/Edit Work Week.py',
        'Scripts/Fill Down.py',
        'Scripts/Insert Custom Column.py',
        'Scripts/Move Task Start Dates.py',
        'Scripts/Paste Cells from Clipboard.py',
        'Scripts/Purge Deleted Items.py',
        'Scripts/PV and EV to Clipboard.py',
        'Scripts/Remove Assignments.py',
        'Scripts/Remove Dependencies.py',
        'Scripts/Reset Window Size.py',
        'Scripts/Select ID.py',
        'Scripts/Set Script Shortcuts.py',
        'Scripts/Task Network Diagram.py',
        'Scripts/changelog.txt',
        'Scripts/readme.txt',
        ]),
        ('Scripts/_Examples', [
        'Scripts/_Examples/Add Reports to Project.py',
        'Scripts/_Examples/Change Work Hours.py',
        'Scripts/_Examples/Sample HTML Chart.ganttpv',
        'Scripts/_Examples/Sample HTML Chart.html',
#        'Scripts/_Examples/Save Report Layouts.py',
        ]),
        ('Scripts/_Examples/Script Debugging Old Version', [
        'Scripts/_Examples/Script Debugging Old Version/Clear Saved Messages.py',
        'Scripts/_Examples/Script Debugging Old Version/Show Saved Messages.py',
        'Scripts/_Examples/Script Debugging Old Version/Start Saving Messages.py',
        ]),
        ('Scripts/_Transforms', [
        'Scripts/_Transforms/ganttpv_report.xslt',
        'Scripts/_Transforms/tasks_in_id_order.xslt',
        ]),
        ('Scripts/Alter Schedule', [
        'Scripts/Alter Schedule/Copy Plan to Baseline.py',
        'Scripts/Alter Schedule/Install Project Schedule Priority.py',
        'Scripts/Alter Schedule/One Task per Resource.py',
        ]),
        ('Scripts/Bar Colors', [
        'Scripts/Bar Colors/Assign Random Colors To Resources.py',
        'Scripts/Bar Colors/Install Resource Plan Bar Color.py',
        'Scripts/Bar Colors/Set Plan Bar Color By Dependency.py',
        'Scripts/Bar Colors/Set Plan Bar Color By Float.py',
        'Scripts/Bar Colors/Set Plan Bar Color By Resource.py',
        'Scripts/Bar Colors/Set Plan Bar Color By Startable.py',
        'Scripts/Bar Colors/Set Plan Bar Color To Default.py',
        'Scripts/Bar Colors/Set Plan Bar Color.py',
        ]),
        ('Scripts/Checklist', [
        'Scripts/Checklist/Add Checklist Item to Task.py',
        'Scripts/Checklist/Install Checklist Tracking.py',
        ]),
        ('Scripts/Hide - Show', [
        'Scripts/Hide - Show/Hide Children.py',
        'Scripts/Hide - Show/Hide If Category Not Action Item.py',
        'Scripts/Hide - Show/Hide If Category Not Issue.py',
        'Scripts/Hide - Show/Hide If ProjectID Not 1.py',
        'Scripts/Hide - Show/Hide Per Resource.py',
        'Scripts/Hide - Show/Show All Rows.py',
        'Scripts/Hide - Show/Show Children.py',
        'Scripts/Hide - Show/Show Only Current Tasks.py',
        ]),
        ('Scripts/Import', [
        'Scripts/Import/Import MS Project XML File.py',
        'Scripts/Import/Import PMGame File.py',
        ]),
        ('Scripts/Install', [
        'Scripts/Install/Analyze Install Scripts.py',
        'Scripts/Install/Install Assignment Role.py',
        'Scripts/Install/Install Document Tracking.py',
        'Scripts/Install/Install Float Tracking.py',
        'Scripts/Install/Install Follow Up Tracking.py',
        'Scripts/Install/Install Month Gantt Time Scale.py',
        'Scripts/Install/Install Partial Hour Duration.py',
        'Scripts/Install/Install Percent Complete.py',
        'Scripts/Install/Install Resource Tracking.py',
        'Scripts/Install/Install Task Actuals.py',
        'Scripts/Install/Install Task Baseline.py',
        'Scripts/Install/Install Task Hour.py',
        'Scripts/Install/Install Task Name Fields.py',
        'Scripts/Install/Install Task Parenting.py',
        'Scripts/Install/Install Task Project Name.py',
        'Scripts/Install/Install Time Units.py',
        'Scripts/Install/Install Week Gantt Time Scale.py',
        ]),
        ('Scripts/Object Role Modeling', [
        'Scripts/Object Role Modeling/Copy Diagram to Clipboard as EMF (Windows Only).py',
        'Scripts/Object Role Modeling/Generate SQL Deltas.py',
        'Scripts/Object Role Modeling/Generate SQL.py',
        'Scripts/Object Role Modeling/Insert Existing Object Types.py',
        'Scripts/Object Role Modeling/Install ORM Diagram.py',
        'Scripts/Object Role Modeling/Rmap Baseline.py',
        'Scripts/Object Role Modeling/Rmap.py',
        'Scripts/Object Role Modeling/Set Left Unique on Binary Fact Types.py',
        ]),
        ('Scripts/Print - Export', [
        'Scripts/Print - Export/Export as HTML.py',
        'Scripts/Print - Export/Export Database as XML.py',
        'Scripts/Print - Export/Print Report.py',
        'Scripts/Print - Export/Save as Script.py',
        'Scripts/Print - Export/Save Backup Copy of Database.py',
        'Scripts/Print - Export/Save Report Layouts.py',
        ]),
        ('Scripts/Resource Groups', [
        'Scripts/Resource Groups/Install Resource Groups.py',
        ]),
        ('Scripts/Script Debugging', [
        'Scripts/Script Debugging/Open GanttPV Explorer.py',
        'Scripts/Script Debugging/Open Python Editor.py',
        'Scripts/Script Debugging/Open Python Shell.py',
        'Scripts/Script Debugging/Show Messages.py',
        ]),
        ('Scripts/Sort', [
        'Scripts/Sort/Sort By Priority.py',
        'Scripts/Sort/Sort By Selected Column.py',
        'Scripts/Sort/Sort Like Related Report.py',
        ]),
#        ('Scripts/Test Suite', [
#        'Scripts/Test Suite/Test Date Routines.py',
#        ]),
        ('Scripts/Track Earned Value or Expenses', [
        'Scripts/Track Earned Value or Expenses/Install Measurement Tracking.py',
        'Scripts/Track Earned Value or Expenses/Update Measurements.py',
        ]),
        ('Scripts/Track Resource Hours', [
        'Scripts/Track Resource Hours/Calculate Assignment Hours.py',
        'Scripts/Track Resource Hours/Install Assignment Hours.py',
        ]),
        ('Scripts/zzMeasure', [
        'Scripts/zzMeasure/Earned Value Hours.py',
        'Scripts/zzMeasure/Expense.py',
        ]),
        ('locale', [
        'locale/pureviolet.pot',
        ]),
#        ('locale/en', [
#        ]),
#        ('locale/es', [
#        ]),
#        ('locale/fr', [
#        ]),
        ('locale/en/LC_MESSAGES', [
        'locale/en/LC_MESSAGES/pureviolet.mo',
        'locale/en/LC_MESSAGES/pureviolet.po',
        ]),
#        ('locale/en/LC_MESSAGES', [
#        ]),
#        ('locale/en/LC_MESSAGES', [
#        ]),
        ('', [
        'License.txt',
        'readme.txt',
        ]),
        ]
    )
