/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-app.h
 *
 * RCS:  $Id: eee-app.h,v 1.10 2002/11/07 01:20:03 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage Inc.
 *
 * Description:	EEE layer application interface prototypes
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/10/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_APP_H
#define _EEE_APP_H


int32
eee_allocateApplicationId(
	uchar8	* appName
);

int32
eee_deallocateApplicationId(
	int32	appId
);

int32
eee_registerReceiveFunc(
	int32	appId,
	void	(*app_rcv_func)(
				eee_descPtr_t	edesc
			),
	void	(*app_mcast_rcv_func)(
				eee_descPtr_t	edesc
			)
);

void
eee_unregisterReceiveFunc(
	int32	appId
);

int32
eee_getApplicationId(
	uchar8	* appName
);

uchar8 *
eee_getNameFromAppId(
	int32	appId
);

/*------------------------------------------------------------------
 *
 *                      Forwarder Interface
 *
 *------------------------------------------------------------------*/
int32
eee_sendMessage(
	void	* src,
	uint32	num_bytes,
	uint32	dest_port,
	uint32	source_port
);

/*++

Routine Description:

    Allocate the packet chain for sending message and copy the data from the
    buffer into the message. If first_edesc is not null, the allocated
    packet is returned here. If first_edesc is null, the message is send.

Arguments:

    src - message buffer
    num_bytes - message length
    dest_port - destination port
    source_port - source port
    first_edesc - if not null, the allocated descriptor is returned here

Return Value:

    NFX_OK
    EEE_ERR_NO_BUF
    EEE_ERR_NO_DESC
    EEE_ERR_UNKNOWN_PORT
    EEE_ERR_PACKET_TOO_LARGE
    EEE_ERR_BAD_PARAM
    
    EEE_FORWARDED_PACKET
    EEE_DROP_PACKET
    EEE_TX_QUEUE_FULL

--*/

int32
eee_alloc_or_send_message(void *src,
                          uint32 num_bytes,
                          uint32 dest_port,
                          uint32 source_port,
                          eee_desc_t **first_edesc);

void
eee_receivePacket(
	eee_descPtr_t	edesc
);

int32
eee_forwardPacket(
	eee_descPtr_t	edesc
);

uchar8 *
eee_getAppNameFromId(
	int32 app_id
);

int32
eee_sendFragmentedMessage(
	void *src,
	uint32 num_bytes,
	uint32 dest_port,
	uint32 source_port,
	eee_desc_t **firstDesc
);

/*------------------------------------------------------------------
 *
 *                      Cleanup Interface
 *
 *------------------------------------------------------------------*/

#define EEE_MAX_FREE_ROUTINES	8	

#if !defined(_KERNEL)
int32
eee_registerCleanupRoutine(
	void	(*function_name)(eee_descPtr_t	edesc));
#endif

/*------------------------------------------------------------------
 *
 *                      EEE application 
 *
 *------------------------------------------------------------------*/

enum eee_msg_type {
    /*
     * Show poll configuration.
     */
    EEE_MSG_POLLCFG_SHOW = EEE_MSG_BASE,

    /*
     * Show all poll configurations.
     */
    EEE_MSG_POLLCFG_SHOW_ALL,

    /*
     * Disable the external links and halt the cores.
     */
    EEE_MSG_HALT,
};

void eee_appRx(eee_descPtr_t edesc);

#endif	/* _EEE_APP_H */
