/*
 *-----------------------------------------------------------------
 *
 * Name:
 *
 * RCS:  $Id: eee-attr.c,v 1.7 2002/11/07 01:20:03 rick Exp $
 *
 * Copyright (C) 2002, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */

#include "nfx-incl.h"
#include "../sm-eee/eee-api.h"
#include "../sm-chassis/cm-api.h"
#ifdef DMALLOC
#include "dmalloc.h"
#endif

#ifdef EEE_ATTR

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrInit()
{
	uint32  my_index, i;

	printf("[eee_initAttribute]\n");

	GET_MY_MEMPOOL_INDEX(my_index);

	eee.desc_attr[my_index] =
					eee_allocateBlock(eee.sm_num_desc * sizeof(eee_attr_t));


	for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
		eee.buf_attr[my_index][i] = 
					eee_allocateBlock(eee.sm_num_buf[i] * sizeof(eee_attr_t));
	}

	printf("[eee_initAttribute] leaving\n");
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
eee_attr_t *
eee_attrGetDescAttrPtr(
	eee_descPtr_t	addr
)
{
	uint32	mp, index;

	for (mp = 0; mp < EEE_NUM_MEM_POOLS; mp++) {
		if ((addr >= eee.desc_base[mp]) &&
										(addr < eee.desc_end[mp])) {
			index = (addr - eee.desc_base[mp]);
			return &(eee.desc_attr[mp][index]);
		}
	}

	return 0;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
eee_attr_t *
eee_attrGetBufAttrPtr(
	address_t	addr
)
{
	uint32	mp, bs, index;

	for (mp = 0; mp < EEE_NUM_MEM_POOLS; mp++) {
		for (bs = 0; bs < EEE_NUM_BUF_SIZES; bs++) {
			if ((addr >= (address_t)eee.buf_base[mp][bs]) &&
									(addr < (address_t)eee.buf_end[mp][bs])) {
				index = (addr -(address_t)eee.buf_base[mp][bs])/eee.buf_size[bs];
				return &(eee.buf_attr[mp][bs][index]);
			}
		}
	}

	return 0;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
eee_attr_t *
eee_attrGetAttrPtr(
	address_t	addr
)
{
	eee_attr_t	* ptr;

	/*
	 * Is this address a descriptor ?
	 */
	if (ptr = eee_attrGetDescAttrPtr((eee_descPtr_t)addr))
		return ptr;

	/*
	 * Is this address a buffer ?
	 */
	if (ptr = eee_attrGetBufAttrPtr(addr))
		return ptr;

	return 0;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrDisplayConfig()
{
	uint32	i, j;

	for (i=0; i<EEE_NUM_MEM_POOLS; i++)
		printf("eee.desc_attr[%d] at %p\n", i, eee.desc_attr[i]);
	printf("\n");
	for (i=0; i<EEE_NUM_MEM_POOLS; i++)
		for (j=0; j<EEE_NUM_BUF_SIZES; j++)
			printf("eee.buf_attr[%d][%d] at %p\n", i, j, eee.buf_attr[i][j]);
	printf("\n");
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrDisplay(
	address_t	addr
)
{
	eee_attr_t	* ptr;
	byte		first, last;

	ptr = eee_attrGetAttrPtr(addr);

	if (!ptr) {
		printf("Invalid address, %p\n", addr);
		return;
	}

	printf("ptr at %p\n", ptr);
	first = ptr->index;
	last = first;
	do {
		if (last == 0)
			last = EEE_ATTR_MAX-1;
		else
			last--;

		printf("   %d: %d\n", ptr->cpu_id[last], ptr->attr[last]);
	} while (last != first);

	printf("\n");
	printf("valid free codes: %d  %d  %d  %d\n", ptr->free_valid[0],
														ptr->free_valid[1],
														ptr->free_valid[2],
														ptr->free_valid[3]);
	printf("\n");
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrAssignPkt(
	eee_descPtr_t	edesc,
	byte			attr
)
{
	eee_attr_t			* ptr;
	eee_descBufPtr_t	bd;
	uint32				i, num_bufs;

	while (edesc) {
		eee_attrAssignDesc(edesc, attr);

		bd = &(edesc->bd[0]);
		if (!(edesc->hdr.control & EDESC_COMMAND_USE_FIRST_BUFFER))
			bd++;

		num_bufs = EEE_GET_NUM_BUFS(edesc);
		for (i=0; i<num_bufs; i++) {
			eee_attrAssignBuf(bd->buf, attr);
			bd++;
		}
		edesc=edesc->hdr.next;
	}
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrAssignDesc(
	eee_descPtr_t	edesc,
	byte			attr
)
{
	eee_attr_t	* ptr;

	ptr = eee_attrGetDescAttrPtr(edesc);

	if (!ptr)
		panic("attrAssignDesc, Invalid edesc addr, %p, attr = 0x%x\n", edesc, attr);

	ptr->attr[ptr->index] = attr;
	ptr->cpu_id[ptr->index] = nfxMyCPUId;
	if (++ptr->index == EEE_ATTR_MAX)
		ptr->index = 0;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrAssignBuf(
	void	* buf,
	byte	attr
)
{
	eee_attr_t	* ptr;

	ptr = eee_attrGetBufAttrPtr((address_t)buf);

	if (!ptr)
		panic("attrAssignBuf, Invalid buf addr, %p, attr = 0x%x\n", buf, attr);

	ptr->attr[ptr->index] = attr;
	ptr->cpu_id[ptr->index] = nfxMyCPUId;
	if (++ptr->index == EEE_ATTR_MAX)
		ptr->index = 0;

}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
int32
eee_attrOkToFreeDesc(
	eee_descPtr_t	edesc
)
{
	eee_attr_t	* ptr;
	byte		last_attr;

	ptr = eee_attrGetDescAttrPtr(edesc);

	if (ptr->index == 0)
		last_attr = ptr->attr[EEE_ATTR_MAX-1];
	else
		last_attr = ptr->attr[ptr->index-1];

	if (ptr->free_valid[0]) {
		if ((ptr->free_valid[0] == last_attr) ||
			(ptr->free_valid[1] == last_attr) ||
			(ptr->free_valid[2] == last_attr) ||
			(ptr->free_valid[3] == last_attr)) 
			return 1;
		else
			return 0;
	}

	return 1;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
int32
eee_attrOkToFreeBuf(
	void	* buf
)
{
	eee_attr_t	* ptr;
	byte		last_attr;

	ptr = eee_attrGetBufAttrPtr((address_t)buf);

	if (ptr->index == 0)
		last_attr = ptr->attr[EEE_ATTR_MAX-1];
	else
		last_attr = ptr->attr[ptr->index-1];

	if (ptr->free_valid[0]) {
		if ((ptr->free_valid[0] == last_attr) ||
			(ptr->free_valid[1] == last_attr) ||
			(ptr->free_valid[2] == last_attr) ||
			(ptr->free_valid[3] == last_attr)) 
			return 1;
		else
			return 0;
	}

	return 1;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrSetPktValidFreeAttr(
	eee_descPtr_t	edesc,
	byte			attr0,
	byte			attr1,
	byte			attr2,
	byte			attr3
)
{
	uint32				i, num_bufs;
	eee_descBufPtr_t	bd;

	while (edesc) {
		bd = &(edesc->bd[0]);
		if (!(edesc->hdr.control & EDESC_COMMAND_USE_FIRST_BUFFER))
			bd++;

		num_bufs = EEE_GET_NUM_BUFS(edesc);
		for (i=0; i<num_bufs; i++) {
			eee_attrSetBufValidFreeAttr(bd->buf, attr0, attr1, attr2, attr3);
			bd++;
		}

		eee_attrSetDescValidFreeAttr(edesc,  attr0, attr1, attr2, attr3);
		edesc=edesc->hdr.next;
	}
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrSetDescValidFreeAttr(
	eee_descPtr_t	edesc,
	byte			attr0,
	byte			attr1,
	byte			attr2,
	byte			attr3
)
{
	eee_attr_t	* ptr;
	
	ptr = eee_attrGetDescAttrPtr(edesc);

	ptr->free_valid[0] = attr0;
	ptr->free_valid[1] = attr1;
	ptr->free_valid[2] = attr2;
	ptr->free_valid[3] = attr3;
}

void
eee_attrGetDescValidFreeAttr(
	eee_descPtr_t	edesc,
	byte			* attr0,
	byte			* attr1,
	byte			* attr2,
	byte			* attr3
)
{
	eee_attr_t	* ptr;
	
	ptr = eee_attrGetDescAttrPtr(edesc);

	*attr0 = ptr->free_valid[0];
	*attr1 = ptr->free_valid[1];
	*attr2 = ptr->free_valid[2];
	*attr3 = ptr->free_valid[3];
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrSetBufValidFreeAttr(
	void	* buf,
	byte	attr0,
	byte	attr1,
	byte	attr2,
	byte	attr3
)
{
	eee_attr_t	* ptr;
	
	ptr = eee_attrGetBufAttrPtr((address_t)buf);

	ptr->free_valid[0] = attr0;
	ptr->free_valid[1] = attr1;
	ptr->free_valid[2] = attr2;
	ptr->free_valid[3] = attr3;
}

void
eee_attrGetBufValidFreeAttr(
	void	* buf,
	byte	* attr0,
	byte	* attr1,
	byte	* attr2,
	byte	* attr3
)
{
	eee_attr_t	* ptr;
	
	ptr = eee_attrGetBufAttrPtr((address_t)buf);

	*attr0 = ptr->free_valid[0];
	*attr1 = ptr->free_valid[1];
	*attr2 = ptr->free_valid[2];
	*attr3 = ptr->free_valid[3];
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/7/02
 *
 *-----------------------------------------------------------------
 */
byte
eee_attrGetDescLastAttr(
	eee_descPtr_t	edesc
)
{
	eee_attr_t	* ptr;
	byte		last_attr;
	
	ptr = eee_attrGetDescAttrPtr(edesc);
	
	if (ptr->index == 0)
		last_attr = ptr->attr[EEE_ATTR_MAX-1];
	else
		last_attr = ptr->attr[ptr->index-1];

	return last_attr;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/7/02
 *
 *-----------------------------------------------------------------
 */
byte
eee_attrGetBufLastAttr(
	void	* buf
)
{
	eee_attr_t	* ptr;
	byte		last_attr;
	
	ptr = eee_attrGetBufAttrPtr(buf);
	
	if (ptr->index == 0)
		last_attr = ptr->attr[EEE_ATTR_MAX-1];
	else
		last_attr = ptr->attr[ptr->index-1];

	return last_attr;
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/23/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrShowDescAll()
{
	uint32			desc_attr[256];
	byte			last;
	uint32			attr;
	uint32			mp;
	eee_descPtr_t	desc;

	bzero(desc_attr, sizeof(desc_attr));

	GET_MY_MEMPOOL_INDEX(mp);

	for (desc =	 eee.desc_base[mp]; desc < eee.desc_end[mp]; desc ++) {
		last = eee_attrGetDescLastAttr(desc);
		desc_attr[last]++;
	}

	printf("Descriptor attributes:\n");
	printf("----------------------\n");
	for (attr=0; attr<256; attr++) {
		printf("%3d: %d\n", attr, desc_attr[attr]);
	}
	printf("----------------------\n\n");
}

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/23/02
 *
 *-----------------------------------------------------------------
 */
void
eee_attrShowBufAll()
{
	uint32			buf_attr[256][EEE_NUM_BUF_SIZES];
	uint32			buf_tot[EEE_NUM_BUF_SIZES];
	byte			last;
	uint32			attr;
	uint32			mp, bufsize;
	uchar8			* buf;

	bzero(buf_attr, sizeof(buf_attr));
	bzero(buf_tot, sizeof(buf_tot));

	GET_MY_MEMPOOL_INDEX(mp);

	for (bufsize = 0; bufsize < EEE_NUM_BUF_SIZES; bufsize++) {
		for (buf = eee.buf_base[mp][bufsize];
				buf < eee.buf_end[mp][bufsize]; buf += eee.buf_size[bufsize]) {
			last = eee_attrGetBufLastAttr(buf);
			buf_attr[last][bufsize]++;
		}
	}

	printf("Buffer attributes:\n");
	printf("Attr         Small         Large         Ultra          Mgmt\n");
	printf("------------------------------------------------------------\n");
	for (attr=0; attr<256; attr++) {
		printf("%3d:", attr);
		for (bufsize = 0; bufsize < EEE_NUM_BUF_SIZES; bufsize++) {
			printf("  %12d", buf_attr[attr][bufsize]);
			buf_tot[bufsize] += buf_attr[attr][bufsize];
		}
		printf("\n");
	}
	printf("------------------------------------------------------------\n\n");

	printf("tot:");
	for (bufsize = 0; bufsize < EEE_NUM_BUF_SIZES; bufsize++) {
		printf("  %12d", buf_tot[bufsize]);
	}
	printf("\n");
}

#endif

