/* 
 *-----------------------------------------------------------------
 *
 * Name:    eee-dvt.c
 *
 * RCS:  $Id: eee-dvt.c,v 1.5 2002/11/07 01:20:03 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:    Test routines for the dvt test.
 *
 * Created by: lipika    
 *
 * Date Created:    6/04/02
 *
 *-----------------------------------------------------------------
 */

#include "nfx-incl.h"
#include "../sm-eee/eee-api.h"
#include "../sm-eee/eee-test.h"
#include "../sm-timer/timer-api.h"
#if defined(SSC) || defined(SSC_MGMT) || defined(FCNIM)
#include "../sm-malloc/malloc-api.h"
#else
#include "../sm-malloc-slab/malloc-api.h"
#endif
#if defined (NFP_TXRX) || (defined (NFP_FP) && !defined(COUGAR))
#include "../sm-bmc12500-eth/bmc12500-eth.h"
#include "../sm-bmc12500-eth/bmc12500-eth-mii.h"
#ifdef NFP_TXRX
#include <sys/bmfpga.h>
#ifdef DMALLOC
#include "dmalloc.h"
#endif
#endif
#endif

//@@@ Change for Cougar to use all four ethernet MACs

#define DVT_NFP_PORT_TXRX_MAX    4
// #define BC1250_MAC_CNT        3
#undef  BC1250_MAX_PKT_SIZE
#define BC1250_MAX_PKT_SIZE     1000    
#define EEE_TEST_NUM_PKT_SPEC_TXRXFRONT        100 


#ifdef NFP_TXRX
uint32    front_seq[2][DVT_NFP_PORT_TXRX_MAX] = {{0,0,0,0},{0,0,0,0}}; /* cpu 0, 1 for TXRX */
uint32    next_exp_front_seq[2][DVT_NFP_PORT_TXRX_MAX] = {{0,0,0,0},{0,0,0,0}};
extern bc1250EthCfg_t *bcEthCfg[BC1250_MAC_CNT];
int dvt_bmc12500Eth_diagTxLuc(uint32 port, uint32 size, uint32 seq);
extern uint32 isTXRXrevH;
extern uint32 isTXRXbmfpga6;
uint32 bmfpga_swap(uint32 t);
#endif

dvt_front_cfg dvtFrontCfg;
uint32  incoming_appid;

 /* sentFromSSC[cpu][plane]  Now max cpu on NFP/NFC is 4 per card */
extern uint32  sentFromSSC[4][3];
uchar8  static_hdr[DVT_NFP_PORT_TXRX_MAX][70];
extern volatile uint32 dvtStop;
extern uint32    next_exp_seq_num[NFX_NUM_SLOTS_PER_CHASSIS][NFX_MAX_CPUS_PER_SLOT][3];
extern uint32 nfxMySlotId;
extern uint32 nfxMyCPUId;
extern eee_dvt_test_stats    dvtstats;
extern eee_dvt_txrx_stats    dvtstats_txrx;
uint32  pktSize=0;

/* Function Declarations */
//  in sm-seep/env.c
extern int32 check_env_copper_sfp(int32 unit);
extern int32 copper_set_loopback_mode( uint32 port);

void eee_reinit_validity_table();
void eee_systemDVTSend(uint32 slot, uint32 cpu, uchar8 * bfr, uint32 size);
void dvt_rcvd_txrx_front_pkt(eee_descPtr_t edesc);
int dvt_bmc12500_spin_pkt(eee_descPtr_t edesc,uint32 port);
void eee_dvttestFrontEnd(uint32 plane);
void dvt_front_loopback(eee_test_hdr_t    *test_hdr);
eee_descPtr_t eee_testCreateDVTTestPkt(uint32 slot,uint32 cpu,eee_test_hdr_t  * pktSpec,uint32 seq);
void dvtRemake_front_pkt(uint32 seq, uint32 link);
void dvt_front_loopback_port(uint32 plane, uint32 port, uint32 size);
#if defined(SIBYTE) && defined(BOBCAT)
int32 gt_mii_writeSMI(uint32 phyAddr, uint32 regAddr, uint32 value, uint32 mask);
#else
void dp83820_writeMII_common(uint32 unit, uint32 phy_id, uint32 reg, uint32 data);
#endif

sysdvt_qlogic_t  *qdvt;

uint32 setPhyIntlpbk=0;



/*-----------------------------------------------------------------
 * Name:    eee_systemDVTinit()
 *
 * Description: Initialises some dvt related params.    
 *
 * Created by: lipika    
 *
 * Date Created:    9/26/02
 *
 *-----------------------------------------------------------------
 */
void
eee_systemDVTinit()
{
    qdvt = (sysdvt_qlogic_t  *)eee_ramAlloc(sizeof(sysdvt_qlogic_t));
    memset(qdvt,0,sizeof(sysdvt_qlogic_t));
    return;
}

/*-----------------------------------------------------------------
 * Name:    eee_systemDVTSend()
 *
 * Description:    Sends a msg to the SSC application
 *
 *                  This function is used by other apps. 
 *                  There is a snmp MIB function that uses
 *                  this function to get stats (Fan, PS, and Pkt counts)
 *
 * Created by: lipika    
 *
 * Date Created:    5/26/02
 *
 *-----------------------------------------------------------------
 */
void
eee_systemDVTSend(uint32 slot, uint32 cpu, uchar8 * bfr, uint32 size)
{
    uint32                  dp;
    uint32                  sp;
    uint32 rc;
    
    dp = PACK_UNICAST_PORT_ADDRESS(slot,
                                   cpu,
                                   incoming_appid,
                                   EEE_MGMT,
                                   NFX_COS_HIGH,
                                   PORT_BEST_FIT);

    sp = PACK_UNICAST_PORT_ADDRESS(nfxMySlotId,
                                   nfxMyCPUId,
                                   eee.dvt_test_app_id,
                                   EEE_MGMT,
                                   NFX_COS_HIGH,
                                   PORT_BEST_FIT);

    
    rc = eee_sendMessage(bfr, size, dp, sp);
    if (rc == EEE_FORWARDED_PACKET) {
 
        SYSDVT_DPRINT(("systemDVTSend dp %08x sp %08x, msg %02x%02x%02x%02x\n",
               dp,sp,bfr[0],bfr[1],bfr[2],bfr[3]));
    }            
    else 
        SYSDVT_DPRINT(("PKT NOT fwd!!\n"));                    
}

/*-----------------------------------------------------------------
 * Name:    eee_reinit_validity_table()
 *
 * Description:    Re-initialize receive functions for test application
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
void
eee_reinit_validity_table()
{
    /* data */
    eee.test_dvt_valid[0][0][EEE_MGMT] = 0;
    eee.test_dvt_valid[0][1][EEE_MGMT] = 0;
    eee.test_dvt_valid[1][0][EEE_MGMT] = 1;
    eee.test_dvt_valid[1][1][EEE_MGMT] = 0;
    eee.test_dvt_valid[1][2][EEE_MGMT] = 0;
    eee.test_dvt_valid[1][3][EEE_MGMT] = 0;
    eee.test_dvt_valid[2][0][EEE_MGMT] = 1;
#ifdef BOBCAT
// olny 2 . 0
    eee.test_dvt_valid[2][1][EEE_MGMT] = 0;
    eee.test_dvt_valid[2][2][EEE_MGMT] = 0;
    eee.test_dvt_valid[2][3][EEE_MGMT] = 0;
#else
    eee.test_dvt_valid[2][1][EEE_MGMT] = 1;
    eee.test_dvt_valid[2][2][EEE_MGMT] = 1;
    eee.test_dvt_valid[2][3][EEE_MGMT] = 1;
#endif
    eee.test_dvt_valid[0][0][EEE_CONTROL] = 0;
    eee.test_dvt_valid[0][1][EEE_CONTROL] = 0;
    eee.test_dvt_valid[1][0][EEE_CONTROL] = 0;
    eee.test_dvt_valid[1][1][EEE_CONTROL] = 0;
    eee.test_dvt_valid[1][2][EEE_CONTROL] = 1;
    eee.test_dvt_valid[1][3][EEE_CONTROL] = 0;
    eee.test_dvt_valid[2][0][EEE_CONTROL] = 1;

#ifdef BOBCAT
// olny 2 . 0
    eee.test_dvt_valid[2][1][EEE_CONTROL] = 0;
    eee.test_dvt_valid[2][2][EEE_CONTROL] = 0;
    eee.test_dvt_valid[2][3][EEE_CONTROL] = 0;
#else
    eee.test_dvt_valid[2][1][EEE_CONTROL] = 1;
    eee.test_dvt_valid[2][2][EEE_CONTROL] = 1;
    eee.test_dvt_valid[2][3][EEE_CONTROL] = 1;
#endif
    eee.test_dvt_valid[0][0][EEE_USER_DATA] = 0;
    eee.test_dvt_valid[0][1][EEE_USER_DATA] = 0;
    eee.test_dvt_valid[1][0][EEE_USER_DATA] = 0;
    eee.test_dvt_valid[1][1][EEE_USER_DATA] = 0;
    eee.test_dvt_valid[1][2][EEE_USER_DATA] = 1;
    eee.test_dvt_valid[1][3][EEE_USER_DATA] = 1;
    eee.test_dvt_valid[2][0][EEE_USER_DATA] = 1;
#ifdef BOBCAT
// olny 2 . 0
    eee.test_dvt_valid[2][1][EEE_USER_DATA] = 0;
    eee.test_dvt_valid[2][2][EEE_USER_DATA] = 0;
    eee.test_dvt_valid[2][3][EEE_USER_DATA] = 0;
#else
    eee.test_dvt_valid[2][1][EEE_USER_DATA] = 1;
    eee.test_dvt_valid[2][2][EEE_USER_DATA] = 1;
    eee.test_dvt_valid[2][3][EEE_USER_DATA] = 1;
#endif

}        

/*-----------------------------------------------------------------
 * Name:    dvtRemake_pkt(slot, cpu, seq, plane, spin)
 *
 * Description: Recreates a missing pkt with the missed seq no for 
 *                that slot, cpu, plane.    
 *
 * Created by: lipika    
 *
 * Date Created:    6/12/02
 *
 *-----------------------------------------------------------------
 */
void
dvtRemake_pkt(uint32 slot, uint32 cpu, uint32 seq, eee_test_hdr_t  *pktHdr)
{
    eee_descPtr_t    edesc;

    edesc = (eee_descPtr_t)eee_testCreateDVTTestPkt(slot, cpu, pktHdr, seq);
    if (edesc) {
        if ((eee_forwardPacket(edesc)) != EEE_FORWARDED_PACKET)
#ifdef USE_SMP                        
            ATOMIC_INC_INT(&eee.test_dvt_send_err[pktHdr->plane], 1);
#else                        
            eee.test_dvt_send_err[pktHdr->plane]++;
#endif                            
        else
        {        
#ifdef USE_SMP                        
            ATOMIC_INC_INT(&dvtstats.packets_sent[pktHdr->plane], 1);
            ATOMIC_INC_INT(&dvtstats.bytes_sent[pktHdr->plane],pktHdr->size);
#else                        
            dvtstats.packets_sent[pktHdr->plane]++;
            dvtstats.bytes_sent[pktHdr->plane] += pktHdr->size;
#endif                            
        }    
    }    
}

#ifdef NFP_TXRX
/*-----------------------------------------------------------------
 * Name:    dvt_rcvd_txrx_front_pkt(edesc)
 *
 * Description: Processes DATA pkts that are rcvd on the front ports
 *                 of the txrx.
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
void
dvt_rcvd_txrx_front_pkt(eee_descPtr_t edesc)
{
    uint32  seq;
    uint32  src_slot, src_cpu, src_plane;
    eee_test_hdr_t    * test_hdr;
    eee_descBuf_t    * bd;
    uint32  port;
    uint32  rc;
    uint32  cp_pktsize=0;

    bd = &(edesc->bd[0]);
    if (!(edesc->hdr.control & EDESC_COMMAND_USE_FIRST_BUFFER))
        bd++;
    test_hdr = (eee_test_hdr_t *)(bd->buf);

    seq = test_hdr->seq;
    port = test_hdr->port;
    /* Sanity check: Port within range? */
    if ((port < 0) || (port > 4)) {
        printf("dvt_rcvd_txrx_front_pkt: Invalid port %d\n", port);
        eee_freePacket(edesc);
        return;
    }        

    /* Increment the per port counter */
    dvtstats_txrx.txrxFront_packets_received[port] ++;
    dvtstats_txrx.txrxFront_bytes_received[port] += test_hdr->size;
    cp_pktsize = test_hdr->size;

    src_slot = EEE_GET_SLOT_NUM(edesc->hdr.src_port);
    src_cpu = EEE_GET_DEST_CPU(edesc->hdr.src_port);
    src_plane = EEE_GET_DTYPE(edesc->hdr.src_port);
    
    // If seq No of rcvd pkt > expectd, then pkt was dropped.
    // Remake missing pkt and increment the extd pkt no by 1.
    if (seq > next_exp_front_seq[nfxMyCPUId][port]) {
        printf("%s test error, expected seq %d, got %d, slot %d, cpu %d port %d Replacing pkt.\n",
                "DATA",
                next_exp_front_seq[nfxMyCPUId][port], seq,
                src_slot, src_cpu, port);
        dvtRemake_front_pkt(next_exp_front_seq[nfxMyCPUId][port], port);
        next_exp_front_seq[nfxMyCPUId][port] = seq;
        eee.test_dvt_rcv_err[src_plane]++; /* DATA */
        dvtstats_txrx.txrxFront_seq_errors[port]++;

        /* For now we don't END the test, but record how many out of
         * sequence packets we've received
         */ 
    }
    else if (seq < next_exp_front_seq[nfxMyCPUId][port]) {
        if(next_exp_front_seq[nfxMyCPUId][port] == 
             (EEE_TEST_NUM_PKT_SPEC_TXRXFRONT - 1)) {        
            printf("%s test error, expected seq %d, got %d, slot %d, cpu %d port %d .\n",
                    "DATA",
                    next_exp_front_seq[nfxMyCPUId][port],
                    seq, src_slot, src_cpu, port);
            dvtRemake_front_pkt(next_exp_front_seq[nfxMyCPUId][port], port);
            next_exp_front_seq[nfxMyCPUId][port] = seq;
        }
        else {        
            /* we are receiving a delayed pkt. i
             * It should have been replaced earlier 
             */
            printf("%s test error, expected seq %d, got %d, slot %d, cpu %d port %d Dropping pkt.\n",
                    "DATA", 
                    next_exp_front_seq[nfxMyCPUId][port], 
                    seq, src_slot, src_cpu, port);
            eee_freePacket(edesc);
            return;
        }
    }        
    next_exp_front_seq[nfxMyCPUId][port] = 
         (next_exp_front_seq[nfxMyCPUId][port] + 1) 
                  % EEE_TEST_NUM_PKT_SPEC_TXRXFRONT;
    delay_us(10);
    rc = dvt_bmc12500_spin_pkt(edesc, port);
    if (rc != EEE_FORWARDED_PACKET) {
        eee.test_dvt_send_err[src_plane]++;
        dvtstats_txrx.txrxFront_packet_send_errors[port]++;
    }    
    else{
        eee.test_dvt_my_sent[src_slot][src_cpu][src_plane]++;
        dvtstats_txrx.txrxFront_packets_sent[port] ++;
        dvtstats_txrx.txrxFront_bytes_sent[port] += cp_pktsize;
    }    
}

/*-----------------------------------------------------------------
 * Name:    dvt_bmc12500_spin_pkt(edesc, port)
 *
 * Description: Formats the spinning pkt with appropriate hdrs 
 *                 for Cheetah.    
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
int
dvt_bmc12500_spin_pkt(eee_descPtr_t edesc,uint32 port)
{
    uint32 pktLen;
    uint32 rc;
    uchar8 *newBufp;
    uchar8 *tmp;
    uchar8 *bptr;
    uint32 bs;
    uint32 len=0;
    eee_descBuf_t   *bd;
    uint32            bufCnt;

    bd     = (edesc->hdr.control & EDESC_COMMAND_USE_FIRST_BUFFER) ?
                         &(edesc->bd[0]) : &(edesc->bd[1]);
    bufCnt = (edesc->hdr.control & EDESC_BUFCNT_MASK) >> EDESC_BUFCNT_SHIFT;
    bptr  = bd->buf;
    len = bd->len;
    /* new */
    if(pktSize < 1766 )
        bs = 1;
    else 
        bs = 2;    

    newBufp = eee_allocateBuffer(eee.my_pool_id, bs, NFX_COS_HIGH);
    if( !newBufp ) {
        printf("Test data buffer allocation failed.\n");
        return(NFX_OK);
    }

    memcpy(newBufp,&static_hdr[port],64);
    tmp = newBufp;
    tmp+=64;
    pktLen = edesc->hdr.control & EDESC_TOTAL_LEN;
    memcpy(tmp,bptr,len-64); //copy original pkt contents from test_hdr

    bd->len+=64;
    memcpy(bptr,newBufp,bd->len);
    eee_deallocateBuffer(newBufp);

    pktLen+=64;
    if( (address_t)((bd->buf) + (bd->len)) & 0x1F ) {        
        bd->len -= 6;
        pktLen -= 6;
    }        
    //printf("Spinning pkt\n");
    //bmc12500Eth_printBuf( edesc->bd[1].buf, edesc->bd[1].len, 0);  
    edesc->hdr.control &= ~EDESC_TOTAL_LEN;
    edesc->hdr.control |= (pktLen & EDESC_TOTAL_LEN);
    edesc->hdr.dest_port = dvtFrontCfg.sp[port];
    rc = bmc12500Eth_txUnicast( edesc->hdr.dest_port,edesc );
    return rc;
}

/*-----------------------------------------------------------------
 * Name:    eee_dvttestFrontEnd(plane)
 *
 * Description:    Stops traffic on the front plane of the txrx.
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
void
eee_dvttestFrontEnd(uint32 plane)
{

    uint32 i=0;
    uint32 phyAddr=0;

    if (!eee.test_dvt_running[plane]) {
        printf("EEE test not running In dvttestFrontEnd plane = %0x \n",plane);
        return;
    }

    // plane comes is as 4 ..aray is only 3
    // eee.test_dvt_running[plane] = 0;
    // eee.test_dvt_running[plane]  could be writting out of bounds
    VERIFY((plane >= 0) && (plane < 3));
    // in this case we are using plane 0, EEE_USER_DATA
    eee.test_dvt_running[EEE_USER_DATA] = 0;
    dvtFrontCfg.test_started = 0;

    /*
     * Reset ALL ports from PHY loopback 
     */  
    for(i=0;i < DVT_NFP_PORT_TXRX_MAX ;i++) {

#if defined(COUGAR)
        bc1250EthCfg_t *cfg;

        cfg = getEthCfgForPort(i);
        phyAddr = cfg->phy.addr;

        bmc12500Eth_mii_write(&cfg->regs, phyAddr, MII_BMCR, 
                          BMCR_ANENABLE | BMCR_DUPLEX | BMCR_SPEED1);
#else
        phyAddr = 0x10 + i;
#if defined(SIBYTE) && defined(BOBCAT)
        gt_mii_writeSMI(phyAddr, MII_BMCR, 
                        BMCR_ANENABLE | BMCR_DUPLEX | BMCR_SPEED1, 0xffff);
#else                    
        dp83820_writeMII_common(0, phyAddr, 0, 
                                0x1140);
#endif
#endif        
        delay_us(10000);
    }
    setPhyIntlpbk = 0;

#ifdef NFP_TXRX
    /* 08/06/04: For Rev H boards with bmfpga ver 6, set bit 8 of the
     * bmfpga before test starts and clear it when test is over.
     * This forces the link led to ignore link status from the lsi 
     * or sfp and the link led will be driven during the internal lpbk
     * without any external cables.
     */    
    uint32 bmfpga_res;
#if defined(SIBYTE) && defined(BOBCAT)
    /* Do this for all bobcat versions */
    bmfpga_res = *(uint32 *)(HW_BMFPGA_BASE_VIRT + 4);
    *(uint32 *)(HW_BMFPGA_BASE_VIRT + 4) = 
        bmfpga_swap(bmfpga_swap(bmfpga_res) & ~BMFPGA_RES_TXRX_LINK_IGNORE); 
#else
    if((isTXRXrevH) && (isTXRXbmfpga6)) {
        bmfpga_res = *(uint32 *)(HW_BMFPGA_BASE_VIRT + 4);
        *(uint32 *)(HW_BMFPGA_BASE_VIRT + 4) = 
           bmfpga_swap(bmfpga_swap(bmfpga_res) & ~BMFPGA_RES_TXRX_LINK_IGNORE); 
    }    
#endif // SIBYTE && BOBCAT
#endif            

    // Debug FP and TXRX crash in sysDvt
    VERIFY((plane >= 0) && (plane < 3));
    VERIFY((nfxMyCPUId >= 0) && (nfxMyCPUId < 4));

    if(sentFromSSC[nfxMyCPUId][plane])
        eee_testInit();
    sentFromSSC[nfxMyCPUId][plane] = 0;
}

/*-----------------------------------------------------------------
 * Name:    dvtRemake_front_pkt(uint32 seq, uint32 link)
 *
 * Description: Recreates a missing pkt with missed seq no for that link.    
 *
 * Created by: lipika    
 *
 * Date Created:    6/12/02
 *
 *-----------------------------------------------------------------
 */
void
dvtRemake_front_pkt(uint32 seq, uint32 link)
{
    //printf("remake_front_pkt : link %d seq %d\n",link, seq);
    dvt_bmc12500Eth_diagTxLuc(link, pktSize, seq);
}

#if defined(SIBYTE) && defined(BOBCAT) && defined (NFP_TXRX)
uint32 copper_loopback = 0;
uint32 rc = 0;
#endif

/*-----------------------------------------------------------------
 * Name:    dvt_front_loopback(plane)
 *
 * Description: Starts the front plane loopback test.    
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
void
dvt_front_loopback(eee_test_hdr_t    *test_hdr)
{
    uint32 port;
    uint32 i, plane;
    uint32 phyAddr=0;

    /* do not allow test to proceed on second core */
    if((nfxMySlotId == NFX_SLOTTYPE_NFP) && (nfxMyCPUId == NFX_NFP_TXRX2)) {
        
        return;
    }

// Debug -------------
    if(!((test_hdr->plane >= 0) && (test_hdr->plane < 3))) {
        printf("In dvt_front_loopback() plane = %0x not between 0-2\n",
                test_hdr->plane);
    }
// Debug -------------

    plane = test_hdr->plane;
    if(plane == SYS_DVT_FRONT) {
        plane = EEE_USER_DATA;
    }
    
    memset(&dvtFrontCfg, 0, sizeof(dvt_front_cfg));

    // Add a check to see if the SFP's are copper.. If so set them up to allow 
    //    internal and external loop back modes...
#if defined(SIBYTE) && defined(BOBCAT) && defined (NFP_TXRX)
    // Need to be global so it only happens once
    // uint32 copper_loopback = 0;
    // uint32 rc = 0;

    if ( (isTXRX()) && (nfxMyCPUId == NFX_NFP_TXRX1)) {
        /* if TXRX check SFP to see if copper */
        /* do it once only */
        if(!copper_loopback) {
            copper_loopback = 1;
            for(i=0; i<4; i++) {
                // in sm-seep/env.c
                if(check_env_copper_sfp(i)) {
                    printf(" Copper SFP found port %d \n",i);
                    rc = copper_set_loopback_mode( i);
                    if( rc != NFX_OK ) {
                        printf("Error Setting Copper SFP Loopback Port %d\n",i);
                        copper_loopback = 0;
                    }
                }
                else
                    printf(" Fiber  SFP found port %d \n",i);
            }
            // need a big delay to allow event manager to discover Copper SFP's
            printf(" -Wait for EVM to discover Copper SFP's if found.\n");
            delay_us(750000);  // 3/4 of a second (.75)
        }
    }

#endif
    //printf("Port %x loopback %d\n",test_hdr->port,test_hdr->loopback);                
    /*
     * Set ALL ports into PHY loopback 
     */  
    if(test_hdr->loopback == INT_LPBK) {    
        if(!setPhyIntlpbk) {
            for(i=0;i<DVT_NFP_PORT_TXRX_MAX;i++) {

#if defined(COUGAR)
                bc1250EthCfg_t *cfg;
                cfg = getEthCfgForPort(i);
                phyAddr = cfg->phy.addr;
                bmc12500Eth_mii_write(&cfg->regs, phyAddr, MII_BMCR, 
                                      BMCR_LOOPBACK | BMCR_ANENABLE | 
                                      BMCR_DUPLEX | BMCR_SPEED1);
#else
                phyAddr = 0x10 + i;
#if defined(SIBYTE) && defined(BOBCAT)
                gt_mii_writeSMI(phyAddr, MII_BMCR, BMCR_LOOPBACK | 
                                BMCR_ANENABLE | BMCR_DUPLEX | BMCR_SPEED1,
                                0xffff);
#else                    
                dp83820_writeMII_common(0, phyAddr, 0, 0x5140);
#endif
#endif         
                delay_us(60000);
            }    
            setPhyIntlpbk = 1;
        }
#ifdef NFP_TXRX
        /* 08/06/04: For Rev H boards with bmfpga ver 6, set bit 8 of the
         * bmfpga before test starts and clear it when test is over.
         * This forces the link led to ignore link status from the lsi 
         * or sfp and the link led will be driven during the internal lpbk
         * without any external cables.
         */    
        uint32 bmfpga_res;
#if defined(CHEETAH)
        if((isTXRXrevH) && (isTXRXbmfpga6)) {
            bmfpga_res = *(uint32 *) (HW_BMFPGA_BASE_VIRT + 4);
            *(uint32 *)(HW_BMFPGA_BASE_VIRT + 4) = 
               bmfpga_swap(bmfpga_swap(bmfpga_res) | 
                           BMFPGA_RES_TXRX_LINK_IGNORE);
        }
#else
        /* Bobcat or Cougar
         */
        bmfpga_res = *(uint32 *) (HW_BMFPGA_BASE_VIRT + 4);
        *(uint32 *)(HW_BMFPGA_BASE_VIRT + 4) = 
           bmfpga_swap(bmfpga_swap(bmfpga_res) | BMFPGA_RES_TXRX_LINK_IGNORE);
#endif // CHEETAH
#endif            
    }    

    // eee.test_dvt_running[plane]  could be writting out of bounds
    VERIFY((plane >= 0) && (plane < 3));
    if(test_hdr->port != 0xff) 
        dvt_front_loopback_port(plane, test_hdr->port, test_hdr->size);
    else {            
        for(port = 0; port < DVT_NFP_PORT_TXRX_MAX ; port++)
            dvt_front_loopback_port(plane, port, test_hdr->size);
    }    

    dvtFrontCfg.test_started = 1;
    eee.test_dvt_running[plane] = 1;
}

/*-----------------------------------------------------------------
 * Name:    dvt_front_loopback_port(uint32 plane, uint32 port,
 *                                  uint32 size)
 *
 * Description: function to start txrx frontplane traffic
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
void
dvt_front_loopback_port(uint32 plane, uint32 port, uint32 size)
{
    uint32 mac=0;
    uint32 sp=0;
    uint32 i=0;

    // Debug -------------
    if(!((plane >= 0) && (plane < 3))) {
        printf("In dvt_front_loopback_port() plane = %0x not between 0-2\n",
                plane);
    }
    // Debug -------------

    if((port == 0) || (port == 1))
        mac = NFP_PORT_TXRX_ETH0;
    else if ((port == 2) || (port == 3)) {
        mac = NFP_PORT_TXRX_ETH2;
    }    
    sp = PACK_UNICAST_PORT_ADDRESS(nfxMySlotId, nfxMyCPUId,
                                    eee.dvt_test_app_id,
                                    plane, NFX_COS_HIGH, mac);
    dvtFrontCfg.sp[port]    = sp;

    for(i=0;i<EEE_TEST_NUM_PKT_SPEC_TXRXFRONT;i++) {
        dvt_bmc12500Eth_diagTxLuc(port, size, 0xFFFF);
    }    
    
    next_exp_front_seq[nfxMyCPUId][port] = 0;
}        

/*-----------------------------------------------------------------
 * Name:    dvt_bmc12500Eth_diagTxLuc()
 *
 * Description: This is a rehash of the transmit fn by Tony Wong in the
 *                bmc12500Eth-mii-diag.c. We add some bogus hdrs before
 *                directly calling the txUnicast fn.    
 *
 * Created by:     lipika    
 *
 * Date Created:    06/03/02    
 *
 *-----------------------------------------------------------------
 */
int
dvt_bmc12500Eth_diagTxLuc(uint32 port, uint32 size, uint32 seq)
{
    bc1250EthCfg_t *cfg;
    uchar8 *tmp;
    uint32 mac=0;
    int32  i=0;
    int32  bufCnt = 0;
    eee_desc_t *edesc;
    eee_descHdr_t *hdr;
    int32   out_port = 0;
    uchar8 junkbuf[BC1250_MAX_PKT_SIZE];
    uint32 appId = 0;
    uint32 rc = 0;
    eee_test_hdr_t    * test_hdr;

    uchar8 fill_byte = 0;
    luc_tx_hdr_t luc_hdr;
    uint16 udp_len = 0;
    uint16 ip_len = 0;
    uint32 junk_idx = 0;
    uint32 index = 0;
    uchar8 *bufp;
    int linkid = 0;

    /* new */
    uint32            num_bufs;
    uint32            buf_bytes;
    uint32            bs;
    uint32            bd_size[EEE_MAX_BUFS];
    eee_descBuf_t     * bd;
    uchar8            * buf[EEE_MAX_BUFS];
    uint32            remain;

    if((port == 0) || (port == 1))
        mac = 0;
    if((port == 2) || (port == 3)) {
        mac = 2;
    }
    
    if (mac == 1) {
        printf("Only MAC 0 and 2 available!\n");
        return 0;
    }
    cfg =  bcEthCfg[mac] ;
    cfg->macId = mac;    

    if((size < 200) || (size > BC1250_MAX_PKT_SIZE))
        pktSize = BC1250_MAX_PKT_SIZE;    
    else 
        pktSize = size;
    fill_byte = 0;
    linkid = port; 

    /*
    for (i = 0; i < BC1250_MAX_PKT_SIZE; i++)
      junkbuf[i] = fill_byte++;
    */
    bufp = &junkbuf[0];

    /* fill LUC header = 20 bytes */
    luc_hdr.field.seq_num = 0;
    luc_hdr.field.pkt_len = 0;
    luc_hdr.field.link_id = linkid;
    luc_hdr.field.control = 3; /* generate both checksums */
    luc_hdr.field.protocol = 0x11;
    luc_hdr.field.tcp_udp_len = pktSize - 20 - 14 - 20;
    luc_hdr.field.src_ip = 0x99999999;
    luc_hdr.field.dest_ip = 0x66666666;
    luc_hdr.field.l3_offset = 14;
    luc_hdr.field.l4_offset = 34;
    luc_hdr.field.tcp_udp_csum = 40;
    luc_hdr.field.tcp_udp_csum = 40;
    luc_hdr.field.ip_csum = 24;

    for (i = 19; i >= 0; i--)
        junkbuf[index++] = luc_hdr.data[i];

    /* fill MAC header = 14 bytes */
    for (i = 0; i < 6; i++)
        junkbuf[index++] = 0xff;
    for (i = 6; i < 12; i++)
        junkbuf[index++] = 0x00;
    junkbuf[index++] = 0x08;
    junkbuf[index++] = 0x00;

    ip_len = pktSize - 14 - 20;

    /* fill IP header = 20 bytes */
    junkbuf[index++] = 0x45;
    junkbuf[index++] = 0x00;
    junkbuf[index++] = (ip_len >> 8) & 0xff ; /* length */
    junkbuf[index++] = (ip_len & 0xff);
    junkbuf[index++] = 0x00; /* id */
    junkbuf[index++] = 0x00; /* id */
    junkbuf[index++] = 0x40; /* flag */
    junkbuf[index++] = 0x00;
    junkbuf[index++] = 0xff;
    junkbuf[index++] = 0x11;
    junkbuf[index++] = 0x00; /* checksum */
    junkbuf[index++] = 0x00; /* checksum */
    junkbuf[index++] = 0x99; /* src ip */
    junkbuf[index++] = 0x99;
    junkbuf[index++] = 0x99;
    junkbuf[index++] = 0x99;
    junkbuf[index++] = 0x66; /* dest ip */
    junkbuf[index++] = 0x66;
    junkbuf[index++] = 0x66;
    junkbuf[index++] = 0x66;

    /* fill UDP header = 8 bytes */
    junkbuf[index++] = 0x11; /* src port */
    junkbuf[index++] = 0x11;
    junkbuf[index++] = 0x22; /* dest port */
    junkbuf[index++] = 0x22;
    udp_len = pktSize - 14 - 20 -20 - 8;
    junkbuf[index++] = (udp_len >> 8) & 0xff;
    junkbuf[index++] = (udp_len & 0xff);
    junkbuf[index++] = 0x00; /* checksum */
    junkbuf[index++] = 0x00; /* checksum */

    junkbuf[index++];
    junkbuf[index++];

    /* copy the header info for later use in spinning the packets */
    memcpy(&static_hdr[port], bufp, 64);

    /* fill the DVT packet info */
    tmp = &(junkbuf[index++]);
    test_hdr = (eee_test_hdr_t *)tmp;
    test_hdr->cmd = EEE_MGMT_TEST_CMD_DATA;
    if(seq == 0xFFFF)
        test_hdr->seq = front_seq[nfxMyCPUId][port];
    else
        test_hdr->seq = seq;
    test_hdr->size = pktSize;
    test_hdr->orig_slot = nfxMySlotId;
    test_hdr->orig_cpu = nfxMyCPUId;
    test_hdr->plane = EEE_USER_DATA;
    test_hdr->port = port;

    /* new */
    edesc = eee_allocateDesc(eee.my_pool_id, NFX_COS_HIGH);
    if (!edesc) {
        printf("dvt_bmc12500Eth_diagTxLuc: Could not allocate edesc!!\n");    
        return 0;
    }                
    memset(edesc,0, sizeof(eee_desc_t));
    hdr = (eee_descHdr_t *)edesc;
    hdr->control = (bufCnt << EDESC_BUFCNT_SHIFT) | pktSize;
    junk_idx = 0;

    /* new */
    if(pktSize < 1766 )
        bs = 1;
    else 
        bs = 2;    

    num_bufs = 0;
    buf_bytes = eee.buf_size[bs] - eee.buf_offset;
    remain = pktSize;
    do {
        buf[num_bufs] = eee_allocateBuffer(eee.my_pool_id, bs, NFX_COS_HIGH);
        if (!buf[num_bufs]) {
            for (i=0; i<num_bufs; i++)
                eee_deallocateBuffer(buf[i]);
            eee_deallocateDesc(edesc);
            return NULL;
        }
        if (remain > buf_bytes) {
            bd_size[num_bufs] = buf_bytes;
            remain -= buf_bytes;
        }
        else {
            bd_size[num_bufs] = remain;
            remain = 0;
        }
        num_bufs++;
    } while (remain);
    
    /*
     * Create packet
     */
    bd = &(edesc->bd[0]);
    edesc->hdr.control = (num_bufs << EDESC_BUFCNT_SHIFT) | pktSize;
    if (num_bufs == EEE_MAX_BUFS) {
        edesc->hdr.control |= EDESC_COMMAND_USE_FIRST_BUFFER;
    }
    else
        bd++;

    for (i=0; i<num_bufs; i++) {
        bd->control = EDESC_BD_CMD_IN_USE | bs;
        bd->len = bd_size[i];
        bd->buf = buf[i];
        bd++;
    }

    /* copy the pkt info into the first buffer */
    memcpy((eee_test_hdr_t *)buf[0],&junkbuf,sizeof(eee_test_hdr_t)+64);

    if (cfg->macId == 0)
        out_port = NFP_PORT_TXRX_ETH0;
    else
        out_port = NFP_PORT_TXRX_ETH2;
    appId = eee_getApplicationId("eee_test_complex");    
    edesc->hdr.dest_port = PACK_UNICAST_PORT_ADDRESS( nfxMySlotId,
                                                     nfxMyCPUId,
                                                     appId,
                                                     EEE_USER_DATA,
                                                     NFX_COS_HIGH,
                                                     out_port);
    edesc->hdr.src_port = edesc->hdr.dest_port;

    if((rc = bmc12500Eth_txUnicast(edesc->hdr.dest_port,edesc)) != 
              EEE_FORWARDED_PACKET)
        eee.test_dvt_send_err[EEE_USER_DATA]++;
    else {
        eee.test_dvt_my_sent[nfxMySlotId][nfxMyCPUId][EEE_USER_DATA]++;
        dvtstats_txrx.txrxFront_packets_sent[port] ++;
        dvtstats_txrx.txrxFront_bytes_sent[port] += test_hdr->size;
    }
    if(seq == 0xFFFF)    
        front_seq[nfxMyCPUId][port] = 
            (front_seq[nfxMyCPUId][port] + 1) % EEE_TEST_NUM_PKT_SPEC_TXRXFRONT;
    return(NFX_OK);
}
#endif
