/*
 *-----------------------------------------------------------------
 * Name:	eee-queue.c
 * Copyright (C) 2001, Agile Storage, Inc.
 * Description:
 *-----------------------------------------------------------------
 */
#include "nfx-types.h"
#include "nfx-incl.h"
#include "../sm-eee/eee-api.h"
#include "../sm-chassis/cm-api.h"

#if EEE_NUM_FIXED_FWD_QUEUES > 0
#include "../sm-fs/fs-api.h"
#endif

#if (EEE_NUM_SM_POOLS > 0)
/*-----------------------------------------------------------------
 * Name:	eee_initSharedDesc()
 * Description:	Allocates space for the Resource Queues (RQ) for the
 *		EEE descriptors from other CPUs on the local module
 *-----------------------------------------------------------------
 */
void
eee_initSharedDescRQ(uint32 pass)
{
	uint32	num_16MB_blocks;
	uint32	i, num_bytes, num_words;
	uint32	my_index;

	EEE_PRINTF(("eee_initSharedDescRQ(%d)\n", pass));

	GET_MY_MEMPOOL_INDEX(my_index);

	EEE_PRINTF(("my_index = %d\n", my_index));

	if (pass == 1) {
		num_16MB_blocks = eee_platGetSharedMemorySize() / 0x1000000;
		for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
			if (i != my_index) {
				num_words = rq_size[i].desc * num_16MB_blocks;
				num_bytes = num_words * sizeof(address_t);
				eee.desc_pool[i].queue.start =
				eee.desc_pool[i].queue.head = eee_allocateBlock(num_bytes);
				eee.desc_pool[i].queue.end = eee.desc_pool[i].queue.start + num_words;
			}
		}
	}
	else if (pass == 2) {
        
#ifdef NFX_SMP
        eee_global_pool_init(&eee.desc_pool[my_index].stack,
                             eee.sm_num_desc,
                             EEE_DESC_POOL_SLAB_SIZE,
                             EEE_NUM_BUF_SIZES,
                             eee.desc_base[my_index],
                             eee.desc_end[my_index]);
#else
		eee.desc_pool[my_index].stack.top = eee_allocateBlock(eee.sm_num_desc * sizeof(address_t));
		EEE_PRINTF(("initSharedDescRQ: stack top at %p\n", eee.desc_pool[my_index].stack.top));
		eee.desc_pool[my_index].stack.top += eee.sm_num_desc;
		eee.desc_pool[my_index].stack.num_avail = 0;
#endif
	}
}

/*-----------------------------------------------------------------
 * Name:	eee_initSharedBufsRQ()
 *
 * Description:	Allocates space for the Resource Queues (RQ) for the
 *		EEE shared buffer addresses from other CPUs on the local module
 *-----------------------------------------------------------------
 */
void
eee_initSharedBufsRQ(uint32 pass)
{
	uint32	num_16MB_blocks;
	uint32	i, j, num_bytes, num_words;
	uint32	my_index;

	EEE_PRINTF(("eee_initSharedBufsRQ(%d)\n", pass));

	GET_MY_MEMPOOL_INDEX(my_index);

	EEE_PRINTF(("my_index = %d\n", my_index));

	if (pass == 1) {
		num_16MB_blocks = eee_platGetSharedMemorySize() / 0x1000000;
		for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
			if (i != my_index) {
				for (j=0; j < EEE_NUM_BUF_SIZES; j++) {
					if (j == 0)
						num_words = rq_size[i].buf_small * num_16MB_blocks;
					else if (j == 1)
						num_words = rq_size[i].buf_large * num_16MB_blocks;
					else if (j == 2)
						num_words = rq_size[i].buf_ultra * num_16MB_blocks;
#ifdef EEE_BUF_MGMT
					else if (j == 3)
						num_words = rq_size[i].buf_mgmt * num_16MB_blocks;
#endif
					else {
						panic("Invalid buffer size\n");
						num_words = 0;
					}
					num_bytes = num_words * sizeof(address_t);
					eee.buf_pool[i][j].queue.start =
					eee.buf_pool[i][j].queue.head = eee_allocateBlock(num_bytes);
					eee.buf_pool[i][j].queue.end =
								eee.buf_pool[i][j].queue.start + num_words;
				}
			}
		}
	}
	else if (pass == 2) {
		for (j=0; j < EEE_NUM_BUF_SIZES; j++) {
#ifdef NFX_SMP
            eee_global_pool_init(&eee.buf_pool[my_index][j].stack,
                                 eee.sm_num_buf[j],
                                 EEE_BUF_POOL_SLAB_SIZE,
                                 j,
                                 eee.buf_base[my_index][j],
                                 eee.buf_end[my_index][j]);
#else
			eee.buf_pool[my_index][j].stack.top =
				eee_allocateBlock(eee.sm_num_buf[j] * sizeof(address_t));
			EEE_PRINTF(("initSharedBufsRQ: stack top at %p\n",
									eee.buf_pool[my_index][j].stack.top));
			eee.buf_pool[my_index][j].stack.top += eee.sm_num_buf[j];
			eee.buf_pool[my_index][j].stack.num_avail = 0;
#endif
		}
	}

}
#endif	/* EEE_NUM_SM_POOLS > 0 */

/*-----------------------------------------------------------------
 * Name:	eee_displayRQ()
 * Description:	Display RQ control structures
 *-----------------------------------------------------------------
 */
void
eee_displayRQ()
{
	uint32	i, my_index;
	GET_MY_MEMPOOL_INDEX(my_index);

#ifdef LATER
	printf("\nShared Memory Size = 0x%x\n\n", eee.sm_size);
	printf("Descriptor RQs:\n");

	printf("num entries:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		if (i == my_index)
			printf("    0x%8x", eee.sm_num_desc);
		else
			printf("    0x%8x", rq_size[i].desc);
	}
	printf("\n");
	printf("start      :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.desc_pool[i].queue.start);
	printf("\n");
	printf("end        :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.desc_pool[i].queue.end);
	printf("\n");
	printf("head       :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.desc_pool[i].queue.head);
	printf("\n");
	printf("tail       :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.desc_pool[i].queue.tail_ptr);
	printf("\n");

	printf("\n");
	printf("Buffer RQs:\n");

	printf("num entries:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		if (i == my_index)
			printf("    0x%8x", eee.sm_num_buf[0]);
		else
			printf("    0x%8x", rq_size[i].buf_small);
	printf("\n");
	printf("small start:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_SMALL].queue.start);
	printf("\n");
	printf("small end  :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_SMALL].queue.end);
	printf("\n");
	printf("small head :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_SMALL].queue.head);
	printf("\n");
	printf("small tail :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_SMALL].queue.tail_ptr);
	printf("\n");
	printf("num entries:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		if (i == my_index)
			printf("    0x%8x", eee.sm_num_buf[1]);
		else
			printf("    0x%8x", rq_size[i].buf_large);
	printf("\n");
	printf("large start:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_LARGE].queue.start);
	printf("\n");
	printf("large end  :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_LARGE].queue.end);
	printf("\n");
	printf("large head :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_LARGE].queue.head);
	printf("\n");
	printf("large tail :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_LARGE].queue.tail_ptr);
	printf("\n");
	printf("num entries:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		if (i == my_index)
			printf("    0x%8x", eee.sm_num_buf[2]);
		else
			printf("    0x%8x", rq_size[i].buf_ultra);
	printf("\n");
	printf("ultra start:");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_ULTRA].queue.start);
	printf("\n");
	printf("ultra end  :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_ULTRA].queue.end);
	printf("\n");
	printf("ultra head :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_ULTRA].queue.head);
	printf("\n");
	printf("ultra tail :");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++)
		printf("    %p", eee.buf_pool[i][EEE_BUF_ULTRA].queue.tail_ptr);
	printf("\n");
#else
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		printf(" desc_pool %d, queue: start 0x%p, end 0x%p, head 0x%p, tail 0x%p\n",
		       eee.desc_pool[i].queue.start, eee.desc_pool[i].queue.end,
		       eee.desc_pool[i].queue.head, eee.desc_pool[i].queue.tail_ptr);
	}
	printf("Buffer RQs:\n");

	printf("num small entries\n");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		if (i == my_index)
			printf(" 0x%8x\n", eee.sm_num_buf[0]);
		else
			printf(" 0x%8x\n", rq_size[i].buf_small);
		printf(" EEE_BUF_SMALL %d: start 0x%p, end 0x%p, head 0x%p, tail 0x%p\n",
		       i,
		       eee.buf_pool[i][EEE_BUF_SMALL].queue.start,
		       eee.buf_pool[i][EEE_BUF_SMALL].queue.end,
		       eee.buf_pool[i][EEE_BUF_SMALL].queue.head,
		       eee.buf_pool[i][EEE_BUF_SMALL].queue.tail_ptr);
	}
	printf("num large entries\n");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		if (i == my_index)
			printf(" 0x%8x\n", eee.sm_num_buf[1]);
		else
			printf(" 0x%8x\n", rq_size[i].buf_large);
		printf(" EEE_BUF_LARGE %d: start 0x%p, end 0x%p, head 0x%p, tail 0x%p\n",
		       i,
		       eee.buf_pool[i][EEE_BUF_LARGE].queue.start,
		       eee.buf_pool[i][EEE_BUF_LARGE].queue.end,
		       eee.buf_pool[i][EEE_BUF_LARGE].queue.head,
		       eee.buf_pool[i][EEE_BUF_LARGE].queue.tail_ptr);
	}
	printf("num ultra entries\n");
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		if (i == my_index)
			printf(" 0x%8x\n", eee.sm_num_buf[2]);
		else
			printf(" 0x%8x\n", rq_size[i].buf_ultra);
		printf(" EEE_BUF_ULTRA %d: start 0x%p, end 0x%p, head 0x%p, tail 0x%p\n",
		       i,
		       eee.buf_pool[i][EEE_BUF_ULTRA].queue.start,
		       eee.buf_pool[i][EEE_BUF_ULTRA].queue.end,
		       eee.buf_pool[i][EEE_BUF_ULTRA].queue.head,
		       eee.buf_pool[i][EEE_BUF_ULTRA].queue.tail_ptr);
	}
#endif /* LATER */
}

#if EEE_NUM_FIXED_FWD_QUEUES > 0

/* Sizes of FS RPC queues between TxRx ACPU and FPs.
 */
uint32 fixed_fwd_sizes[EEE_NUM_FIXED_FWD_QUEUES] ={FS_RPC_QUEUE_DEPTH + 1};

void
eee_initFixedFwdQueues(void)
{
    int j;
    for (j = EEE_NUM_FWD_QUEUES; j < (EEE_NUM_FWD_QUEUES + EEE_NUM_FIXED_FWD_QUEUES); ++j) {

        uint32 num_fwd_entries = fixed_fwd_sizes[j - EEE_NUM_FWD_QUEUES];
		eee.rcv_queue[j].rcv_start = eee.rcv_queue[j].rcv_head =
		  ((eee_descPtr_t *)eee_allocateBlock(num_fwd_entries * sizeof(address_t)));
        if (eee.rcv_queue[j].rcv_head == NULL) {
            panic("Can not allocate EEE receive queue %d\n", j);
        }
	eee.rcv_queue[j].rcv_end = (eee.rcv_queue[j].rcv_start + num_fwd_entries);
        NFX_SPIN_INIT(&eee.rcv_queue[j].rcv_spin, SPINLOCK_LEVEL_UNKNOWN);
    }
}
#endif /* EEE_NUM_FIXED_FWD_QUEUES */

/*-----------------------------------------------------------------
 * Name:	eee_initFWDQueues()
 * Description:	Allocate shared memory for the intracard forwarding queues
 *-----------------------------------------------------------------
 */
void
eee_initFWDQueues()
{
	uint32	j, num_fwd_entries;

#ifdef EEE_NEW_RATIO
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++) {
		if (fwd_size[j])
			num_fwd_entries = eee.sm_num_fwd;
		else
			num_fwd_entries = 0;
		eee.rcv_queue[j].rcv_start =
		eee.rcv_queue[j].rcv_head = ((eee_descPtr_t *)
                                     eee_allocateBlock(num_fwd_entries *
                                                       sizeof(address_t)));
		eee.rcv_queue[j].rcv_end = (eee.rcv_queue[j].rcv_start +
                                    num_fwd_entries);
        NFX_SPIN_INIT(&eee.rcv_queue[j].rcv_spin, SPINLOCK_LEVEL_UNKNOWN);
	}

#else
	uint32	num_512_words;
	num_512_words = eee.sm_num_fwd / 512;

	for (j=0; j<EEE_NUM_FWD_QUEUES; j++) {
		num_fwd_entries = fwd_size[j] * num_512_words;
		eee.rcv_queue[j].rcv_start =
		eee.rcv_queue[j].rcv_head = (eee_descPtr_t *)eee_allocateBlock(num_fwd_entries*sizeof(address_t));
		eee.rcv_queue[j].rcv_end = eee.rcv_queue[j].rcv_start + num_fwd_entries;
	}

#endif	/* EEE_NEW_RATIO */
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_displayFWD()
{
	uint32	j;

#ifdef LATER
	printf("\nRCV queues:\n");
	printf("start      :");
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++)
		printf("    %p", eee.rcv_queue[j].rcv_start);
	printf("\n");
	printf("end        :");
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++)
		printf("    %p", eee.rcv_queue[j].rcv_end);
	printf("\n");
	printf("head       :");
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++)
		printf("    %p", eee.rcv_queue[j].rcv_head);
	printf("\n");
	printf("tail       :");
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++)
		printf("    %p", eee.rcv_queue[j].rcv_tail_ptr);
	printf("\n");
#else
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++) {
		printf("FWD RCV Queues %d, start 0x%p, end 0x%p, head 0x%p, tail 0x%p\n",
		       j, eee.rcv_queue[j].rcv_start, eee.rcv_queue[j].rcv_end,
		       eee.rcv_queue[j].rcv_head, eee.rcv_queue[j].rcv_tail_ptr);
	}
#endif
}

/*-----------------------------------------------------------------
 * Name:	eee_initAllocateTailPtrs()
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_initAllocateTailPtrs()
{
	uint32	i, j, my_index;

	GET_MY_MEMPOOL_INDEX(my_index);

	EEE_PRINTF(("[eee_initAllocateTailPtrs]:get desc tail pointers\n"));
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		if (i == my_index)
			continue;
		eee.far_desc_pool[i].tail_ptr = eee_allocateBlock(sizeof(address_t));
		EEE_PRINTF(("initAllocateTailPtrs, far_desc_pool[%d] = %p\n", i, eee.far_desc_pool[i].tail_ptr));
	}
	
	EEE_PRINTF(("[eee_initAllocateTailPtrs]:get buf tail pointers\n"));
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		if (i == my_index)
			continue;
		for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
			eee.far_buf_pool[i][j].tail_ptr = eee_allocateBlock(sizeof(address_t));
	EEE_PRINTF(("initAllocateTailPtrs, far_buf_pool[%d][%d] = %p\n", i, j, eee.far_buf_pool[i][j].tail_ptr));
		}
	}

	EEE_PRINTF(("[eee_initAllocateTailPtrs]:get fwd tail pointers\n"));
	for (j=0; j<EEE_NUM_FWD_QUEUES; j++) {
		eee.fwd_queue[j].fwd_tail_ptr = eee_allocateBlock(sizeof(address_t));
		EEE_PRINTF(("initAllocateTailPtrs, fwd_tail_ptr[%d] = %p\n", j, eee.fwd_queue[j].fwd_tail_ptr));
	}

	eee.fwd_queue[EEE_FS_RPC_QUEUE_INDEX].fwd_tail_ptr = eee_allocateBlock(sizeof(address_t));
}

