/*
 *-----------------------------------------------------------------
 *
 * Name:
 *
 * RCS:  $Id: eee-queue.h,v 1.5 2002/11/13 01:14:33 maximk Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_QUEUE_H
#define _EEE_QUEUE_H

#define QUEUE_PTR_INC(_ptr, _end, _start) {			\
	(_ptr)++;										\
	if ((_ptr) == (_end))							\
		(_ptr) = (_start);							\
}

/*-----------------------------------------------------------------
 * Name:    eee_initSharedDesc()
 *
 * Description: Allocates space for the Resource Queues (RQ) for the
 *              EEE descriptors from other CPUs on the local module
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/10/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_initSharedDescRQ(uint32 pass);

/*-----------------------------------------------------------------
 * Name:    eee_initSharedBufsRQ()
 *
 * Description: Allocates space for the Resource Queues (RQ) for the
 *              EEE shared buffer addresses from other CPUs on the local
 *              module
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/10/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_initSharedBufsRQ(uint32 pass);

/*-----------------------------------------------------------------
 * Name:    eee_displayRQ()
 *
 * Description: Display RQ control structures
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/10/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_displayRQ(void);

/*-----------------------------------------------------------------
 * Name:    eee_initFWDQueues()
 *
 * Description: Allocate shared memory for the intracard forwarding queues
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/11/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_initFWDQueues(void);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern void
eee_displayFWD(void);

/*-----------------------------------------------------------------
 * Name:    eee_initAllocateTailPtrs()
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/16/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_initAllocateTailPtrs(void);

#endif	/* _EEE_QUEUE_H */

