/*
 *-----------------------------------------------------------------
 * Name:	eee-rq.c
 * Copyright (C) 2001, Agile Storage, Inc.
 * Description:	Resource Queue routines
 *-----------------------------------------------------------------
 */
#include "nfx-incl.h"
#include "../sm-eee/eee-api.h"
#include "../sm-chassis/cm-api.h"
#include "../sm-hw/mem-api.h"

#if (EEE_NUM_SM_POOLS > 1)

#define REMOTE_POOL_INDEX	(EEE_REMOTE_POOL-SHARED_POOL_OFFSET)

uint64 rq_desc_max = 0;
uint64 rq_buf_max[EEE_NUM_BUF_SIZES] = {0, 0, 0, 0};

uint64 rq_desc_iter = 0;
uint64 rq_buf_iter[EEE_NUM_BUF_SIZES] = {0, 0, 0, 0};

uint64 rq_desc_alloc = 0;
uint64 rq_buf_alloc[EEE_NUM_BUF_SIZES] = {0, 0, 0, 0};

uint64 rq_desc_idle = 0;
uint64 rq_buf_idle = 0;

struct rq_poll_stats {
	uint64	num_called;
	uint64	poll_desc_idle;
	uint64	poll_desc_valid;
	uint64	num_desc_alloc;
	uint64	poll_buf_idle[EEE_NUM_BUF_SIZES];
	uint64	poll_buf_valid[EEE_NUM_BUF_SIZES];
	uint64	num_buf_alloc[EEE_NUM_BUF_SIZES];
	uint32	max_val;
	uint32	hwm_desc;
	uint32	hwm_buf[EEE_NUM_BUF_SIZES];
} rq_stats;

/*-----------------------------------------------------------------
 * Name: eee_rqResupply()
 *
 * Description:	Supply resources to queues in shared memory pools in other
 *		CPUs memory.  In our write-only scheme, check the tail
 *		pointers for the last entry read by the receiving CPU.
 *-----------------------------------------------------------------
 */
void
eee_rqResupply(void	* cb, uint32	tref)
{
	void	* tp;
	uint64	rq_desc_tmp = 0;
	uint64	rq_buf_small_tmp = 0;
	uint64	rq_buf_large_tmp = 0;
	uint64	rq_buf_ultra_tmp = 0;
	uint64	rq_buf_mgmt_tmp = 0;
	struct rq_poll_stats * sp = &rq_stats;

	if (nfxMyCoreId != 0)
		return;

	sp->num_called++;

#if 0
	/*
	 * Do not need the spinlock, since this function will only run on one
	 * core.
	 */
	if (!NFX_SPIN_TRYLOCK(&eee.rq_spin))
		return;
#endif
	
	/*
	 * Check descriptor resource queues
	 */
	if ((tp = *(eee.far_desc_pool[REMOTE_POOL_INDEX].tail_ptr))) {
		address_t	* hp = eee.far_desc_pool[REMOTE_POOL_INDEX].head;
		uint32		cnt, valid_cnt, i;
		address_t	desc[512];

		if ((address_t)tp >= (address_t)hp)
			cnt = (address_t)tp - (address_t)hp;
		else
			cnt = ((address_t)eee.far_desc_pool[REMOTE_POOL_INDEX].end - (address_t)hp) + 
					((address_t)tp - (address_t)eee.far_desc_pool[REMOTE_POOL_INDEX].start);

		if (cnt) {
			cnt /= sizeof(address_t);

			if (cnt > sp->max_val)
				cnt = sp->max_val;

			valid_cnt = eee_allocateNDesc(EEE_SHARED_POOL, 
                                          NFX_COS_HIGH, 
                                          (eee_descPtr_t *)desc, 
                                          cnt);
			if (valid_cnt == cnt) {
				for (i=0; i<cnt; i++) {
					*hp = (address_t)desc[i];
					QUEUE_PTR_INC(	hp,
						eee.far_desc_pool[REMOTE_POOL_INDEX].end,
						eee.far_desc_pool[REMOTE_POOL_INDEX].start);
				}
				eee_stats->rq_desc_allocated[REMOTE_POOL_INDEX] += cnt;
				eee.far_desc_pool[REMOTE_POOL_INDEX].head = hp;
				rq_desc_tmp = cnt;
			}
			else
				printf("Error in rqResupply, valid_cnt = %d, cnt = %d\n", valid_cnt, cnt);
		}
	}

	/*
	 * Check buffer resource queues
	 */
	if ((tp = *(eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].tail_ptr))) {
		address_t	* hp = eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].head;
		uint32		cnt, valid_cnt, i;
		address_t	buf[512];

		if ((address_t)tp >= (address_t)hp)
			cnt = (address_t)tp - (address_t)hp;
		else
			cnt = ((address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].end - (address_t)hp) +
			  ((address_t)tp - (address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].start);

		if (cnt) {
			cnt /= sizeof(address_t);

			if (cnt > sp->max_val)
				cnt = sp->max_val;

			valid_cnt = eee_allocateNBuffers(EEE_SHARED_POOL,
                                             EEE_BUF_SMALL,
                                             NFX_COS_HIGH,
                                             (void **)buf,
                                             cnt);
			if (valid_cnt == cnt) {
				for (i=0; i<cnt; i++) {
					*hp = (address_t)buf[i];
					QUEUE_PTR_INC(	hp,
					eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].end,
					eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].start);
				}
				eee_stats->rq_buf_allocated[REMOTE_POOL_INDEX][EEE_BUF_SMALL] += cnt;
				eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_SMALL].head = hp;
				rq_buf_small_tmp = cnt;
			}
			else
				printf("Error in rqResupply, valid_cnt = %d, cnt = %d\n", valid_cnt, cnt);
		}
	}
	if ((tp = *(eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].tail_ptr))) {
		address_t	* hp = eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].head;
		uint32		cnt, valid_cnt, i;
		address_t	buf[512];

		if ((address_t)tp >= (address_t)hp)
			cnt = (address_t)tp - (address_t)hp;
		else
		cnt = ((address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].end - (address_t)hp) + 
			((address_t)tp - (address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].start);

		if (cnt) {
			cnt /= sizeof(address_t);

			if (cnt > sp->max_val)
				cnt = sp->max_val;

			valid_cnt = eee_allocateNBuffers(EEE_SHARED_POOL,
                                             EEE_BUF_LARGE,
                                             NFX_COS_HIGH,
                                             (void **)buf,
                                             cnt);
			if (valid_cnt == cnt) {
				for (i=0; i<cnt; i++) {
					*hp = (address_t)buf[i];
					QUEUE_PTR_INC(	hp,
						eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].end,
						eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].start);
				}
				eee_stats->rq_buf_allocated[REMOTE_POOL_INDEX][EEE_BUF_LARGE] += cnt;
				eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_LARGE].head = hp;
				rq_buf_large_tmp = cnt;
			}
			else
				printf("Error in rqResupply, valid_cnt = %d, cnt = %d\n", valid_cnt, cnt);
		}
	}
	if (eee.sm_num_buf[EEE_BUF_ULTRA]) {
	if ((tp = *(eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].tail_ptr))) {
		address_t	* hp = eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].head;
		uint32		cnt, valid_cnt, i;
		address_t	buf[512];

		if ((address_t)tp >= (address_t)hp)
			cnt = (address_t)tp - (address_t)hp;
		else
		cnt = ((address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].end - (address_t)hp) + 
			((address_t)tp - (address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].start);

		if (cnt) {
			cnt /= sizeof(address_t);

			if (cnt > sp->max_val)
				cnt = sp->max_val;

			valid_cnt = eee_allocateNBuffers(EEE_SHARED_POOL,
                                             EEE_BUF_ULTRA,
                                             NFX_COS_HIGH,
                                             (void **)buf,
                                             cnt);
			if (valid_cnt == cnt) {
				for (i=0; i<cnt; i++) {
					*hp = (address_t)buf[i];
					QUEUE_PTR_INC(	hp,
					eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].end,
					eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].start);
				}
				eee_stats->rq_buf_allocated[REMOTE_POOL_INDEX][EEE_BUF_ULTRA] += cnt;
				eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_ULTRA].head = hp;
				rq_buf_ultra_tmp = cnt;
			} else
				printf("Error in rqResupply, valid_cnt = %d, cnt = %d\n", valid_cnt, cnt);
		}
	}
	}
	if (eee.sm_num_buf[EEE_BUF_MGMT]) {
	if ((tp = *(eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].tail_ptr))) {
		address_t * hp = eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].head;
		uint32 cnt, valid_cnt, i;
		address_t buf[512];

		if ((address_t)tp >= (address_t)hp)
			cnt = (address_t)tp - (address_t)hp;
		else
			cnt = ((address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].end - (address_t)hp) + 
			((address_t)tp - (address_t)eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].start);

		if (cnt) {
			cnt /= sizeof(address_t);

			if (cnt > sp->max_val)
				cnt = sp->max_val;

			valid_cnt = eee_allocateNBuffers(EEE_SHARED_POOL,
                                             EEE_BUF_MGMT,
                                             NFX_COS_HIGH,
                                             (void **)buf,
                                             cnt);
			if (valid_cnt == cnt) {
				for (i=0; i<cnt; i++) {
					*hp = (address_t)buf[i];
					QUEUE_PTR_INC(	hp,
					eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].end,
					eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].start);
				}
				eee_stats->rq_buf_allocated[REMOTE_POOL_INDEX][EEE_BUF_MGMT] += cnt;
				eee.far_buf_pool[REMOTE_POOL_INDEX][EEE_BUF_MGMT].head = hp;
				rq_buf_mgmt_tmp = cnt;
			} else
				printf("Error in rqResupply, valid_cnt = %d, cnt = %d\n", valid_cnt, cnt);
		}
	}
	}

	if (rq_desc_tmp) {
		sp->poll_desc_valid++;
		sp->num_desc_alloc += rq_desc_tmp;
		if (rq_desc_tmp > sp->hwm_desc)
			sp->hwm_desc = rq_desc_tmp;
	} else
		sp->poll_desc_idle++;

	if (rq_buf_small_tmp) {
		sp->poll_buf_valid[0]++;
		sp->num_buf_alloc[0] += rq_buf_small_tmp;
		if (rq_buf_small_tmp > sp->hwm_buf[0])
			sp->hwm_buf[0] = rq_buf_small_tmp;
	} else
		sp->poll_buf_idle[0]++;
	
	if (rq_buf_large_tmp) {
		sp->poll_buf_valid[1]++;
		sp->num_buf_alloc[1] += rq_buf_large_tmp;
		if (rq_buf_large_tmp > sp->hwm_buf[1])
			sp->hwm_buf[1] = rq_buf_large_tmp;
	} else
		sp->poll_buf_idle[1]++;
	
	if (rq_buf_ultra_tmp) {
		sp->poll_buf_valid[2]++;
		sp->num_buf_alloc[2] += rq_buf_ultra_tmp;
		if (rq_buf_ultra_tmp > sp->hwm_buf[2])
			sp->hwm_buf[2] = rq_buf_ultra_tmp;
	} else
		sp->poll_buf_idle[2]++;
	
	if (rq_buf_mgmt_tmp) {
		sp->poll_buf_valid[3]++;
		sp->num_buf_alloc[3] += rq_buf_mgmt_tmp;
		if (rq_buf_mgmt_tmp > sp->hwm_buf[3])
			sp->hwm_buf[3] = rq_buf_mgmt_tmp;
	} else
		sp->poll_buf_idle[3]++;

	if (cb) {
		ushort16	i;
		sp->num_called = 0;
		sp->poll_desc_idle = 0;
		sp->poll_desc_valid = 0;
		sp->num_desc_alloc = 0;
		sp->hwm_desc = 0;
		for (i=0; i<EEE_NUM_BUF_SIZES; i++)  {
			sp->poll_buf_idle[i] = 0;
			sp->poll_buf_valid[i] = 0;
			sp->num_buf_alloc[i] = 0;
			sp->hwm_buf[i] = 0;
		}
	}

#if 0
	NFX_SPIN_UNLOCK(&eee.rq_spin);
#endif
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_rqCfgSet(uint32	max_val)
{
	rq_stats.max_val = max_val;
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_rqCfgClear()
{
	ushort16	i;
	struct rq_poll_stats * sp = &rq_stats;

#if 0
	NFX_SPIN_LOCK(&eee.rq_spin);
#endif
	sp->num_called = 0;
	sp->poll_desc_idle = 0;
	sp->poll_desc_valid = 0;
	sp->num_desc_alloc = 0;
	sp->hwm_desc = 0;
	for (i=0; i<EEE_NUM_BUF_SIZES; i++)  {
		sp->poll_buf_idle[i] = 0;
		sp->poll_buf_valid[i] = 0;
		sp->num_buf_alloc[i] = 0;
		sp->hwm_buf[i] = 0;
	}

#if 0
	NFX_SPIN_UNLOCK(&eee.rq_spin);
#endif
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_rqCfgView(uint32	just_hwm)
{
	ushort16	i;
	extern uchar8	* bufsize_string[];

#if 0
	NFX_SPIN_LOCK(&eee.rq_spin);
#endif

	if (just_hwm) {
		printf("RQ: max_val         = %d\n", rq_stats.max_val);
		printf("    desc HWM        = %d\n", rq_stats.hwm_desc);
		for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
		printf("    buf[%s] HWM  = %d\n", bufsize_string[i], rq_stats.hwm_buf[i]);
		}
	}
	else {
	printf("RQ: called          = %lld\n", rq_stats.num_called);
	printf("    max_val         = %d\n", rq_stats.max_val);
	printf("    poll_desc_idle  = %lld\n", rq_stats.poll_desc_idle);
	printf("    poll_desc_valid = %lld\n", rq_stats.poll_desc_valid);
	printf("    desc_alloc      = %lld\n", rq_stats.num_desc_alloc);
	printf("    desc_alloc HWM  = %d\n", rq_stats.hwm_desc);
	printf("    desc_alloc AVG  = %lld\n",
				rq_stats.poll_desc_valid ?
				rq_stats.num_desc_alloc/rq_stats.poll_desc_valid : 0);
	for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
		printf("    poll_buf_idle[%s]  = %lld\n", bufsize_string[i],
											rq_stats.poll_buf_idle[i]);
		printf("    poll_buf_valid[%s] = %lld\n", bufsize_string[i],
											rq_stats.poll_buf_valid[i]);
		printf("    buf_alloc[%s]      = %lld\n", bufsize_string[i],
											rq_stats.num_buf_alloc[i]);
		printf("    buf_alloc[%s] HWM  = %d\n", bufsize_string[i],
											rq_stats.hwm_buf[i]);
		printf("    buf_alloc[%s] AVG  = %lld\n", bufsize_string[i],
					rq_stats.poll_buf_valid[i] ?
					rq_stats.num_buf_alloc[i]/rq_stats.poll_buf_valid[i] : 0);
	}
	}

#if 0
	NFX_SPIN_UNLOCK(&eee.rq_spin);
#endif
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_rqCfgSendToSSC(
	uint32	just_hwm,
	eee_poll_cfg_rsp_t	* rsp,
	uint32	max_rsps,
	uint32	* num_added)
{
	ushort16	i;
	extern uchar8	* bufsize_string[];
	uint32	num = 0;

#if 0
	NFX_SPIN_LOCK(&eee.rq_spin);
#endif

	if (just_hwm) {
		if (num < max_rsps) {
			strncpy(rsp->str, "RQ", POLLCFG_RSP_STR_LEN);
			rsp->cnt = POLLCFG_RSP_SECTION_LABEL;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "max_val", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.max_val;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "desc HWM", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.hwm_desc;
			rsp++; num++;
		}
		for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
			if (num < max_rsps) {
				snprintf(rsp->str, POLLCFG_RSP_STR_LEN,
							"buf[%s] HWM", bufsize_string[i]);
				rsp->cnt = rq_stats.hwm_buf[i];
				rsp++; num++;
			}
		}
	} else {
		if (num < max_rsps) {
			strncpy(rsp->str, "RQ", POLLCFG_RSP_STR_LEN);
			rsp->cnt = POLLCFG_RSP_SECTION_LABEL;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "called", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.num_called;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "max_val", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.max_val;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "poll_desc_idle", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.poll_desc_idle;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "poll_desc_valid", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.poll_desc_valid;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "desc_alloc", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.num_desc_alloc;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "desc_alloc HWM", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.hwm_desc;
			rsp++; num++;
		}
		if (num < max_rsps) {
			strncpy(rsp->str, "desc_alloc AVG", POLLCFG_RSP_STR_LEN);
			rsp->cnt = rq_stats.poll_desc_valid ?
					rq_stats.num_desc_alloc/rq_stats.poll_desc_valid : 0;
			rsp++; num++;
		}

		for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
			if (num < max_rsps) {
				snprintf(rsp->str, POLLCFG_RSP_STR_LEN,
							"poll_buf_idle[%s]", bufsize_string[i]);

				rsp->cnt = rq_stats.poll_buf_idle[i];
				rsp++; num++;
			}
			if (num < max_rsps) {
				snprintf(rsp->str, POLLCFG_RSP_STR_LEN,
							"poll_buf_valid[%s]", bufsize_string[i]);
											
				rsp->cnt = rq_stats.poll_buf_valid[i];
				rsp++; num++;
			}
			if (num < max_rsps) {
				snprintf(rsp->str, POLLCFG_RSP_STR_LEN,
							"buf_alloc[%s]", bufsize_string[i]);
											
				rsp->cnt = rq_stats.num_buf_alloc[i];
				rsp++; num++;
			}
			if (num < max_rsps) {
				snprintf(rsp->str, POLLCFG_RSP_STR_LEN,
							"buf_alloc[%s] HWM", bufsize_string[i]);
											
				rsp->cnt = rq_stats.hwm_buf[i];
				rsp++; num++;
			}
			if (num < max_rsps) {
				snprintf(rsp->str, POLLCFG_RSP_STR_LEN,
							"buf_alloc[%s] AVG", bufsize_string[i]);
					
				rsp->cnt = rq_stats.poll_buf_valid[i] ?
					rq_stats.num_buf_alloc[i]/rq_stats.poll_buf_valid[i] : 0;
				rsp++; num++;
			}
		}
	}

	*num_added = num;

#if 0
	NFX_SPIN_UNLOCK(&eee.rq_spin);
#endif
}

eee_poll_cfg_t eee_rqPollCfgStruct[] = {
	{"view",	eee_rqCfgView},
	{"clear",	eee_rqCfgClear},
	{"ssc",		eee_rqCfgSendToSSC},
	{"rq",		eee_rqCfgSet},
	{NULL, 0}
};

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_rqInit()
{
#if 0
	NFX_SPIN_INIT(&eee.rq_spin, SPINLOCK_LEVEL_UNKNOWN);
#endif
	eee_registerPollingFunc(EEE_HIGH_PRIORITY, eee_rqResupply,0, eee_rqPollCfgStruct);
	rq_stats.max_val = 512;
}
#endif
