/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-shmem.h
 *
 * RCS:  $Id: eee-shmem.h,v 1.11 2002/08/06 19:32:26 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:	defines the well known structure that will be used to
 *				pass addresses between CPUs on a module.
 *
 * Created by:	Rick Lund
 *
 * Date Created:	5/14/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_SHMEM_H
#define _EEE_SHMEM_H

#ifdef SSC_MGMT
#define EEE_GET_ADDR_TIMEOUT	0x1000
#else
#define EEE_GET_ADDR_TIMEOUT	0x90000000
#endif
#define EEE_SHMEM_ADDR_READY	0xabcdef01

#define MAX_NUM_MEM_POOLS		10
#define MAX_NUM_BUF_SIZES		EEE_NUM_BUF_SIZES
#define MAX_NUM_IPC_QUEUES		10
#define MAX_NUM_CPUS_PER_POOL	10
#define MAX_NUM_FWD_QUEUES		10

#define MAX_COREDUMP_PARAMS     6

typedef struct eee_init_shmem {
	uint32				ready;

	uint32				num_mem_pools;
	uint32				num_ipc_queues;
	uint32				num_fwd_queues;
	uint32				num_buf_sizes;

	eee_queue_pool_cntl_t	rq_desc_pool[MAX_NUM_MEM_POOLS];
	eee_queue_pool_cntl_t	rq_buf_pool[MAX_NUM_MEM_POOLS][MAX_NUM_BUF_SIZES];

	eee_ipcEntry_t		* ipc_rcv_start[MAX_NUM_IPC_QUEUES];
	eee_ipcEntry_t		* ipc_rcv_end[MAX_NUM_IPC_QUEUES];

	eee_descPtr_t		* rcv_start[MAX_NUM_FWD_QUEUES];
	eee_descPtr_t		* rcv_end[MAX_NUM_FWD_QUEUES];

	address_t			desc_tail_ptr[MAX_NUM_MEM_POOLS];
	address_t			buf_tail_ptr[MAX_NUM_MEM_POOLS][MAX_NUM_BUF_SIZES];
	address_t			fwd_tail_ptr[MAX_NUM_FWD_QUEUES];

	eee_descPtr_t		desc_base;
	eee_descPtr_t		desc_end;
	void *				buf_base[MAX_NUM_BUF_SIZES];
	void *				buf_end[MAX_NUM_BUF_SIZES];

    int sm_num_regions;

    struct sm_region {
        uint64 phys_offset;
        uint64 size;
        uint64 virt;
    } sm_regions[4];

#ifdef EEE_ATTR
	eee_attr_t			* desc_attr;
	eee_attr_t			* buf_attr[MAX_NUM_BUF_SIZES];
#endif

#ifdef COUGAR
    /*
     * TXRX core dump control parameters
     */
    address_t           coredump_ctl[MAX_COREDUMP_PARAMS];
#endif

} eee_shmem_init_t;

#endif	/* _EEE_SHMEM_H */

