/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-test.h
 *
 * RCS:  $Id: eee-test.h,v 1.11 2002/12/10 00:04:57 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	5/20/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_TEST_H
#define _EEE_TEST_H

#define DVT_REV2

//#define SYSDVT_DEBUG_PRINT
#ifdef SYSDVT_DEBUG_PRINT
#define SYSDVT_DPRINT(_x)      printf _x
#else
#define SYSDVT_DPRINT(_x)
#endif

#define EEE_TEST_NUM_PKT_SPEC		8		
typedef struct test_pkt_spec {
	uint32	bufsize;
	uint32	num_bytes;
} eee_testPktSpec_t;

#define EEE_MGMT_TEST_CMD_STOP		0x00112234
#define EEE_MGMT_TEST_CMD_START		0xffeeddcb
#define EEE_MGMT_TEST_CMD_DATA		0xa5b6c7d8
#define EEE_MGMT_STATS_REQUEST		0x55
#define EEE_MGMT_STATS_REPORT		0x66
#define EEE_MGMT_STATS_CLEAR		0x77
#define SYS_DVT_FRONT			    4
#define EEE_MGMT_TEST_CMD_CLEAR		0x01010101

typedef struct mgmt_test_hdr {
	uint32	cmd;
	uint32	seq;
	uint32	size;
	uint32	orig_slot;
	uint32	orig_cpu;
	uint32	plane;
	uint32	spin;
	uint32	res[1];
	uint32  port;
	uint32  loopback;
} eee_test_hdr_t;

// @@@ fix hard coded numbers - use define for # of FC/eth ports.
typedef struct {
	uint32 command;
	uint32 slot;
	uint32 cpu;
	uint32 packets_sent[4];
	uint32 packets_received[4];
	uint64 bytes_sent[4];
	uint64 bytes_received[4];
	uint32 packet_errors[4];
	uint32 packet_send_errors[4];
	uint32 seq_errors[4];
	uint32 crc_errors[4];
	uint32 pktComp_errors[4];
#ifndef CHEETAH
	uint32 fatal_errors[4];
#else
	uint32 fatal_errors;
#endif
} eee_dvt_test_stats;

typedef struct {
	uint32 command;
	uint32 slot;
	uint32 cpu;
	uint32 txrxFront_packets_sent[4];	/* 4 ports */
	uint32 txrxFront_packets_received[4];
	uint64 txrxFront_bytes_sent[4];
	uint64 txrxFront_bytes_received[4];
	uint32 txrxFront_packet_send_errors[4];
	uint32 txrxFront_seq_errors[4];
	uint32 txrxFront_pktComp_errors[4];
	uint32 packets_sent; /* mgmt plane */
	uint32 packets_received; /* mgmt plane */
	uint64 bytes_sent; /* mgmt plane */
	uint64 bytes_received; /* mgmt plane */
	uint32 packet_send_errors; /* mgmt plane */
	uint32 seq_errors; /* mgmt plane */
	uint32 pktComp_errors; /* mgmt plane */
} eee_dvt_txrx_stats; /* mgmt plane */

#define isFrontPlane  1

#define EXT_LPBK      0
#define INT_LPBK      1

typedef struct {
	uint32 test_started;
	uint32 testPort;
	uint32 sp[4];
	uint32 rcvdDataPkt[4];
	uint32 test_stopped;
} dvt_front_cfg;

typedef struct {
	char 	*str1;
	char   *str2;
} fcstr_set_t;	

// Bobcat fcadmin functions requires 3 parameters
typedef struct {
	char   *str1;
	char   *str2;
	char   *str3;
} fcstr_set_bc_t;
	
/* Statistics for a CPU's FC ports.
 */
typedef struct {
        uint32 qlogic_sent[NFX_NUM_FC_PORTS_PER_CPU];
        uint32 qlogic_rcvd[NFX_NUM_FC_PORTS_PER_CPU];
        unsigned long qlogic_bytes_sent[NFX_NUM_FC_PORTS_PER_CPU];
        unsigned long qlogic_bytes_rcvd[NFX_NUM_FC_PORTS_PER_CPU];
        uint32 qlogic_dataErr[NFX_NUM_FC_PORTS_PER_CPU];
        uint32 qlogic_crcErr[NFX_NUM_FC_PORTS_PER_CPU];
        uint32 qlogic_dispCnt[NFX_NUM_FC_PORTS_PER_CPU];
        uint32 qlogic_FrameLenCnt[NFX_NUM_FC_PORTS_PER_CPU];
        uint32 qlogic_FatalErr[NFX_NUM_FC_PORTS_PER_CPU];
} sysdvt_qlogic_t;

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	5/20/01
 *
 *-----------------------------------------------------------------
 */
extern int32						/*  NFX_OK,
									 *  EEE_ERR_NO_DESC,
									 *  EEE_ERR_NO_BUF,
									 *  EEE_ERR_BAD_PARAM,
									 *  EEE_ERR_PACKET_TOO_LARGE
									 */
eee_testCreateSimplePacket(
	uint32	dest_slot,			/* slot number */
	uint32	dest_cpu,			/* cpu id on that slot */
	uint32	size,				/* number of bytes in test message to send */
	uint32	bufsize,			/* EEE_BUF_SMALL,
									EEE_BUF_LARGE,
									EEE_BUF_ULTRA */
	uint32	plane,				/* 0 = data, 1 = mgmt */
	uint32	seq_num
);

/*-----------------------------------------------------------------
 * Name:    eee_testCreateDVTTestPkt()
 *
 * Description: Create a packet from a known sequence
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/20/01
 *
 *-----------------------------------------------------------------
 */
extern eee_descPtr_t                           /* returns edesc addr or NULL */
eee_testCreateDVTTestPkt(
    uint32  slot,
    uint32  cpu,
    eee_test_hdr_t  * pktSpec,
    uint32  seq
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    12/01/01
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_testSendDVTStartPkt(
    uint32  slot,
    uint32  cpu,
    uint32  plane,
    uint32  num_pkts,
    uint32  spin
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    12/01/01
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_testSendDVTStopPkt(
    uint32  slot,
    uint32  cpu,
    uint32  plane
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/22/02
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_testSendDVTClearPkt(
    uint32  slot,
    uint32  cpu,
    uint32  plane
);

/*-----------------------------------------------------------------
 * Name:    eee_testDVTStart(mode)
 *
 * Description: Start EEE layer test
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/20/01
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_testDVTStart(
    uint32  num_pkts,
    uint32  plane,
    uint32  spin
);

/*-----------------------------------------------------------------
 * Name:    eee_testDVTEnd()
 *
 * Description: Stop EEE layer test
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/20/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testDVTEnd(
    uint32  plane
);

/*-----------------------------------------------------------------
 * Name:    eee_testDVTClear()
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/22/02
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testDVTClear(
    uint32  plane
);

/*-----------------------------------------------------------------
 * Name:    eee_testDVTPrintStats()
 *
 * Description: Show send/receive stats for EEE test
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/20/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testDVTPrintStats(
    uint32  plane
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    12/05/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testDVTClearStats(
    uint32  plane
);

/*-----------------------------------------------------------------
 * Name:    eee_testSimpleRcv()
 *
 * Description: Receive function for EEE test packets
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/19/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testSimpleRcv(
    eee_descPtr_t   edesc
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testDVTRcv(
    eee_descPtr_t   edesc
);

/*-----------------------------------------------------------------
 * Name:    eee_anpTestRcv()
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern void
eee_anpTestRcv(
    eee_descPtr_t   edesc
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_sendMessageTest(
    uint32  slot,
    uint32  cpu,
    uint32  num_bytes
);

/*-----------------------------------------------------------------
 * Name:    eee_testInit()
 *
 * Description: Initialize receive functions for test application
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/19/01
 *
 *-----------------------------------------------------------------
 */
extern void
eee_testInit(void);

/*-----------------------------------------------------------------
 * Name:    eee_testSysDVTStart(mode)
 *
 * Description: Start system DVT test
 *
 * Created by: lipika
 *
 * Date Created:    6/01/02
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_testSysDVTStart(
eee_test_hdr_t  *test_hdr
);

extern boolean
eee_is_local_slot_cpu(int slot, int cpu);

#endif	/* _EEE_TEST_H */

