/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-validate.h
 *
 * RCS:  $Id: eee-validate.h,v 1.3 2002/09/26 17:23:58 maximk Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/24/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_VALIDATE_H
#define _EEE_VALIDATE_H

/*
 * Allocation validation information. We use uint32 for the allocation/free
 * addresses to save space, sign extend to get the real address.
 */
typedef struct eee_val {
    /*
     * The address of the caller of allocation function.  If 0 the object was 
     * not allocated.  
     */
	uint32 alloc;

    /*
     * The address of the caller of free function. If 0 the object is 
     * currently allocated.
     */
	uint32 free;

    /*
     * Number of references to this object.
     */
    uint32 refcnt;
} eee_validate_t;

extern eee_validate_t *eee_desc_validate[2];
extern eee_validate_t *eee_buf_validate[2][EEE_NUM_BUF_SIZES];

#endif	/* _EEE_VALIDATE_H */

