/* vi:ts=4
 *-----------------------------------------------------------------
 *
 * Name:    nfx-defs.h
 *
 * RCS:  $Id: nfx-defs.h,v 1.74 2002/11/21 19:26:34 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage Inc.
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */

/*
 * NOTE:
 * Only put items in this file that are common to all platforms.
 * Things that differ between platforms need to go in the platform
 * specific files {bc,bl,ch,cg}/nfs-defs.h.
 */

#ifndef _NFX_DEFS_H
#define _NFX_DEFS_H

/*
 * The name of the product.
 */
#define PRODUCT_NAME DEFAULT_VENDOR_NAME " NAS Gateway"

#define FILER_OS_NAME DEFAULT_VENDOR_NAME " EverON"

#ifndef NULL
#define NULL                0
#endif

#ifndef TRUE
#define TRUE                1
#define FALSE               0
#endif

/*
 * Generic return codes, see nfx-error.h for module specific ranges
 */
#define NFX_OK              0
#define NFX_ERR             -1

/*
 * MIN/MAX
 */
#if !defined(MIN)
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#if !defined(array_len)

/*++

Routine Description:
    
    Calculate array length. Must be a true array.

Arguments:
    
    ar - array

Return Value:

    Returns the array length.

--*/

#define array_len(ar) (sizeof(ar) / sizeof((ar)[0]))
#endif

#ifdef linux
/* @@@ temporary place in the absence of the system includes.
 */
#define PF_EEE 30
#define AF_EEE PF_EEE
#endif


/* Ethernet types */
#define EEE_ETH_TYPE        0x0022
#define EEE_ETH_TYPE_SAC    0x0F22

/*
 * Class of Service levels
 */
#define NFX_COS_HIGH        0
#define NFX_COS_LOW         1

/* Card type definitions
 */

/* The System Services Controller.
 */
#define NFX_CARDTYPE_SSC 0

/* The Network File Processor.
 */
#define NFX_CARDTYPE_NFP 1

/* The Fibre Channel Processor.
 */
#define NFX_CARDTYPE_FCNIM 2

/* The number of cards.
 */
#define NFX_CARDTYPE_NUM 3

/* Slot definitions
 */

/* Unknown slot number.
 */
#define NFX_SLOTTYPE_UNKNOWN -1

/* The System Services Controller.
 */
#define NFX_SLOTTYPE_SSC 0

/* The Network File Processor.
 */
#define NFX_SLOTTYPE_NFP 1

/* The Fibre Channel Processor.
 */
#define NFX_SLOTTYPE_FC 2

#define NFX_SLOT_MIN 0

/* The maximum number of slots we ever expect.
 */
#define NFX_SLOT_MAX 11

#define NFX_NUM_SLOTS_PER_CHASSIS   (NFX_SLOT_MAX + 1)

/*
 * CPU identifiers
 */
#define NFX_MAX_CPUS_PER_SLOT       16

#define NFX_FCNIM_CPUID3            3   /* nfxMyCPUId=3 is fc slice 0 */
#define NFX_FCNIM_CPUID2            2   /* nfxMyCPUId=2 is fc slice 1 */
#define NFX_FCNIM_CPUID1            1   /* nfxMyCPUId=1 is fc slice 2 */
#define NFX_FCNIM_CPUID0            0   /* nfxMyCPUId=0 is fc slice 3 */

/* SSC cpu types */
#define NFX_SSC_NUM_CPUS            2   /* on physical card */
#define NFX_SSC_UNIX                0
#define NFX_SSC_MGMT                1

#define NFX_CPUID_UNKNOWN           (-1)

/*
 * Port Identifiers
 */
#define PORT_BEST_FIT               0
#define PORT_LOCAL_APP              1

/* Ports for diagnostic tests.
 */
#define NFP_PORT_TXRX_ETH0          2
#define NFP_PORT_TXRX_ETH1          3
#define NFP_PORT_TXRX_ETH2          4
/* Cougar has four ports.
 */
#define NFP_PORT_TXRX_ETH3          5
/* FP ports for Cheetah and Bobcat.
 */
#define NFP_PORT_FP_ETH0            5
#define NFP_PORT_FP_ETH1            6
#define NFP_PORT_FP_ETH2            7
#define NFP_PORT_MGMT               8
#define NFP_PORT_LOCAL_QUEUE        9

#define FCNIM_PORT_FC               2
#define FCNIM_PORT_BP_DATA          3
#define FCNIM_PORT_BP_MGMT          4
#define FCNIM_PORT_BP_CONTROL       5

#define SSC_PORT_BP_DATA            2
#define SSC_PORT_BP_MGMT            3
#define SSC_PORT_LOCAL_QUEUE        4

#define PROM_PORT_MGMT          2
#define PROM_PORT_NET0          3
#define PROM_PORT_NET1          4
#define PROM_PORT_FP0           5
#define PROM_PORT_FP1           6
#define PROM_PORT_TXRX0         7
#define PROM_PORT_TXRX1         8
#define PROM_PORT_TXRX2         9
#define PROM_PORT_FP2           10

/*
 * Application Message Type Base Number Assignment
 *  The first word of the application's messages shall be in the range
 *  assigned to that application. This will enable applications to 
 *  differentiate their messages from those of other applications.
 */
#define FS_MSG_BASE     0
#define SCSI_MSG_BASE   1024
#define EVM_MSG_BASE    2048
#define SPM_MSG_BASE    2560
#define NFS_MSG_BASE    3072
#define CIFS_MSG_BASE   4096
#define SBM_MSG_BASE    5120
#define ELAYER_MSG_BASE 6144
#define SDM_MSG_BASE    7168
#define EA_MSG_BASE     8192
#define EA_SPM_MSG_BASE       8200
#define EA_NTFY_MSG_BASE      8250
#define EA_FSYS_MSG_BASE      8300
#define EA_FSET_MSG_BASE      8350
#define EA_EXPORT_MSG_BASE    8400
#define EA_SNAPS_MSG_BASE     8450
#define EA_CHASSIS_MSG_BASE   8480
#define EA_SDM_MSG_BASE       8490
#define EA_RAID_MSG_BASE      8500
#define EL_MSG_BASE     8600
#define EV_MSG_BASE     8704
#define REGM_MSG_BASE   9216
#define ELOG_MSG_BASE   9248
#define CCM_MSG_BASE    9312
#define MOUNTD_MSG_BASE 9344 
#define AM_MSG_BASE     9376
#define TAPE_MSG_BASE   9504
#define NDMP_MSG_BASE   9604
#define FILE_MSG_BASE   9704
#define IPMD_MSG_BASE   9804
#define DM_MSG_BASE     9904
#define RCONN_MSG_BASE  9920
#define NCM_MSG_BASE    9950
#define CLUSTER_MSG_BASE    9960
#define EVENT_MSG_BASE  9970
#define FSSF_MSG_BASE   9990
#define BCETH_MSG_BASE  10030
#define NFSSSC_MSG_BASE 10050
#define REQ_STATS_MSG_BASE 10080
#define RAID_MSG_BASE   10112
#define CM_MSG_BASE     10208
#define PROM_UPGRADE_MSG_BASE 10240
#define STATS_MSG_BASE 10250
#define SSC_AUTHEN_MSG_BASE 10300
#define AUDIT_MSG_BASE 10350
#define CSHARE_MSG_BASE 10370
#define SYMLINK_MSG_BASE 10390
#define CLUSTER_MSG_ID_BASE 10410
#define VSVR_MSG_ID_BASE 10460
#define EEE_MSG_BASE  10540
#define VTM_MSG_BASE  10560
#define SANM_MSG_BASE   10600
#define SANM_AG_MSG_BASE 10680
#define SANM_DM_MSG_BASE 10730
#define DRS_MSG_BASE    10780
#define DUMP_RESTORE_MSG_BASE 10800
#define SNMPD_MSG_BASE  11000
#define SCT_MSG_BASE    11100
#define DCACHE_MSG_BASE 11200
#define CLUSTER_RL_BASE 11280
#define VSVR_MSG_ID_BASE_2 11380
#define MGMTBUS_MSG_BASE   11480

#define TPL_FP_MSG_BASE    11500
#define REPLN_MSG_BASE     11540
#define IPR_MSG_BASE       11620
#define NEXT_MSG_BASE      11720 /* If you add here, change the range comparison
                                  * for the previous message base in the code.
                                  */

/*
 * NFX spinlock definitions.
 */
#ifdef NFX_SMP /* TODO - define these functions, just placeholders now. */
#ifdef NFX_SPINLOCK_DEBUG
#define NFX_SPIN_INIT(_lockp, _level)   spinlock_init((nfx_spinlock_t *)(_lockp), _level)
#define NFX_SPIN_LOCK(_lockp)           spinlock_getlock((nfx_spinlock_t *)(_lockp))
#define NFX_SPIN_UNLOCK(_lockp)         spinlock_unlock((nfx_spinlock_t *)(_lockp))
#define NFX_SPIN_TRYLOCK(_lockp)        spinlock_trylock((nfx_spinlock_t *)(_lockp))
#else
#define NFX_SPIN_INIT(_lockp, _level)   (_lockp)->lock = 0
#define NFX_SPIN_LOCK(_lockp)           SPINLOCK_LOCK((nfx_spinlock_t *)(_lockp))
#define NFX_SPIN_UNLOCK(_lockp)         SPINLOCK_UNLOCK((nfx_spinlock_t *)(_lockp))
#define NFX_SPIN_TRYLOCK(_lockp)        SPINLOCK_TRYLOCK((nfx_spinlock_t *)(_lockp))
#endif
#else
#define NFX_SPIN_INIT(_lockp, _level)
#define NFX_SPIN_LOCK(_lockp)
#define NFX_SPIN_UNLOCK(_lockp)
#define NFX_SPIN_TRYLOCK(_lockp)        1
#endif

/*------------------------------------------------------------------------------
 * System timeouts and periods in seconds.
 *------------------------------------------------------------------------------
 */
#define NFX_VOLUME_CREATE_TO    (8 *60) /* Volume create timeout. */
#define NFX_VSVR_TO             (9 *60) /* Virtural server enable/disable timeout. */


#define NFX_GENERAL_IO_TIMOUT   55  /* 10s for link up + */
                                    /* 30s for drive start time + */
                                    /* (1 IO + 2 retries) at 5s each */
#define NFX_EXPRESS_IO_TIMOUT   15  /* 10s for link up + 1 IO at 5s */
#define NFX_VOL_TSTAMP_PERIOD    5  /* >= EXPRESS_IO_TO / 2 to simplify... */
#define NFX_WRITE_GATE_PERIOD   10  /* TSTAMP_PERIOD < x <= 2*TSTAMP_PERIOD */
#define NFX_DEFAULT_IO_TIMEOUT  180 /* Default timeout per read/write reqeust.
                                     * This is a value chosen to give ctrl's
                                     * like 3Par to complete their rolling
                                     * upgrade before they begin responding to
                                     * the IO req's.
                                     */
#define NFX_DEFAULT_DISK_IO_TO  15  /* This is a 15 sec time for each IO to disk
                                     * to timeout before EVM will make another
                                     * attempt for this IO until we reach the
                                     * NFX_DEFAULT_IO_TIMEOUT.
                                     * This was changed to 5 for 1.2.4, now back to 15.
                                     * PR12114 - AlanP.
                                     */
#define NFX_MAX_IO_TIMEOUT_SUPPORT  300 /* This is the file system timeout that
                                         * are supporting. All the IO's in FS
                                         * will wait for atlest these many
                                         * seconds before timing out. The prefered
                                         * values for IO timeouts can be set to
                                         * any value from 15 - 300 sec's.
                                         */

/*----------------------------------------------------------------------------*/

#define NFX_SW_VER 2

#ifdef PROM
#define NFX_MAX_CONN    128     /* max. # of connections supported */
#else
#define NFX_MAX_CONN    32768    /* max. # of connections supported */
#endif

/*------------------------------------------------------------------------------
 * HW workaround definition.
 *------------------------------------------------------------------------------
 */
/* Temporary WorkARound for fake seep in crasdump are in flash memory */
#define FAKE_SEEP_ON_FLASH_WAR  1

/*------------------------------------------------------------------------------
 * Global Clustering Constants
 *------------------------------------------------------------------------------
 */

#define CLUST_NODE_FAIL_TIMEOUT     60  /* (seconds) */

/*------------------------------------------------------------------------------
 * Global Names for the management vs and scratch volume
 *------------------------------------------------------------------------------
 */

#define VS_MGMT_NAME             "VS_MGMT"

#define NFX_SCRATCH_VOLUME       "vol_mgmt"
#define NFX_SCRATCH_VS           VS_MGMT_NAME

/* 
 * Dump predefined snapshot names
 */

#define DUMP_SNAP_PREFIX    "dump_"                 // dump snapshot name prefix
#define DUMP_SNAP_PREFIX_LEN strlen(DUMP_SNAP_PREFIX)


/*------------------------------------------------------------------------------
 * Mirror snap shot name. Used to generate new snapshot name.
 *------------------------------------------------------------------------------
 */

#define SANM_MIRROR_SNAP_PREFIX          "SANM_SS_"
#define SANM_MIRROR_SNAP_PREFIX_LEN      8
#define SANM_MAX_NAME_LEN                16

/* A define to prevent strings from growing too long
 */
#define unused__ __attribute__((unused))

/* A define that declares a parameter as unused in the optimized build, but
 * not in the DEBUG build.
 */
#ifdef DEBUG
#define opt_unused__
#else
#define opt_unused__ __attribute__((unused))
#endif

/* @@@; Back plane interface name 
 */
#define ONSTOR_BP_IF_NAME "bp0"

/* The maximum size of the NULL-terminated virtual interface name.
 */
#define IPM_STR_SIZE            24

/* Time related definitions
 */
#define NFX_MINUTE              60                  // in seconds
#define NFX_HOUR                (NFX_MINUTE*60)     // in seconds
#define NFX_DAY                 (NFX_HOUR*24)       // in seconds

#endif  /* _NFX_DEFS_H */

