/*
 *-----------------------------------------------------------------
 * Name:    nfx-types.h
 * Copyright (C) 2009, OnStor Inc.
 *-----------------------------------------------------------------
 */
#ifndef _NFX_TYPES_H
#define _NFX_TYPES_H

#ifndef _NFX_ERROR_H
#include "nfx-error.h"
#endif

#define NFX_OK 0

#define __long64

typedef unsigned int req_state_t;

typedef long long           int64;
typedef unsigned long long  uint64;

NFX_ASSERT_STATIC(sizeof (uint64)   == 8);
NFX_ASSERT_STATIC(sizeof (int64)    == 8);

typedef int                 int32;
typedef unsigned int        uint32;

NFX_ASSERT_STATIC(sizeof (int32)    == 4);
NFX_ASSERT_STATIC(sizeof (uint32)   == 4);

typedef short               int16;
typedef unsigned short      uint16;
typedef short               short16;
typedef unsigned short      ushort16;

NFX_ASSERT_STATIC(sizeof (int16)    == 2);
NFX_ASSERT_STATIC(sizeof (uint16)   == 2);
NFX_ASSERT_STATIC(sizeof (short16)  == 2);
NFX_ASSERT_STATIC(sizeof (ushort16) == 2);

typedef unsigned char       byte;
typedef char                int8;
typedef unsigned char       uint8;
typedef char                char8;
typedef unsigned char       uchar8;

NFX_ASSERT_STATIC(sizeof (byte)     == 1);
NFX_ASSERT_STATIC(sizeof (int8)     == 1);
NFX_ASSERT_STATIC(sizeof (uint8)    == 1);
NFX_ASSERT_STATIC(sizeof (char8)    == 1);
NFX_ASSERT_STATIC(sizeof (uchar8)   == 1);

#ifdef LATER
#if !defined(SSC) && !defined(__OpenBSD__) && !defined(linux) && !defined(__BIT_TYPES_DEFINED__)

typedef uint32 uint32_t;
typedef uint64 uint64_t;
typedef uint16 uint16_t;
typedef uint8 uint8_t;

typedef uint32 u_long;
typedef int64      quad_t;
typedef uint64     u_quad_t;

#include <mips/types.h>

typedef __SIZE_TYPE__ size_t;

#else
#include <sys/types.h>
#endif
#endif /* LATER */

typedef uint32 NTSTATUS;
#define STATUS_SUCCESS ((NTSTATUS)0x00000000L) // ntsubauth

typedef unsigned char       boolean;

typedef unsigned long long  nfx_cod_t;

NFX_ASSERT_STATIC(sizeof (nfx_cod_t) == 8);

/* Define a virtual server id.
 */
typedef uint32 vs_id_t;

/* Invalid / undefined VS id
 */
#define VS_ID_INVALID 0

#if defined(NFX_MOD_SSC) || defined(TUXRX)    // Only valid for SSC OR TUXRX compiles
#if defined(SSC_MGMT)
typedef unsigned long uintptr_t;
typedef long          intptr_t;
#else
// include <inttypes.h>       // For ANSI types
typedef unsigned long uintptr_t;
typedef long          intptr_t;
#endif
#elif defined(NFX_MOD_NFP)
typedef unsigned long uintptr_t;
typedef long          intptr_t;
#elif ((!defined(_SYS_TYPES_H_) && !defined(__intptr_t_defined)) || defined(FREE_BSD))
typedef unsigned long uintptr_t;
typedef long          intptr_t;
#elif defined(__OpenBSD__) 
typedef unsigned long uintptr_t;
typedef long          intptr_t;         
#elif defined(TUXRX) 
typedef unsigned long long uintptr_t;
typedef long long           intptr_t;         
#endif
typedef uintptr_t     address_t;

NFX_ASSERT_STATIC(sizeof (address_t) == sizeof (void *));

#define NETEEE_FRAGMENT
#define EEE_ALLOC_USE_TAILQ
#define EEE_VALIDATE
#define REQ_TRACING
#define CIFS_PRINT_PACKETS
#define NFS_DONT_FREE_REQUESTS -DRECYCLE_REQUESTS
#define CIFS_DONT_FREE_REQUESTS -DRECYCLE_REQUESTS
#define DCACHE_ENABLE_READAHEAD
#define DCACHE_VERIFY_CACHE_LIST
#define DCACHE_VERIFY_CACHE_LIST_AFTER_INSERTION
#define DCACHE_SAVE_REQ_RESP
#define DCACHE_DEBUG_ENABLE
#define DCACHE_DEBUG_ASSERT
#define DCACHE_DEBUG_FILE_HIST
#define BASIC_STATS
#define DETAIL_STATS
#define PKT_ALLOC_USE_TAILQ
#define FS_RPC_USE_TAILQ

#endif  /* _NFX_TYPES_H */

