/*
 *-----------------------------------------------------------------
 * Name: tpl-ipc.h
 * Copyright (C) 2009, OnStor, Inc.
 *
 * IPC queues between transport layer txrx and application txrx.
 *-----------------------------------------------------------------
 */
#ifndef _TPL_LINUX_IPC_H
#define _TPL_LINUX_IPC_H

typedef struct {
    volatile void *ptr;
    volatile void *msg;
} tpl_qent_t;

enum tpl_event {
    TPL_EVNT_BIND_REQ=0,  
    TPL_EVNT_BIND_REQ_ACK,
    TPL_EVNT_UNBIND_REQ,
    TPL_EVNT_UNBIND_REQ_ACK,
    TPL_EVNT_CLOSE_REQ,
    TPL_EVNT_ADD_CONN,
    TPL_EVNT_ADD_CONN_ACK,
    TPL_EVNT_DEL_CONN,
    TPL_EVNT_DEL_CONN_ACK,
    TPL_EVNT_PKTQ_TX,
    TPL_EVNT_PKTQ_TXCOMP,
    TPL_EVNT_PKTQ_RX,  
    TPL_EVNT_PKTQ_TX_SLOW,
    TPL_EVNT_UNBIND_REQ_ACK2,
    TPL_EVNT_REQUESTS_AVAILABLE,
    TPL_EVNT_LOOPBACK,
    TPL_EVNT_CNT  /* maxinum num. of evnts */
};

/* txrx IPC evnet definitions */
typedef struct {
	unsigned int evnt_msg;
	unsigned int evnt_rc;
	void	*evnt_data;
        unsigned int evnt_vsId;
} tpl_evntMsg_t;

#define    TPL_READ_WRITE_GAP       512     

typedef struct {
    tpl_qent_t  *rdPtr;  // read ptr
    unsigned int lag;    // lag between rdPtr and tailRdPtr 
    unsigned int total_rd;
} tpl_rd_t;

typedef struct {
    tpl_qent_t  *wrPtr; //read ptr
    tpl_qent_t *volatile tailRdPtr; // tailing read ptr
    unsigned int      total_wr;
} tpl_wr_t;

/* common queue structure */
typedef struct tpl_ipcq {
    tpl_qent_t  *tpl_ipcqStartPtr;  /* start of Q allocation */
    tpl_qent_t  *tpl_ipcqEndPtr;    /* end of Q allocation */ 
    tpl_rd_t    tpl_ipcqRdPtr;    
    tpl_wr_t    tpl_ipcqWrPtr;      
    unsigned int      tpl_ipcqDropCnt;    /* entries dropped because Q is full */
    unsigned int      tpl_ipcqHWater;     /* higher water mark for entries in queue */
} tpl_ipcq_t;

/* ipc queue definitions */
#define TPL_IPC_EVNTQ_NTOA      0
#define TPL_IPC_EVNTQ_ATON      1
#define TPL_IPC_EVNTQ_PKTS_COMP 2

#define TPL_IPC_Q_CNT           3

/* MAX_NTOA_EVNT 
 * Under EEE this was MAX(max_num_connections + some_additional_pkts, 2 * max_descriptors)
 */
#define PKT_MAX_DESC_CNT (10*1024)   /* Max PKT descriptors, from sm-pkt/pkt.h */

#define TPL_NTOA_MORE_EVNT      1024

#if (NFX_MAX_CONN > PKT_MAX_DESC_CNT)
#define MAX_NTOA_EVNTS  (NFX_MAX_CONN + TPL_NTOA_MORE_EVNT)
#else
#define MAX_NTOA_EVNTS (PKT_MAX_DESC_CNT*2)
#endif

#endif /* _TPL_LINUX_IPC_H */



    

