/*                               -*- Mode: C -*- 
 * handler_tbl.c
 * 
 * Description     : NDMP request handler table.
 * 
 * Copyright (c) 1999 Network Appliance, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*
 * The majority of this code was taken from the NDMP SDK client toolkit.
 */

#include "ndmp_common.h"
#include "ndmpc.h"

NdmpMsgHandler ndmp_msg_handler_tbl[] =
{
	{
		NDMP_CONNECT_OPEN, 2,
		0,
		AUTH_NOT_REQUIRED,
		XDR_AND_SIZE(ndmp_connect_open_request),
		XDR_AND_SIZE(ndmp_connect_open_reply)
	},
	{
		NDMP_CONNECT_CLIENT_AUTH, 2,
		0,
		AUTH_NOT_REQUIRED,
		XDR_AND_SIZE(ndmp_connect_client_auth_request),
		XDR_AND_SIZE(ndmp_connect_client_auth_reply)
	},
	{
		NDMP_CONNECT_CLOSE, 2,
		0,
		AUTH_NOT_REQUIRED,
		0, 0,
		0, 0
	},
	{
		NDMP_CONFIG_GET_HOST_INFO, 2,
		0,
		AUTH_NOT_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_config_get_host_info_reply)
	},
	{
		NDMP_CONFIG_GET_BUTYPE_ATTR, 2,
		0,
		AUTH_NOT_REQUIRED,
		XDR_AND_SIZE(ndmp_config_get_butype_attr_request),
		XDR_AND_SIZE(ndmp_config_get_butype_attr_reply)
	},
	{
		NDMP_CONFIG_GET_MOVER_TYPE, 2,
		0,
		AUTH_NOT_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_config_get_mover_type_reply)
	},
	{
		NDMP_SCSI_OPEN, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_scsi_open_request),
		XDR_AND_SIZE(ndmp_scsi_open_reply)
	},
	{
		NDMP_SCSI_CLOSE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_scsi_close_reply)
	},
	{
		NDMP_SCSI_GET_STATE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_scsi_get_state_reply)
	},
	{
		NDMP_SCSI_SET_TARGET, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_scsi_set_target_request),
		XDR_AND_SIZE(ndmp_scsi_set_target_reply)
	},
	{
		NDMP_SCSI_RESET_DEVICE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_scsi_reset_device_reply)
	},
	{
		NDMP_SCSI_RESET_BUS, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_scsi_reset_bus_reply)
	},
	{
		NDMP_SCSI_EXECUTE_CDB, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_execute_cdb_request),
		XDR_AND_SIZE(ndmp_execute_cdb_reply)
	},
	{
		NDMP_TAPE_OPEN, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_tape_open_request),
		XDR_AND_SIZE(ndmp_tape_open_reply)
	},
	{
		NDMP_TAPE_CLOSE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_tape_close_reply)
	},
	{
		NDMP_TAPE_GET_STATE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_tape_get_state_reply_v2)
	},
	{
		NDMP_TAPE_MTIO, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_tape_mtio_request),
		XDR_AND_SIZE(ndmp_tape_mtio_reply)
	},
	{
		NDMP_TAPE_WRITE, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_tape_write_request),
		XDR_AND_SIZE(ndmp_tape_write_reply)
	},
	{
		NDMP_TAPE_READ, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_tape_read_request),
		XDR_AND_SIZE(ndmp_tape_read_reply)
	},
	{
		NDMP_TAPE_EXECUTE_CDB, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_tape_execute_cdb_request),
		XDR_AND_SIZE(ndmp_tape_execute_cdb_reply)
	},
	{
		NDMP_DATA_GET_STATE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_data_get_state_reply_v2)
	},
	{
		NDMP_DATA_START_BACKUP, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_data_start_backup_request_v2),
		XDR_AND_SIZE(ndmp_data_start_backup_reply)
	},
	{
		NDMP_DATA_START_RECOVER, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_data_start_recover_request_v2),
		XDR_AND_SIZE(ndmp_data_start_recover_reply)
	},
	{
		NDMP_DATA_ABORT, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_data_abort_reply)
	},
	{
		NDMP_DATA_GET_ENV, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_data_get_env_reply)
	},
	{
		NDMP_DATA_STOP, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_data_stop_reply)
	},
	{
		NDMP_NOTIFY_DATA_HALTED, 2,
		notifyDataHalted,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_notify_data_halted_request),
		0, 0
	},
	{
		NDMP_NOTIFY_CONNECTED, 2,
		notifyConnected,
		AUTH_NOT_REQUIRED,
		XDR_AND_SIZE(ndmp_notify_connected_request),
		0, 0
	},
	{
		NDMP_NOTIFY_MOVER_HALTED, 2,
		notifyMoverHalted,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_notify_mover_halted_request),
		0, 0
	},
	{
		NDMP_NOTIFY_MOVER_PAUSED, 2,
		notifyMoverPaused,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_notify_mover_paused_request),
		0, 0
	},
	{
		NDMP_NOTIFY_DATA_READ, 2,
		notifyDataRead,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_notify_data_read_request),
		0, 0
	},
	{
		NDMP_LOG_LOG, 2,
		logLog,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_log_log_request),
		0, 0
	},
	{
		NDMP_LOG_DEBUG, 2,
		logDebug,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_log_debug_request),
		0, 0
	},
	{
		NDMP_LOG_FILE, 2,
		logFile,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_log_file_request),
		0, 0
	},
	{
		NDMP_FH_ADD_UNIX_PATH, 2,
		fileHistoryAddUnix,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_fh_add_unix_path_request),
		0, 0
	},
	{
		NDMP_FH_ADD_UNIX_NODE, 2,
		fileHistoryAddUnixNode,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_fh_add_unix_node_request),
		0, 0
	},
	{
		NDMP_FH_ADD_UNIX_DIR, 2,
		fileHistoryAddUnixDir,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_fh_add_unix_dir_request),
		0, 0
	},
	{
		NDMP_MOVER_GET_STATE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_mover_get_state_reply)
	},
	{
		NDMP_MOVER_LISTEN, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_mover_listen_request),
		XDR_AND_SIZE(ndmp_mover_listen_reply)
	},
	{
		NDMP_MOVER_CONTINUE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_mover_continue_reply)
	},
	{
		NDMP_MOVER_ABORT, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_mover_abort_reply)
	},
	{
		NDMP_MOVER_STOP, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_mover_stop_reply)
	},
	{
		NDMP_MOVER_SET_WINDOW, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_mover_set_window_request),
		XDR_AND_SIZE(ndmp_mover_set_window_reply)
	},
	{
		NDMP_MOVER_READ, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_mover_read_request),
		XDR_AND_SIZE(ndmp_mover_read_reply)
	},
	{
		NDMP_MOVER_CLOSE, 2,
		0,
		AUTH_REQUIRED,
		0, 0,
		XDR_AND_SIZE(ndmp_mover_close_reply)
	},
	{
		NDMP_MOVER_SET_RECORD_SIZE, 2,
		0,
		AUTH_REQUIRED,
		XDR_AND_SIZE(ndmp_mover_set_record_size_request),
		XDR_AND_SIZE(ndmp_mover_set_record_size_reply)
	},
	{
		0,
		0,
		0,
		0, 0,
		0, 0
	}
};
