// hexpand.cpp : Defines the entry point for the console application.
//

#include <citkTypes.h>

#include <stdlib.h>
#include <ctype.h>

/*
#include <vrsst_string.h>
#include <vrsst_file.h>
#include <vrsst_arrayval.h>
using namespace vrSSTypes;
*/

#define CDING1(c) (isalpha(c) || (c)=='_')
#define CDING(c) (isalnum(c) || (c)=='_')

#define LINE_LEN	130
#define VERSION		"HExpand v 1.6"
#define TEMPFILE	"HEXPAND.~H"

//String	S_T = "TRUE";
//String	S_F = "FALSE";

void CDECL vrss_assert( const char*m )
{
	printf("ERROR: %s\n",m);
}

#define CO_QUIET				'q'
#define CO_VERBOSE				'v'
#define CO_INCLUDEDIR			'i'
#define CO_DEFINE				'd'
#define CO_KEEPDEFINE			'k'
#define CO_LISTHEADERS			'l'
#define CO_LISTDEFINES			'p'
#define CO_OPTIMIZE				'o'
#define CO_STRIP				's'
#define CO_ADDHEADER			'h'
#define CO_ADDFOOTER			'f'
#define CO_SKIPEMPTY			'e'
#define CO_ONLYCHANGED			'c'
#define CO_REVISION				'r'
#define CO_REVISIONFILE			'u'


ArrayVal<String>	IncludeDirs;			//	i
ArrayVal<String>	Defines;				//	d
ArrayVal<String>	KeepDefs;				//	k
ArrayVal<String>	HeadersDone;
ArrayVal<bool>		IfStack;
ArrayVal<bool>		DoitStack;
ArrayVal<bool>		LeaveStack;
ArrayVal<String>	FileStack;
DFile output;

String	sRevisionDef, sRevisionNo, sRevisionFile;

bool	skip = false;			// ifdef enzo
bool	doit = true;

int		iMaxRecurse=99;						// #
bool	bQuiet=false;						// q
bool	bVerbose=false;						// v
bool	bListHeaders = false;				// l
bool	bListDefines = false;				// p
bool	bOptimize = false;					// o
bool	bStrip = false;						// s
bool	bAddHeader = false;					// h
bool	bAddFooter = false;					// f
bool	bSkipEmptyLines = false;			// e
bool	bOnlyIfChanged = false;				// c
bool	bRevision = false;					// r
//bool	bSkipComments = !false;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

bool ParseComment( String& );
bool ParsePreproc( const String& );

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
/*
void GetFirstWord( String &ss)
{
//	int ns = ss.Pos(' ');	// Next space
//	if (ns>=0)
//		ss.SetLength(ns);
	int ns = 0;
	while (CDING(ss[ns]) ns++;
	ss.SetLength(ns);
}
*/

String GetCIdentifier( const String &ss )
{
	if (!CDING1(ss[0]))
	{
		printf("ERROR: Identifier expected: %s\n",ss.c_str());
		return "";
	}

	int ns = 1;
	while (CDING(ss[ns])) ns++;

//	String ident = ss.SubString(0,ns);
//	ss.Delete(0,ns+1);
//	return ident;
	return ss.SubString(0,ns);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
			
void RemoveWhiteSpace( String& s )
{
	s.Trim();
	s.Replace("\t"," ");
	s.Replace("  "," ");
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

String GetFilename( String& ss )//, String &fn )
{
	int f = ss.Pos('<');
	if (f>=0)
	{
		int e = ss.Skip(f+1).Pos('>');
		if (e>=0)
			return ss.SubString(f+1,e);
	}

	f = ss.Pos('\"');
	if (f>=0)
	{
		int e = ss.Skip(f+1).Pos('\"');
		if (e>f)
			return ss.SubString(f+1,e);
	}
	return "";//false;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

bool ParseNormal( String &ss )
{
	int sp2 = ss.Pos("/*");
	int sp3 = ss.Pos("//");

	if (sp3>=0 && (sp2<0 || sp2>sp3))
	{
		// Everything after '//' is a comment
		ss.SetLength(sp3);
		return false;
	}

	if (sp2>=0)
	{
		String rest = ss.Skip(sp2+2);		// Everything after /*
		ss.SetLength(sp2);					// Everything before /*
		// Everything after '/*' is a comment
		bool com = ParseComment(rest);		// Remove the comment from 'rest'
		ss += rest;
		return com;
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////////

bool ParseComment( String &ss )
{
	int sp = ss.Pos("*/");
	if (sp>=0)
	{
		// Everything after '*/' should be parsed normally
		ss.Delete(0,sp+2);
		return ParseNormal(ss);
	}

	// Entire string is commented
	ss="";
	return true;
}

///////////////////////////////////////////////////////////////////////////////

String GetWord( String &ss )
{
	ss.TrimLeft();
	if (ss[0]=='\"')
	{
		for (int t=1;t<ss.Length();t++)
			if (ss[t]=='\"' && ss[t-1]!='\\')
			{
				String s = ss.SubString(0,t+1);
				ss.Delete(0,t+1);
				return s;
			}
		return ss;
	}
	String s = ss.DelWord();
	int cp = s.Pos('\"');
	if (cp>=0)
	{
		ss = s.Skip(cp) + ss;
		s.SetLength(cp);
	}
	return s;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void FlushBuffer( DFile &out, String &buf )
{
	if (!buf.IsEmpty())
	{
		out.WriteLine(buf);
		buf.Clear();
	}
}

///////////////////////////////////////////////////////////////////////////////

bool ProcessFile( String file )
{
//	printf("INPUT %s\n",file.c_str());

	// Determine REAL filename (strip path)
	String fil = file;
	int i = _max( fil.PosR('/'), fil.PosR('\\') );
	if (i>=0)
		fil.Delete(0,i+1);

	// Check if this file was already processed
//	if (HeadersDone.Contains(fil))
//		return true;								// remove #include
	for (int ff=0;ff<HeadersDone.Count();ff++)
	{
		if (HeadersDone[ff].EqualsIC(fil))			// case insensitive
		{
			// Extra case sensitive compare; issue a warning if it fails
			if (!HeadersDone[ff].Equals(fil))
				printf("Warning: Skipping file with inconsistent case: %s\n", file.c_str() );
			return true;							// remove #include
		}
	}

	// Add this file to the list
	HeadersDone.Add(fil);

	// Check the max recursion level
	if (FileStack.Count() > iMaxRecurse)
		return false;								// keep #include

	DFile in;

#ifdef _WIN32
	file.Replace('/','\\');							// turn slashes 90 degs
#endif
	// Try to open the file in all directories
	for (int dd=0;dd<IncludeDirs.Count();dd++)
		if (in.Open(IncludeDirs[dd]+file))
			break;

	// Still not open?
	if (!in.Opened())
	{
		if (!bQuiet)
		{
			if (FileStack.Count()>0)
				printf("Not found: %s, included in: %s\n", file.c_str(), FileStack.Peek().c_str() );
			else
				printf("Not found: %s\n", file.c_str() );
		}
		return false;								// keep #include
	}

	if (bVerbose)
		printf("Processing file: %s [%i]\n", fil.c_str(), FileStack.Count() );

	if (bAddHeader)
		output.WriteLine("///////////////////////////////// ["+fil+"]");

	FileStack.Push( fil );
	bool preproc = false;
	bool comment = false;
	String buf;

	while (!in.EndOfFile())
	{
		String s = in.ReadString();
		String stripped = s;

		if (comment)					// Line starts as comment
		{
			comment = ParseComment(stripped);
			RemoveWhiteSpace(stripped);
		}
		else
		{
			comment = ParseNormal(stripped);
			RemoveWhiteSpace(stripped);

			if (stripped[0]=='#')
			{
				FlushBuffer(output,buf);

				if (ParsePreproc(stripped ))
					continue;

				preproc = true;
			}
		}

		if (!skip)
		{
			String &line=bStrip?stripped:s;

			if (bSkipEmptyLines && line.IsEmpty())
				continue;

			if (!bStrip)
			{
				output.WriteLine(line);
				continue;
			}

			bool slash = stripped.CharR(0)=='\\';
			if (slash)
				line.Crop(1);

			if (!preproc)
			{
				// Add 'line' to buffer
				while (!line.IsEmpty())
				{
					String word = GetWord(line);
					if (!buf.IsEmpty())
					{
						char r = buf.CharR(0);
						if (CDING(r) && CDING(word[0]) || (r=='*' && word[0]=='='))
							buf = buf + String(' ') + word;
						else
							buf = buf + word;
					}
					else
						buf = word;
					if (buf.Length()>LINE_LEN)
						FlushBuffer(output,buf);
				}
			}
			else
			{
				// Add 'line' to buffer
				while (!line.IsEmpty())
				{
					String word = GetWord(line);
					if (!buf.IsEmpty())
					{
//						char r = buf.CharR(0);
//						if (isalnum(r) && isalnum(word[0]) || (r=='*' && word[0]=='='))
							buf = buf + " " + word;
//						else
//							buf = buf + word;
					}
					else
						buf = word;
					if (buf.Length()>LINE_LEN)
					{
						if (!line.IsEmpty())
							buf = buf + "\\";
						FlushBuffer(output,buf);
					}
				}
			}

			if (preproc && !slash)
			{
				FlushBuffer(output,buf);
				preproc = false;
			}
		}
	}

	if (!skip)
		FlushBuffer(output,buf);

	FileStack.Pop();
	if (bAddFooter)
		output.WriteLine("///////////////////////////////// ["+fil+"] END");

	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

bool ParsePreproc( const String &_ss )
{
	String ss = _ss;

	if (ss.DelPrefix("#include "))	// No #include statement
	{
		String fn = GetFilename(ss);
//		printf("IN %s\n", ss.c_str());
		if (fn.Length()>0)
		{
//			printf("UIT %s -> %s\n", ss.c_str(),fn.c_str());
			if (ProcessFile(fn))
				return true;
		}
		return false;
	}

	if (ss.DelPrefix("#define "))	// #define xxx
	{
		ss = GetCIdentifier(ss);
		Defines.Add(ss);			// Add define

		if (bRevision && ss.Equals(sRevisionDef) && !sRevisionNo.IsEmpty())
		{
			int whitespace = ss.Length()+9;
			// DAMNED: whitespaces where already removed, otherwise this would work perfectly
			while (_ss[whitespace]==' ' || _ss[whitespace]=='\t') whitespace++;

			String _rev = _ss.Skip(whitespace);
			_rev.DelInt();
			
			// Update revision number
			output.WriteLine(_ss.SubString(0,whitespace)+sRevisionNo+_rev);
			return true;
		}

		return false;
//		return ss.Pos("INCLUDED")>=0;
	}

	if (ss.DelPrefix("#undef "))	// #undef xxxx
	{
		ss = GetCIdentifier(ss);
		Defines.Remove(ss);			// Remove define
		return false;
	}

	if (!bOptimize)
		return false;

	if (ss.DelPrefix("#ifdef "))
	{
		ss = GetCIdentifier(ss);
		if (KeepDefs.Contains(ss))
			goto keepdef;
		LeaveStack.Push(false);
		IfStack.Push( skip );
		DoitStack.Push(doit);
		doit = Defines.Contains(ss);
		if (!doit)
			skip = true;
		return true;
	}
	if (ss.DelPrefix("#ifndef "))
	{
		ss = GetCIdentifier(ss);
		if (KeepDefs.Contains(ss))
			goto keepdef;
		LeaveStack.Push(false);
		IfStack.Push( skip );
		DoitStack.Push(doit);
		doit = !Defines.Contains(ss);
		if (!doit)
			skip = true;
		return true;
	}
	if (ss.DelPrefix("#endif"))
	{
		skip = IfStack.Pop();
		doit = DoitStack.Pop();
		return !LeaveStack.Pop();
	}
	if (ss.DelPrefix("#if "))
	{
keepdef:
		IfStack.Push(skip);
		DoitStack.Push(doit);
		LeaveStack.Push(true);
		return false;
	}
	if (ss.DelPrefix("#elif "))
	{
		IfStack.Push(skip);
		DoitStack.Push(doit);
		LeaveStack.Push(true);
		return false;
	}
	if (ss.DelPrefix("#else"))
	{
		doit = !doit;
		if (!doit)
			skip = true;
		return !LeaveStack.Peek();
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

bool CompareFiles( String fn1, String fn2 )
{
	DFile f1, f2;
	if (!f1.Open(fn1) || !f2.Open(fn2))
		return false;
	if (f1.FileSize() != f2.FileSize())
		return false;
	while (!f1.EndOfFile() && !f2.EndOfFile())
	{
		String line = f1.ReadString();
		if (line!=f2.ReadString())
		{
			// Don't compare lines containing a revision number
			if (bRevision && line.Prefix("#define") && line.Pos(sRevisionDef)>=8)
				continue;
			return false;
		}
	}
	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

int main(int argc, char* argv[])
{
	String inf, outf="out.h";
	bool Help=false;
	int a;
	char option_char = 0;				// we shouldn't mix / and -

	IncludeDirs.Add("");				// always check current dir

	// Scan for simple options first
	for (a=1;a<argc;a++)
	{
		if (option_char)
		{
			// Consistent option char?
			if (argv[a][0]!=option_char)
				continue;
		}
		else
		{
			if (argv[a][0]!='-' && argv[a][0]!='/')
				continue;
			option_char = argv[a][0];
		}

		// Simple options may be concatenated
		char opt;
		for (int ch=1;opt=argv[a][ch];ch++)
		{
			switch (tolower(opt))
			{
			case CO_VERBOSE: bVerbose = true;
				break;
			case CO_OPTIMIZE: bOptimize = true;
				break;
			case CO_STRIP: bStrip = true;
				break;
			case CO_SKIPEMPTY: bSkipEmptyLines = true;
				break;
			case CO_ONLYCHANGED: bOnlyIfChanged = true;
				break;
			case CO_ADDHEADER: bAddHeader = true;
				break;
			case CO_ADDFOOTER: bAddFooter = true;
				break;
			case CO_LISTHEADERS: bListHeaders = true;
				break;
			case CO_LISTDEFINES: bListDefines = true;
				break;
			case CO_QUIET: bQuiet = true;
				break;
			case CO_INCLUDEDIR: 
			case CO_DEFINE: 
			case CO_KEEPDEFINE: 
			case CO_REVISION:
			case CO_REVISIONFILE:
				// Ignore these options, if it's the first char
				// They will be processed below
				// Error: these cannot be combined with others
				if (ch!=1)
					printf("Ignored option: %c\n", opt );
				break;
			default:
				if (opt>='0' && opt<='9')
				{
					// Any number sets the max. recurse level
					iMaxRecurse = opt - '0';
					break;
				}
				printf("Unknown option: %c\n", opt );
				// seep through [help]
			case '\0':
				// no char after / or -
			case '?':
				if (!bQuiet)
					Help = true;
				break;
			}
		}
	}
	
	if (!bQuiet)
		printf( "\n"VERSION", copyright 2002 by Mondo Bizzarro BV\n\n" );

	// Scan for advanced options next
	for (a=1;a<argc;a++)
	{
		if (argv[a][0]!=option_char)
		{
			// Not an option; must be a file name
			if (inf.Length()>0)
				outf = argv[a];
			else 
				inf = argv[a];
			continue;
		}

		// Parse complex options
		char opt = argv[a][1];
		switch (tolower(opt))
		{
		case CO_INCLUDEDIR: 
			if (argv[++a])
			{
				String dirs = argv[a], dir;
				do
				{
					int pos = dirs.Pos(';');		// first , or ;
					if (pos<0)
						pos = dirs.Pos(',');
					if (pos>0)
					{
						dir = dirs.SubString(0,pos);
						dirs.Delete(0,pos+1);
					}
					else
					{
						dir = dirs;					// silly copy :-(
						dirs.Clear();
					}
					if (bVerbose)
						printf("Include dir: %s\n", dir.c_str());

					// Make sure the path name ends in a (back-)slash
#ifdef _WIN32
//					dir.Replace('/','\\');			// turn slashes 90 degs
					if (dir.CharR(0)!='\\')
						dir = dir + "\\";
#else
					if (dir.CharR(0)!='/')
						dir = dir + "/";
#endif
					IncludeDirs.Add(dir);
				}
				while (!dirs.IsEmpty());
			}
			else
				printf("ERROR: Argument expected after /%c\n",opt);
			break;
		case CO_REVISION:
			if (argv[++a])
			{
				bRevision = true;
				sRevisionDef = argv[a];
				if (bVerbose)
					printf("Revision number: %s\n", sRevisionDef.c_str());
			}
			else
				printf("ERROR: Argument expected after /%c\n",opt);
			break;
		case CO_REVISIONFILE:
			if (argv[++a])
			{
				sRevisionFile = argv[a];
				if (bVerbose)
					printf("Revision number file: %s\n", sRevisionFile.c_str());
			}
			else
				printf("ERROR: Argument expected after /%c\n",opt);
			break;
		case CO_KEEPDEFINE: 
			if (argv[++a])
			{
				KeepDefs.Add(argv[a]);
				if (bVerbose)
					printf("Keeping define %s\n", argv[a]);
			}
			else
				printf("ERROR: Argument expected after /%c\n",opt);
			break;
		case CO_DEFINE: 
			if (argv[++a])
			{
				Defines.Add(argv[a]);
				if (bVerbose)
					printf("Defining %s\n", argv[a]);
			}
			else
				printf("ERROR: Argument expected after /%c\n",opt);
			break;
		}
	}

	if (!bRevision && !sRevisionFile.IsEmpty())
	{
		printf("Must specify /%c when using /%c\n",CO_REVISION,CO_REVISIONFILE);
		sRevisionFile.Clear();
	}

	if (bQuiet && bVerbose)
		printf("Combining /%c with /%c can cause strange behaviour\n",CO_QUIET,CO_VERBOSE);

	if (!inf.IsEmpty() && !outf.IsEmpty())
	{
		if (bRevision)
		{
			bool ok = false;
			// Scan output file for current version number
			// or scan sRevisionFile, is specified
			String rev_file = sRevisionFile.IsEmpty()?outf:sRevisionFile;
			if (output.Open(rev_file))
			{
				if (bVerbose)
					printf("Checking current revision number in %s\n",rev_file.c_str());
				String s;
				while (!output.EndOfFile())
				{
					s = output.ReadString();
					if (s.DelPrefix("#define"))
					{
						s.TrimLeft();
						if (GetCIdentifier(s).Equals(sRevisionDef))
						{				
							s.DelWord();
							int rev = s.ToInt()+1;
							sRevisionNo = INTSTRING(rev);
							ok = true;
							break;
//							if (bVerbose)
//								printf("New revision number: %s\n", sRevisionNo );
						}
					}
				}
				output.Close();
			}
			if (!ok && !bQuiet)
				printf("Current revision number not found\n");
		}

		String routf=outf;	// REAL output file (might be TEMPFILE)

		// Check if we have write access to the output file
		if (!DFile().Open(outf,true))
		{
			// No write access to output file; does it even exist?
			if (DFile().Open(outf))
			{
				// We DO have read access => read only
				printf("ERROR: %s is read-only\n",outf.c_str());
			}
			bOnlyIfChanged = false;
		}
		else
		{
			// We have write access to output file => OK
			if (bOnlyIfChanged)
				// Use intermediate (temp) file
				routf = TEMPFILE;
		}

		if (bVerbose)
			printf("Creating output file: %s\n", routf.c_str());

		if (output.Create(routf))
		{
			output.WriteLine("// This file was generated by "VERSION );
			output.WriteLine("//");

			String rinf;		// REAL input file
			do 
			{
				int pos = inf.Pos(';');		// first , or ;
				if (pos<0)
					pos = inf.Pos(',');
				if (pos>0)
				{
					rinf = inf.SubString(0,pos);
					inf.Delete(0,pos+1);
				}
				else
				{
					rinf = inf;				// silly copy :-(
					inf.Clear();
				}

				if (!ProcessFile(rinf))
				{
					printf("ERROR: File not found: %s\n", rinf.c_str());
					output.WriteLine("// ERROR: File not found: "+rinf);
				}
			}
			while (!inf.IsEmpty());

			output.Close();

			bool updated = true;

			if (bOnlyIfChanged)
			{
				if (CompareFiles(routf,outf))
				{
					// Files are the same; delete temp file
					if (!bQuiet) 
						printf("%s was not changed\n", outf.c_str() );

					if (bVerbose)
						printf("Deleting %s\n", routf.c_str());
					if (remove(routf.c_str())!=0)
						printf("ERROR: Unable to delete file: %s\n", routf.c_str() );
					updated = false;
				}
				else
				{
					// File has changed are the same; rename temp file
					printf("%s was changed\n", outf.c_str() );

					if (bVerbose)
						printf("Renaming %s to %s\n", routf.c_str(),outf.c_str());
					if (remove(outf.c_str())!=0)
						printf("ERROR: Unable to delete file: %s\n", outf.c_str() );
					if (rename(routf.c_str(),outf.c_str())!=0)
						printf("ERROR: Unable to update file: %s\n", outf.c_str() );
				}
			}

			if (updated && bRevision)
			{
//				if (!bQuiet)
					printf("New revision number: %s\n",sRevisionNo.c_str());

				if (!sRevisionFile.IsEmpty())
				{
					if (output.Create(sRevisionFile))
					{
						output.WriteLine("// This file was generated by "VERSION );
						output.WriteLine("//");
						output.WriteLine("#define "+sRevisionDef+" "+sRevisionNo);
						if (bVerbose)
							printf("%s was updated\n",sRevisionFile.c_str());
					}
					else
						printf("ERROR: Could not create %s\n",sRevisionDef.c_str());
				}
			}

			if (!bQuiet) 
				printf("Ready...\n\n");
		}
		else // if (output.Create(routf))
			printf("ERROR: Unable to create output file : %s\n\n", outf.c_str() );
	}
	else // if (!inf.IsEmpty() && !outf.IsEmpty())
		Help =true;

	if (bListHeaders)
	{
		for (int t=0;t<HeadersDone.Count();t++)
			printf("#include <%s>\n", HeadersDone[t].c_str() );
	}

	if (bListDefines)
	{
		for (int t=0;t<Defines.Count();t++)
			printf("#define %s\n", Defines[t].c_str() );
	}

	if (Help)
	{
		printf( "Usage:  HEXPAND [options] <in.h>[;more.h] [options] [out.h] [options]\n\n");
		printf( "Options:    -%c <include-dir>    add Include directory\n", CO_INCLUDEDIR );  
		printf( "            -%c <def>            Define <def>; use with -%c\n", CO_DEFINE, CO_OPTIMIZE );  
		printf( "            -%c <def>            don`t optimize <def>; use with -%c\n", CO_KEEPDEFINE, CO_OPTIMIZE );  
		printf( "            -%c <def>            increment Revision number <def>\n", CO_REVISION );  
		printf( "            -%c <file>           Update revision number in <file>\n", CO_REVISIONFILE );  
		printf( "            -%c                  Optimize preprocessor definitions\n", CO_OPTIMIZE );  
		printf( "            -%c                  Verbose mode (debug)\n", CO_VERBOSE ); 
		printf( "            -%c                  add a Header before each file\n", CO_ADDHEADER );  
		printf( "            -%c                  add a Footer after each file\n", CO_ADDFOOTER );  
		printf( "            -%c                  Strip comments and tabs\n", CO_STRIP );  
		printf( "            -%c                  remove Empty lines\n", CO_SKIPEMPTY ); 
		printf( "            -%c                  replaces output file only if Changed\n", CO_ONLYCHANGED ); 
		printf( "            -%c                  List processed files when ready\n", CO_LISTHEADERS );  
		printf( "            -%c                  list Preprocessor definitions when ready\n", CO_LISTDEFINES ); 
 		printf( "            -%c                  Quiet operation\n", CO_QUIET ); 
		printf( "            -0..9               Set the maximum recursion level\n\n" ); 
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
