/*
 * Bobcat Board Register Definitions
 *
 * (C) 2007 Onstor Inc.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __ONSTOR_BMFPGA_H__
#define __ONSTOR_BMFPGA_H__

#define BOBCAT_REG_BOARD_STATUS	0x0000
#define BOBCAT_REG_INTERRUPT	0x0004
#define BOBCAT_REG_GPP			0x0008
#define BOBCAT_REG_TEST_REG		0x000c
#define BOBCAT_REG_FP_CTRL		0x0010
#define BOBCAT_REG_FP_CTRL2		0x0014
#define BOBCAT_REG_FP_STATUS	0x0018
#define BOBCAT_REG_FP_STATUS2	0x001c
#define BOBCAT_REG_FP_PWR_OUT	0x0020
#define BOBCAT_REG_FP_PWR_IN	0x0024
#define BOBCAT_REG_FP_MBX_OUT	0x0028
#define BOBCAT_REG_FP_MBX_IN	0x002c
#define BOBCAT_REG_FC0_CTRL		0x0030
#define BOBCAT_REG_FC0_CTRL2	0x0034
#define BOBCAT_REG_FC0_STATUS	0x0038
#define BOBCAT_REG_FC0_STATUS2	0x003c
#define BOBCAT_REG_FC0_PWR_OUT	0x0040
#define BOBCAT_REG_FC0_PWR_IN	0x0044
#define BOBCAT_REG_FC0_MBX_OUT	0x0048
#define BOBCAT_REG_SSC_MBX_IN	0x004c
#define BOBCAT_REG_FC1_CTRL		0x0050
#define BOBCAT_REG_FC1_CTRL2	0x0054
#define BOBCAT_REG_FC1_STATUS	0x0058
#define BOBCAT_REG_FC1_STATUS2	0x005c
#define BOBCAT_REG_FC1_PWR_OUT	0x0060
#define BOBCAT_REG_FC1_PWR_IN	0x0064
#define BOBCAT_REG_FC1_MBX_OUT	0x0068
#define BOBCAT_REG_FC1_MBX_IN	0x006c

extern unsigned long bobcat_fpga_base;

#define __FPGA_REG_TO_ADDR(reg)						\
	((void *) bobcat_fpga_base + BOBCAT_REG_##reg)
#define BOBCAT_FPGA_WRITE(x, reg) writeb(x, __FPGA_REG_TO_ADDR(reg))
#define BOBCAT_FPGA_READ(reg) readl(__FPGA_REG_TO_ADDR(reg))

#endif
