
#if defined(CONFIG_BOBCAT_8250_DEBUG_CONSOLE)

#include <linux/console.h>
#include <linux/serial.h>
#include <linux/serial_core.h>
#include <asm/serial.h> /* For the serial port location and base baud */
#include <asm/mach-bobcat/bobcat.h>

/* --- CONFIG --- */

typedef unsigned char uint8;
typedef unsigned int uint32;

/* --- END OF CONFIG --- */

#define         UART16550_BAUD_2400             2400
#define         UART16550_BAUD_4800             4800
#define         UART16550_BAUD_9600             9600
#define         UART16550_BAUD_19200            19200
#define         UART16550_BAUD_38400            38400
#define         UART16550_BAUD_57600            57600
#define         UART16550_BAUD_115200           115200

#define         UART16550_PARITY_NONE           0
#define         UART16550_PARITY_ODD            0x08
#define         UART16550_PARITY_EVEN           0x18
#define         UART16550_PARITY_MARK           0x28
#define         UART16550_PARITY_SPACE          0x38

#define         UART16550_DATA_5BIT             0x0
#define         UART16550_DATA_6BIT             0x1
#define         UART16550_DATA_7BIT             0x2
#define         UART16550_DATA_8BIT             0x3

#define         UART16550_STOP_1BIT             0x0
#define         UART16550_STOP_2BIT             0x4

/* ----------------------------------------------------- */

/* === CONFIG === */

/* [jsun] we use the second serial port for kdb */
#define         BASE                    0xbf200000UL
#define OCELOT_BASE_BAUD ( 20000000 / 16 )
#define         MAX_BAUD                OCELOT_BASE_BAUD

/* === END OF CONFIG === */

#define         REG_OFFSET              4

/* register offset */
#define         OFS_RCV_BUFFER          0
#define         OFS_TRANS_HOLD          0
#define         OFS_SEND_BUFFER         0
#define         OFS_INTR_ENABLE         (1*REG_OFFSET)
#define         OFS_INTR_ID             (2*REG_OFFSET)
#define         OFS_FCR                 (2*REG_OFFSET)
#define         OFS_DATA_FORMAT         (3*REG_OFFSET)
#define         OFS_LINE_CONTROL        (3*REG_OFFSET)
#define         OFS_MODEM_CONTROL       (4*REG_OFFSET)
#define         OFS_RS232_OUTPUT        (4*REG_OFFSET)
#define         OFS_LINE_STATUS         (5*REG_OFFSET)
#define         OFS_MODEM_STATUS        (6*REG_OFFSET)
#define         OFS_RS232_INPUT         (6*REG_OFFSET)
#define         OFS_SCRATCH_PAD         (7*REG_OFFSET)

#define         OFS_DIVISOR_LSB         (0*REG_OFFSET)
#define         OFS_DIVISOR_MSB         (1*REG_OFFSET)


/* memory-mapped read/write of the port */
#define    UART16550_READ(y)     (*((volatile uint8*)(BASE + (y) + 3)))
#define    UART16550_WRITE(y, z) ((*((volatile uint8*)(BASE + (y) + 3))) = (z))

static int remoteDebugInitialized = 0;

void debugInit(uint32 baud, uint8 data, uint8 parity, uint8 stop)
{
	/* disable interrupts */
	//UART16550_WRITE(OFS_INTR_ENABLE, 0);
bob_vectors->printf("isr=%#x\n", UART16550_READ(OFS_INTR_ID));
	//UART16550_WRITE(OFS_FCR, 7); /* reset and enable fifos */
	//UART16550_WRITE(OFS_INTR_ENABLE, 0);
bob_vectors->printf("fcr=%#x\n", UART16550_READ(OFS_FCR));

	/* set up baud rate */
	{
		uint32 divisor;

		/* set DIAB bit */
		//UART16550_WRITE(OFS_LINE_CONTROL, 0x80);

bob_vectors->printf("lsb=%#x, msb=%#x\n", UART16550_READ(OFS_DIVISOR_LSB),
	UART16550_READ(OFS_DIVISOR_MSB));

		/* set divisor */
		divisor = MAX_BAUD / baud;
		divisor = 4; /* 57600 */
		//UART16550_WRITE(OFS_DIVISOR_LSB, divisor & 0xff);
		//UART16550_WRITE(OFS_DIVISOR_MSB, (divisor & 0xff00) >> 8);

		/* clear DIAB bit */
		//UART16550_WRITE(OFS_LINE_CONTROL, 0x0);
	}

	/* set data format */
	//UART16550_WRITE(OFS_DATA_FORMAT, data | parity | stop);
	remoteDebugInitialized = 1;
}

uint8 getDebugChar(void)
{
	if (!remoteDebugInitialized) {
		remoteDebugInitialized = 1;
		debugInit(UART16550_BAUD_57600, UART16550_DATA_8BIT,
			UART16550_PARITY_NONE, UART16550_STOP_1BIT);
	}

	while ((UART16550_READ(OFS_LINE_STATUS) & 0x1) == 0) ;
	return UART16550_READ(OFS_RCV_BUFFER);
}


int putDebugChar(uint8 byte)
{
	if (!remoteDebugInitialized) {
		remoteDebugInitialized = 1;
		debugInit(UART16550_BAUD_57600, UART16550_DATA_8BIT,
			UART16550_PARITY_NONE, UART16550_STOP_1BIT);
	}

bob_vectors->printf("lsr=%#x\n", UART16550_READ(OFS_LINE_STATUS));
	while ((UART16550_READ(OFS_LINE_STATUS) & 0x20) == 0);
	UART16550_WRITE(OFS_SEND_BUFFER, byte);
	return 1;
}

 void
bc_8250_puts(struct console *con, const char *s, unsigned n)
{
	char *c = (char *)s;

	while (n--) {
		if (*c == '\n') {
			putDebugChar('\r');
		}
		putDebugChar(*c++);
	}
}

 int
bc_8250_setup(struct console *con, char *foome)
{
	debugInit(UART16550_BAUD_57600, UART16550_DATA_8BIT, UART16550_PARITY_NONE,
		UART16550_STOP_1BIT);

	return 0;
}

static struct console pcon = {
	.name = "ttyS",
	.write = bc_8250_puts,
	.setup = bc_8250_setup,
	.flags = CON_PRINTBUFFER | CON_BOOT,
	.index = -1,
};

 void __init
bc_8250_console_setup(void)
{
	register_console(&pcon);

	printk("Registerd 8250 debug console\n");
}

 void __init
disable_early_printk(void)
{
	unregister_console(&pcon);
}
#endif
