/*
 * Copyright 2002 Momentum Computer Inc.
 * Author: Matthew Dharm <mdharm@momenco.com>
 *
 * Louis Hamilton, Red Hat, Inc.
 * hamilton@redhat.com  [MIPS64 modifications]
 *
 * Based on Ocelot Linux port, which is
 * Copyright 2001 MontaVista Software Inc.
 * Author: jsun@mvista.com or jsun@junsun.net
 *
 * Copyright 2007 Onstor In.c
 * Author: Andrew Sharp (andy.sharp@onstor.com)
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 * Added changes for SMP - Manish Lachwani (lachwani@pmc-sierra.com)
 */
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>
#include <linux/mv643xx.h>
#include <linux/ctype.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/pmon.h>

#include <asm/mach-bobcat/bobcat.h>

#include "bobcat_bm_fpga.h"

uint8_t eee_ssc_ext_mac[2][6];
unsigned long bc_memsize;
unsigned long ipaddr = 0;
unsigned long netmask = 0;

extern uint8_t *mv64440_sram_base;
extern unsigned long cpu_clock;
extern unsigned long bus_clock;

DEFINE_SPINLOCK(bc_tty1_lock);

struct onstor_vectors biteme = {
#ifdef CONFIG_BOBCAT_8250_DEBUG_CONSOLE
	.printf = (int (*)(const char*, ...))0x80032c5cUL,
	.tty1_printf = (int (*)(const char*, ...))0x80032df4UL,
#else
	.printf = printk,
	.tty1_printf = printk,
#endif
};

struct callvectors *debug_vectors;
struct onstor_vectors *bob_vectors = &biteme;
EXPORT_SYMBOL(bob_vectors);

 const char *
get_system_type(void)
{
	return "ONStor Bobcat";
}

#ifdef CONFIG_64BIT

 unsigned long __init
signext(unsigned long addr)
{
	addr &= 0xffffffff;
	return (unsigned long)((int)addr);
}

 void *
get_arg(unsigned long args, int arc)
{
	unsigned long ul;
	unsigned char *puc, uc;

	args += (arc * 4);
	ul = (unsigned long)signext(args);
	puc = (unsigned char *)ul;
	if (puc == 0)
		return (void *)0;

#ifdef CONFIG_CPU_LITTLE_ENDIAN
	uc = *puc++;
	l = (unsigned long)uc;
	uc = *puc++;
	ul |= (((unsigned long)uc) << 8);
	uc = *puc++;
	ul |= (((unsigned long)uc) << 16);
	uc = *puc++;
	ul |= (((unsigned long)uc) << 24);
#else
	uc = *puc++;
	ul = ((unsigned long)uc) << 24;
	uc = *puc++;
	ul |= (((unsigned long)uc) << 16);
	uc = *puc++;
	ul |= (((unsigned long)uc) << 8);
	uc = *puc++;
	ul |= ((unsigned long)uc);
#endif
	ul = signext(ul);

	return (void *)ul;
}

 char *
arg64(unsigned long addrin, int arg_index)
{
	unsigned long args;
	char *p;

	args = signext(addrin);
	p = (char *)get_arg(args, arg_index);

	return p;
}
#endif  /* CONFIG_64BIT */

/*
 * convert a hex ascii char to an integer
 */
 static inline uint8_t __init
hexchr2int(uint8_t c)
{
	c &= 0xff;
	return c > '9' ? (c > 'F' ? c - 'a' : c - 'A') : c - '0';
}

/*
 * fixed mac addrs for the eee "interfaces"
 */
 static void __init
init_etheraddr(uint8_t *etheraddr, uint8_t *mac_addr)
{
	int i;
	if (!mac_addr) {
		return;
	}
	for (i = 0; i < 6; i++) {
		etheraddr[i] = mac_addr[i];
	}
}

#if 0
 void __init
init_eee_addrs(void)
{
	volatile struct marvell_seep __iomem *chassis_seep =
		(struct marvell_seep *)mv64440_sram_base;

	if (chassis_seep) {
bob_vectors->printf("chassis_seep = %#p\n", chassis_seep);
		init_etheraddr(chassis_seep->mac_addr, eee_ssc_ext_mac[0], 0);
bob_vectors->printf("prom_init: eee_ssc_mac[0] = "
"%02x:%02x:%02x:%02x:%02x:%02x\n",
eee_ssc_ext_mac[0][0], eee_ssc_ext_mac[0][1], eee_ssc_ext_mac[0][2],
eee_ssc_ext_mac[0][3], eee_ssc_ext_mac[0][4], eee_ssc_ext_mac[0][5]);
		init_etheraddr(chassis_seep->mac_addr, eee_ssc_ext_mac[1], 1);
bob_vectors->printf("prom_init: eee_ssc_mac[1] = "
"%02x:%02x:%02x:%02x:%02x:%02x\n",
eee_ssc_ext_mac[1][0], eee_ssc_ext_mac[1][1], eee_ssc_ext_mac[1][2],
eee_ssc_ext_mac[1][3], eee_ssc_ext_mac[1][4], eee_ssc_ext_mac[1][5]);
	} else {
		bob_vectors->printf("prom_init: cannot access SEEP\n");
	}
}
#endif

 void
prom_putchar(char c)
{
	/*
	 * early_printk schtuff
	 */
#ifdef CONFIG_BOBCAT_8250_DEBUG_CONSOLE
	bob_vectors->tty1_printf("%c", c);
#elif defined (CONFIG_BOBCAT_MPSC_EARLY_PRINTK)
	bob_vectors->printf("%c", c);
#else
	printk("%c", c);
#endif
}

/*
 * hack to insert the ip address passed through the environment array
 * into the ip= kernel command line option.
 *
 * Rules: only insert the address if there isn't an ip= option or if the
 * ip= option contains a blank ip address
 */
#if 0
 static void
insert_ipaddr(void)
{
	char t[2048];
	char *o;

	if (ipaddr == 0) {
		return;
	}
	for (o = arcs_cmdline; o; o = strchr(o, ' ')) {
		/*
		 * eat multiple spaces
		 */
		while (*o == ' ' || *o == '\t') {
			o++;
		}
		if (option starts with "ip=") {
			if ("ip=:" or "ip=  :") {
				copy remainder of cmdline to temp buffer
				copy in ip addr
				copy remainder of cmdline from temp buffer to end of ip addr
			}
		}
	}

	if (no ip= option) {
		strcat(arcs_cmdline, "ip=%d.%d.%d.%d:", (ipaddr >> 24) & 0xff,
			(ipaddr >> 16) & 0xff, (ipaddr >> 8) & 0xff, ipaddr & 0xff,
		if (netmask) {
			strcat(arcs_cmdline, "%d.%d.%d.%d", (netmask >> 24) & 0xff,
				(netmask >> 16) & 0xff, (netmask >> 8) & 0xff, netmask & 0xff);
		}
	}
}
#endif


/*
 * PMON passes arguments in C main() style
 * */
 void __init
prom_init(void)
{
	unsigned int argc = fw_arg0;
	char **arg = (char **)fw_arg1;
	char **env = (char **)fw_arg2;
	struct callvectors *cv = (struct callvectors *)fw_arg3;
	char *mac0_addr = NULL;
	char *mac1_addr = NULL;
	int i;

#ifdef CONFIG_32BIT
	/*
	 * save the PROM vectors for debugging use
	 */
	debug_vectors = cv;
	if (debug_vectors == NULL) {
		static struct callvectors dv;

		debug_vectors = &dv;
		debug_vectors->printf = biteme.printf;
	} else {
		bob_vectors->printf = debug_vectors->printf;
		bob_vectors->tty1_printf =
			(int (*)(const char*, ...))debug_vectors->gets;
	}

	bob_vectors->printf("Booting Linux kernel...\n");

	/*
	 * add any boot args from the prom command line to the compiled in
	 * command line.  arg[0] is "g"; the rest is boot parameters.
	 */
	for (i = 1; i < argc; i++) {
		if (strlen(arcs_cmdline) + strlen(arg[i] + 1) >= sizeof(arcs_cmdline)) {
			break;
		}
		strcat(arcs_cmdline, " ");
		strcat(arcs_cmdline, arg[i]);
	}

#define strtoip(STR, DST) sscanf(STR, "%hhu.%hhu.%hhu.%hhu", (char *)&DST, \
		((char *)&DST) + 1, ((char *)&DST) + 2, ((char *)&DST) + 3);

	for (i = 0; *env; env++) {

		bob_vectors->printf("prom_init: env[%d] = '%s", i++, *env);
		if (!strncmp("macaddr", *env, 7)) {
			/*
			 * some IDIOT has the mac addr in binary in the env
			 */
			int k;

			for (k = 0; k < 6; k++) {
				bob_vectors->printf("%02x%s", (*env)[k + 9] & 0xff,
					k == 5 ? "" : ":");
			}
		}
		bob_vectors->printf("'\n");

		if (strncmp("ipaddr", *env, strlen("ipaddr")) == 0) {
			strtoip(*env + strlen("ipaddr="), ipaddr);
			continue;
		}
		if (strncmp("netmask", *env, strlen("netmask")) == 0) {
			strtoip(*env + strlen("netmask="), netmask);
			continue;
		}
		if (strncmp("macaddr0", *env, strlen("macaddr0")) == 0) {
			mac0_addr = *env + strlen("macaddr0=");
			continue;
		}
		if (strncmp("macaddr1", *env, strlen("macaddr1")) == 0) {
			mac1_addr = *env + strlen("macaddr1=");
			continue;
		}
		if (strncmp("memsize", *env, strlen("memsize=")) == 0) {
			bc_memsize = simple_strtol(*env + strlen("memsize="), NULL, 10);
			continue;
		}
		if (strncmp("gtbase", *env, strlen("gtbase")) == 0) {
			marvell_base = simple_strtol(*env + strlen("gtbase="), NULL, 16);
			continue;
		}
		if (strncmp("cpuclock", *env, strlen("cpuclock")) == 0) {
			cpu_clock = simple_strtol(*env + strlen("cpuclock="), NULL, 10);
			continue;
		}
		if (strncmp("busclock", *env, strlen("busclock")) == 0) {
			bus_clock = simple_strtol(*env + strlen("busclock="), NULL, 10);
		}
	}
#elif defined(CONFIG_64BIT)
	char *ptr;

	/*
	 * save the PROM vectors for debugging use
	 */
	debug_vectors = (struct callvectors *)signext((unsigned long)cv);
	if (debug_vectors == NULL) {
		static struct callvectors dv;

		debug_vectors = &dv;
		debug_vectors->printf =
			(int (*)(const char*, ...))signext(biteme.printf);
		debug_vectors->tty1_printf =
			(int (*)(const char*, ...))signext(biteme.tty1_printf);
	} else {
		bob_vectors->printf =
			(int (*)(const char*, ...))signext(debug_vectors->printf);
		bob_vectors->tty1_printf =
			(int (*)(const char*, ...))signext(debug_vectors->gets);
	}

	bob_vectors->printf("Booting Linux kernel...\n");
	bob_vectors->printf("Mips64 Bobcat\n");

	/*
	 * add any boot args from the prom command line to the compiled in
	 * command line.  arg[0] is "g"; the rest is boot parameters.
	 */

	for (i = 1; i < argc; i++) {
		ptr = (char *)arg64((unsigned long)arg, i);
		if ((strlen(arcs_cmdline) + strlen(ptr) + 1) >=
		    sizeof(arcs_cmdline))
			break;
		strcat(arcs_cmdline, ptr);
		strcat(arcs_cmdline, " ");
	}

	i = 0;
	while (1) {
		ptr = (char *)arg64((unsigned long)env, i);
		if (!ptr) {
			break;
		}

		if (strncmp("gtbase", ptr, strlen("gtbase")) == 0) {
			marvell_base = simple_strtol(ptr + strlen("gtbase="), NULL, 16);

			if ((marvell_base & 0xffffffff00000000) == 0) {
				marvell_base |= 0xffffffff00000000;
			}

			printk("marvell_base set to 0x%016lx\n", marvell_base);
		}
		if (strncmp("cpuclock", ptr, strlen("cpuclock")) == 0) {
			cpu_clock = simple_strtol(ptr + strlen("cpuclock="), NULL, 10);
			printk("cpu_clock set to %d\n", cpu_clock);
		}
		if (strncmp("busclock", *env, strlen("busclock")) == 0) {
			bus_clock = simple_strtol(*env + strlen("busclock="), NULL, 4);
		}
		i++;
	}

#endif /* CONFIG_64BIT */

	init_etheraddr(eee_ssc_ext_mac[0], mac0_addr);
	init_etheraddr(eee_ssc_ext_mac[1], mac1_addr);
	//insert_ipaddr();
#ifndef CONFIG_DEBUG_KERNEL
	for (i = 0; i < 2; i++) {
		bob_vectors->printf("prom_init: eee_ssc_mac[%d] = "
			"%02x:%02x:%02x:%02x:%02x:%02x\n", i, eee_ssc_ext_mac[i][0],
			eee_ssc_ext_mac[i][1], eee_ssc_ext_mac[i][2], eee_ssc_ext_mac[i][3],
			eee_ssc_ext_mac[i][4], eee_ssc_ext_mac[i][5]);
	}
#endif

	mips_machgroup = MACH_GROUP_ONSTOR;
	mips_machtype = MACH_ONSTOR_BOBCAT;
}

 void __init
prom_free_prom_memory(void)
{
	/*
	 * don't free our PROM memory
	 */
}

 void __init
prom_fixup_mem_map(unsigned long start, unsigned long end)
{
}

#ifdef CONFIG_SMP
 void __init
prom_boot_secondary(int cpu, struct task_struct *it)
{
	/* Clear the semaphore */
	//*(volatile uint32_t *)(0xbb000a68) = 0x80000000;
}

 void __init
prom_init_secondary(void)
{
	clear_c0_config(CONF_CM_CMASK);
	set_c0_config(0x2);

	clear_c0_status(ST0_IM);
	set_c0_status(0x1ffff);
}

 void __exit
prom_smp_finish(void)
{
}

#endif /* CONFIG_SMP */
