/*
 * Copyright (C) 2000, 2001 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/blkdev.h>
#include <linux/bootmem.h>
#include <linux/smp.h>
#include <linux/initrd.h>
#include <linux/pm.h>

#include <asm/bootinfo.h>
#include <asm/reboot.h>
#include <asm/pmon.h>
#include <asm/sibyte/sb1250.h>
#include <asm/sibyte/sb1250_regs.h>
#include <asm/sibyte/sb1250_scd.h>

#include <asm/mach-cougar/cougar.h>

#ifdef CONFIG_EARLY_PRINTK
extern void sb1250_serial_console_init(void);
#endif

#ifdef CONFIG_RTC_DRV_DS1511
extern void ds1511_wdog_set(unsigned long deciseconds);
#endif

unsigned long cg_memsize;
unsigned long ipaddr = 0;
unsigned long netmask = 0;
unsigned long cpu_clock;
unsigned long bus_clock;
struct callvectors *debug_vectors;
extern void *mcpu_shared_memory;

#ifdef CONFIG_SMP
# define LAUNCHSTACK_SIZE 256
static unsigned long secondary_sp __initdata;
static unsigned long secondary_gp __initdata;

static unsigned char launchstack[LAUNCHSTACK_SIZE] __initdata
	__attribute__((aligned(2 * sizeof(long))));
#endif

static __init void prom_meminit(void)
{
#ifdef CONFIG_BLK_DEV_INITRD
	unsigned long initrd_pstart;
	unsigned long initrd_pend;

	initrd_pstart = __pa(initrd_start);
	initrd_pend = __pa(initrd_end);
	if (initrd_start &&
	    ((initrd_pstart > MAX_RAM_SIZE)
	     || (initrd_pend > MAX_RAM_SIZE))) {
		panic("initrd out of addressable memory");
	}

	//add_memory_region(0x0UL, COUGAR_PROM_SZ, BOOT_MEM_ROM_DATA);
	add_memory_region(0, initrd_pstart, BOOT_MEM_RAM);
	//add_memory_region(COUGAR_PROM_SZ, initrd_pstart - COUGAR_PROM_SZ,
		//BOOT_MEM_RAM);
	add_memory_region(initrd_pstart, initrd_pend - initrd_pstart,
			  BOOT_MEM_RESERVED);

	add_memory_region(initrd_pend, 0x10000000UL - initrd_pend, BOOT_MEM_RAM);

#else
	add_memory_region(0x0UL, COUGAR_PROM_SZ, BOOT_MEM_ROM_DATA);
	add_memory_region(COUGAR_PROM_SZ, 0x10000000UL - COUGAR_PROM_SZ,
		BOOT_MEM_RAM);
	//add_memory_region(0x0UL, 0x10000000UL, BOOT_MEM_RAM);

#endif

	/*
	 * add the upper 256M
	 */
	add_memory_region(0x80000000UL, 0xf000000UL, BOOT_MEM_RAM);
	/*
	 * shared memory for communicating with phantoms
	 */
	add_memory_region(SHARED_MEM_START, SHARED_MEM_SIZE, BOOT_MEM_RESERVED);
	mcpu_shared_memory = ioremap(SHARED_MEM_START, SHARED_MEM_SIZE);
}

void prom_cpu0_exit(void *unused)
{
        while (1) ;
}

static void prom_linux_restart(void)
{
#ifdef CONFIG_SMP
	if (smp_processor_id()) {
		smp_call_function(prom_cpu0_exit, NULL, 1, 1);
	}
#endif
	/*
	 * hit the reset button
	 */
#ifdef CONFIG_RTC_DRV_DS1511
	ds1511_wdog_set(300);
#else
	/*
	 * tickle the internal sibyte reset
	 */
	__raw_writeq(M_SYS_SYSTEM_RESET, IOADDR(A_SCD_SYSTEM_CFG));
#endif
	while(1);
}

static void prom_linux_exit(void)
{
#ifdef CONFIG_SMP
	if (smp_processor_id()) {
		smp_call_function(prom_cpu0_exit, NULL, 1, 1);
	}
#endif
	while(1);
}

/*
 * PMON passes arguments in C main() style
 * */
 void __init
cougar_pmon_init(void)
{
	unsigned long argc = fw_arg0;
	char **arg = (char **)fw_arg1;
	char **env = (char **)fw_arg2;
	struct callvectors *cv = (struct callvectors *)fw_arg3;
	char *mac0_addr = NULL;
	char *mac1_addr = NULL;
	int i;

#ifdef CONFIG_ONSTOR_COUGAR
	/*
	 * save the PROM vectors for debugging use
	 */
	debug_vectors = cv;
	if (debug_vectors == NULL) {
		static struct callvectors dv;

		debug_vectors = &dv;
		/*
		 * since our pmon is broken and doesn't legitimately populate
		 * the callvector address, plunk the hardcoded pmon printf
		 * address here.
		 */
		debug_vectors->printf = (void *)0xffffffff88888888;
	}

	printk("Booting Linux kernel...Mips64 Cougar\n");

	/*
	 * add any boot args from the prom command line to the compiled in
	 * command line.  arg[0] is "g"; the rest is boot parameters.
	 */
#ifndef notyut
	printk("%s: argc=%ld, arg=%p, env=%p\n", __func__, argc, arg, env);
#endif
	for (i = 1; i < argc; i++) {
		if (strlen(arcs_cmdline) + strlen(arg[i] + 1) >= sizeof(arcs_cmdline)) {
			break;
		}
		strcat(arcs_cmdline, " ");
		strcat(arcs_cmdline, arg[i]);
	}

#define strtoip(STR, DST) sscanf(STR, "%hhu.%hhu.%hhu.%hhu", (char *)&DST, \
		((char *)&DST) + 1, ((char *)&DST) + 2, ((char *)&DST) + 3);

	for (i = 0; env && *env; env++) {

		printk("prom_init: env[%d] = '%s", i++, *env);
		if (!strncmp("macaddr", *env, 7)) {
			/*
			 * some IDIOT has the mac addr in binary in the env
			 */
			int k;

			for (k = 0; k < 6; k++) {
				printk("%02x%s", (*env)[k + 9] & 0xff,
					k == 5 ? "" : ":");
			}
		}
		printk("'\n");

		if (strncmp("ipaddr", *env, strlen("ipaddr")) == 0) {
			strtoip(*env + strlen("ipaddr="), ipaddr);
			continue;
		}
		if (strncmp("netmask", *env, strlen("netmask")) == 0) {
			strtoip(*env + strlen("netmask="), netmask);
			continue;
		}
		if (strncmp("macaddr0", *env, strlen("macaddr0")) == 0) {
			mac0_addr = *env + strlen("macaddr0=");
			continue;
		}
		if (strncmp("macaddr1", *env, strlen("macaddr1")) == 0) {
			mac1_addr = *env + strlen("macaddr1=");
			continue;
		}
		if (strncmp("memsize", *env, strlen("memsize=")) == 0) {
			cg_memsize = simple_strtol(*env + strlen("memsize="), NULL, 10);
			continue;
		}
		if (strncmp("cpuclock", *env, strlen("cpuclock")) == 0) {
			cpu_clock = simple_strtol(*env + strlen("cpuclock="), NULL, 10);
			continue;
		}
		if (strncmp("busclock", *env, strlen("busclock")) == 0) {
			bus_clock = simple_strtol(*env + strlen("busclock="), NULL, 10);
		}
	}

#else //if defined(CONFIG_64BIT)
	char *ptr;

	/*
	 * save the PROM vectors for debugging use
	 */
	debug_vectors = (struct callvectors *)signext((unsigned long)cv);
	if (debug_vectors == NULL) {
		static struct callvectors dv;

		debug_vectors = &dv;
		debug_vectors->printf =
			(int (*)(const char*, ...))signext(biteme.printf);
		debug_vectors->tty1_printf =
			(int (*)(const char*, ...))signext(biteme.tty1_printf);
	} else {
		bob_vectors->printf =
			(int (*)(const char*, ...))signext(debug_vectors->printf);
		bob_vectors->tty1_printf =
			(int (*)(const char*, ...))signext(debug_vectors->gets);
	}

	bob_vectors->printf("Booting Linux kernel...\n");
	bob_vectors->printf("Mips64 Cougar\n");

	/*
	 * add any boot args from the prom command line to the compiled in
	 * command line.  arg[0] is "g"; the rest is boot parameters.
	 */

	for (i = 1; i < argc; i++) {
		ptr = (char *)arg64((unsigned long)arg, i);
		if ((strlen(arcs_cmdline) + strlen(ptr) + 1) >=
		    sizeof(arcs_cmdline))
			break;
		strcat(arcs_cmdline, ptr);
		strcat(arcs_cmdline, " ");
	}

	i = 0;
	while (1) {
		ptr = (char *)arg64((unsigned long)env, i);
		if (!ptr) {
			break;
		}

		if (strncmp("cpuclock", ptr, strlen("cpuclock")) == 0) {
			cpu_clock = simple_strtol(ptr + strlen("cpuclock="), NULL, 10);
			printk("cpu_clock set to %d\n", cpu_clock);
		}
		if (strncmp("busclock", *env, strlen("busclock")) == 0) {
			bus_clock = simple_strtol(*env + strlen("busclock="), NULL, 4);
		}
		i++;
	}

#endif /* CONFIG_64BIT */

}

/*
 * prom_init is called just after the cpu type is determined, from setup_arch()
 */
void __init prom_init(void)
{

#ifdef CONFIG_EARLY_PRINTK
	sb1250_serial_console_init();
#endif

	cougar_pmon_init();

	_machine_restart   = (void (*)(char *))prom_linux_restart;
	_machine_halt      = prom_linux_exit;
	pm_power_off = prom_linux_exit;

	mips_machgroup = MACH_GROUP_ONSTOR;
	mips_machtype = MACH_ONSTOR_COUGAR;
	prom_meminit();
}

void __init prom_free_prom_memory(void)
{
	/* Not sure what I'm supposed to do here.  Nothing, I think */
}

#if defined(CONFIG_SMP)
/*
 * Assume cpus are already set up by whatever prom is in the system.
 * Set up phys_cpu_present_map and the logical/physical mappings.
 * XXXKW will the boot CPU ever not be physical 0?
 *
 * Common setup before any secondaries are started
 */
void __init plat_smp_setup(void)
{
	int i, num;

	cpus_clear(phys_cpu_present_map);
	cpu_set(0, phys_cpu_present_map);
	__cpu_number_map[0] = 0;
	__cpu_logical_map[0] = 0;

	for (i = 1, num = 0; i < NR_CPUS; i++) {
		cpu_set(i, phys_cpu_present_map);
		__cpu_number_map[i] = ++num;
		__cpu_logical_map[num] = i;
	}
	printk(KERN_INFO "Detected %i available secondary CPU(s)\n", num);
}

static void __init prom_smp_bootstrap(void)
{
	local_irq_disable();

	__asm__ __volatile__(
	"	move	$sp, %0		\n"
	"	move	$gp, %1		\n"
	"	j	smp_bootstrap	\n"
	:
	: "r" (secondary_sp), "r" (secondary_gp));
}

void __init plat_prepare_cpus(unsigned int max_cpus)
{
}


void prom_smp_finish(void)
{
	extern void sb1250_smp_finish(void);
	sb1250_smp_finish();
}

void __init prom_init_secondary(void)
{
	extern void sb1250_smp_init(void);
	sb1250_smp_init();
}

/*
 * get idle task running on secondary cpu.
 */
void prom_boot_secondary(int cpu, struct task_struct *idle)
{
	unsigned long gp = (unsigned long) task_thread_info(idle);
	unsigned long sp = __KSTK_TOS(idle);

	secondary_sp = sp;
	secondary_gp = gp;

/*
 * don't have a prom_cpustart just yet...

	prom_cpustart(cpu, &prom_smp_bootstrap, launchstack + LAUNCHSTACK_SIZE, 0);

 */
}

/*
 * Final cleanup after all secondaries booted
 */
void prom_cpus_done(void)
{
}

#endif /* CONFIG_SMP */

void prom_putchar(char c)
{
}
